/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DData;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DIndex;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DSummary;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.core.internal.IDTextualItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellBorder;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellFocusMark;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellFolder;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellImage;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellLine;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellLinePrefix;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellParagraph;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellRenderable;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellTable;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.tools.internal.DChartTranslator;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class TExtensibleContentProvider
extends DParser {
    private static TExtensibleContentProvider globalLayoutExtensible = null;

    public static TExtensibleContentProvider getInstance() {
        if (globalLayoutExtensible == null) {
            globalLayoutExtensible = new TExtensibleContentProvider();
        }
        return globalLayoutExtensible;
    }

    private TExtensibleContentProvider() {
    }

    public TAbstractCell addListItemPrefix(IArg info, IDItem i) {
        TAbstractCell c = null;
        if (!(i.getParent() instanceof DList)) {
            return c;
        }
        DList l = (DList)i.getParent();
        info.getListLevel().newEntry();
        switch (l.getFormat()) {
            case 4: {
                break;
            }
            case 5: {
                ISymbol s;
                switch (info.getListLevel().getLevel()) {
                    case 1: {
                        s = DSymbolRegistry.GetOval();
                        break;
                    }
                    case 2: {
                        s = DSymbolRegistry.GetSquare();
                        break;
                    }
                    case 3: {
                        s = DSymbolRegistry.GetDiamond();
                        break;
                    }
                    case 4: {
                        s = DSymbolRegistry.GetRight();
                        break;
                    }
                    default: {
                        s = DSymbolRegistry.GetMinus();
                    }
                }
                info.addReturnValue(new TCellLinePrefix((IDItem)l, s, i, info.getListLevel().getLevel() - 1));
                break;
            }
            default: {
                String rval = info.getListLevel().toFormatString(l.getFormat());
                if (rval == null) break;
                info.addReturnValue(new TCellLinePrefix((IDItem)l, rval, i, info.getListLevel().getLevel() - 1));
            }
        }
        return c;
    }

    public void doMethod(DDocument doc, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.getContainer().setItem((IDItem)doc);
        this.doChildrenItem((IDItem)doc, ext, info);
    }

    public void doMethod(IDRenderable g, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        TCellFocusMark fc = new TCellFocusMark((IDItem)g);
        info.addReturnValue(fc);
        IDRenderable renderable = g;
        if (g instanceof DGraphic) {
            DChartTranslator tc = new DChartTranslator();
            renderable = tc.translate((DGraphic)g);
        }
        TCellRenderable c = new TCellRenderable(renderable);
        info.addReturnValue(c);
        fc.setEndMark(c);
    }

    public void doMethod(DImage i, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        this.addListItemPrefix(info, (IDItem)i);
        IImage img = info.getImageProvider().getImage(i.getName());
        info.addReturnValue(new TCellImage(i, img, 0, 0));
    }

    public void doMethod(DList l, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.getListLevel().increase();
        this.doChildrenItem((IDItem)l, ext, arg);
        info.getListLevel().decrease();
    }

    public void doMethod(DLine l, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.addReturnValue(new TCellLine(l));
    }

    public void doMethod(DPageBreak pb, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.addReturnValue(new TCell((IDItem)pb));
    }

    public void doMethod(DPageCounter pc, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.addReturnValue(new TCellText((IDItem)pc, "99999"));
    }

    public void doMethod(DParagraph p, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        this.addListItemPrefix(info, (IDItem)p);
        TCellParagraph cp = new TCellParagraph((IDItem)p, info.getLayout(), p.getAlignment());
        cp.fillContent((IDItem)p, info.getGc(), info.getImageProvider(), info.getProgressMonitor(), info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
        info.addReturnValue(cp);
    }

    public void doMethod(DPopup p, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        if (info.isDrawPopup()) {
            TCellParagraph c = new TCellParagraph((IDItem)p, info.getLayout(), p.getAlignment());
            c.setMargin(5, 5, 5, 5);
            c.fillContent((IDItem)p, info.getGc(), info.getImageProvider(), info.getProgressMonitor(), info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
            info.addReturnValue(c);
        }
    }

    public void doMethod(DLink l, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        this.addListItemPrefix(info, (IDItem)l);
        TCellFocusMark fc = new TCellFocusMark((IDItem)l);
        info.addReturnValue(fc);
        this.doChildrenItem((IDItem)l, ext, arg);
        if (!DLinkUtil.isPopupLink((IDLink)l) || !info.isFlatPopup()) {
            fc.setEndMark(info.getCell());
            return;
        }
        DLinkResolver r = new DLinkResolver((IDLink)l);
        r.resolve(null);
        DPopup popup = (DPopup)r.getTaggedItem();
        if (popup != null) {
            boolean dp = info.isDrawPopup();
            info.setDrawPopup(true);
            this.invokeDoMethod(popup, ext, arg);
            info.setDrawPopup(dp);
        }
    }

    public void doMethod(DSection s, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.addReturnValue(new TCell((IDItem)s));
        this.doChildrenItem((IDItem)s, ext, info);
    }

    public void doMethod(DTable t, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        TCellTable l = new TCellTable((IDItem)t, t.getRowCount(), t.getColumnCount(), t.getColumnWidth(), t.getBorder());
        l.setReversed(info.getLayout().isReversed());
        l.fillContent((IDItem)t, info.getGc(), info.getImageProvider(), info.getProgressMonitor(), info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
        info.addReturnValue(l);
    }

    public void doMethod(DCell c, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        TCellParagraph cl = new TCellParagraph((IDItem)c, info.getLayout(), c.getAlignment());
        cl.fillContent((IDItem)c, info.getGc(), info.getImageProvider(), info.getProgressMonitor(), info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
        info.addReturnValue(cl);
    }

    public void doMethod(DCellText c, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        TCellParagraph cl = new TCellParagraph((IDItem)c, info.getLayout(), c.getAlignment());
        String s = c.getText() == null ? "" : c.getText();
        cl.addCell(new TCellText((IDItem)c, s));
        info.addReturnValue(cl);
    }

    public void doMethod(DRow r, DExtensible ext, Object arg) {
        this.doChildrenItem((IDItem)r, ext, arg);
    }

    public void doMethod(DTag t, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.addReturnValue(new TCell((IDItem)t));
    }

    public void doMethod(DData d, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        info.addReturnValue(new TCell((IDItem)d));
    }

    public void doMethod(IDTextualItem t, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        this.addListItemPrefix(info, (IDItem)t);
        String text = t.getText();
        if (text == null) {
            return;
        }
        info.addReturnValue(new TCellText((IDItem)t, text));
    }

    public void doMethod(DTitle t, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        IDStyle s = t.getAppliedStyle();
        int format = 1;
        if (s != null) {
            format = s.getNumberingFormat();
        }
        info.getTitleLevel().increase(t.getLevel());
        String st = info.getTitleLevel().toFormatString(format);
        info.addReturnValue(new TCellText((IDItem)t, st));
        this.doChildrenItem((IDItem)t, ext, arg);
    }

    public void doMethod(DSummary summary, DExtensible ext, Object arg) {
    }

    public void doMethod(DIndex index, DExtensible ext, Object arg) {
    }

    public void doMethod(DIndexEntry indexentry, DExtensible ext, Object arg) {
        this.doChildrenItem((IDItem)indexentry, ext, arg);
    }

    public void doMethod(DFolder _folder, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        ((TExtensibleContentProvider)ext).addListItemPrefix(info, (IDItem)_folder);
        TCellFolder cell = new TCellFolder(_folder);
        cell.getLayout().setReversed(info.getLayout().isReversed());
        cell.fillContent(cell, (IDItem)_folder, info.getGc(), info.getImageProvider(), info.getProgressMonitor(), info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
        info.addReturnValue(cell);
    }

    public void doMethod(DBorder _border, DExtensible ext, Object arg) {
        IArg info = (IArg)arg;
        ((TExtensibleContentProvider)ext).addListItemPrefix(info, (IDItem)_border);
        TCellBorder cell = new TCellBorder(_border);
        cell.getLayout().setReversed(info.getLayout().isReversed());
        cell.fillContent(cell, (IDItem)_border, info.getGc(), info.getImageProvider(), info.getProgressMonitor(), info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
        info.addReturnValue(cell);
    }

    public void doChildrenItem(IDItem item, DExtensible ext, Object parser_arg) {
        if (item == null) {
            return;
        }
        IArg info = (IArg)parser_arg;
        info.getProgressMonitor().setTotalWorks(info.getProgressMonitor().getTotalWorks() + item.getChildCount());
        IDItem i = item.getFirstChild();
        while (i != null) {
            this.invokeDoMethod(i, ext, parser_arg);
            info.getProgressMonitor().worked(info.getProgressMonitor().getWorkCount() + 1);
            i = i.getNext();
        }
    }

    public static interface IArg {
        public ILayout getLayout();

        public TAbstractCellContainer getContainer();

        public TAbstractCell getCell();

        public DTitleLevel getTitleLevel();

        public DListLevel getListLevel();

        public boolean isFlatPopup();

        public boolean isDrawPopup();

        public void setDrawPopup(boolean var1);

        public IGC getGc();

        public IDIImageProvider getImageProvider();

        public IDProgressMonitor getProgressMonitor();

        public void addReturnValue(TAbstractCell var1);
    }
}

