/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.SWTDStyle;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;
import org.eclipse.tptp.platform.report.tools.internal.SimpleProgressMonitor;

public class StyleEditor
extends Composite {
    IDStyle d_fcurrentStyle = null;
    List d_fcurrentStylelist = null;
    Color altforeground = null;
    public final Signal styleChanged = new Signal("styleChanged()");
    boolean fontchanged = false;
    boolean bcolchanged = false;
    boolean fcolchanged = false;
    boolean undechanged = false;
    boolean strichanged = false;
    boolean overchanged = false;
    boolean dashchanged = false;
    private Color defaultfontbackground = null;
    private Color defaultbackground = null;
    Button w_changeFontButton = null;
    private Text w_fontLabel = null;
    protected Button w_foreColorButton = null;
    protected Button w_foreColorButton2 = null;
    private MyColorEditor w_foreColorEditor = null;
    protected Button w_backColorButton = null;
    protected Button w_backColorButton2 = null;
    private MyColorEditor w_backColorEditor = null;
    Button w_underlineButton = null;
    Button w_strikeoutButton = null;
    Button w_overlineButton = null;
    Button w_dashedButton = null;
    TextPreviewer w_previewer = null;
    FontData d_selectedFont = null;

    public static String getHelpMultiSelection() {
        return ReportCorePlugin.translate((String)"TEXT_HELP_MULTISELECTION");
    }

    public StyleEditor(Composite parent, int style) {
        super(parent, style);
        this.altforeground = new Color((Device)this.getDisplay(), 200, 200, 200);
        this.createSWidget();
        this.styleChanged.connect((Object)this, "applyStyle()");
    }

    public void setMultiSelectionColor(Color col) {
        if (col == null || col.isDisposed()) {
            return;
        }
        if (this.altforeground != null && !this.altforeground.isDisposed()) {
            this.altforeground.dispose();
        }
        this.altforeground = col;
    }

    public void setStyle(IDStyle style) {
        this.d_fcurrentStyle = style;
        this.d_fcurrentStylelist = null;
        this.d_selectedFont = null;
        this.initializeSWidget();
    }

    public void setStyleList(List stylelist) {
        this.d_fcurrentStyle = null;
        this.d_fcurrentStylelist = null;
        if (stylelist.size() > 0) {
            this.d_fcurrentStyle = (IDStyle)stylelist.get(0);
            if (stylelist.size() > 0) {
                this.d_fcurrentStylelist = stylelist;
            }
        }
        this.d_selectedFont = null;
        this.initializeSWidget();
    }

    public void applyStyle() {
        this.applyToStyle(this.d_fcurrentStyle);
        if (this.d_fcurrentStylelist != null) {
            int idx = 0;
            while (idx < this.d_fcurrentStylelist.size()) {
                IDStyle style = (IDStyle)this.d_fcurrentStylelist.get(idx);
                this.applyToStyle(style);
                ++idx;
            }
        }
        this.bcolchanged = false;
        this.fcolchanged = false;
        this.undechanged = false;
        this.strichanged = false;
        this.overchanged = false;
        this.dashchanged = false;
        this.updateStateWidget();
    }

    public void applyToStyle(IDStyle style) {
        RGB rgbc;
        IDColor bc;
        if (style == null) {
            return;
        }
        IDFont dfont = style.getFont();
        if (dfont == null) {
            dfont = new DFont();
        }
        int stold = dfont.getStyle();
        int st = 0;
        if (this.d_selectedFont != null) {
            dfont.setFamily(this.d_selectedFont.getName());
            dfont.setSize(this.d_selectedFont.getHeight());
            this.d_selectedFont.getStyle();
            if (false) {
                st = 0;
            }
            if ((this.d_selectedFont.getStyle() & 1) != 0) {
                st = 1;
            }
            if ((this.d_selectedFont.getStyle() & 2) != 0) {
                st += 2;
            }
        } else {
            st = 0xFFFFFFC3 & stold;
        }
        if (this.undechanged) {
            if (this.w_underlineButton.getSelection()) {
                st |= 4;
            }
        } else {
            st |= 4 & stold;
        }
        if (this.strichanged) {
            if (this.w_strikeoutButton.getSelection()) {
                st |= 0x20;
            }
        } else {
            st |= 0x20 & stold;
        }
        if (this.overchanged) {
            if (this.w_overlineButton.getSelection()) {
                st |= 8;
            }
        } else {
            st |= 8 & stold;
        }
        if (this.dashchanged) {
            if (this.w_dashedButton.getSelection()) {
                st |= 0x10;
            }
        } else {
            st |= 0x10 & stold;
        }
        dfont.setStyle(st);
        style.setFont(dfont);
        if (this.bcolchanged) {
            if (this.w_backColorButton.getSelection()) {
                bc = style.getBackColor();
                if (bc == null) {
                    bc = new DColor();
                }
                rgbc = this.w_backColorEditor.getColorValue();
                bc.setRGB(rgbc.red, rgbc.green, rgbc.blue);
                style.setBackColor(bc);
            } else {
                style.setBackColor(null);
            }
        }
        if (this.fcolchanged) {
            if (this.w_foreColorButton.getSelection()) {
                bc = style.getForeColor();
                if (bc == null) {
                    bc = new DColor();
                }
                rgbc = this.w_foreColorEditor.getColorValue();
                bc.setRGB(rgbc.red, rgbc.green, rgbc.blue);
                style.setForeColor(bc);
            } else {
                style.setForeColor(null);
            }
        }
    }

    protected void initializeSWidget() {
        if (this.d_fcurrentStyle == null) {
            return;
        }
        SWTDStyle.SFont sfont = SWTDStyle.getFont((Device)this.getDisplay(), (IDFont)this.d_fcurrentStyle.getFont());
        if (sfont != null) {
            FontData font = sfont.getFont().getFontData()[0];
            this.initFontWidget(font);
        }
        SWTDStyle.SColor backColor = null;
        Color bcolor = null;
        if (this.d_fcurrentStyle.getBackColor() == null) {
            bcolor = SWTDStyle.getDefaultBack((Device)this.getDisplay());
            this.w_backColorButton.setSelection(false);
            this.w_backColorButton2.setEnabled(false);
        } else {
            backColor = SWTDStyle.getColor((Device)this.getDisplay(), (IDColor)this.d_fcurrentStyle.getBackColor());
            bcolor = backColor.getColor();
            this.w_backColorButton.setSelection(true);
            this.w_backColorButton2.setEnabled(true);
        }
        this.w_backColorEditor.setColorValue(bcolor.getRGB());
        SWTDStyle.SColor foreColor = SWTDStyle.getColor((Device)this.getDisplay(), (IDColor)this.d_fcurrentStyle.getForeColor());
        if (this.d_fcurrentStyle.getForeColor() == null) {
            this.w_foreColorButton.setSelection(false);
            this.w_foreColorButton2.setEnabled(false);
        } else {
            this.w_foreColorButton.setSelection(true);
            this.w_foreColorButton2.setEnabled(true);
        }
        this.w_foreColorEditor.setColorValue(foreColor.getColor().getRGB());
        int IDStyle2 = 0;
        if (this.d_fcurrentStyle.getFont() != null) {
            IDStyle2 = this.d_fcurrentStyle.getFont().getStyle();
        }
        this.w_underlineButton.setSelection((IDStyle2 & 4) != 0);
        this.w_strikeoutButton.setSelection((IDStyle2 & 0x20) != 0);
        this.w_overlineButton.setSelection((IDStyle2 & 8) != 0);
        this.w_dashedButton.setSelection((IDStyle2 & 0x10) != 0);
        DFont nfont = null;
        if (this.d_fcurrentStyle.getFont() != null) {
            nfont = new DFont();
            nfont.setFamily(this.d_fcurrentStyle.getFont().getFamily());
            nfont.setScript(this.d_fcurrentStyle.getFont().getScript());
            nfont.setSize(this.d_fcurrentStyle.getFont().getSize());
            nfont.setStyle(this.d_fcurrentStyle.getFont().getStyle());
        }
        this.w_previewer.setDefaultStyle((IDStyle)new DStyle(this.d_fcurrentStyle.getName(), (IDFont)nfont, this.d_fcurrentStyle.getForeColor(), this.d_fcurrentStyle.getBackColor()));
        this.w_previewer.refresh();
        this.updateStateWidget();
    }

    void updateStateWidget() {
        if (this.d_fcurrentStylelist != null && this.haveDifferentFont()) {
            this.w_fontLabel.setBackground(this.altforeground);
        } else {
            this.w_fontLabel.setBackground(this.defaultfontbackground);
        }
        if (this.d_fcurrentStylelist != null && this.haveDifferentBCol()) {
            this.w_backColorButton.setBackground(this.altforeground);
        } else {
            this.w_backColorButton.setBackground(this.defaultbackground);
        }
        if (this.d_fcurrentStylelist != null && this.haveDifferentFCol()) {
            this.w_foreColorButton.setBackground(this.altforeground);
        } else {
            this.w_foreColorButton.setBackground(this.defaultbackground);
        }
        if (this.d_fcurrentStylelist != null && this.haveDifferentUnderline()) {
            this.w_underlineButton.setBackground(this.altforeground);
        } else {
            this.w_underlineButton.setBackground(this.defaultbackground);
        }
        if (this.d_fcurrentStylelist != null && this.haveDifferentStrikeOut()) {
            this.w_strikeoutButton.setBackground(this.altforeground);
        } else {
            this.w_strikeoutButton.setBackground(this.defaultbackground);
        }
        if (this.d_fcurrentStylelist != null && this.haveDifferentOverline()) {
            this.w_overlineButton.setBackground(this.altforeground);
        } else {
            this.w_overlineButton.setBackground(this.defaultbackground);
        }
        if (this.d_fcurrentStylelist != null && this.haveDifferentDashed()) {
            this.w_dashedButton.setBackground(this.altforeground);
        } else {
            this.w_dashedButton.setBackground(this.defaultbackground);
        }
    }

    void initFontWidget(FontData fd) {
        int style = fd.getStyle();
        String strStyle = new String();
        if (false) {
            strStyle = "Normal ";
        }
        if ((style & 1) != 0) {
            strStyle = String.valueOf(strStyle) + "Bold ";
        }
        if ((style & 2) != 0) {
            strStyle = String.valueOf(strStyle) + "Italic ";
        }
        this.w_fontLabel.setText(String.valueOf(fd.getName()) + ", " + fd.getHeight() + " " + strStyle);
    }

    private boolean haveDifferentFont() {
        boolean bold;
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
        boolean bl = font != null ? (font.getStyle() & 1) == 1 : (bold = false);
        boolean italic = font != null ? (font.getStyle() & 2) == 2 : false;
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
            if (font == null || font.getFamily() == null) {
                if (fonttmp != null) {
                    return true;
                }
            } else {
                if (fonttmp == null || fonttmp.getFamily() == null) {
                    return true;
                }
                if (!font.getFamily().equalsIgnoreCase(fonttmp.getFamily()) || font.getSize() != fonttmp.getSize() || (fonttmp.getStyle() & 1) == 1 != bold || (fonttmp.getStyle() & 2) == 2 != italic) {
                    return true;
                }
            }
            ++idx;
        }
        return false;
    }

    private boolean haveDifferentFCol() {
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDColor color = ((IDStyle)this.d_fcurrentStylelist.get(0)).getForeColor();
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            IDColor colortmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getForeColor();
            if (color == null) {
                if (colortmp != null) {
                    return true;
                }
            } else {
                if (colortmp == null) {
                    return true;
                }
                if (color.getBlue() != colortmp.getBlue() || color.getGreen() != colortmp.getGreen() || color.getRed() != colortmp.getRed()) {
                    return true;
                }
            }
            ++idx;
        }
        return false;
    }

    private boolean haveDifferentBCol() {
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDColor color = ((IDStyle)this.d_fcurrentStylelist.get(0)).getBackColor();
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            IDColor colortmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getBackColor();
            if (color == null) {
                if (colortmp != null) {
                    return true;
                }
            } else {
                if (colortmp == null) {
                    return true;
                }
                if (color.getBlue() != colortmp.getBlue() || color.getGreen() != colortmp.getGreen() || color.getRed() != colortmp.getRed()) {
                    return true;
                }
            }
            ++idx;
        }
        return false;
    }

    private boolean haveDifferentUnderline() {
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
        boolean underline = font != null ? (font.getStyle() & 4) == 4 : false;
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            boolean underlinetmp;
            IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
            boolean bl = fonttmp != null ? (fonttmp.getStyle() & 4) == 4 : (underlinetmp = false);
            if (underline != underlinetmp) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean haveDifferentStrikeOut() {
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
        boolean strike = font != null ? (font.getStyle() & 0x20) == 32 : false;
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            boolean striketmp;
            IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
            boolean bl = fonttmp != null ? (fonttmp.getStyle() & 0x20) == 32 : (striketmp = false);
            if (strike != striketmp) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean haveDifferentOverline() {
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
        boolean overline = font != null ? (font.getStyle() & 8) == 8 : false;
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            boolean overlinetmp;
            IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
            boolean bl = fonttmp != null ? (fonttmp.getStyle() & 8) == 8 : (overlinetmp = false);
            if (overline != overlinetmp) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean haveDifferentDashed() {
        if (this.d_fcurrentStylelist == null) {
            return false;
        }
        if (this.d_fcurrentStylelist.size() < 2) {
            return false;
        }
        IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
        boolean dashed = font != null ? (font.getStyle() & 0x10) == 16 : false;
        int idx = 1;
        while (idx < this.d_fcurrentStylelist.size()) {
            boolean dashedtmp;
            IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
            boolean bl = fonttmp != null ? (fonttmp.getStyle() & 0x10) == 16 : (dashedtmp = false);
            if (dashed != dashedtmp) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private GridData createFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    private GridData createHorizontalFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    protected void createSWidget() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(this.createFill());
        Group gb = new Group((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        gb.setLayout((Layout)layout);
        gb.setLayoutData((Object)this.createHorizontalFill());
        gb.setText(ReportCorePlugin.translate((String)"TEXT_FONT"));
        this.w_fontLabel = new Text((Composite)gb, 2056);
        GridData data = this.createHorizontalFill();
        data.horizontalSpan = 3;
        this.w_fontLabel.setLayoutData((Object)data);
        this.w_fontLabel.setText(ReportCorePlugin.translate((String)"UNKNOWN"));
        this.defaultfontbackground = this.w_fontLabel.getBackground();
        this.w_changeFontButton = new Button((Composite)gb, 8);
        this.w_changeFontButton.setText(ReportCorePlugin.translate((String)"CHANGE_TEXT_FONT"));
        this.w_changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTDStyle.SFont sfont;
                FontDialog fontDialog = new FontDialog(StyleEditor.this.w_changeFontButton.getShell());
                if (StyleEditor.this.d_selectedFont != null) {
                    FontData[] fdloc = new FontData[]{StyleEditor.this.d_selectedFont};
                    fontDialog.setFontList(fdloc);
                } else if (StyleEditor.this.d_fcurrentStyle != null && (sfont = SWTDStyle.getFont((Device)StyleEditor.this.getDisplay(), (IDFont)StyleEditor.this.d_fcurrentStyle.getFont())) != null) {
                    fontDialog.setFontList(sfont.getFont().getFontData());
                }
                StyleEditor.this.d_selectedFont = fontDialog.open();
                if (StyleEditor.this.d_selectedFont != null) {
                    StyleEditor.this.initFontWidget(StyleEditor.this.d_selectedFont);
                    StyleEditor.this.w_previewer.setFont(StyleEditor.this.d_selectedFont);
                }
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_changeFontButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                StyleEditor.this.w_changeFontButton = null;
            }
        });
        gb = new Group((Composite)this, 0);
        GridLayout glayout = new GridLayout(2, false);
        gb.setLayout((Layout)glayout);
        gb.setLayoutData((Object)this.createHorizontalFill());
        gb.setText(ReportCorePlugin.translate((String)"FONT_COLORS"));
        this.w_foreColorButton = new Button((Composite)gb, 16416);
        this.w_foreColorButton.setText(ReportCorePlugin.translate((String)"FOREGROUND_COLOR"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        this.w_foreColorButton.setLayoutData((Object)gd);
        this.w_foreColorEditor = new MyColorEditor((Composite)gb);
        this.w_foreColorButton2 = this.w_foreColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.w_foreColorButton2.setLayoutData((Object)gd);
        this.w_foreColorButton2.setEnabled(false);
        this.w_foreColorEditor.setColorValue(new RGB(0, 0, 0));
        this.w_foreColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                StyleEditor.this.fcolchanged = true;
                StyleEditor.this.w_foreColorButton2.setEnabled(StyleEditor.this.w_foreColorButton.getSelection());
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_foreColorButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                StyleEditor.this.fcolchanged = true;
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_backColorButton = new Button((Composite)gb, 16416);
        this.w_backColorButton.setText(ReportCorePlugin.translate((String)"BACKGROUND_COLOR"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        this.w_backColorButton.setLayoutData((Object)gd);
        this.w_backColorEditor = new MyColorEditor((Composite)gb);
        this.w_backColorButton2 = this.w_backColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.w_backColorButton2.setLayoutData((Object)gd);
        this.w_backColorButton2.setEnabled(false);
        this.w_backColorEditor.setColorValue(new RGB(255, 255, 255));
        this.w_backColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                StyleEditor.this.bcolchanged = true;
                StyleEditor.this.w_backColorButton2.setEnabled(StyleEditor.this.w_backColorButton.getSelection());
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_backColorButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                StyleEditor.this.bcolchanged = true;
                StyleEditor.this.styleChanged.emit();
            }
        });
        gb = new Group((Composite)this, 0);
        glayout = new GridLayout(2, true);
        gb.setLayout((Layout)glayout);
        gb.setLayoutData((Object)this.createHorizontalFill());
        gb.setText(ReportCorePlugin.translate((String)"FONT_ATTRIBUTES"));
        this.w_underlineButton = new Button((Composite)gb, 32);
        this.w_underlineButton.setText(ReportCorePlugin.translate((String)"UNDERLINE"));
        this.w_underlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleEditor.this.undechanged = true;
                StyleEditor.this.w_previewer.setUnderline(StyleEditor.this.w_underlineButton.getSelection());
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.defaultbackground = this.w_underlineButton.getBackground();
        this.w_strikeoutButton = new Button((Composite)gb, 32);
        this.w_strikeoutButton.setText(ReportCorePlugin.translate((String)"STRIKE_OUT"));
        this.w_strikeoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleEditor.this.strichanged = true;
                StyleEditor.this.w_previewer.setStrikeOut(StyleEditor.this.w_strikeoutButton.getSelection());
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_overlineButton = new Button((Composite)gb, 32);
        this.w_overlineButton.setText(ReportCorePlugin.translate((String)"OVERLINE"));
        this.w_overlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleEditor.this.overchanged = true;
                StyleEditor.this.w_previewer.setOverline(StyleEditor.this.w_overlineButton.getSelection());
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_dashedButton = new Button((Composite)gb, 32);
        this.w_dashedButton.setText(ReportCorePlugin.translate((String)"DASHED"));
        this.w_dashedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleEditor.this.dashchanged = true;
                StyleEditor.this.w_previewer.setDashed(StyleEditor.this.w_dashedButton.getSelection());
                StyleEditor.this.styleChanged.emit();
            }
        });
        this.w_previewer = new TextPreviewer(ReportCorePlugin.translate((String)"TEXT_FOR_PREVIEW"), this);
        gd = new GridData(1808);
        gd.heightHint = this.w_previewer.getPreferredExtent();
        gd.widthHint = this.w_previewer.getPreferredExtent();
        this.w_previewer.getControl().setLayoutData((Object)gd);
        this.w_foreColorEditor.sgn_valueChanged.connect((Object)this.w_previewer, "setForegroundColor(org.eclipse.swt.graphics.Color)");
        this.w_backColorEditor.sgn_valueChanged.connect((Object)this.w_previewer, "setBackgroundColor(org.eclipse.swt.graphics.Color)");
    }

    class MyColorEditor {
        private Point fExtent;
        Image fImage;
        RGB fColorValue;
        Color fColor;
        Button fButton;
        public final Signal sgn_valueChanged = new Signal("valueChanged(org.eclipse.swt.graphics.Color)");

        public MyColorEditor(Composite parent) {
            this.fButton = new Button(parent, 8);
            this.fExtent = this.computeImageSize((Control)parent);
            this.fImage = new Image((Device)parent.getDisplay(), this.fExtent.x, this.fExtent.y);
            GC gc = new GC((Drawable)this.fImage);
            gc.setBackground(this.fButton.getBackground());
            gc.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
            gc.dispose();
            this.fButton.setImage(this.fImage);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ColorDialog colorDialog = new ColorDialog(MyColorEditor.this.fButton.getShell());
                    colorDialog.setRGB(MyColorEditor.this.fColorValue);
                    RGB newColor = colorDialog.open();
                    if (newColor != null) {
                        MyColorEditor.this.fColorValue = newColor;
                        MyColorEditor.this.updateColorImage();
                        MyColorEditor.this.sgn_valueChanged.emit((Object)new Color((Device)MyColorEditor.this.fButton.getDisplay(), newColor));
                    }
                }
            });
            this.fButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (MyColorEditor.this.fImage != null) {
                        MyColorEditor.this.fImage.dispose();
                        MyColorEditor.this.fImage = null;
                    }
                    if (MyColorEditor.this.fColor != null) {
                        MyColorEditor.this.fColor.dispose();
                        MyColorEditor.this.fColor = null;
                    }
                }
            });
        }

        public RGB getColorValue() {
            return this.fColorValue;
        }

        public void setColorValue(RGB rgb) {
            this.fColorValue = rgb;
            this.updateColorImage();
        }

        public Button getButton() {
            return this.fButton;
        }

        protected void updateColorImage() {
            Display display = this.fButton.getDisplay();
            GC gc = new GC((Drawable)this.fImage);
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
            if (this.fColor != null) {
                this.fColor.dispose();
            }
            this.fColor = new Color((Device)display, this.fColorValue);
            gc.setBackground(this.fColor);
            gc.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
            gc.dispose();
            this.fButton.setImage(this.fImage);
        }

        protected Point computeImageSize(Control window) {
            GC gc = new GC((Drawable)window);
            Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
            gc.setFont(f);
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            Point p = new Point(height * 3 - 6, height);
            return p;
        }
    }

    public static class TextPreviewer {
        private SWTViewer f_text;
        private IDStyle f_style;
        private String f_string = null;
        DDocument doc = null;
        private DText f_dtxt = null;

        public TextPreviewer(String s, Composite parent) {
            this.f_string = s;
            this.f_text = new SWTViewer(parent, 2048);
            this.f_text.setProgressMonitor((IDProgressMonitor)new SimpleProgressMonitor());
            this.f_text.setMargins(10, 0, 0, 0);
            this.doc = new DDocument();
            DSection s1 = new DSection("");
            this.doc.addChild((IDItem)s1);
            DParagraph p = new DParagraph(36);
            s1.addChild((IDItem)p);
            this.f_dtxt = new DText(this.f_string);
            p.addChild((IDItem)this.f_dtxt);
            this.f_text.setContent((IDItem)this.doc);
        }

        public void refresh() {
            this.f_text.refresh();
        }

        public Control getControl() {
            return this.f_text;
        }

        public void setDefaultStyle(IDStyle style) {
            this.f_style = style;
            IDFont dfont = this.f_style.getFont();
            if (dfont == null) {
                dfont = new DFont();
            }
            this.f_style.setFont(dfont);
            this.doc.setStyle(this.f_style);
            this.f_dtxt.setStyle(this.f_style);
            if (this.f_style.getBackColor() != null) {
                this.f_text.setBackground(SWTDStyle.getColor((Device)Display.getCurrent(), (IDColor)this.f_style.getBackColor()).getColor());
            } else {
                this.f_text.setBackground(SWTDStyle.getDefaultBack((Device)Display.getCurrent()));
            }
            this.f_text.redraw();
        }

        public void setFont(FontData fontData) {
            IDFont dfont = this.f_style.getFont();
            int st = dfont.getStyle();
            if (fontData != null) {
                dfont.setFamily(fontData.getName());
                dfont.setSize(fontData.getHeight());
                fontData.getStyle();
                st = false ? (st |= 0) : (st &= 0xFFFFFFFF);
                st = (fontData.getStyle() & 1) != 0 ? (st |= 1) : (st &= 0xFFFFFFFE);
                st = (fontData.getStyle() & 2) != 0 ? (st |= 2) : (st &= 0xFFFFFFFD);
            }
            dfont.setStyle(st);
            this.f_style.setFont(dfont);
            this.f_text.redraw();
        }

        public void setForegroundColor(Color fcolor) {
            this.f_style.setForeColor((IDColor)new DColor(fcolor.getRed(), fcolor.getGreen(), fcolor.getBlue()));
            this.f_text.redraw();
        }

        public void setBackgroundColor(Color bcolor) {
            this.f_style.setBackColor((IDColor)new DColor(bcolor.getRed(), bcolor.getGreen(), bcolor.getBlue()));
            this.f_text.setBackground(SWTDStyle.getColor((Device)Display.getCurrent(), (IDColor)this.f_style.getBackColor()).getColor());
            this.f_text.redraw();
        }

        public void setUnderline(boolean sel) {
            IDFont dfont = this.f_style.getFont();
            if (sel) {
                dfont.setStyle(dfont.getStyle() | 4);
            } else {
                dfont.setStyle(dfont.getStyle() & 0xFFFFFFFB);
            }
            this.f_style.setFont(dfont);
            this.f_text.redraw();
        }

        public void setStrikeOut(boolean sel) {
            IDFont dfont = this.f_style.getFont();
            if (sel) {
                dfont.setStyle(dfont.getStyle() | 0x20);
            } else {
                dfont.setStyle(dfont.getStyle() & 0xFFFFFFDF);
            }
            this.f_style.setFont(dfont);
            this.f_text.redraw();
        }

        public void setOverline(boolean sel) {
            IDFont dfont = this.f_style.getFont();
            if (sel) {
                dfont.setStyle(dfont.getStyle() | 8);
            } else {
                dfont.setStyle(dfont.getStyle() & 0xFFFFFFF7);
            }
            this.f_style.setFont(dfont);
            this.f_text.redraw();
        }

        public void setDashed(boolean sel) {
            IDFont dfont = this.f_style.getFont();
            if (sel) {
                dfont.setStyle(dfont.getStyle() | 0x10);
            } else {
                dfont.setStyle(dfont.getStyle() & 0xFFFFFFEF);
            }
            this.f_style.setFont(dfont);
            this.f_text.redraw();
        }

        public int getPreferredExtent() {
            return 40;
        }
    }
}

