/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.StyleEditor;
import org.eclipse.xsd.util.XSDParser;

public class StyleRegistryEditor
extends Composite {
    Signal itemSelected = new Signal("itemSelected(org.eclipse.tptp.platform.report.core.internal.IDStyle)");
    Signal itemsSelected = new Signal("itemsSelected(sellist)");
    DStyleRegistry localRegistry = null;
    DStyleRegistry sourceRegistry = null;
    public Signal valueChanged = new Signal("valueChanged(boolean)");
    org.eclipse.swt.widgets.List thelist = null;
    private StyleEditor theeditor = null;

    public StyleRegistryEditor(Composite parent, int style) {
        super(parent, style);
        this.createSWidget();
    }

    protected void createSWidget() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        this.setLayout((Layout)layout);
        this.thelist = new org.eclipse.swt.widgets.List((Composite)this, 2818);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        this.thelist.setLayoutData((Object)data);
        this.theeditor = new StyleEditor(this, 0);
        this.thelist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selcount = StyleRegistryEditor.this.thelist.getSelectionCount();
                if (selcount == 0) {
                    return;
                }
                if (selcount == 1) {
                    String sel = StyleRegistryEditor.this.thelist.getItem(StyleRegistryEditor.this.thelist.getSelectionIndex());
                    IDStyle sty = StyleRegistryEditor.this.localRegistry.getFirstStyle(sel);
                    StyleRegistryEditor.this.itemSelected.emit((Object)((DStyle)sty));
                    return;
                }
                String[] seltab = StyleRegistryEditor.this.thelist.getSelection();
                ArrayList<IDStyle> sellist = new ArrayList<IDStyle>(seltab.length);
                int idx = 0;
                while (idx < seltab.length) {
                    IDStyle sty = StyleRegistryEditor.this.localRegistry.getFirstStyle(seltab[idx]);
                    if (sty != null) {
                        sellist.add(sty);
                    }
                    ++idx;
                }
                StyleRegistryEditor.this.itemsSelected.emit(sellist);
            }
        });
        this.itemSelected.connect((Object)this.theeditor, "setStyle(org.eclipse.tptp.platform.report.core.internal.IDStyle)");
        this.itemsSelected.connect((Object)this.theeditor, "setStyleList(java.util.List)");
    }

    public void applyUpdate() {
        for (IDStyle so : this.localRegistry) {
            IDStyle s = this.sourceRegistry.getFirstStyle(so.getName());
            s.setBackColor(so.getBackColor());
            s.setForeColor(so.getForeColor());
            s.setFont(so.getFont());
            s.setNumberingFormat(so.getNumberingFormat());
            s.setWallpaper(so.getWallpaper());
            s.setName(so.getName());
        }
    }

    protected void updateSWidget() {
        this.thelist.removeAll();
        if (this.localRegistry == null) {
            return;
        }
        for (Object obj : this.localRegistry) {
            if (obj == null || !(obj instanceof IDStyle)) continue;
            DStyle style = (DStyle)obj;
            this.thelist.add(style.getName());
        }
        if (this.thelist.getItemCount() > 0) {
            this.thelist.select(0);
            String first = this.thelist.getItem(0);
            IDStyle sty = this.localRegistry.getFirstStyle(first);
            this.theeditor.setStyle((IDStyle)((DStyle)sty));
        }
    }

    public void setStyleRegistry(DStyleRegistry registry) {
        this.localRegistry = new DStyleRegistry();
        this.sourceRegistry = registry;
        Iterator i = registry.iterator();
        while (i.hasNext()) {
            DStyle s = new DStyle();
            IDStyle so = (IDStyle)i.next();
            DColor cl = null;
            if (so.getBackColor() != null) {
                cl = new DColor(so.getBackColor().getRed(), so.getBackColor().getGreen(), so.getBackColor().getBlue());
            }
            s.setBackColor(cl);
            cl = null;
            if (so.getForeColor() != null) {
                cl = new DColor(so.getForeColor().getRed(), so.getForeColor().getGreen(), so.getForeColor().getBlue());
            }
            s.setForeColor(cl);
            DFont f = null;
            if (so.getFont() != null) {
                f = new DFont(so.getFont().getFamily(), so.getFont().getScript(), so.getFont().getSize(), so.getFont().getStyle());
            }
            s.setFont(f);
            s.setNumberingFormat(so.getNumberingFormat());
            s.setWallpaper(so.getWallpaper());
            s.setName(so.getName());
            this.localRegistry.putStyle((IDStyle)s);
        }
        this.updateSWidget();
    }

    public void updateStyleRegistry(DStyleRegistry newregistry) {
        for (Object s : newregistry) {
            if (!(s instanceof IDStyle)) continue;
            List sol = this.localRegistry.getStyles(((IDStyle)s).getName());
            if (sol != null && sol.size() > 0) {
                for (Object so : sol) {
                    if (!(so instanceof IDStyle)) continue;
                    ((IDStyle)so).setBackColor(((IDStyle)s).getBackColor());
                    ((IDStyle)so).setForeColor(((IDStyle)s).getForeColor());
                    ((IDStyle)so).setFont(((IDStyle)s).getFont());
                    ((IDStyle)so).setNumberingFormat(((IDStyle)s).getNumberingFormat());
                    ((IDStyle)so).setWallpaper(((IDStyle)s).getWallpaper());
                }
                continue;
            }
            this.localRegistry.putStyle((IDStyle)s);
        }
        this.updateSWidget();
    }

    public void fromText(String txt) {
        if (txt == null || txt == ReportCorePlugin.translate((String)"3")) {
            return;
        }
        DXmlReader reader = new DXmlReader((IXmlParser)new XSDXmlParserAdapter(new XSDParser()));
        ByteArrayInputStream buf = new ByteArrayInputStream(txt.getBytes());
        try {
            reader.read((InputStream)buf);
            DStyleRegistry newregistry = reader.getStyleRegistry();
            if (newregistry != null) {
                this.updateStyleRegistry(newregistry);
            }
        }
        catch (Exception e) {
            System.err.println(ReportCorePlugin.translate((String)"READ_FAILED"));
            e.printStackTrace();
        }
    }

    public String toText() {
        DXmlWriter aw = new DXmlWriter();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            aw.write((OutputStream)buf, (IDObject)this.localRegistry);
        }
        catch (Exception exception) {}
        return buf.toString();
    }
}

