/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.StyleRegistryEditor;

public class StylesFieldEditor
extends FieldEditor {
    private DStyleRegistry d_registry = null;
    private StyleRegistryEditor w_stylesField = null;
    public Signal valueChanged = new Signal("valueChanged(boolean)");

    public StylesFieldEditor() {
    }

    public StylesFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
        this.connectSignals();
    }

    private void connectSignals() {
        if (this.w_stylesField == null) {
            return;
        }
        this.w_stylesField.valueChanged.connect(this.valueChanged);
    }

    public void setStylesRegistry(DStyleRegistry reg) {
        this.d_registry = reg;
        if (this.w_stylesField != null) {
            this.w_stylesField.setStyleRegistry(this.d_registry);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.w_stylesField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.w_stylesField = new StyleRegistryEditor(parent, 0);
        if (this.d_registry != null) {
            this.w_stylesField.setStyleRegistry(this.d_registry);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 400;
        this.w_stylesField.setLayoutData(gd);
    }

    protected void doLoad() {
        if (this.w_stylesField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.w_stylesField.fromText(value);
        }
    }

    protected void doLoadDefault() {
        if (this.w_stylesField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.w_stylesField.fromText(value);
        }
    }

    protected void doStore() {
        this.w_stylesField.applyUpdate();
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.w_stylesField.toText());
    }

    public int getNumberOfControls() {
        return 1;
    }
}

