/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.actions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.tptp.platform.common.ui.trace.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIDelegateHelper;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class RunGCActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object element) throws Exception {
        if (element instanceof TRCAgentProxy) {
            this.run((TRCAgentProxy)element);
        }
    }

    public boolean isEnabledFor(Object element) {
        if (element instanceof TRCAgentProxy) {
            TRCAgentProxy agent = (TRCAgentProxy)element;
            return this.isEnabledFor(agent);
        }
        if (element instanceof TRCProcessProxy) {
            EList agents = ((TRCProcessProxy)element).getAgentProxies();
            for (TRCAgentProxy agent : agents) {
                if (agent.eIsProxy() || !this.isEnabledFor(agent)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEnabledFor(TRCAgentProxy agent) {
        return agent.getType().equals("Profiler") && agent.isMonitored();
    }

    private void run(TRCAgentProxy trcAgent) throws InactiveAgentException, NotConnectedException {
        if (!trcAgent.getType().equals("Profiler")) {
            return;
        }
        if (!trcAgent.isMonitored()) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString((String)CommonUITraceMessages.TRC_MSGT), (String)UIPlugin.getResourceString((String)TIMessages.ERROR_RUN_GC));
            return;
        }
        IAgentController agentController = null;
        ICollector agentInstance = null;
        TRCNode trcNode = trcAgent.getProcessProxy().getNode();
        try {
            agentController = AgentControllerDelegate.getInstance().getConnection(trcNode.getName(), trcNode.getPort());
        }
        catch (Exception e) {
            LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)NLS.bind((String)TIMessages.ERROR_TI_AC_UNAVAILABLE, (Object)String.valueOf(trcNode.getPort())), (Throwable)e);
            return;
        }
        if (agentController != null) {
            agentInstance = TIDelegateHelper.locateTIAgent(agentController, trcAgent.getProcessProxy().getPid());
        }
        if (agentInstance instanceof IAgent) {
            agentInstance.sendCommand("<RunGC iid=\"org.eclipse.tptp.jvmti\"/></RunGC>", new ICommandHandler(){

                public void incomingCommand(INode node, ICommandElement command) {
                }
            });
        }
    }
}

