/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.provisional.extension.ICustomAnalysisProvider;

public class TIHeapAnalysisUI {
    private Button collectObjectAllocationSite;
    private ICustomAnalysisProvider[] providers = null;

    public void setProviders(ICustomAnalysisProvider[] providers) {
        this.providers = providers;
    }

    public void createControl(Composite parent) {
        this.createLevelOfDetailGroup(parent);
    }

    private void createLevelOfDetailGroup(Composite parent) {
        Group grp = this.createGroup(parent, TIMessages.EXEC_LEVEL_OF_DETAIL);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 10;
        grp.setLayout((Layout)gridLayout);
        this.collectObjectAllocationSite = this.createButton((Composite)grp, TIMessages.EXEC_COLLECT_OBJECT_ALLOCATION, 32);
        this.collectObjectAllocationSite.setToolTipText(TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_HEAP_OBJ_ALLOC_DESC"));
        if (this.providers != null) {
            int provider = 0;
            while (provider < this.providers.length) {
                this.providers[provider].createAnalysisButton(this.createButton((Composite)grp, this.providers[provider].getButtonName(), 32));
                ++provider;
            }
        }
    }

    private Group createGroup(Composite parent, String name) {
        Group grp = new Group(parent, 0);
        grp.setLayout((Layout)new GridLayout());
        grp.setLayoutData((Object)new GridData(4, -1, true, true));
        grp.setText(name);
        return grp;
    }

    private Button createButton(Composite parent, String name, int style) {
        Button button = new Button(parent, style);
        button.setLayoutData((Object)new GridData(4, -1, true, false));
        button.setText(name);
        return button;
    }

    public boolean isCollectObjectAllocationSiteSelected() {
        return this.collectObjectAllocationSite == null || this.collectObjectAllocationSite.isDisposed() ? false : this.collectObjectAllocationSite.getSelection();
    }

    public void setCollectObjectAllocationSite(boolean collectObjectAllocation) {
        this.collectObjectAllocationSite.setSelection(collectObjectAllocation);
    }
}

