/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.probekit.launch.internal.ProbekitLaunchPlugin;
import org.eclipse.tptp.platform.probekit.launch.internal.config.ProbekitLaunchMessages;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistry;
import org.eclipse.tptp.platform.probekit.registry.ProbeRegistryEntry;
import org.eclipse.tptp.platform.probekit.util.InvalidProbeBundleException;
import org.eclipse.tptp.platform.probekit.util.ProbeLaunchConfigString;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILaunchValidator;

public class TIProbekitLaunchValidator
implements ILaunchValidator {
    public IStatus validateConfiguration(ILaunchConfiguration configuration) {
        Status noProbesSelected = null;
        try {
            boolean probesSelected = configuration.getAttribute("anyProbesSelected", false);
            if (!probesSelected) {
                noProbesSelected = new Status(4, UIPlugin.getPluginId(), LauncherMessages.ERROR_NO_PROBES_SELECTED);
            }
        }
        catch (Exception exception) {}
        return noProbesSelected;
    }

    public IStatus launchNotification(ILaunchConfiguration configuration) {
        final ProfilingSetsManager psm = ProfilingSetsManager.instance();
        final ArrayList<String> invalidProbes = new ArrayList<String>();
        String strMissingOrInvalidProbes = "";
        String strLineSeparator = System.getProperty("line.separator");
        final ILaunchConfiguration config = configuration;
        Map mapProbeSpecs = this.getSelectedProbes(configuration, "org.eclipse.tptp.platform.probekit.Probespec.PROBEUI");
        Iterator iterKeys = mapProbeSpecs.keySet().iterator();
        while (iterKeys.hasNext()) {
            String key = iterKeys.next().toString();
            String strProbeSpec = (String)mapProbeSpecs.get(key);
            ProbeLaunchConfigString probeConfigDeploy = ProbeLaunchConfigString.fromString((String)strProbeSpec);
            String strProbeID = probeConfigDeploy.getRegistryId();
            ProbeRegistryEntry entry = ProbeRegistry.getRegistry().lookupById(strProbeID);
            if (entry == null) {
                strMissingOrInvalidProbes = String.valueOf(strMissingOrInvalidProbes) + strProbeID + strLineSeparator;
                invalidProbes.add(strProbeID);
                continue;
            }
            try {
                entry.fullValidate();
            }
            catch (InvalidProbeBundleException invalidProbeBundleException) {
                strMissingOrInvalidProbes = String.valueOf(strMissingOrInvalidProbes) + strProbeID + strLineSeparator;
                invalidProbes.add(strProbeID);
                ProbeRegistry.getRegistry().remove(entry);
            }
        }
        if (strMissingOrInvalidProbes.length() > 0) {
            strMissingOrInvalidProbes = String.valueOf(strLineSeparator) + strMissingOrInvalidProbes;
            final String strWarningQuery = NLS.bind((String)ProbekitLaunchMessages._26, (Object)strMissingOrInvalidProbes);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    boolean bOK = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)ProbekitLaunchMessages._27, (String)strWarningQuery);
                    if (bOK) {
                        try {
                            String setID = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, null);
                            IProfilingSet set = (IProfilingSet)psm.getProfilingSets().get(setID);
                            if (set != null) {
                                String strProbeOptionPrefix = "SETOPTION_org.eclipse.tptp.platform.probekit.Probespec.PROBEUI";
                                boolean bRemovedProbes = false;
                                Map attributes = set.getAttributes();
                                Iterator iterKeys = attributes.keySet().iterator();
                                while (iterKeys.hasNext()) {
                                    ProfilingAttribute profAttribute;
                                    String strValue;
                                    ProbeLaunchConfigString probeConfigDeploy;
                                    String strID;
                                    String key = iterKeys.next().toString();
                                    if (!key.startsWith(strProbeOptionPrefix) || !invalidProbes.contains(strID = (probeConfigDeploy = ProbeLaunchConfigString.fromString((String)(strValue = (profAttribute = (ProfilingAttribute)attributes.get(key)).getValue()))).getRegistryId())) continue;
                                    iterKeys.remove();
                                    bRemovedProbes = true;
                                }
                                if (bRemovedProbes) {
                                    set.setAttributes(attributes);
                                    psm.writeSetsToPreferences();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ProbekitLaunchPlugin.reportException((Throwable)e);
                        }
                    }
                }
            });
        }
        return null;
    }

    protected Map getSelectedProbes(ILaunchConfiguration launchConfig, String strPrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ProfilingSetsManager psm = ProfilingSetsManager.instance();
            Vector configOptions = psm.getOptions(launchConfig);
            for (AgentConfigurationEntry entry : configOptions) {
                String strName;
                if (entry == null || (strName = entry.getName()) == null || !strName.startsWith(strPrefix)) continue;
                String strValue = entry.getValue();
                map.put(strName, strValue);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return map;
    }
}

