/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.internal.analysistypes.TIThreadAnalysisUI;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.PIMemoryAnalysisConf;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;

public class TIThreadAnalysisConfig
extends AbstractConfiguration {
    public TIThreadAnalysisConfig() {
        super(new Class[]{TIThreadAnalysisOpt.class});
    }

    public static class TIThreadAnalysisOpt
    extends PIMemoryAnalysisConf.MemoryConfigurationPage {
        private TIThreadAnalysisUI threadAnalysisUI = new TIThreadAnalysisUI();
        private boolean contentionAnalysis = false;
        private boolean controlsCreated;

        public void reset(ILaunchConfiguration launchConfiguration) {
            try {
                this.contentionAnalysis = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS, false);
            }
            catch (CoreException e) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_CONFIGURATION_RESET, (Throwable)e);
            }
        }

        public Vector getAttributes() {
            if (this.controlsCreated) {
                this.contentionAnalysis = this.threadAnalysisUI.getContentionAnalysis();
            }
            Vector<DataCollectionEngineAttribute> options = new Vector<DataCollectionEngineAttribute>();
            options.add(new DataCollectionEngineAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS, String.valueOf(this.contentionAnalysis)));
            return options;
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
            if (this.controlsCreated) {
                this.contentionAnalysis = this.threadAnalysisUI.getContentionAnalysis();
            }
            configurationWC.setAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS, this.contentionAnalysis);
            return true;
        }

        public void createControl(Composite parent) {
            this.threadAnalysisUI.createControl(parent);
            this.threadAnalysisUI.setContentionAnalysis(this.contentionAnalysis);
            this.controlsCreated = true;
        }

        public String getDescription() {
            return TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_THRD_DESC");
        }

        public String getTitle() {
            return TIPlugin.getResourceString("JVMTI_ANALYSIS_TYPE_THRD_NAME");
        }
    }
}

