/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.analysistypes;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;

public class TITimeAnalysisUI {
    private Button collectCPUTime;
    private Button showExecutionStat;
    private Button showExecutionFlow;
    private Button _autoFrequency;
    private Button _manualFrequency;
    private Spinner _pollingFreq;

    public void createControl(Composite parent) {
        this.createLevelOfDetailGroup(parent);
        this.createTypeOfDataGroup(parent);
    }

    private void createLevelOfDetailGroup(Composite parent) {
        Group grp = this.createGroup(parent, TIMessages.EXEC_LEVEL_OF_DETAIL);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 10;
        grp.setLayout((Layout)gridLayout);
        this.collectCPUTime = this.createButton((Composite)grp, TIMessages.EXEC_COLLECT_CPU_TIME, 32);
    }

    private void createTypeOfDataGroup(Composite parent) {
        Group grp = this.createGroup(parent, TIMessages.EXEC_TYPE_OF_DATA);
        ((GridData)grp.getLayoutData()).verticalAlignment = 0x1000008;
        this.showExecutionStat = this.createButton((Composite)grp, TIMessages.EXEC_COLLECT_STATISTICS, 16);
        this.addExecutionOption(grp);
        this.showExecutionFlow = this.createButton((Composite)grp, TIMessages.EXEC_COLLECT_FLOW, 16);
        this.showExecutionStat.setSelection(false);
        this.showExecutionFlow.setSelection(true);
    }

    private void addExecutionOption(Group ctx) {
        GridLayout layout = new GridLayout(2, false);
        Composite _detailsExecGroup = new Composite((Composite)ctx, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalIndent = 20;
        _detailsExecGroup.setLayoutData((Object)data);
        _detailsExecGroup.setLayout((Layout)layout);
        Composite pollingFreqComp = new Composite(_detailsExecGroup, 0);
        GridLayout pollingFreqCompGL = new GridLayout(2, false);
        pollingFreqCompGL.marginLeft = 20;
        pollingFreqComp.setLayout((Layout)pollingFreqCompGL);
        pollingFreqComp.setLayoutData((Object)new GridData(4, -1, true, false));
        this._autoFrequency = new Button(pollingFreqComp, 16);
        GridData autoFrequencyGD = new GridData(4, -1, true, false);
        autoFrequencyGD.horizontalSpan = 2;
        this._autoFrequency.setLayoutData((Object)autoFrequencyGD);
        this._autoFrequency.setText(TraceMessages.EXECUTION_ANALYSIS_AUTO_FREQ);
        this._autoFrequency.setSelection(true);
        this._manualFrequency = new Button(pollingFreqComp, 16);
        this._manualFrequency.setLayoutData((Object)new GridData(4, -1, true, false));
        this._manualFrequency.setText(TraceMessages.EXECUTION_ANALYSIS_MANUAL_FREQ);
        this._manualFrequency.setSelection(false);
        this._pollingFreq = new Spinner(pollingFreqComp, 2048);
        this._pollingFreq.setLayout((Layout)new GridLayout());
        this._pollingFreq.setLayoutData((Object)new GridData(4, -1, true, false));
        this._pollingFreq.setValues(60, 1, 10000, 0, 10, 100);
        this._pollingFreq.setEnabled(true);
        this._manualFrequency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITimeAnalysisUI.this._pollingFreq.setEnabled(true);
                TITimeAnalysisUI.this._pollingFreq.setFocus();
            }
        });
        this._autoFrequency.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITimeAnalysisUI.this._pollingFreq.setEnabled(false);
            }
        });
        this.showExecutionStat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TITimeAnalysisUI.this.executionStateChange(((Button)e.widget).getSelection());
            }
        });
    }

    private Group createGroup(Composite parent, String name) {
        Group grp = new Group(parent, 0);
        grp.setLayout((Layout)new GridLayout());
        grp.setLayoutData((Object)new GridData(4, -1, true, true));
        grp.setText(name);
        return grp;
    }

    private Button createButton(Composite parent, String name, int style) {
        Button button = new Button(parent, style);
        button.setLayoutData((Object)new GridData(4, -1, true, false));
        button.setText(name);
        return button;
    }

    public boolean isCollectCPUTimeSelected() {
        return this.collectCPUTime == null || this.collectCPUTime.isDisposed() ? false : this.collectCPUTime.getSelection();
    }

    public boolean isAutoPollingSelected() {
        return this._autoFrequency == null || this._autoFrequency.isDisposed() ? false : this._autoFrequency.getSelection();
    }

    public boolean isManualPollingSelected() {
        return this._manualFrequency == null || this._manualFrequency.isDisposed() ? false : this._manualFrequency.getSelection();
    }

    public int getPollingFrequency() {
        return this._pollingFreq.getSelection();
    }

    public void setCollectCPUTime(boolean collectCPUTime) {
        this.collectCPUTime.setSelection(collectCPUTime);
    }

    public boolean isShowExecutionFlowSelected() {
        return this.showExecutionFlow == null || this.showExecutionFlow.isDisposed() ? false : this.showExecutionFlow.getSelection();
    }

    public void setShowExecutionFlow(boolean showExecutionFlow) {
        this.showExecutionFlow.setSelection(showExecutionFlow);
        this.showExecutionStat.setSelection(!showExecutionFlow);
        this.executionStateChange(!showExecutionFlow);
    }

    public void setPollingFrequency(int frequency) {
        this._pollingFreq.setSelection(frequency);
    }

    public void setAutoPolling(boolean autoPolling) {
        this._autoFrequency.setSelection(autoPolling);
    }

    public void setManualPolling(boolean manualPolling) {
        this._manualFrequency.setSelection(manualPolling);
        if (!this.showExecutionFlow.getSelection()) {
            this._pollingFreq.setEnabled(manualPolling);
        } else {
            this._pollingFreq.setEnabled(false);
        }
    }

    private void executionStateChange(boolean selected) {
        if (selected && !this._autoFrequency.getSelection() && !this._manualFrequency.getSelection()) {
            this._autoFrequency.setSelection(selected);
        }
        this._autoFrequency.setEnabled(selected);
        this._manualFrequency.setEnabled(selected);
        this._pollingFreq.setEnabled(selected && this._manualFrequency.getSelection());
    }
}

