/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.controlproviders;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
import org.eclipse.tptp.platform.jvmti.client.internal.TIUtility;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractProcessControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IProcessStateModifier;

public class TIProcessControlProvider
extends AbstractProcessControlProvider {
    public IProcessStateModifier getProcessStateModifier() {
        return TIProcessStateModifier.getInstance();
    }

    public static class TIProcessStateModifier
    implements IProcessStateModifier {
        private static TIProcessStateModifier instance = new TIProcessStateModifier();
        private StructuredSelection input;
        private Iterator inputIterator;
        private Hashtable processedInputs = new Hashtable();

        private TIProcessStateModifier() {
        }

        public static TIProcessStateModifier getInstance() {
            return instance;
        }

        public synchronized void setInput(StructuredSelection input) {
            this.input = input;
        }

        public synchronized boolean canTerminate() {
            TRCProcessProxy processProxy;
            this.inputIterator = this.input == null ? null : this.input.iterator();
            this.processedInputs.clear();
            boolean canTerminate = true;
            boolean activeProcessOrAgentSelected = false;
            while ((processProxy = this.getNextProcessProxy()) != null) {
                activeProcessOrAgentSelected = true;
                boolean bl = canTerminate = canTerminate && processProxy.isActive();
            }
            return canTerminate && activeProcessOrAgentSelected;
        }

        public synchronized void terminate() throws CoreException {
            TRCProcessProxy currentProcessProxy;
            this.inputIterator = this.input == null ? null : this.input.iterator();
            this.processedInputs.clear();
            CoreException error = null;
            long processId = 0L;
            while ((currentProcessProxy = this.getNextProcessProxy()) != null) {
                block6: {
                    try {
                        String title = TraceMessages.TRC_MSGT;
                        processId = currentProcessProxy.getPid();
                        String msg = NLS.bind((String)TraceMessages.TERMINATE_Q, (Object[])new Object[]{currentProcessProxy.getName(), String.valueOf(processId)});
                        if (MessageDialog.openQuestion((Shell)UIPlugin.getActiveWorkbenchShell(), (String)title, (String)msg)) {
                            IProcess process;
                            TRCNode trcNode = currentProcessProxy.getNode();
                            IAgentController ac = AgentControllerDelegate.getInstance().getConnection(trcNode.getName(), trcNode.getPort());
                            if (ac != null && (process = ac.getProcess(processId)) != null && process.isActive()) {
                                process.kill();
                            }
                            break block6;
                        }
                        return;
                    }
                    catch (InactiveProcessException inactiveProcessException) {
                    }
                    catch (Exception e) {
                        error = new CoreException((IStatus)new Status(4, UIPlugin.getPluginId(), 4, NLS.bind((String)ControlMessages.ERROR_PROCESS_TERMINATE, (Object)String.valueOf(processId)), (Throwable)e));
                    }
                }
                this.terminateProcessProxy(currentProcessProxy);
                if (error == null) continue;
                throw error;
            }
        }

        public void terminateProcessProxy(TRCProcessProxy processProxy) {
            TIUtility.terminateProcessProxy(processProxy);
            EList agentProxies = processProxy.getAgentProxies();
            int i = 0;
            int agentCount = agentProxies.size();
            while (i < agentCount) {
                TRCAgentProxy agentProxy = (TRCAgentProxy)agentProxies.get(i);
                if ("org.eclipse.tptp.jvmti".equals(agentProxy.getName()) && agentProxy.isActive()) {
                    TIUtility.terminateAgentProxy(agentProxy, false);
                }
                ++i;
            }
        }

        private TRCProcessProxy getNextProcessProxy() {
            if (this.inputIterator == null) {
                return null;
            }
            TRCProcessProxy currentInput = null;
            while (this.inputIterator.hasNext()) {
                Object input = this.inputIterator.next();
                TRCAgentProxy agentProxy = null;
                if (input instanceof TRCAgentProxy && (agentProxy = (TRCAgentProxy)input).isActive()) {
                    currentInput = agentProxy.getProcessProxy();
                    if (this.processedInputs.get(currentInput) != null) continue;
                    this.processedInputs.put(currentInput, Boolean.TRUE);
                    return currentInput;
                }
                if (!(input instanceof TRCProcessProxy) || this.processedInputs.get(input) != null) continue;
                this.processedInputs.put(input, Boolean.TRUE);
                return (TRCProcessProxy)input;
            }
            return null;
        }
    }
}

