/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.launcher.ILauncherHandler;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.IAgentListener;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadExtensionSlot;

public class ProbeControlListener
implements IAgentListener {
    IAgent controlAgent = null;
    Map launcherHandlers;
    ILaunchConfiguration config;

    public ProbeControlListener(ILaunchConfiguration callingConfiguration) {
        this.config = callingConfiguration;
    }

    public void error(IAgent agent, String errorMessage) {
    }

    public void agentActive(IAgent agent) {
        block5: {
            try {
                String launchItemSelections = this.config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, null);
                if (launchItemSelections.indexOf("org.eclipse.tptp.analysisType.jvmti.probe") != -1) {
                    this.initializeLauncherHandlers();
                    Object[] launcherHandlersArray = this.launcherHandlers.values().toArray();
                    int num = 0;
                    while (num < launcherHandlersArray.length) {
                        ILauncherHandler type = (ILauncherHandler)launcherHandlersArray[num];
                        if (type instanceof LaunchPadExtensionSlot) {
                            LaunchPadExtensionSlot extension = new LaunchPadExtensionSlot();
                            extension.handlePreAgentActiveJVMTI(agent, this.config);
                        }
                        ++num;
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block5;
                Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public void agentInactive(IAgent agent) {
    }

    private void initializeLauncherHandlers() {
        this.launcherHandlers = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.trace.ui", "launcherHandler");
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement elem = elements[i];
                String id = elem.getAttribute("id");
                ILauncherHandler getControlType = null;
                try {
                    getControlType = (ILauncherHandler)elem.createExecutableExtension("class");
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        Status status = new Status(4, UIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    e.printStackTrace();
                }
                if (getControlType != null) {
                    this.launcherHandlers.put(id, getControlType);
                }
                ++i;
            }
        }
    }
}

