/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.SelectedAgent;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.AgentController;
import org.eclipse.tptp.platform.execution.client.core.internal.ConsoleImpl;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
import org.eclipse.tptp.platform.execution.util.TPTPDataPath;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIAnalysisTypeFiltration;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.TIDelegateHelper;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadException;
import org.eclipse.tptp.platform.probekit.launch.launchpad.LaunchPadExtensionSlot;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractDCMutualLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.AgentSelection;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentAttach;
import org.eclipse.tptp.trace.ui.provisional.launcher.IParameterExtractor;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;

public class TIAttachLauncherDelegate
extends AbstractDCMutualLauncher
implements IDataCollectorAgentAttach,
IParameterExtractor {
    private IAgentController agentController;
    private ILaunchConfiguration configuration;
    private ILaunch launch;
    private final int ATTACH_POLL_TIME = 10;

    public Node createNode() {
        return null;
    }

    public boolean isProcessLauncher() {
        return false;
    }

    public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
        int port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, CommonUIPlugin.getDefault().getPreferenceStore().getDefaultInt("localhost_port"));
        try {
            this.agentController = AgentControllerDelegate.getInstance().getConnection(hostName, port);
            this.configuration = configuration;
            this.launch = launch;
        }
        catch (Exception e) {
            throw LauncherUtility.createCoreException((int)4, (String)e.getLocalizedMessage(), (Exception)e);
        }
    }

    public void launch(AgentSelection[] selection) throws CoreException {
        int i = 0;
        while (i < selection.length) {
            Object agentObject = selection[i].getAgent();
            final TRCAgentProxy agentProxy = selection[i].getAgentProxy();
            agentProxy.setType("Profiler");
            if (agentObject instanceof IAgent && agentProxy != null) {
                final IAgent agent = (IAgent)agentObject;
                new Job(TIMessages.TASK_CONNECTING_TO_AGENT){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            TIAttachLauncherDelegate.this.launchAgent(agent, agentProxy);
                        }
                        catch (Exception e) {
                            UIPlugin.getDefault().log((Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            ++i;
        }
    }

    private void launchAgent(IAgent agent, final TRCAgentProxy agentProxy) throws CoreException, InactiveAgentException, InactiveProcessException {
        boolean isEnableDataCollection;
        final ICollector tiAgent = TIDelegateHelper.locateTIAgent(this.agentController, agent.getProcess().getProcessId());
        if (tiAgent == null) {
            return;
        }
        SelectedAgent[] selectedAgents = LauncherUtility.retrieveSelectedAgents((ILaunchConfiguration)this.configuration);
        int j = 0;
        while (j < selectedAgents.length) {
            if (!selectedAgents[j].getPid().equals(String.valueOf(tiAgent.getProcess().getProcessId()))) {
                return;
            }
            String[] selectedAnalysisTypes = selectedAgents[j].getAnalysisTypes();
            if (selectedAnalysisTypes != null) {
                int k = 0;
                while (k < selectedAnalysisTypes.length) {
                    String analysisType = selectedAnalysisTypes[k].toString();
                    if (analysisType != null && analysisType.equals("org.eclipse.tptp.analysisType.jvmti.probe")) {
                        LaunchPadExtensionSlot extension = new LaunchPadExtensionSlot();
                        try {
                            extension.handlePreAgentActiveJVMTI((IAgent)tiAgent, this.configuration);
                        }
                        catch (LaunchPadException launchPadException) {}
                    }
                    ++k;
                }
            }
            ++j;
        }
        tiAgent.startMonitoring(TPTPDataPath.DATA_PATH_TWO_WAY);
        TIDelegateHelper.getInstance().processAttached(tiAgent, this.launch);
        IProcessListener processListener = new IProcessListener(){

            public void processLaunched(IProcess process) {
            }

            public void processExited(IProcess process) {
                TIDelegateHelper.getInstance().processDetached(agentProxy, tiAgent);
            }
        };
        agent.getProcess().addProcessListener(processListener);
        TIDelegateHelper.getInstance().sendFilters(this.configuration, tiAgent);
        TIDelegateHelper.getInstance().sendOptions(this.configuration, agentProxy, tiAgent);
        ConsoleImpl console = (ConsoleImpl)agent.getProcess().getConsole();
        ((AgentController)this.agentController).addDataListener(console.getDataConnectionID(), console.getDataProcessor());
        boolean bl = isEnableDataCollection = this.configuration == null ? true : this.configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
        if (isEnableDataCollection) {
            TIDelegateHelper.getInstance().sendEnableDataCollection(this.configuration, tiAgent);
        }
        TIDelegateHelper.getInstance().startPolling(tiAgent, 10);
        TIDelegateHelper.configureDataProcessor(this.configuration, agentProxy, tiAgent);
        if (!tiAgent.isAgentRunning()) {
            tiAgent.run();
        }
        if (!isEnableDataCollection) {
            TIDelegateHelper.getInstance().setPausedState(agentProxy);
        }
    }

    public void postLaunch(IStatus launchStatus) throws CoreException {
        TIAnalysisTypeFiltration.clearCache();
    }

    public ProcessParameters getProcessParameters(ILaunchConfiguration launchConfiguration) {
        ProcessParameters params = new ProcessParameters();
        List<String> args = TIDelegateHelper.getInstance().getVMArgList(launchConfiguration);
        params.addExecutableParameter(args);
        return params;
    }
}

