/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.jvmti.client.internal.launcher;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFilterManager;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.SelectedAgent;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.IAgentListener;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.agent.internal.AgentState;
import org.eclipse.tptp.platform.execution.client.agent.internal.AgentStatePool;
import org.eclipse.tptp.platform.execution.client.core.ConnectionInfo;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
import org.eclipse.tptp.platform.execution.exceptions.NoSuchApplicationException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.exceptions.ProcessActiveException;
import org.eclipse.tptp.platform.execution.exceptions.TimeoutException;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.TPTPDataPath;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;
import org.eclipse.tptp.platform.jvmti.client.internal.ITILaunchConfigurationConstants;
import org.eclipse.tptp.platform.jvmti.client.internal.TIMessages;
import org.eclipse.tptp.platform.jvmti.client.internal.TIPlugin;
import org.eclipse.tptp.platform.jvmti.client.internal.TIUtility;
import org.eclipse.tptp.platform.jvmti.client.internal.controlproviders.TIAgentControlProvider;
import org.eclipse.tptp.platform.jvmti.client.internal.controlproviders.TIProcessControlProvider;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.ACProcessToDebugProcessAdapter;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.HierarchicalModelFactory;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.ILauncherParameterProvider;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.ProbeControlListener;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.AgentControllerDelegate;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.RunCommand;
import org.eclipse.tptp.platform.jvmti.client.internal.launcher.util.SetOutputFormatCommand;
import org.eclipse.tptp.platform.jvmti.client.provisional.extension.ICustomAnalysisProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisTypeManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.StatGeneratorDataProcessor;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILightConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIDelegateHelper {
    private static final String CMD_APPLY_FILTERS = "applyFilters";
    private static final String CMD_APPLY_OPTIONS = "applyOptions";
    private static final String CMD_COLLECT_DATA = "CollectData";
    private static final String CMD_SET_OUTPUT_FORMAT = "setOutputFormat";
    private static final String ELEMENT_FILTER = "Filter";
    private static final String ELEMENT_OPTION = "option";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_VALUE = "value";
    private static final String ATTRIBUTE_IID = "iid";
    protected static final String EXEC_JAVA = "java.exe";
    private static final String TI_VARIABLE_OUTPUT_FORMAT = "TPTP_OUTPUT_FORMAT";
    private static final String AC_VARIALBE_CLASSPATH = "CLASSPATH";
    protected static final String TI_CGPROF_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;CGProf:execdetails=false ";
    protected static final String TI_EXEC_CGPROF_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;CGProf:execdetails=true ";
    protected static final String TI_HEAP_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;HeapProf";
    protected static final String TI_HEAP_ALLOC_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;HeapProf:allocsites=true";
    protected static final String TI_THRD_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;ThreadProf";
    protected static final String TI_EXEC_THRD_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;ThreadProf:contanalysis=true";
    protected static final String TI_PROBE_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;ProbekitAgent:ext-pk-BCILibraryName=BCIEngProbe";
    protected static String TI_JVM_FLAG = "-agentlib:JPIBootLoader=JPIAgent:server=controlled;CGProf:execdetails=false ";
    private static final NOOPCommandHandler NOOP_COMMAND_HANDLER = new NOOPCommandHandler();
    private static TIDelegateHelper instance = new TIDelegateHelper();
    private static int POLL_TIME = 10;
    private boolean isCGProf = true;
    private boolean isAggProf = false;
    private boolean isProcessActive = false;
    private static final int RETRY_THRESHOLD = 60;
    private static final int WAITING_TIME = 100;
    private int errCount = 0;
    private Object lock = new Object();
    private long errorCode = 0L;
    private String errorMsg;
    private AgentState _agentState = null;
    private ICustomAnalysisProvider analysisProvider = null;

    private TIDelegateHelper() {
    }

    public static TIDelegateHelper getInstance() {
        return instance;
    }

    private void resetConfigurationPages(ILaunchConfiguration launchConfiguration) {
        List analysisTypes = this.getSelectedTIAnalysisTypes(launchConfiguration);
        int analysisTypesCount = analysisTypes == null ? 0 : analysisTypes.size();
        int i = 0;
        while (i < analysisTypesCount) {
            Object currentAnalysisTypeObject = analysisTypes.get(i);
            LightConfigurationLoader confLoader = null;
            if (currentAnalysisTypeObject instanceof AnalysisType && (confLoader = ((AnalysisType)currentAnalysisTypeObject).getConfigurationLoader()) != null) {
                ILightConfiguration analysisTypeConfiguraiton = confLoader.getConfigurationClass();
                if (confLoader.isEditable()) {
                    IConfigurationPage[] configurationPages = ((IConfiguration)analysisTypeConfiguraiton).getConfigurationPages();
                    int j = 0;
                    while (j < configurationPages.length) {
                        configurationPages[j].reset(launchConfiguration);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public synchronized void launch(ILauncherParameterProvider launcher, ILaunchConfiguration launchConfiguration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.resetConfigurationPages(launchConfiguration);
        Map mp = launchConfiguration.getAttributes();
        int mapsize = mp.size();
        Iterator keyValuePairs = mp.entrySet().iterator();
        this.isCGProf = true;
        int i = 0;
        while (i < mapsize) {
            Map.Entry entry = keyValuePairs.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.addOption(new StringBuffer(), key.toString(), value.toString());
            TI_JVM_FLAG = TI_CGPROF_JVM_FLAG;
            if ("org.eclipse.hyades.trace.ui.ATTR_DATA_COLLECTOR".equals(key.toString())) {
                if (value.toString().indexOf("heap") != -1) {
                    boolean hasAttributes = false;
                    if (this.checkAllocOptions(launchConfiguration, ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE)) {
                        TI_JVM_FLAG = TI_HEAP_ALLOC_JVM_FLAG;
                        hasAttributes = true;
                    } else {
                        TI_JVM_FLAG = TI_HEAP_JVM_FLAG;
                    }
                    ICustomAnalysisProvider[] providers = TIPlugin.getProviders();
                    StringBuilder jvmArgs = new StringBuilder();
                    StringBuilder tiJVMFlags = new StringBuilder(TI_JVM_FLAG);
                    if (providers != null) {
                        int provider = 0;
                        while (provider < providers.length) {
                            this.analysisProvider = providers[provider];
                            if (this.checkAllocOptions(launchConfiguration, this.analysisProvider.getAllocOptionToCheck())) {
                                List<String> extraJVMArgs;
                                tiJVMFlags.append(this.analysisProvider.updateJVMArg(hasAttributes));
                                if (!hasAttributes) {
                                    hasAttributes = true;
                                }
                                if ((extraJVMArgs = this.analysisProvider.addExtraJVMArgs()) != null && extraJVMArgs.size() != 0) {
                                    for (String extraJVMArg : extraJVMArgs) {
                                        if ((extraJVMArg = extraJVMArg.trim()) == null || extraJVMArg.length() == 0) continue;
                                        jvmArgs.append(extraJVMArg);
                                        jvmArgs.append(" ");
                                    }
                                }
                            }
                            ++provider;
                        }
                    }
                    this.analysisProvider = null;
                    if (hasAttributes) {
                        tiJVMFlags.append(" ");
                    }
                    TI_JVM_FLAG = String.valueOf(tiJVMFlags.toString()) + jvmArgs.toString();
                    this.isCGProf = false;
                    break;
                }
                if (value.toString().indexOf("thread") != -1) {
                    TI_JVM_FLAG = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS, false) ? TI_EXEC_THRD_JVM_FLAG : TI_THRD_JVM_FLAG;
                    this.isCGProf = false;
                    break;
                }
                if (value.toString().indexOf("probe") != -1) {
                    TI_JVM_FLAG = TI_PROBE_JVM_FLAG;
                    String VMArgs = launchConfiguration.getAttribute("executab1leArgs", "");
                    String classpath = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, null);
                    if (classpath != null) {
                        StringBuffer bootClassPath = new StringBuffer();
                        bootClassPath.append("-Xbootclasspath/p:");
                        boolean isWindows = false;
                        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
                            bootClassPath.append("\"");
                            isWindows = true;
                        }
                        bootClassPath.append(classpath);
                        if (isWindows) {
                            bootClassPath.append("\"");
                        }
                        VMArgs = String.valueOf(VMArgs) + " " + bootClassPath.toString();
                    }
                    TI_JVM_FLAG = String.valueOf(VMArgs) + " " + TI_JVM_FLAG;
                    this.isCGProf = false;
                    break;
                }
            }
            ++i;
        }
        if (this.isCGProf && this.checkAllocOptions(launchConfiguration, ITILaunchConfigurationConstants.ATTR_EXEC_FLOW)) {
            TI_JVM_FLAG = TI_EXEC_CGPROF_JVM_FLAG;
        }
        launcher.preLaunch(launchConfiguration, mode, launch, monitor);
        monitor.setTaskName(TIMessages.TASK_CONNECTING_TO_AC);
        IAgentController agentController = this.connectToAgentController(launcher);
        monitor.worked(2);
        monitor.setTaskName(TIMessages.TASK_LAUNCHING_PROCESS);
        this.launchProcess(agentController, launcher, launchConfiguration, launch, 1, monitor);
    }

    private static void switchPerspective() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    boolean shouldSwitch = CommonUIPlugin.getDefault().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", CommonUIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", TraceWizardMessages.CONFIRM_PSWITCH);
                    if (shouldSwitch) {
                        UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                    }
                    if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
                        PDProjectExplorer nav = (PDProjectExplorer)UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                        nav.getViewer().refresh();
                    }
                }
                catch (Exception exc) {
                    CommonPlugin.logError((Throwable)exc);
                }
            }
        });
    }

    public String getVMArg(ILaunchConfiguration launchConfiguration) {
        List<String> args = this.getVMArgList(launchConfiguration);
        if (args != null) {
            StringBuilder result = new StringBuilder();
            for (String arg : args) {
                if (arg == null || arg.trim().length() == 0) continue;
                result.append(String.valueOf(arg.trim()) + " ");
            }
            return result.toString();
        }
        return null;
    }

    public List<String> getVMArgList(ILaunchConfiguration launchConfiguration) {
        try {
            String collectors = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, "");
            ArrayList<String> args = new ArrayList<String>();
            String JVM_FLAG = TI_CGPROF_JVM_FLAG;
            if (collectors.indexOf("heap") != -1) {
                boolean hasAttributes = false;
                if (this.checkAllocOptions(launchConfiguration, ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE)) {
                    JVM_FLAG = TI_HEAP_ALLOC_JVM_FLAG;
                    hasAttributes = true;
                } else {
                    JVM_FLAG = TI_HEAP_JVM_FLAG;
                }
                ICustomAnalysisProvider[] providers = TIPlugin.getProviders();
                StringBuilder tiJVMFlags = new StringBuilder(JVM_FLAG);
                if (providers != null) {
                    int provider = 0;
                    while (provider < providers.length) {
                        this.analysisProvider = providers[provider];
                        if (this.checkAllocOptions(launchConfiguration, this.analysisProvider.getAllocOptionToCheck())) {
                            List<String> extraJVMArgs;
                            tiJVMFlags.append(this.analysisProvider.updateJVMArg(hasAttributes));
                            if (!hasAttributes) {
                                hasAttributes = true;
                            }
                            if ((extraJVMArgs = this.analysisProvider.addExtraJVMArgs()) != null && extraJVMArgs.size() != 0) {
                                for (String extraJVMArg : extraJVMArgs) {
                                    if ((extraJVMArg = extraJVMArg.trim()) == null || extraJVMArg.length() == 0) continue;
                                    args.add(extraJVMArg);
                                }
                            }
                        }
                        ++provider;
                    }
                }
                this.analysisProvider = null;
                if (hasAttributes) {
                    tiJVMFlags.append(" ");
                }
                JVM_FLAG = tiJVMFlags.toString();
                this.isCGProf = false;
            }
            if (collectors.indexOf("thread") != -1) {
                JVM_FLAG = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_CONTENTION_ANALYSIS, false) ? TI_EXEC_THRD_JVM_FLAG : TI_THRD_JVM_FLAG;
                this.isCGProf = false;
            }
            if (collectors.indexOf("probe") != -1) {
                JVM_FLAG = TI_PROBE_JVM_FLAG;
                this.isCGProf = false;
            }
            if (this.isCGProf && this.checkAllocOptions(launchConfiguration, ITILaunchConfigurationConstants.ATTR_EXEC_FLOW)) {
                JVM_FLAG = TI_EXEC_CGPROF_JVM_FLAG;
            }
            args.add(0, JVM_FLAG);
            return args;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IAgentController connectToAgentController(ILauncherParameterProvider launcher) throws CoreException {
        try {
            String hostname = launcher.getHostName();
            int port = launcher.getPortNumber();
            return AgentControllerDelegate.getInstance().getConnection(hostname, port);
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw LauncherUtility.createCoreException((int)4, (String)NLS.bind((String)TIMessages.ERROR_TI_AC_UNAVAILABLE, (Object)String.valueOf(launcher.getPortNumber())), (Exception)e);
        }
    }

    private static boolean isLocal(String hostName) {
        hostName = AgentControllerDelegate.getUnifiedHostName(hostName);
        String localHostName = "";
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return hostName.equalsIgnoreCase(localHostName);
    }

    private String parseArguments(String args) {
        if (args == null) {
            return null;
        }
        int ch = -1;
        int index = 0;
        int argLength = args.length();
        String argsRet = "";
        while (argLength > 0) {
            argsRet = Character.isWhitespace((char)(ch = (int)args.charAt(index++))) ? String.valueOf(argsRet) + " " : String.valueOf(argsRet) + String.valueOf((char)ch);
            --argLength;
        }
        return argsRet;
    }

    private void launchProcess(final IAgentController agentController, ILauncherParameterProvider launcher, final ILaunchConfiguration launchConfiguration, ILaunch launch, int launchMode, final IProgressMonitor monitor) throws CoreException {
        try {
            org.eclipse.tptp.platform.execution.client.core.IProcess process = agentController.createProcess();
            ProcessParameters processParameters = launcher.getProcessParameters(launchConfiguration);
            String programParameter = processParameters.getApplicationParametersStr();
            String processParameter = String.valueOf(processParameters.getExecutableParametersStr()) + " " + processParameters.getApplicationName() + (programParameter.length() > 0 ? " " + programParameter.trim() : "");
            processParameter = this.parseArguments(processParameter).trim();
            process.setExecutable(EXEC_JAVA);
            process.setParameter(processParameter);
            this.setEnvironmentVariables(process, launcher, launchConfiguration);
            String hostName = launcher.getHostName();
            if (TIDelegateHelper.isLocal(hostName)) {
                process.setLocation(launcher.getLocation());
            } else {
                process.setLocation(".");
            }
            process.setName(processParameters.getApplicationName());
            ACProcessToDebugProcessAdapter adapter = new ACProcessToDebugProcessAdapter(launch, process, launchMode, true);
            UIPlugin.getDefault().registerLaunchProcess((IProcess)adapter);
            IProcessListener processListener = new IProcessListener((IProcess)adapter){
                private TRCAgentProxy tiTRCAgentProxy;
                private ICollector agent = null;
                private final /* synthetic */ IProcess val$adapter;
                {
                    this.val$adapter = iProcess;
                }

                public synchronized void processLaunched(org.eclipse.tptp.platform.execution.client.core.IProcess process) {
                    final org.eclipse.tptp.platform.execution.client.core.IProcess cproc = process;
                    monitor.setTaskName(TIMessages.TASK_CONNECTING_TO_AGENT);
                    TIDelegateHelper.this.isProcessActive = true;
                    this.tiTRCAgentProxy = TIDelegateHelper.this.attachToAgent(agentController, process, launchConfiguration, monitor);
                    try {
                        this.agent = TIDelegateHelper.locateTIAgent(agentController, process.getProcessId());
                    }
                    catch (InactiveProcessException inactiveProcessException) {}
                    if (this.agent == null) {
                        return;
                    }
                    LoadersUtils.registerAgentInstance((TRCAgentProxy)this.tiTRCAgentProxy, (Object)this.agent);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            IConsole console = TIDelegateHelper.getConsole(cproc);
                            TIDelegateHelper.showConsole(console);
                        }
                    });
                    if (this.tiTRCAgentProxy != null) {
                        ProcessMap.put((TRCProcessProxy)this.tiTRCAgentProxy.getProcessProxy(), (IProcess)this.val$adapter);
                    }
                    monitor.worked(1);
                }

                public synchronized void processExited(org.eclipse.tptp.platform.execution.client.core.IProcess process) {
                    UIPlugin.getDefault().deregisterLaunchProcess(this.val$adapter);
                    new Thread(){

                        public void run() {
                            try {
                                2.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)val$adapter, 8)});
                        }
                    }.start();
                    TIDelegateHelper.this.cleanupAgent(this.tiTRCAgentProxy, this.agent);
                }
            };
            process.addProcessListener(processListener);
            process.launch();
            monitor.worked(1);
        }
        catch (ProcessActiveException e) {
            this.handleError(monitor, TIMessages.ERROR_TI_PROCESS_LAUNCH_ACTIVE, (Exception)((Object)e));
        }
        catch (NotConnectedException e) {
            this.handleError(monitor, NLS.bind((String)TIMessages.ERROR_TI_AC_UNAVAILABLE, (Object)String.valueOf(agentController.getConnectionInfo().getPort())), (Exception)((Object)e));
        }
        catch (NoSuchApplicationException e) {
            this.handleError(monitor, TIMessages.ERROR_TI_PROCESS_LAUNCH_NO_APP, (Exception)((Object)e));
        }
        catch (InactiveAgentException e) {
            this.handleError(monitor, TIMessages.ERROR_TI_PROCESS_LAUNCH_INACTIVE_AG, (Exception)((Object)e));
        }
        catch (TimeoutException e) {
            this.handleError(monitor, TIMessages.ERROR_TI_PROCESS_LAUNCH_TIMEOUT, (Exception)((Object)e));
        }
    }

    private void cleanupAgent(TRCAgentProxy tiTRCAgentProxy, ICollector agent) {
        if (tiTRCAgentProxy == null) {
            return;
        }
        TraceUtils.removeSnapshot((TRCAgentProxy)tiTRCAgentProxy);
        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)tiTRCAgentProxy);
        TIProcessControlProvider.TIProcessStateModifier processStateModifier = TIProcessControlProvider.TIProcessStateModifier.getInstance();
        processStateModifier.terminateProcessProxy(tiTRCAgentProxy.getProcessProxy());
        this.isProcessActive = false;
        int i = 1;
        while (i <= 100) {
            if (tiTRCAgentProxy.getStopTime() > tiTRCAgentProxy.getStartTime()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            ++i;
        }
        if (agent != null) {
            try {
                ACDataProcessorAdapter dataProcessor = (ACDataProcessorAdapter)LoadersUtils.locateDataProcessor((TRCAgentProxy)tiTRCAgentProxy);
                if (dataProcessor != null) {
                    dataProcessor.cleanUp();
                }
                agent.stopMonitoring();
            }
            catch (InactiveAgentException inactiveAgentException) {}
        }
    }

    public synchronized void processAttached(ICollector agent, ILaunch launch) {
        this.isAggProf = true;
        this.isProcessActive = true;
    }

    public synchronized void processDetached(TRCAgentProxy tiTRCAgentProxy, ICollector agent) {
        this.isProcessActive = false;
        this.cleanupAgent(tiTRCAgentProxy, agent);
    }

    private void setEnvironmentVariables(org.eclipse.tptp.platform.execution.client.core.IProcess process, ILauncherParameterProvider launcher, ILaunchConfiguration launchConfiguration) throws CoreException, ProcessActiveException {
        Map configEnv = launchConfiguration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        if (configEnv != null) {
            Iterator iter = configEnv.entrySet().iterator();
            Map.Entry entry = null;
            String key = null;
            String value = null;
            while (iter.hasNext()) {
                entry = iter.next();
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                if (value != null) {
                    value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
                }
                process.prependEnvironmentVariable(key, value);
            }
        }
        process.prependEnvironmentVariable(AC_VARIALBE_CLASSPATH, launcher.getClassPath());
    }

    private void handleError(IProgressMonitor monitor, String message, Exception e) throws CoreException {
        monitor.setCanceled(true);
        throw LauncherUtility.createCoreException((int)4, (String)message);
    }

    private TRCAgentProxy attachToAgent(IAgentController agentController, org.eclipse.tptp.platform.execution.client.core.IProcess process, ILaunchConfiguration launchConfiguration, IProgressMonitor monitor) {
        return this.attachToAgent(agentController, null, launchConfiguration, process, monitor);
    }

    public TRCAgentProxy attachToAgent(IAgentController agentController, TRCAgentProxy agentProxy, org.eclipse.tptp.platform.execution.client.core.IProcess process, IProgressMonitor monitor) {
        return this.attachToAgent(agentController, agentProxy, null, process, monitor);
    }

    private TRCAgentProxy attachToAgent(IAgentController agentController, TRCAgentProxy agentProxy, ILaunchConfiguration launchConfiguration, org.eclipse.tptp.platform.execution.client.core.IProcess process, IProgressMonitor monitor) {
        ICollector tiAgent;
        block12: {
            this.errCount = 0;
            tiAgent = null;
            tiAgent = TIDelegateHelper.locateTIAgent(agentController, process.getProcessId());
            while (tiAgent == null && this.errCount < 60) {
                Thread.sleep(100L);
                tiAgent = TIDelegateHelper.locateTIAgent(agentController, process.getProcessId());
                ++this.errCount;
            }
            if (tiAgent != null) break block12;
            this.handleErrorCondition(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, NLS.bind((String)TIMessages.ERROR_TI_AGENT_UNAVAILABLE, (Object)"org.eclipse.tptp.jvmti"), null, process, monitor);
            return null;
        }
        try {
            boolean isEnableDataCollection;
            TRCAgentProxy tiAgentProxy;
            boolean addProbeListener;
            if (launchConfiguration != null && (addProbeListener = this.probesSelected(launchConfiguration))) {
                ProbeControlListener probeController = new ProbeControlListener(launchConfiguration);
                tiAgent.addAgentListener((IAgentListener)probeController);
            }
            tiAgent.startMonitoring(TPTPDataPath.DATA_PATH_TWO_WAY);
            TRCAgentProxy trcAgentProxy = tiAgentProxy = agentProxy == null ? this.createModelEntities(launchConfiguration, agentController, process, tiAgent) : this.createModelEntities(agentProxy, agentController, process, tiAgent);
            if (launchConfiguration != null) {
                LauncherUtility.addLaunchConfigId((TRCProcessProxy)trcAgentProxy.getProcessProxy(), (String)launchConfiguration.getType().getIdentifier());
            }
            this._agentState = AgentStatePool.getAgentInfo((ConnectionInfo)agentController.getConnectionInfo(), (long)process.getProcessId());
            if (launchConfiguration != null) {
                this.sendFilters(launchConfiguration, tiAgent);
                this.sendOptions(launchConfiguration, trcAgentProxy, tiAgent);
            } else {
                this.sendFilters(tiAgentProxy, tiAgent);
                this.sendOptions(agentProxy != null ? agentProxy : tiAgentProxy, trcAgentProxy, tiAgent);
            }
            TIDelegateHelper.switchPerspective();
            TIDelegateHelper.configureDataProcessor(launchConfiguration, tiAgentProxy, tiAgent);
            boolean bl = isEnableDataCollection = launchConfiguration == null ? true : launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
            if (isEnableDataCollection) {
                TIDelegateHelper.getInstance().sendEnableDataCollection(launchConfiguration, tiAgent);
            }
            if (!tiAgent.isAgentRunning()) {
                tiAgent.run();
            }
            if (!isEnableDataCollection) {
                this.setPausedState(tiAgentProxy);
            }
            return trcAgentProxy;
        }
        catch (InactiveAgentException e) {
            this.handleErrorCondition(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, TIMessages.ERROR_TI_AGENT_INACTIVE, (Exception)((Object)e), process, monitor);
        }
        catch (Exception e) {
            this.handleErrorCondition(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, TIMessages.ERROR_TI_AGENT_UNKNOWN, e, process, monitor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureDataProcessor(ILaunchConfiguration launchConfiguration, TRCAgentProxy agentProxy, ICollector tiAgent) throws CoreException {
        boolean isProfileToLaunch;
        ACDataProcessorAdapter dataProcessor;
        SetOutputFormatHandler handler = new SetOutputFormatHandler();
        String outputFormat = System.getenv(TI_VARIABLE_OUTPUT_FORMAT);
        if (outputFormat != null) {
            if (!"binary".equals(outputFormat) && !"xml".equals(outputFormat)) {
                throw new IllegalArgumentException("Environment variable TPTP_OUTPUT_FORMAT should be 'xml' or 'binary'");
            }
        } else {
            outputFormat = "binary";
        }
        SetOutputFormatCommand command = new SetOutputFormatCommand(outputFormat);
        Object object = handler.getLock();
        synchronized (object) {
            try {
                tiAgent.sendCommand(command.buildCommand(), (ICommandHandler)handler);
                handler.getLock().wait();
            }
            catch (InactiveAgentException e) {
                e.printStackTrace();
            }
            catch (NotConnectedException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if ("xml".equals(handler.getFormat())) {
            dataProcessor = (ACDataProcessorAdapter)LoadersUtils.locateDataProcessor((TRCAgentProxy)agentProxy);
            if (dataProcessor == null) {
                dataProcessor = new ACDataProcessorAdapter(agentProxy);
            }
        } else {
            dataProcessor = new BFDataProcessorAdapter(agentProxy);
        }
        LoadersUtils.registerDataProcessor((TRCAgentProxy)agentProxy, (XMLLoader)dataProcessor);
        boolean bl = isProfileToLaunch = launchConfiguration == null ? agentProxy.isToProfileFile() : launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
        if (isProfileToLaunch) {
            String filePath;
            String string = filePath = launchConfiguration == null ? agentProxy.getProfileFile() : launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null);
            if (filePath != null) {
                agentProxy.setProfileFile(filePath);
                dataProcessor.setProfileFileName(filePath);
                dataProcessor.createWriter();
                if (dataProcessor.isNewProfileFile()) {
                    dataProcessor.writeXMLVersion(dataProcessor.getWriter());
                    dataProcessor.startTrace(dataProcessor.getWriter());
                }
            }
        }
        tiAgent.addDataListener((IDataProcessor)dataProcessor);
        TIAgentControlProvider.TIAgentStateModifier agentStateModifier = TIAgentControlProvider.TIAgentStateModifier.getInstance();
        agentStateModifier.setInput(new StructuredSelection((Object)agentProxy));
        agentStateModifier.startMonitoring();
    }

    public static ICollector locateTIAgent(IAgentController agentController, long processId) {
        try {
            return (ICollector)agentController.getAgent("org.eclipse.tptp.jvmti", ICollector.class.getName(), processId);
        }
        catch (NotConnectedException e) {
            ConnectionInfo connectionInfo = agentController.getConnectionInfo();
            String port = LauncherMessages.LAUNCHER_COMMON_UNKNOWN;
            if (connectionInfo != null) {
                port = String.valueOf(connectionInfo.getPort());
            }
            LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)NLS.bind((String)TIMessages.ERROR_TI_AC_UNAVAILABLE, (Object)port), (Throwable)e);
            return null;
        }
    }

    private boolean checkAllocOptions(ILaunchConfiguration launchConfiguration, String optionCheck) {
        try {
            List analysisTypes = this.getSelectedTIAnalysisTypes(launchConfiguration);
            int analysisTypesCount = analysisTypes == null ? 0 : analysisTypes.size();
            boolean retValue = false;
            int i = 0;
            while (i < analysisTypesCount) {
                Object currentAnalysisTypeObject = analysisTypes.get(i);
                LightConfigurationLoader confLoader = null;
                if (currentAnalysisTypeObject instanceof AnalysisType && (confLoader = ((AnalysisType)currentAnalysisTypeObject).getConfigurationLoader()) != null) {
                    ILightConfiguration analysisTypeConfiguraiton = confLoader.getConfigurationClass();
                    DataCollectionEngineAttribute[] attributes = analysisTypeConfiguraiton.getAttributes();
                    int attributeCount = attributes == null ? 0 : attributes.length;
                    int j = 0;
                    while (j < attributeCount) {
                        if (optionCheck.equals(ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE) && ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE.equals(attributes[j].getName()) && (retValue = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE, false)) || this.analysisProvider != null && (retValue = this.analysisProvider.checkAllocOptions(launchConfiguration, optionCheck, attributes[j].getName())) || optionCheck.equals(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW) && ITILaunchConfigurationConstants.ATTR_EXEC_FLOW.equals(attributes[j].getName()) && (retValue = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW, true)) || optionCheck.equals(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING) && ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING.equals(attributes[j].getName()) && (retValue = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING, false))) break;
                        ++j;
                    }
                }
                ++i;
            }
            return retValue;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void sendOptions(ILaunchConfiguration launchConfiguration, TRCAgentProxy agentProxy, ICollector tiAgent) {
        try {
            optionCommand = new StringBuffer();
            TIUtility.addElement(optionCommand, "applyOptions", false, false);
            TIUtility.addAttribute(optionCommand, new String[]{"iid"}, new String[]{"org.eclipse.tptp.jvmti"}, false, true);
            analysisTypes = this.getSelectedTIAnalysisTypes(launchConfiguration, tiAgent);
            analysisTypesCount = analysisTypes == null ? 0 : analysisTypes.size();
            collectExecData = false;
            collectHeapData = false;
            isAutoPolling = false;
            isManualPolling = false;
            i = 0;
            while (i < analysisTypesCount) {
                block16: {
                    currentAnalysisTypeObject = analysisTypes.get(i);
                    confLoader = null;
                    if (!(currentAnalysisTypeObject instanceof AnalysisType) || (confLoader = ((AnalysisType)currentAnalysisTypeObject).getConfigurationLoader()) == null) break block16;
                    analysisTypeConfiguraiton = confLoader.getConfigurationClass();
                    if (confLoader.isEditable()) {
                        configurationPages = ((IConfiguration)analysisTypeConfiguraiton).getConfigurationPages();
                        j = 0;
                        while (j < configurationPages.length) {
                            configurationPages[j++].reset(launchConfiguration);
                        }
                    }
                    attributeCount = (attributes = analysisTypeConfiguraiton.getAttributes()) == null ? 0 : attributes.length;
                    j = 0;
                    while (j < attributeCount) {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        value = attributes[j].getValue();
                                        if (!ITILaunchConfigurationConstants.ATTR_EXEC_DATA.equals(attributes[j].getName())) break block17;
                                        collectExecData = true;
                                        ** GOTO lbl-1000
                                    }
                                    if (!ITILaunchConfigurationConstants.ATTR_HEAP_DATA.equals(attributes[j].getName())) break block18;
                                    collectHeapData = true;
                                    ** GOTO lbl-1000
                                }
                                if (!ITILaunchConfigurationConstants.ATTR_EXEC_MANUAL_POLLING.equals(attributes[j].getName())) break block19;
                                try {
                                    isManualPolling = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_MANUAL_POLLING, false);
                                }
                                catch (Exception v0) {
                                    isManualPolling = false;
                                }
                                value = String.valueOf(isManualPolling);
                                ** GOTO lbl-1000
                            }
                            if (!ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING.equals(attributes[j].getName())) break block20;
                            try {
                                isAutoPolling = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_AUTO_POLLING, false);
                            }
                            catch (Exception v1) {
                                isAutoPolling = false;
                            }
                            value = String.valueOf(isAutoPolling);
                            ** GOTO lbl-1000
                        }
                        if (ITILaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ.equals(attributes[j].getName())) {
                            TIDelegateHelper.POLL_TIME = Integer.valueOf(value);
                        } else lbl-1000:
                        // 5 sources

                        {
                            this.addOption(optionCommand, attributes[j].getName(), value);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            TIUtility.addElement(optionCommand, "applyOptions", true, true);
            tiAgent.sendCommand(optionCommand.toString(), (ICommandHandler)TIDelegateHelper.NOOP_COMMAND_HANDLER);
            agentProxy.setCollectionMode(this.computeCollectionMode(launchConfiguration, collectExecData, collectHeapData));
            if (tiAgent != null && this._agentState != null && this._agentState.token != null && this._agentState.token.equals("CGProf")) {
                this.isAggProf = true;
            }
            if (this.isAggProf) {
                pollthread = new PeriodicPoll(tiAgent);
                pollthread.start();
            }
            if (tiAgent != null && this._agentState != null && (this.isCGProf || this.isAggProf) && this._agentState.token == null) {
                this._agentState.token = "CGProf";
            }
            return;
        }
        catch (InactiveAgentException e) {
            error = e;
        }
        catch (NotConnectedException e) {
            error = e;
        }
        LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_AGENT_OPTIONS, (Throwable)error);
    }

    private void addOption(StringBuffer optionCommand, String name, String value) {
        TIUtility.addElement(optionCommand, ELEMENT_OPTION, false, true);
        TIUtility.addElement(optionCommand, ELEMENT_NAME, false, true);
        optionCommand.append(name);
        TIUtility.addElement(optionCommand, ELEMENT_NAME, true, true);
        TIUtility.addElement(optionCommand, ELEMENT_VALUE, false, true);
        optionCommand.append(value);
        TIUtility.addElement(optionCommand, ELEMENT_VALUE, true, true);
        TIUtility.addElement(optionCommand, ELEMENT_OPTION, true, true);
    }

    public void sendOptions(TRCAgentProxy oldAgentProxy, TRCAgentProxy agentProxy, ICollector tiAgent) {
        Throwable error;
        try {
            StringBuffer optionCommand = new StringBuffer();
            TIUtility.addElement(optionCommand, CMD_APPLY_OPTIONS, false, false);
            TIUtility.addAttribute(optionCommand, new String[]{ATTRIBUTE_IID}, new String[]{"org.eclipse.tptp.jvmti"}, false, true);
            EList agentProxyConf = oldAgentProxy.getConfigurations();
            int i = 0;
            int confCount = agentProxyConf.size();
            while (i < confCount) {
                TRCConfiguration config = (TRCConfiguration)agentProxyConf.get(i);
                EList options = config.getOptions();
                int opt = 0;
                while (opt < options.size()) {
                    TRCOption option = (TRCOption)options.get(opt);
                    this.addOption(optionCommand, option.getKey(), option.getValue());
                    ++opt;
                }
                ++i;
            }
            TIUtility.addElement(optionCommand, CMD_APPLY_OPTIONS, true, true);
            tiAgent.sendCommand(optionCommand.toString(), (ICommandHandler)NOOP_COMMAND_HANDLER);
            agentProxy.setCollectionMode(oldAgentProxy.getCollectionMode());
            return;
        }
        catch (InactiveAgentException e) {
            error = e;
        }
        catch (NotConnectedException e) {
            error = e;
        }
        LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_AGENT_OPTIONS, (Throwable)error);
    }

    private TRCCollectionMode computeCollectionMode(ILaunchConfiguration launchConfiguration, boolean collectExecData, boolean collectHeapData) {
        block9: {
            boolean collectHeapInstanceLevelInfo;
            boolean collectExecInstanceLevelInfo;
            boolean collectExecutionFlow;
            try {
                collectExecutionFlow = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_FLOW, true);
                this.isAggProf = !collectExecutionFlow;
                collectExecInstanceLevelInfo = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_COLLECT_INSTANCE, false);
                collectHeapInstanceLevelInfo = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_HEAP_COLLECT_INSTANCE, false);
            }
            catch (CoreException coreException) {
                return TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            if (collectExecData) {
                if (collectHeapData) {
                    if (collectHeapInstanceLevelInfo) {
                        return collectExecutionFlow ? TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL : TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
                    }
                    return collectExecutionFlow ? (collectExecInstanceLevelInfo ? TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL : TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL) : TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
                }
                return collectExecutionFlow ? (collectExecInstanceLevelInfo ? TRCCollectionMode.EXECUTION_FULL_LITERAL : TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL) : TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            boolean heapObjAllocSites = true;
            try {
                ICustomAnalysisProvider[] providers;
                heapObjAllocSites = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_EXEC_OBJ_ALLOC_SITE, false);
                if (heapObjAllocSites) break block9;
                ICustomAnalysisProvider[] iCustomAnalysisProviderArray = providers = TIPlugin.getProviders();
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    ICustomAnalysisProvider provider = iCustomAnalysisProviderArray[n2];
                    if (provider.getCollectAnalysisOption()) {
                        heapObjAllocSites = true;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        return TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL;
    }

    public void sendFilters(String filterSetId, ICollector tiAgent) {
        Throwable error;
        try {
            FilterSetElement filterSet = (FilterSetElement)TraceFilterManager.getInstance().getFilterSet().get(filterSetId);
            if (filterSet == null && (filterSet = ProfilingSetsManager.instance().findNextAvailableFilterSet()) == null) {
                return;
            }
            ArrayList filterElements = filterSet.getChildren();
            StringBuffer filterCommand = new StringBuffer();
            TIUtility.addElement(filterCommand, CMD_APPLY_FILTERS, false, false);
            TIUtility.addAttribute(filterCommand, new String[]{ATTRIBUTE_IID}, new String[]{"org.eclipse.tptp.jvmti"}, false, true);
            if (filterElements != null) {
                int i = 0;
                int filterElementCount = filterElements.size();
                while (i < filterElementCount) {
                    FilterTableElement currentElement = (FilterTableElement)filterElements.get(i);
                    TIUtility.addElement(filterCommand, ELEMENT_FILTER, false, true);
                    filterCommand.append(currentElement.getText()).append(" ").append(currentElement.getMethod()).append(" ").append(currentElement.getVisibility().equals(TraceMessages.INCLUDE) ? "INCLUDE" : "EXCLUDE");
                    TIUtility.addElement(filterCommand, ELEMENT_FILTER, true, true);
                    ++i;
                }
            }
            TIUtility.addElement(filterCommand, CMD_APPLY_FILTERS, true, true);
            tiAgent.sendCommand(filterCommand.toString(), (ICommandHandler)NOOP_COMMAND_HANDLER);
            return;
        }
        catch (NotConnectedException e) {
            error = e;
        }
        catch (InactiveAgentException e) {
            error = e;
        }
        LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_AGENT_FILTERS, (Throwable)error);
    }

    public void sendFilters(ILaunchConfiguration launchConfiguration, ICollector tiAgent) {
        try {
            String filterSetId = launchConfiguration.getAttribute(ITILaunchConfigurationConstants.ATTR_FILTERSET_ID, this.getDefaultFilterSetName(launchConfiguration));
            this.sendFilters(filterSetId, tiAgent);
            if (LauncherUtility.isAutoFilteringCriteria((ILaunchConfiguration)launchConfiguration)) {
                LauncherUtility.removeAutogeneratedFilterSet();
            }
        }
        catch (CoreException e) {
            LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_AGENT_FILTERS, (Throwable)e);
        }
    }

    private String getDefaultFilterSetName(ILaunchConfiguration config) throws CoreException {
        return !LauncherUtility.isAutoFilteringCriteria((ILaunchConfiguration)config) ? "org.eclipse.hyades.trace.ui.filterSet.default" : "auto_generated_filter_set";
    }

    public void sendFilters(TRCAgentProxy agentProxy, ICollector tiAgent) {
        TRCOption[] options = TIUtility.getAgentOptions(agentProxy, ITILaunchConfigurationConstants.ATTR_FILTERSET_ID);
        if (options.length >= 1) {
            this.sendFilters(options[0].getValue(), tiAgent);
        }
    }

    public void sendEnableDataCollection(ILaunchConfiguration configuration, ICollector tiAgent) {
        Throwable error = null;
        String cmd = new String("<EnableDataCollection iid=\"org.eclipse.tptp.jvmti\"></EnableDataCollection>");
        boolean isEnableDataCollection = true;
        if (configuration != null) {
            try {
                isEnableDataCollection = configuration == null ? true : configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
            }
            catch (CoreException e) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_AGENT_FILTERS, (Throwable)e);
                return;
            }
        }
        if (isEnableDataCollection) {
            try {
                tiAgent.sendCommand(cmd, (ICommandHandler)NOOP_COMMAND_HANDLER);
            }
            catch (InactiveAgentException e) {
                error = e;
            }
            catch (NotConnectedException e) {
                error = e;
            }
            if (error != null) {
                LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)TIMessages.ERROR_TI_AGENT_FILTERS, (Throwable)error);
                return;
            }
            return;
        }
    }

    private TRCAgentProxy createModelEntities(ILaunchConfiguration launchConfiguration, IAgentController agentController, org.eclipse.tptp.platform.execution.client.core.IProcess process, ICollector tiAgent) throws CoreException {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String projectName = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
        String monitorName = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
        List analysisTypes = this.getSelectedTIAnalysisTypes(launchConfiguration);
        return this.createModelEntities(projectName, monitorName, analysisTypes, agentController, process, tiAgent);
    }

    private TRCAgentProxy createModelEntities(TRCAgentProxy agentProxy, IAgentController agentController, org.eclipse.tptp.platform.execution.client.core.IProcess process, ICollector tiAgent) throws CoreException {
        TRCMonitor monitor = agentProxy.getProcessProxy().getNode().getMonitor();
        URI uri = monitor.eResource().getURI();
        if (uri.segmentCount() - 2 < 0) {
            throw LauncherUtility.createCoreException((int)4, (String)TIMessages.ERROR_TI_AGENT_PROJECT_NAME);
        }
        String projectName = monitor.eResource().getURI().segment(uri.segmentCount() - 2);
        String monitorName = monitor.getName();
        ArrayList<AnalysisType> analysisTypes = new ArrayList<AnalysisType>();
        TRCOption[] analysisTypeOptions = TIUtility.getAgentOptions(agentProxy, LauncherConstants.ANALYSIS_TYPE_ASSOCIATION);
        int i = 0;
        while (i < analysisTypeOptions.length) {
            AnalysisType analysisType = AnalysisTypeManager.getInstance().getAnalysisType(analysisTypeOptions[i].getValue());
            if (analysisType != null && !analysisTypes.contains(analysisType)) {
                analysisTypes.add(analysisType);
            }
            ++i;
        }
        TRCAgentProxy newAgentProxy = this.createModelEntities(projectName, monitorName, analysisTypes, agentController, process, tiAgent);
        newAgentProxy.setProfileFile(agentProxy.getProfileFile());
        return newAgentProxy;
    }

    private TRCAgentProxy createModelEntities(String projectName, String monitorName, List analysisTypes, IAgentController agentController, org.eclipse.tptp.platform.execution.client.core.IProcess process, ICollector tiAgent) throws CoreException {
        ConnectionInfo connectionInfo = agentController.getConnectionInfo();
        IContainer container = PDCoreUtil.createContainer((IPath)new Path(projectName));
        TRCMonitor monitor = PDCoreUtil.createMonitor((IContainer)container, (String)monitorName);
        TRCNode trcNode = PDCoreUtil.createNode((TRCMonitor)monitor, (String)connectionInfo.getHostName(), (String)String.valueOf(connectionInfo.getPort()));
        TRCProcessProxy trcProcessProxy = HierarchicalModelFactory.createTRCProcessProxy(trcNode, process);
        TRCAgentProxy trcAgentProxy = HierarchicalModelFactory.createTRCAgentProxy(trcProcessProxy, (IAgent)tiAgent, "Profiler");
        int analysisTypeCount = analysisTypes == null ? 0 : analysisTypes.size();
        TRCConfiguration agentProxyConfiguration = null;
        int i = 0;
        while (i < analysisTypeCount) {
            if (i == 0) {
                agentProxyConfiguration = HierarchicalModelFactory.createTRCConfiguration(trcAgentProxy, "SETOPTION");
            }
            Object currentAnalysisType = analysisTypes.get(i);
            String id = null;
            if (currentAnalysisType instanceof AnalysisType) {
                id = ((AnalysisType)currentAnalysisType).getId();
            } else if (currentAnalysisType instanceof IProfilingSetType) {
                id = ((IProfilingSetType)currentAnalysisType).getId();
            }
            if (id != null) {
                HierarchicalModelFactory.createOption(agentProxyConfiguration, String.valueOf(LauncherConstants.ANALYSIS_TYPE_ASSOCIATION) + "(" + id + ")", id);
            }
            ++i;
        }
        return trcAgentProxy;
    }

    private List getSelectedTIAnalysisTypes(ILaunchConfiguration launchConfiguration) {
        return this.getSelectedTIAnalysisTypes(launchConfiguration, null);
    }

    private List getSelectedTIAnalysisTypes(ILaunchConfiguration launchConfiguration, ICollector tiAgent) {
        ArrayList<AnalysisType> analysisTypes = new ArrayList<AnalysisType>();
        try {
            if ("org.eclipse.hyades.trace.ui.internal.launcher.localJavaProcess".equals(launchConfiguration.getType().getIdentifier())) {
                SelectedAgent[] selectedAgents = LauncherUtility.retrieveSelectedAgents((ILaunchConfiguration)launchConfiguration);
                int i = 0;
                while (i < selectedAgents.length) {
                    String[] selectedAnalysisTypes;
                    if (selectedAgents[i].getPid().equals(String.valueOf(tiAgent.getProcess().getProcessId())) && (selectedAnalysisTypes = selectedAgents[i].getAnalysisTypes()) != null) {
                        int j = 0;
                        while (j < selectedAnalysisTypes.length) {
                            AnalysisType analysisType = AnalysisTypeManager.getInstance().getAnalysisType(selectedAnalysisTypes[j]);
                            if (analysisType != null) {
                                analysisTypes.add(analysisType);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                Hashtable dataCollectionSelections;
                String launchItemSelections = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, null);
                if (launchItemSelections != null && (dataCollectionSelections = LauncherUtility.unserializeSelection((String)launchItemSelections)) != null) {
                    return (List)dataCollectionSelections.get(DataCollectorManager.getInstance().getDataCollector("org.eclipse.tptp.trace.jvmti.jvmtiMechanism"));
                }
            }
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log((Throwable)e);
        }
        catch (InactiveProcessException e) {
            UIPlugin.getDefault().log((Throwable)e);
        }
        return analysisTypes;
    }

    private boolean handleErrorCondition(String title, String message, Exception e, org.eclipse.tptp.platform.execution.client.core.IProcess process, IProgressMonitor monitor) {
        monitor.setCanceled(true);
        LauncherUtility.openErrorWithDetail((String)title, (String)message, (Throwable)e);
        try {
            if (process != null) {
                process.kill();
            }
        }
        catch (InactiveProcessException inactiveProcessException) {
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (InactiveAgentException inactiveAgentException) {}
        return false;
    }

    public static ProcessParameters getProcessParameter(ProcessParameters processParameters) {
        processParameters.addExecutableParameter(TI_JVM_FLAG);
        return processParameters;
    }

    private boolean probesSelected(ILaunchConfiguration launchConfiguration) {
        boolean addProbeListener = false;
        List selectedTypes = this.getSelectedTIAnalysisTypes(launchConfiguration);
        int i = 0;
        while (i < selectedTypes.size()) {
            AnalysisType analysisType = (AnalysisType)selectedTypes.get(i);
            if (analysisType.getId().equals("org.eclipse.tptp.analysisType.jvmti.probe")) {
                addProbeListener = true;
            }
            ++i;
        }
        return addProbeListener;
    }

    public void startPolling(ICollector tiAgent) {
        PeriodicPoll pollthread = new PeriodicPoll(tiAgent);
        pollthread.start();
    }

    public void startPolling(ICollector tiAgent, int POLL_TIME) {
        TIDelegateHelper.POLL_TIME = POLL_TIME;
        PeriodicPoll pollthread = new PeriodicPoll(tiAgent);
        pollthread.start();
    }

    private static IConsole getConsole(org.eclipse.tptp.platform.execution.client.core.IProcess process) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console instanceof org.eclipse.debug.ui.console.IConsole && ((org.eclipse.debug.ui.console.IConsole)console).getProcess().equals(process)) {
                return console;
            }
            ++i;
        }
        return null;
    }

    private static void showConsole(IConsole console) {
        IViewPart consoleView;
        IWorkbenchPage page;
        if (console == null) {
            return;
        }
        IWorkbenchWindow window = UIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (consoleView = page.findView("org.eclipse.ui.console.ConsoleView")) != null && consoleView instanceof IConsoleView) {
            ((IConsoleView)consoleView).display(console);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAgent(IAgentController agentController, ICollector tiAgent, IProgressMonitor monitor) {
        this.errCount = 0;
        RunCommand runCommand = new RunCommand();
        Object object = this.lock;
        synchronized (object) {
            while (this.errCount < 60) {
                this.errorCode = 0L;
                this.errorMsg = "";
                try {
                    tiAgent.sendCommand(runCommand.buildCommand(), (ICommandHandler)new RunCommandHandler());
                    tiAgent.resume();
                    this.lock.wait(100L);
                }
                catch (Exception exception) {}
                if (this.errorCode <= 0L) break;
                ++this.errCount;
            }
        }
        if (this.errorCode > 0L) {
            LauncherUtility.openErrorWithDetail((String)LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, (String)this.errorMsg, null);
        }
    }

    public void setPausedState(TRCAgentProxy agentProxy) {
        if (agentProxy != null) {
            LauncherUtility.sendProfileEvent((int)2, (Object)agentProxy);
            agentProxy.setMonitored(false);
            agentProxy.setAttached(true);
            agentProxy.setActive(true);
        }
    }

    public static class ACDataProcessorAdapter
    extends StatGeneratorDataProcessor
    implements IDataProcessor {
        private boolean processAlive = true;
        private int activity;
        private boolean enabled = true;

        public ACDataProcessorAdapter(TRCAgentProxy agentProxy) {
            super(agentProxy);
            ACDataProcessorAdapter bfLoader = this;
            bfLoader.setLoadXml(true);
        }

        public void incomingData(byte[] buffer, int length, InetAddress peer) {
            if (!this.enabled) {
                return;
            }
            this.preIncomingData();
            super.incommingData(buffer, length, peer);
        }

        public void incomingData(char[] buffer, int length, InetAddress peer) {
            if (!this.enabled) {
                return;
            }
            this.preIncomingData();
            super.incommingData(buffer, length, peer);
        }

        protected void preIncomingData() {
            if (!this.processAlive) {
                ++this.activity;
            }
        }

        public void setProcessAlive(boolean processAlive) {
            this.processAlive = processAlive;
        }

        public boolean isProcessAlive() {
            return this.processAlive;
        }

        public int getActivity() {
            return this.activity;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class BFDataProcessorAdapter
    extends ACDataProcessorAdapter {
        public BFDataProcessorAdapter(TRCAgentProxy agentProxy) {
            super(agentProxy);
            BFDataProcessorAdapter bfLoader = this;
            bfLoader.setLoadXml(false);
        }

        protected void loadEventHook(byte[] buffer, int offset, int length) {
            this.loadEvent(buffer, offset, length);
        }

        protected boolean isValidTag(byte[] buf, int offset, int length) {
            return true;
        }

        protected String getDumpFileName() {
            return "TraceContents-" + this.getTimeStamp() + ".bin";
        }

        protected void writeByte(byte[] data, int offset, int length) {
            try {
                if (this.fileWriter != null) {
                    this.fileWriter.write(data, offset, length);
                    this.fileWriter.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void endTrace(OutputStream randomFile) {
            try {
                if (randomFile != null) {
                    randomFile.flush();
                    randomFile.close();
                }
            }
            catch (IOException iOException) {}
        }

        public void writeXMLVersion(OutputStream randomFile) {
        }

        public void startTrace(OutputStream randomFile) {
        }
    }

    public static final class NOOPCommandHandler
    implements ICommandHandler {
        public void incomingCommand(INode node, ICommandElement command) {
        }
    }

    private class PeriodicPoll
    extends Thread {
        boolean isMonitored = true;
        ICollector tiAgent;

        public PeriodicPoll(ICollector agent) {
            this.tiAgent = agent;
        }

        public void run() {
            while (this.isMonitored && TIDelegateHelper.this.isProcessActive) {
                this.isMonitored = this.tiAgent.isMonitored();
                StringBuffer optionCommand = new StringBuffer();
                TIUtility.addElement(optionCommand, TIDelegateHelper.CMD_COLLECT_DATA, false, false);
                TIUtility.addAttribute(optionCommand, new String[]{TIDelegateHelper.ATTRIBUTE_IID}, new String[]{"org.eclipse.tptp.jvmti"}, false, true);
                TIUtility.addElement(optionCommand, TIDelegateHelper.CMD_COLLECT_DATA, true, true);
                try {
                    this.tiAgent.sendCommand(optionCommand.toString(), (ICommandHandler)NOOP_COMMAND_HANDLER);
                    Thread.sleep(POLL_TIME * 1000);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            System.gc();
        }
    }

    class RunCommandHandler
    implements ICommandHandler {
        RunCommandHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incomingCommand(INode node, ICommandElement command) {
            String commandStr = new String(((CommandFragment)command).getCommandData());
            TPTPXMLParse ParseObj = new TPTPXMLParse();
            ParseObj.setParser(commandStr);
            Hashtable CommandHash = ParseObj.getHashTable();
            if (CommandHash.containsKey("ErrCode")) {
                try {
                    if (commandStr.indexOf("Wrong Phase") == -1) {
                        TIDelegateHelper.this.errorCode = Long.parseLong((String)CommandHash.get("ErrCode"));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (commandStr.indexOf("Wrong Phase") == -1) {
                    TIDelegateHelper.this.errorMsg = (String)CommandHash.get("ErrInfo");
                }
            }
            Object object = TIDelegateHelper.this.lock;
            synchronized (object) {
                TIDelegateHelper.this.lock.notifyAll();
            }
        }
    }

    static class SetOutputFormatHandler
    implements ICommandHandler {
        private final Object lock = new Object();
        private String format = "xml";

        SetOutputFormatHandler() {
        }

        public String getFormat() {
            return this.format;
        }

        public Object getLock() {
            return this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incomingCommand(INode node, ICommandElement command) {
            String commandStr = new String(((CommandFragment)command).getCommandData());
            TPTPXMLParse ParseObj = new TPTPXMLParse();
            ParseObj.setParser(commandStr);
            Hashtable CommandHash = ParseObj.getHashTable();
            this.format = CommandHash.containsKey("format") ? (String)CommandHash.get("format") : "xml";
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

