/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.provisional.IOperationContext;
import org.eclipse.tptp.platform.report.birt.core.BIRTPlugin;
import org.eclipse.tptp.platform.report.birt.core.internal.impl.BIRTResourceLocator;
import org.eclipse.tptp.platform.report.birt.core.provisional.IReportElement;
import org.osgi.framework.Bundle;

public class ReportElementExtensionRegistryReader {
    public static final String PLUGIN_POINT = "reportElement";
    public static final String REPORTELEMENT = "reportElement";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String PROPERTY = "property";
    public static final String CLASSPROPERTY = "classProperty";
    public static final String DESCRIPTION = "description";
    public static final String CLASS = "class";
    private static ReportElementExtensionRegistryReader instance = null;
    private List reportElements = new LinkedList();

    public static ReportElementExtensionRegistryReader getInstance() {
        if (instance == null) {
            instance = new ReportElementExtensionRegistryReader();
        }
        return instance;
    }

    private ReportElementExtensionRegistryReader() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(BIRTPlugin.getDefault().getBundle().getSymbolicName(), "reportElement");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        try {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("reportElement")) {
                        this.reportElements.add(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BIRTPlugin.logError(e);
        }
    }

    public IReportElement createReportElement(String id) {
        if (id == null) {
            return null;
        }
        int x = 0;
        while (x < this.reportElements.size()) {
            IConfigurationElement configElem = (IConfigurationElement)this.reportElements.get(x);
            if (id.equals(configElem.getAttribute(ID))) {
                try {
                    IConfigurationElement child;
                    IReportElement elem = (IReportElement)configElem.createExecutableExtension(CLASS);
                    IConfigurationElement[] children = configElem.getChildren(PROPERTY);
                    IOperationContext context = elem.getContext();
                    int y = 0;
                    while (y < children.length) {
                        child = children[y];
                        String plugin = child.getContributor().getName();
                        Bundle bundle = Platform.getBundle((String)plugin);
                        String value = child.getAttribute(VALUE);
                        String key = child.getAttribute(NAME);
                        if (key.equals("CONTEXT_TEMPLATE_FILE") || key.equals("CONTEXT_CHILD_TEMPLATEFILE")) {
                            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(value), null);
                            context.setProperty(key, (Object)url);
                        } else if (value != null) {
                            context.setProperty(key, (Object)value);
                        }
                        ++y;
                    }
                    children = configElem.getChildren(CLASSPROPERTY);
                    y = 0;
                    while (y < children.length) {
                        child = children[y];
                        String key = child.getAttribute(NAME);
                        if (key.equals("CONTEXT_RESOURCE_LOCATOR")) {
                            Object locator = configElem.createExecutableExtension(CLASS);
                            context.setProperty(key, locator);
                        } else if (key.equals("CONTEXT_MSG_BUNDLE")) {
                            Object clazz = configElem.createExecutableExtension(CLASS);
                            BIRTResourceLocator locator = new BIRTResourceLocator(clazz.getClass());
                            context.setProperty("CONTEXT_RESOURCE_LOCATOR", (Object)locator);
                        }
                        ++y;
                    }
                    return elem;
                }
                catch (InvalidRegistryObjectException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
        return null;
    }

    public List getWizardCategoryElements() {
        return this.reportElements;
    }
}

