/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.birt.core.internal.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tptp.platform.common.provisional.EclipseOperationStatus;
import org.eclipse.tptp.platform.common.provisional.IOperationContext;
import org.eclipse.tptp.platform.common.provisional.IOperationStatus;
import org.eclipse.tptp.platform.report.birt.core.internal.impl.BIRTResourceLocator;
import org.eclipse.tptp.platform.report.birt.core.provisional.BIRTReportGenerator;
import org.eclipse.tptp.platform.report.birt.core.provisional.IReportElement;

public class ReportElementImpl
implements IReportElement {
    protected InputStream dataSource;
    protected OutputStream outputStream;
    protected List content;
    protected List childElements;
    protected IOperationContext context;
    protected String rootFile;

    public String getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(String rootFile) {
        this.rootFile = rootFile;
    }

    public InputStream getTemplateFile() {
        Object templateFile = this.context.getProperty("CONTEXT_TEMPLATE_FILE");
        try {
            if (templateFile instanceof URL) {
                return ((URL)templateFile).openStream();
            }
            if (templateFile instanceof InputStream) {
                return (InputStream)templateFile;
            }
            if (templateFile instanceof String) {
                return new FileInputStream(new File((String)templateFile));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.tptp.platform.report.birt.ui", 4, e.getMessage(), (Throwable)e);
            this.context.setStatus((IOperationStatus)new EclipseOperationStatus((IStatus)status));
        }
        return null;
    }

    public void setTemplateFile(InputStream templateFile) {
        this.context.setProperty("CONTEXT_TEMPLATE_FILE", (Object)templateFile);
    }

    public OutputStream getOutputStream() {
        Object out = this.context.getProperty("CONTEXT_OUTSTREAM");
        if (out != null) {
            try {
                if (out instanceof OutputStream) {
                    return (OutputStream)out;
                }
                if (out instanceof String) {
                    return new FileOutputStream(new File((String)out));
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.tptp.platform.report.birt.ui", 4, e.getMessage(), (Throwable)e);
                this.context.setStatus((IOperationStatus)new EclipseOperationStatus((IStatus)status));
            }
        } else {
            String outputFolder = (String)this.context.getProperty("CONTEXT_OUT_FOLDER");
            if (outputFolder != null) {
                this.rootFile = (String)this.context.getProperty("CONTEXT_OUT_FILE");
                if (this.rootFile == null) {
                    this.rootFile = "index.html";
                }
                try {
                    return new FileOutputStream(String.valueOf(outputFolder) + File.separator + this.rootFile);
                }
                catch (FileNotFoundException e) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.report.birt.ui", 4, e.getMessage(), (Throwable)e);
                    this.context.setStatus((IOperationStatus)new EclipseOperationStatus((IStatus)status));
                }
            }
        }
        return null;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.context.setProperty("CONTEXT_OUTSTREAM", (Object)outputStream);
    }

    public InputStream getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(InputStream dataSource) {
        this.dataSource = dataSource;
    }

    public List getChildElements() {
        if (this.childElements == null) {
            this.childElements = new ArrayList();
        }
        return this.childElements;
    }

    public List getContent() {
        return this.content;
    }

    public void setContent(List content) {
        this.content = content;
    }

    public boolean isEmbedded() {
        Object embedded = this.context.getProperty("CONTEXT_EMBEDDED");
        if (embedded instanceof Boolean) {
            return (Boolean)embedded;
        }
        return false;
    }

    public void setEmbedded(boolean embedded) {
        this.context.setProperty("CONTEXT_EMBEDDED", (Object)new Boolean(embedded));
    }

    public boolean isSortable() {
        Object sortable = this.context.getProperty("CONTEXT_SORTABLE");
        if (sortable instanceof Boolean) {
            return (Boolean)sortable;
        }
        return true;
    }

    public void setSortable(boolean sortable) {
        this.context.setProperty("CONTEXT_SORTABLE", (Object)new Boolean(sortable));
    }

    public void initialize() {
    }

    public IOperationContext getContext() {
        return this.context;
    }

    public void setContext(IOperationContext context) {
        this.context = context;
    }

    protected String getImageDir() {
        String imgDir = (String)this.context.getProperty("CONTEXT_IMG_DIR");
        if (imgDir == null) {
            imgDir = "";
        }
        return imgDir;
    }

    public void generate() {
        block26: {
            String imgDir = this.getImageDir();
            if (imgDir == null) {
                imgDir = "";
            }
            String birtHome = (String)this.context.getProperty("CONTEXT_BIRT_HOME");
            InputStream in = null;
            InputStream templateFile = null;
            BIRTResourceLocator resourceLocator = (BIRTResourceLocator)this.context.getProperty("CONTEXT_RESOURCE_LOCATOR");
            String outputFolder = (String)this.context.getProperty("CONTEXT_OUT_FOLDER");
            if (outputFolder != null) {
                this.rootFile = (String)this.context.getProperty("CONTEXT_OUT_FILE");
                if (this.rootFile == null) {
                    this.rootFile = "index.html";
                }
            }
            try {
                try {
                    in = this.getDataSource();
                    templateFile = this.getTemplateFile();
                    BIRTReportGenerator generator = BIRTReportGenerator.getInstance();
                    generator.setBirtHome(birtHome);
                    generator.generateHTMLReport(this.getOutputStream(), templateFile, in, this.isSortable(), imgDir, outputFolder, resourceLocator);
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.tptp.platform.report.birt.ui", 4, " ", (Throwable)e);
                    this.context.setStatus((IOperationStatus)new EclipseOperationStatus((IStatus)status));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (templateFile != null) {
                        try {
                            templateFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (templateFile != null) {
                    try {
                        templateFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (templateFile != null) {
                try {
                    templateFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

