/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.birt.core.provisional;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tptp.platform.report.birt.core.BIRTPlugin;
import org.eclipse.tptp.platform.report.birt.core.internal.impl.BIRTResourceLocator;
import org.eclipse.tptp.platform.report.birt.core.internal.impl.HtmlSortWrapper;
import org.eclipse.tptp.platform.report.birt.core.internal.impl.TPTPHTMLRenderContext;
import org.eclipse.tptp.platform.report.birt.core.internal.impl.TPTPImageHandler;
import org.eclipse.tptp.platform.report.birt.core.provisional.IReportElement;
import org.osgi.framework.Bundle;

public class BIRTReportGenerator {
    private static BIRTReportGenerator INSTANCE;
    protected String birtHome;
    private IReportEngine engine;

    public static BIRTReportGenerator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BIRTReportGenerator();
        }
        return INSTANCE;
    }

    public void generateHTMLReport(OutputStream os, String imageDir, InputStream datasource, InputStream templateFile) throws Exception {
        this.generateHTMLReportFragment(os, imageDir, null, datasource, templateFile, false, null);
    }

    public void generateHTMLReport(OutputStream os, String imageDir, String baseImageURL, InputStream datasource, InputStream templateFile, BIRTResourceLocator resourceLocator) throws Exception {
        this.generateHTMLReportFragment(os, imageDir, baseImageURL, datasource, templateFile, false, resourceLocator);
    }

    public void generateHTMLReport(IReportElement reportElement, String imageDir, String baseImageURL, BIRTResourceLocator resourceLocator) throws Exception {
        OutputStream reportStream = reportElement.getOutputStream();
        PrintStream ps = null;
        ps = new PrintStream(reportStream);
        if (reportElement.isSortable()) {
            this.copySortIcons(reportElement.isSortable(), String.valueOf(baseImageURL) + File.separator + imageDir);
            ps.print(HtmlSortWrapper.getHeader(imageDir));
            reportElement.setEmbedded(true);
        }
        this.processReportElement(ps, reportElement, imageDir, baseImageURL, resourceLocator);
        if (reportElement.isSortable()) {
            reportElement.setEmbedded(false);
            ps.print(HtmlSortWrapper.getFooter());
        }
        ps.close();
    }

    private void copySortIcons(boolean sortable, String outputFolder) throws IOException {
        if (sortable) {
            File file = new File(outputFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory()) {
                this.copyImageFiles(outputFolder, "arrow.gif");
                this.copyImageFiles(outputFolder, "darrow.gif");
                this.copyImageFiles(outputFolder, "uarrow.gif");
            }
        }
    }

    private void copyImageFiles(String outputFolder, String filename) throws IOException {
        int len;
        InputStream in = FileLocator.find((Bundle)BIRTPlugin.getDefault().getBundle(), (IPath)new Path("images" + File.separator + filename), null).openStream();
        byte[] buffer = new byte[2048];
        FileOutputStream out = new FileOutputStream(String.valueOf(outputFolder) + File.separator + filename);
        while ((len = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        ((OutputStream)out).close();
    }

    private void processReportElement(OutputStream parentStream, IReportElement reportElement, String imageDir, String baseImageURL, BIRTResourceLocator resourceLocator) throws Exception {
        OutputStream reportStream = null;
        PrintStream ps = null;
        boolean embedded = reportElement.isEmbedded();
        if (parentStream != null && embedded) {
            reportStream = parentStream;
        } else if (reportElement.isSortable()) {
            ps = new PrintStream(reportElement.getOutputStream());
            ps.print(HtmlSortWrapper.getHeader(imageDir));
            reportStream = ps;
            embedded = true;
        } else {
            reportStream = reportElement.getOutputStream();
        }
        this.generateHTMLReportFragment(reportStream, imageDir, baseImageURL, reportElement.getDataSource(), reportElement.getTemplateFile(), embedded, resourceLocator);
        if (reportElement.isSortable() && ps != null) {
            ps.print(HtmlSortWrapper.getFooter());
            ps.close();
        }
        if (reportElement.getChildElements() != null && reportElement.getChildElements().size() > 0) {
            int x = 0;
            while (x < reportElement.getChildElements().size()) {
                IReportElement childReportElement = (IReportElement)reportElement.getChildElements().get(x);
                this.processReportElement(reportStream, childReportElement, imageDir, baseImageURL, resourceLocator);
                ++x;
            }
        }
    }

    public void generateHTMLReport(OutputStream out, InputStream templateFile, InputStream dataSource, boolean sortable, String imageDir, String baseImageURL, BIRTResourceLocator resourceLocator) throws Exception {
        PrintStream reportStream = null;
        PrintStream ps = null;
        reportStream = ps = new PrintStream(out);
        if (sortable) {
            this.copySortIcons(sortable, String.valueOf(baseImageURL) + File.separator + imageDir);
            ps.print(HtmlSortWrapper.getHeader(imageDir));
        }
        this.generateHTMLReportFragment(reportStream, imageDir, baseImageURL, dataSource, templateFile, false, resourceLocator);
        if (sortable) {
            ps.print(HtmlSortWrapper.getFooter());
            ps.close();
        }
        ps.close();
    }

    private IReportEngine getEngine() throws BirtException {
        if (this.engine == null) {
            EngineConfig config = new EngineConfig();
            if (this.birtHome != null) {
                config.setProperty("BIRT_HOME", (Object)this.birtHome);
            }
            Platform.startup((PlatformConfig)config);
            IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            this.engine = factory.createReportEngine(config);
            HTMLEmitterConfig emitterConfig = new HTMLEmitterConfig();
            emitterConfig.setImageHandler((IHTMLImageHandler)new TPTPImageHandler());
            emitterConfig.setActionHandler((IHTMLActionHandler)new HTMLActionHandler());
            config.getEmitterConfigs().put("html", emitterConfig);
            this.engine.changeLogLevel(Level.SEVERE);
        }
        return this.engine;
    }

    public boolean initializationOK() {
        try {
            Class.forName("org.eclipse.birt.report.engine.api.IReportEngine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private void generateHTMLReportFragment(OutputStream os, String imageDir, String baseImageURL, InputStream xmlInput, InputStream templateFile, boolean embedded, BIRTResourceLocator resourceLocator) throws Exception {
        this.engine = this.getEngine();
        TPTPHTMLRenderContext renderContext = new TPTPHTMLRenderContext();
        if (imageDir != null) {
            renderContext.setImageDirectory(imageDir);
            renderContext.setImageDirectory(String.valueOf(baseImageURL) + File.separator + imageDir);
            renderContext.setTptpImageDir(imageDir);
        }
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFormat("html");
        renderContext.setSupportedImageFormats("SVG;PNG;GIF;JPG;BMP");
        renderContext.setRenderOption((IRenderOption)options);
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("HTML_RENDER_CONTEXT", (Object)renderContext);
        contextMap.put("org.eclipse.birt.report.data.oda.xml.inputStream", xmlInput);
        contextMap.put("org.eclipse.birt.report.data.oda.xml.closeInputStream", "true");
        IReportRunnable report = null;
        try {
            report = this.engine.openReportDesign(templateFile);
            report.getDesignHandle().getModule().getSession().setResourceLocator((IResourceLocator)resourceLocator);
        }
        catch (EngineException e) {
            this.engine.destroy();
            throw e;
        }
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(report);
        task.setAppContext(contextMap);
        options.setEmbeddable(embedded);
        OutputStream out = os;
        if (embedded) {
            out = new ByteArrayOutputStream();
        }
        options.setOutputFormat("html");
        options.setOutputStream(out);
        task.setRenderOption((IRenderOption)options);
        task.setAppContext(contextMap);
        task.run();
        if (embedded) {
            os.write(((ByteArrayOutputStream)out).toString("UTF-8").getBytes());
        }
    }

    public String getBirtHome() {
        return this.birtHome;
    }

    public void setBirtHome(String birtHome) {
        this.birtHome = birtHome;
    }
}

