/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.actions.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticViewer;
import org.eclipse.hyades.trace.views.adapter.internal.ProfilingAdvancedTabAttributeSet;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersAdvancedUI;
import org.eclipse.hyades.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class FilterOutAction
implements IViewActionDelegate {
    private ArrayList filterOutObjs = new ArrayList(2);
    private FilterTraceViewer viewer;
    private static String FILTER_OUT_OPERATOR = BasicFeatureFilterAttribute.getOperatorString((RelationalOperators)RelationalOperators.get((int)5));

    public void run(IAction action) {
        EList arguments;
        LogicalExpression logicalExpression;
        if (this.viewer == null) {
            return;
        }
        ProfilingAdvancedTabAttributeSet advancedSet = new ProfilingAdvancedTabAttributeSet();
        SimpleSearchQuery query = this.viewer.advancedQuery();
        int openIndex = -1;
        if (query != null && query.getWhereExpression() != null && query.getWhereExpression() instanceof LogicalExpression) {
            logicalExpression = (LogicalExpression)query.getWhereExpression();
            logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
            arguments = logicalExpression.getArguments();
        } else if (query != null && query.getWhereExpression() == null) {
            logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
            arguments = logicalExpression.getArguments();
            query.setWhereExpression((WhereExpression)logicalExpression);
        } else {
            return;
        }
        openIndex += arguments.size();
        int i = 0;
        while (i < this.filterOutObjs.size()) {
            IFilterAttribute filterAttribute;
            EAttribute attribute = null;
            String value = null;
            Object obj = this.filterOutObjs.get(i);
            if (obj instanceof TRCPackage) {
                attribute = TracePackageImpl.init().getTRCPackage_Name();
                value = ((TRCPackage)obj).getName();
            } else if (obj instanceof TRCClass) {
                attribute = TracePackageImpl.init().getTRCClass_Name();
                value = ((TRCClass)obj).getName();
            } else if (obj instanceof TRCMethod && !(this.viewer instanceof MemoryStatisticViewer)) {
                attribute = TracePackageImpl.init().getTRCMethod_Name();
                value = ((TRCMethod)obj).getName();
            }
            if (attribute != null && value != null && (filterAttribute = advancedSet.getFilterAttribute((EStructuralFeature)attribute)) != null) {
                WhereExpression whereExpression = filterAttribute.getWhereExpression(FILTER_OUT_OPERATOR, value);
                whereExpression.setName(FiltersAdvancedUI.getWhereExpressionName((LogicalExpression)logicalExpression, (IFilterAttribute)filterAttribute));
                arguments.add((Object)whereExpression);
            }
            ++openIndex;
            ++i;
        }
        this.viewer.updateAdvancedQuery(query, openIndex);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.filterOutObjs.clear();
        if (selection != null && selection instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TRCPackage) && !(obj instanceof TRCClass) && !(obj instanceof TRCMethod)) continue;
                this.filterOutObjs.add(obj);
            }
        }
    }

    public void init(IViewPart view) {
        this.viewer = view instanceof FilterTraceViewer ? (FilterTraceViewer)view : null;
    }

    public void dispose() {
        this.filterOutObjs = null;
        this.viewer = null;
    }
}

