/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.trace.views.adapter.internal.ActiveFilter;

public abstract class DynamicFilter
extends ActiveFilter {
    protected static final Map REGISTERED_FILTERS = new HashMap();

    public DynamicFilter(String enabledKey, String disabledKey) {
        super(enabledKey, disabledKey);
        DynamicFilter.register(this);
    }

    public abstract SimpleSearchQuery update(SimpleSearchQuery var1, EObject var2);

    public static boolean containsDynamicFilters(SimpleSearchQuery filter) {
        if (filter == null) {
            return false;
        }
        WhereExpression whereExpression = filter.getWhereExpression();
        if (whereExpression == null) {
            return false;
        }
        WhereExpression subexpression = DynamicFilter.getNamedSubexpression(whereExpression, REGISTERED_FILTERS.keySet());
        return subexpression != null;
    }

    public static SimpleSearchQuery updateDynamicFilters(SimpleSearchQuery filter, EObject object) {
        if (filter == null) {
            return null;
        }
        WhereExpression whereExpression = filter.getWhereExpression();
        if (whereExpression == null) {
            return filter;
        }
        return DynamicFilter.updateDynamicFilters(filter, whereExpression, object);
    }

    private static SimpleSearchQuery updateDynamicFilters(SimpleSearchQuery query, WhereExpression we, EObject object) {
        SimpleSearchQuery result = query;
        Object filter = REGISTERED_FILTERS.get(we.getName());
        if (filter != null) {
            result = ((DynamicFilter)filter).update(result, object);
        }
        if (we instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)we;
            EList subExpsessions = le.getArguments();
            int i = 0;
            while (i < subExpsessions.size()) {
                WhereExpression subExpression = (WhereExpression)subExpsessions.get(i);
                result = DynamicFilter.updateDynamicFilters(result, subExpression, object);
                ++i;
            }
        }
        return result;
    }

    private static void register(DynamicFilter filter) {
        REGISTERED_FILTERS.put(filter.getEnabledKey(), filter);
    }
}

