/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.AggregatedExecutionStatisticsTab;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTab;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTabItem;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionSummaryTab;
import org.eclipse.hyades.trace.views.adapter.internal.MethodDetailsTab;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticMethodPage;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternTab;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ExecutionStatisticPage2
extends MultiLevelStatisticMethodPage {
    ExecutionStatisticTabItem[] _items;
    CTabFolder _tabFolder;
    static final int EXECUTION_SUMMARY_TAB_INDEX = 0;
    static final int EXECUTION_DETAILS_TAB_INDEX = 1;
    static final int AGGREGATED_EXECUTION_STATISTICS_TAB_INDEX = 2;
    static final int METHOD_DETAILS_TAB_INDEX = 3;
    static final int METHOD_INVOCATION_TAB_INDEX = 4;
    static final int NO_ACTIVE_TAB_INDEX = -2;
    private int activeTabIndex = -2;
    private MethodDetailsTab _methodDetailsTab = new MethodDetailsTab(this);

    public MethodDetailsTab getMethodDetailsTab() {
        return this._methodDetailsTab;
    }

    public ExecutionStatisticPage2(EObject mofObject, TraceViewer _viewer) {
        super(mofObject, _viewer);
        this._items = new ExecutionStatisticTabItem[]{new ExecutionSummaryTab(this), new ExecutionStatisticTab(this), new AggregatedExecutionStatisticsTab(this), this._methodDetailsTab, new SinglePatternTab(this)};
    }

    protected MultiLevelStatisticView displayData(Composite parent) {
        return null;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(TraceUIPlugin.getPluginId()) + ".clst0000");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this._tabFolder = new CTabFolder(parent, 0x800400);
        this._tabFolder.setLayoutData((Object)gd);
        this._tabFolder.setFont(parent.getFont());
        this._tabFolder.setBackground(parent.getDisplay().getSystemColor(22));
        this._tabFolder.setForeground(parent.getDisplay().getSystemColor(21));
        this._tabFolder.setSelectionBackground(new Color[]{parent.getDisplay().getSystemColor(25)}, new int[0]);
        this._tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExecutionStatisticPage2.this.tabItemSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ExecutionStatisticPage2.this.tabItemSelected();
            }
        });
        int i = 0;
        while (i < this._items.length) {
            if (!this._items[i].isEmpty()) {
                this._items[i].createControl((Composite)this._tabFolder);
                CTabItem tabItem = new CTabItem(this._tabFolder, 0);
                tabItem.setText(this._items[i].getViewTitle());
                tabItem.setControl(this._items[i].getControl());
                tabItem.setData((Object)this._items[i]);
            }
            ++i;
        }
        this.selectTabItem(0);
    }

    public Action percentMode() {
        return ((ExecutionStatisticViewer2)this.getTraceViewer()).percentMode();
    }

    public Action deltaColumns() {
        return ((ExecutionStatisticViewer2)this.getTraceViewer()).deltaColumns();
    }

    public Action getInstanceLevel() {
        return ((ExecutionStatisticViewer2)this._viewer).getInstanceLevel();
    }

    protected ExecutionStatisticTabItem getSelectedItem() {
        if (this._tabFolder == null) {
            return null;
        }
        CTabItem selection = this._tabFolder.getSelection();
        return (ExecutionStatisticTabItem)(selection != null ? selection.getData() : null);
    }

    public ExecutionStatisticViewer2 getViewer() {
        return (ExecutionStatisticViewer2)this._viewer;
    }

    public void updateButtons(int level) {
        super.updateButtons(level);
        this.getInstanceLevel().setChecked(4 == level);
        this.deltaColumns().setEnabled(4 != level);
    }

    public boolean isEmpty() {
        return !PerftraceUtil.hasExecutionInfo((EObject)this.getMOFObject());
    }

    public Control getControl() {
        return this._tabFolder;
    }

    public void refreshPage() {
        if (this._tabFolder != null) {
            int i = 0;
            while (i < this._tabFolder.getItemCount()) {
                ((ExecutionStatisticTabItem)this._tabFolder.getItem(i).getData()).refresh();
                ++i;
            }
        }
    }

    public void setFocus() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.setFocus();
        }
    }

    public void selectionChanged() {
        if (this._tabFolder != null) {
            int i = 0;
            while (i < this._tabFolder.getItemCount()) {
                ((ExecutionStatisticTabItem)this._tabFolder.getItem(i).getData()).selectionChanged();
                ++i;
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.fillContextMenu(menu);
        }
    }

    public void dispose() {
        super.dispose();
        this._mofObject = null;
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.disposed = true;
        if (this._items != null) {
            int i = 0;
            while (i < this._items.length) {
                this._items[i].dispose();
                ++i;
            }
        }
        this._tabFolder.dispose();
    }

    public MultiLevelStatisticView getView() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            return selItem.getStatisticView();
        }
        return null;
    }

    public void update(boolean newPage) {
        if (newPage) {
            int i = 0;
            while (i < this._items.length) {
                this._items[i].update(newPage);
                ++i;
            }
        } else if (this._tabFolder != null) {
            this._items[this.getActiveTabIndex()].update(newPage);
        }
    }

    protected void setActiveTabIndex(int index) {
        if (index >= 0 && index < this._items.length) {
            this.activeTabIndex = index;
            return;
        }
        this.activeTabIndex = -2;
    }

    protected int getActiveTabIndex() {
        return this.activeTabIndex;
    }

    protected void selectTabItem(int index) {
        if (this._tabFolder != null && index >= 0 && index < this._items.length) {
            int tab = 0;
            while (tab < this._tabFolder.getItemCount()) {
                if (this._tabFolder.getItem(tab).getData() == this._items[index]) {
                    this._tabFolder.setSelection(tab);
                    this.activeTabIndex = index;
                    this.tabItemSelected();
                }
                ++tab;
            }
        }
    }

    public void showMethodDetailsTab() {
        this.selectTabItem(3);
    }

    public void showExecutionStatisticTab() {
        this.selectTabItem(1);
    }

    public void showMethodInvocationTab() {
        this.selectTabItem(4);
    }

    public void showAggregatedExecutionStatistic() {
        this.selectTabItem(2);
    }

    public void showExecutionSummaryTab() {
        this.selectTabItem(0);
    }

    public void setCheckedLevels(int newLevel) {
        int i = 0;
        while (i < this._items.length) {
            this._items[i].setCheckedLevels(newLevel);
            ++i;
        }
    }

    public AggregatedExecutionStatisticsTab getAggregatedExecutionStatisticsTab() {
        return (AggregatedExecutionStatisticsTab)this._items[2];
    }

    public void runShowPercentAction() {
        int i = 0;
        while (i < this._items.length) {
            this._items[i].runShowPercentAction();
            ++i;
        }
    }

    public void runDeltaColumnsAction() {
        int i = 0;
        while (i < this._items.length) {
            this._items[i].runDeltaColumnsAction();
            ++i;
        }
    }

    public void runNextAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runNextAction();
        }
    }

    public void runPreviousAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runPreviousAction();
        }
    }

    public void runHomeAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runHomeAction();
        }
    }

    public void runShowCallerAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runShowCallerAction();
        }
    }

    public void runShowCalleeAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runShowCalleeAction();
        }
    }

    public void runStdSelectAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runStdSelectAction();
        }
    }

    public void runZoomInAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runZoomInAction();
        }
    }

    public void runZoomOutAction() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            selItem.runZoomOutAction();
        }
    }

    protected void tabItemSelected() {
        final ExecutionStatisticTabItem selItem = this.getSelectedItem();
        if (selItem != null) {
            if (this.isVisible()) {
                this.propagateHiddenToItem(this.activeTabIndex);
            }
            this.activeTabIndex = -2;
            int i = 0;
            while (i < this._items.length) {
                if (this._items[i] == selItem) {
                    this.activeTabIndex = i;
                    break;
                }
                ++i;
            }
            if (this.isVisible()) {
                this.propagateVisibleToItem(this.activeTabIndex);
            }
            this.getViewer().setFilterActionEnabled(selItem.isFilteringEnabled());
            this.getViewer().enableSupportedActions(selItem);
            selItem.tabItemSelected();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("ShowFilterAction", Boolean.toString(selItem.isFilteringEnabled()));
                    return null;
                }
            });
        } else {
            this.getViewer().enableSupportedActions(null);
        }
    }

    public Object[] getViewerControls() {
        ExecutionStatisticTabItem selItem = this.getSelectedItem();
        return selItem != null ? selItem.getViewerControls() : null;
    }

    protected void handleHidden() {
        this.propagateHiddenToItem(this.activeTabIndex);
    }

    protected void handleVisible() {
        this.propagateVisibleToItem(this.activeTabIndex);
    }

    protected void propagateVisibleToItem(int index) {
        if (index == -2) {
            return;
        }
        ExecutionStatisticTabItem item = this._items[index];
        item.setVisible();
    }

    protected void propagateHiddenToItem(int index) {
        if (index == -2) {
            return;
        }
        ExecutionStatisticTabItem item = this._items[index];
        item.setHidden();
    }
}

