/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTabItem;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.filters.internal.actions.FiltersEditorAction;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceMessages;
import org.eclipse.ui.forms.widgets.Form;

public class ExecutionStatisticTab
extends ExecutionStatisticTabItem {
    protected static final String _title = TraceUIPlugin.getString("2");
    protected MultiLevelStatisticView _view;
    protected HyadesFormToolkit _toolkit;
    protected Form _form;
    protected Link _info;

    public ExecutionStatisticTab(ExecutionStatisticPage2 page) {
        super(page);
    }

    public void createControl(Composite parent) {
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this._form = this._toolkit.createForm(parent);
        this._form.setText(_title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        this._form.setLayoutData((Object)new GridData(4, 4, true, true));
        this._form.getBody().setLayout((Layout)gridLayout);
        this._form.getBody().setLayoutData((Object)new GridData(4, 4, true, true));
        this._info = new Link(this._form.getBody(), 0x40 | this._toolkit.getOrientation());
        this._info.setBackground(this._toolkit.getColors().getBackground());
        this._info.setForeground(this._toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Font font = this._info.getFont();
        FontData fd = font.getFontData()[0];
        font = new Font(null, new FontData(fd.getName(), fd.getHeight(), fd.getStyle() | 1));
        this._info.setFont(font);
        this._info.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExecutionStatisticTab.this._page != null && ExecutionStatisticTab.this._page.getViewer() != null) {
                    FiltersEditorAction feAction = new FiltersEditorAction(ExecutionStatisticTab.this._page.getViewer().getFilterInformationManager(), true);
                    feAction.run();
                }
            }
        });
        this._info.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._view = new ExecutionStatisticView(this._form.getBody(), this._page);
        this._page.setContextMenu((Control)this._view.getTree(), (ISelectionProvider)this._view.getTreeViewer());
        this._view.getControl().setFocus();
    }

    public Control getControl() {
        return this._form;
    }

    public void refresh() {
        if (this._view != null) {
            this._view.updateButtons();
            this._view.refresh();
            this._info.setText(NLS.bind((String)CommonUITraceMessages.CHOOSE_FILTER_MSG, (Object)this.getCurrentFilterName()));
        }
    }

    public void setFocus() {
        if (this._view != null) {
            this._view.getControl().setFocus();
            this._view.showNewSelection();
        }
    }

    public void selectionChanged() {
        if (this._view != null) {
            this._view.selectionChanged();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this._view != null) {
            this._view.menuAboutToShow(menu);
        }
    }

    public void dispose() {
        if (this._view != null) {
            this._view.dispose();
            this._view = null;
        }
        if (this._toolkit != null) {
            this._toolkit.dispose();
            this._toolkit = null;
        }
        if (this._form != null) {
            this._form.dispose();
            this._form = null;
        }
        this._page = null;
    }

    public MultiLevelStatisticView getView() {
        return this._view;
    }

    public MultiLevelStatisticView getStatisticView() {
        return this._view;
    }

    public void update(boolean newPage) {
        if (this._view != null) {
            this._view.update();
            this._info.setText(NLS.bind((String)CommonUITraceMessages.CHOOSE_FILTER_MSG, (Object)this.getCurrentFilterName()));
        }
    }

    public String getCurrentFilterName() {
        SimpleSearchQuery filter = this._page.getViewer().getCurrentFilter();
        String filterName = filter != null ? filter.getName() : CommonUITraceMessages.ST_FLTAPN;
        return filterName;
    }

    public String getViewTitle() {
        return _title;
    }

    public void setCheckedLevels(int newLevel) {
        this._view.setLevel(newLevel);
        this._view.updateButtons();
        this._view.redrawTable();
    }

    public void runShowPercentAction() {
        if (this._view != null) {
            this._view.getShowPercentAction().run();
        }
    }

    public void runDeltaColumnsAction() {
        if (this._view != null) {
            this._view.getDeltaColumnsAction().run();
        }
    }

    public boolean isFilteringEnabled() {
        return true;
    }

    public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = this._page.getViewer();
        return new IAction[]{viewer.getReportAction(), viewer.getFiltersAction(), viewer._packageLevel, viewer._classLevel, viewer._methodLevel, viewer._instanceLevel, viewer._openSource, viewer._percentMode, viewer._deltaColumns};
    }

    public Object[] getViewerControls() {
        return new Object[]{this._view.getTree()};
    }

    protected void handleHidden() {
        if (this._view != null) {
            this._view.setHidden();
        }
    }

    protected void handleVisible() {
        if (this._view != null) {
            this._view.setVisible();
        }
    }
}

