/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTabItem;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticMethodViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;

public class ExecutionStatisticViewer2
extends MultiLevelStatisticMethodViewer
implements IPartListener {
    public static final String VIEW_ID = "org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2";
    public static final String RUNTIME_ID = "RUNTIME_ID";
    private static ExecutionStatisticViewer2 activeViewer;
    protected Action _percentMode;
    protected Action _deltaColumns;
    protected Action _next;
    protected Action _previous;
    protected Action _update;
    protected Action _caller;
    protected Action _callee;
    protected Action _showRawTime;
    protected Action _zoomInAction;
    protected Action _zoomOutAction;
    protected Action _stdSelectAction;
    protected Action _showCompensatedTime;
    protected Action _openColorDialog;
    protected Action _instanceLevel;
    protected IContributionItem[] _toolbarItems;
    protected IMenuManager _timeMenu;
    protected static final String _title;

    static {
        _title = TraceUIPlugin.getString("2");
    }

    public TraceViewerPage createPage(EObject mofObject) {
        if (this._fi != null) {
            this._fi.restore();
        }
        return new ExecutionStatisticPage2(mofObject, (TraceViewer)this);
    }

    public String getViewTitle() {
        return _title;
    }

    protected void getLevelActions(Vector actions) {
        super.getLevelActions(actions);
        this._instanceLevel = new Action("show.instance.level"){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    ExecutionStatisticViewer2.this.revertChecked(ExecutionStatisticViewer2.this._instanceLevel);
                    return;
                }
                ExecutionStatisticViewer2.this.setCheckedLevels(page, 4);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._instanceLevel.setEnabled(true);
        actions.addElement(new Separator());
        actions.addElement(this._instanceLevel);
    }

    private void getMultiLevelActions(Vector actions) {
        this.createPercentModeAction();
        String strShowDelta = TraceUIMessages._84;
        this._deltaColumns = new Action(strShowDelta){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    ExecutionStatisticViewer2.this.revertChecked(ExecutionStatisticViewer2.this._deltaColumns);
                    return;
                }
                page.runDeltaColumnsAction();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._deltaColumns.setText(strShowDelta);
        TracePluginImages.setImageDescriptors((IAction)this._deltaColumns, "lcl16", "delta_show.gif");
        this._deltaColumns.setDescription(strShowDelta);
        this._deltaColumns.setToolTipText(strShowDelta);
        this._deltaColumns.setEnabled(true);
        int actionSize = actions.size();
        super.getActions(actions);
        if (actionSize + 1 < actions.size()) {
            actions.insertElementAt(this._percentMode, actionSize + 2);
            actions.insertElementAt(this._deltaColumns, actionSize + 3);
        } else {
            actions.addElement(this._percentMode);
            actions.addElement(this._deltaColumns);
        }
    }

    private void getSinglePatternActions(Vector actions) {
        String compTime = TraceUIMessages._112;
        this._showCompensatedTime = new Action(compTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(compTime);
        this._showCompensatedTime.setDescription(compTime);
        this._showCompensatedTime.setToolTipText(compTime);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(ref == 0);
        String rawTime = TraceUIMessages._111;
        this._showRawTime = new Action(rawTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(rawTime);
        this._showRawTime.setDescription(rawTime);
        this._showRawTime.setToolTipText(rawTime);
        ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(ref == 1);
        String strPrev = TraceUIMessages._9;
        this._previous = new Action(strPrev){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runPreviousAction();
            }
        };
        this._previous.setText(strPrev);
        TracePluginImages.setImageDescriptors((IAction)this._previous, "lcl16", "prev_nav.gif");
        this._previous.setDescription(strPrev);
        this._previous.setToolTipText(TraceUIMessages._11);
        String strNext = TraceUIMessages._10;
        this._next = new Action(strNext){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runNextAction();
            }
        };
        this._next.setText(strNext);
        TracePluginImages.setImageDescriptors((IAction)this._next, "lcl16", "next_nav.gif");
        this._next.setDescription(strNext);
        this._next.setToolTipText(TraceUIMessages._12);
        String strHome = TraceUIMessages._73;
        this._update = new Action(strHome){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runHomeAction();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._update.setText(strHome);
        TracePluginImages.setImageDescriptors((IAction)this._update, "tool16", "home_nav.gif");
        this._update.setDescription(strHome);
        this._update.setToolTipText(strHome);
        String strStdSelect = TraceUIMessages._117;
        this._stdSelectAction = new Action(strStdSelect){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runStdSelectAction();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._stdSelectAction.setText(strStdSelect);
        TracePluginImages.setImageDescriptors((IAction)this._stdSelectAction, "lcl16", "select_zoomin.gif");
        this._stdSelectAction.setDescription(strStdSelect);
        this._stdSelectAction.setToolTipText(strStdSelect);
        String strZoomIn = TraceUIMessages._7;
        this._zoomInAction = new Action(strZoomIn){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runZoomInAction();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomInAction.setText(strZoomIn);
        TracePluginImages.setImageDescriptors((IAction)this._zoomInAction, "lcl16", "zoomin_nav.gif");
        this._zoomInAction.setDescription(strZoomIn);
        this._zoomInAction.setToolTipText(strZoomIn);
        String strZoomOut = TraceUIMessages._8;
        this._zoomOutAction = new Action(strZoomOut){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runZoomOutAction();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomOutAction.setText(strZoomOut);
        TracePluginImages.setImageDescriptors((IAction)this._zoomOutAction, "lcl16", "zoomout_nav.gif");
        this._zoomOutAction.setDescription(strZoomOut);
        this._zoomOutAction.setToolTipText(strZoomOut);
        String strCaller = TraceUIMessages._71;
        this._caller = new Action(strCaller){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runShowCallerAction();
            }
        };
        this._caller.setText(strCaller);
        TracePluginImages.setImageDescriptors((IAction)this._caller, "lcl16", "showcaller_co.gif");
        this._caller.setDescription(strCaller);
        this._caller.setToolTipText(strCaller);
        String strCalee = TraceUIMessages._72;
        this._callee = new Action(strCalee){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runShowCalleeAction();
            }
        };
        this._callee.setText(strCalee);
        TracePluginImages.setImageDescriptors((IAction)this._callee, "lcl16", "caller_co.gif");
        this._callee.setDescription(strCalee);
        this._callee.setToolTipText(strCalee);
        this._openColorDialog = new Action(TraceUIMessages._99){

            public void run() {
                GraphColorDialog dialog = new GraphColorDialog(ExecutionStatisticViewer2.this.getViewSite().getShell(), TraceUIMessages._97, null);
                dialog.open();
            }
        };
        this._openColorDialog.setText(TraceUIMessages._99);
        TracePluginImages.setImageDescriptors((IAction)this._openColorDialog, "tool16", "opengraphcolor_co.gif");
        this._openColorDialog.setDescription(TraceUIMessages._99);
        this._openColorDialog.setToolTipText(TraceUIMessages._99);
        this.createPercentModeAction();
        actions.add(new Separator());
        actions.add(this._caller);
        actions.add(this._callee);
        actions.add(new Separator());
        actions.add(this._previous);
        actions.add(this._next);
        actions.add(new Separator());
        actions.add(this._stdSelectAction);
        actions.add(this._zoomInAction);
        actions.add(this._zoomOutAction);
        actions.add(new Separator());
        actions.add(this._update);
        actions.add(new Separator());
        actions.add(this._openColorDialog);
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        this._timeMenu = new MenuManager(TraceUIMessages._113);
        menu.add((IContributionItem)this._timeMenu);
        this._timeMenu.add((IAction)this._showCompensatedTime);
        this._timeMenu.add((IAction)this._showRawTime);
    }

    public void getActions(Vector actions) {
        this.getMultiLevelActions(actions);
        this.getSinglePatternActions(actions);
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this._toolbarItems = tbm.getItems();
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action deltaColumns() {
        return this._deltaColumns;
    }

    public Action getInstanceLevel() {
        return this._instanceLevel;
    }

    protected void setActionsNull() {
        super.setActionsNull();
        this._instanceLevel = null;
    }

    public void updateContext() {
        super.updateContext();
        this.setActionProperties(this._instanceLevel, this._context, "show.instance.level");
    }

    public void setCheckedLevels(MultiLevelStatisticPage page, int newLevel) {
        ((ExecutionStatisticPage2)page).setCheckedLevels(newLevel);
    }

    public Object[] getViewerControls() {
        if (this.getCurrentPage() instanceof ExecutionStatisticPage2) {
            return ((ExecutionStatisticPage2)this.getCurrentPage()).getViewerControls();
        }
        return null;
    }

    public Viewer[] getExportViewer() {
        return null;
    }

    public void showMethodDetailsTab() {
        Object obj = this.getModelObject();
        if (obj != null) {
            this.showMethodDetailsTab((EObject)obj);
        }
    }

    public void showMethodDetailsTab(EObject object) {
        this.setPageTab(object, 3);
        this.addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2)this.getCurrentPage();
        if (page != null) {
            page.getMethodDetailsTab().getView().updateCurrentSelection();
            page.showMethodDetailsTab();
        }
    }

    public void showExecutionStatisticTab(EObject object) {
        this.setPageTab(object, 1);
        this.addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2)this.getCurrentPage();
        if (page != null) {
            page.showExecutionStatisticTab();
        }
    }

    public void showMethodInvocationTab() {
        Object obj = this.getModelObject();
        if (obj != null) {
            this.showMethodInvocationTab((EObject)obj);
        }
    }

    public void showMethodInvocationTab(EObject object) {
        this.setPageTab(object, 4);
        this.addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2)this.getCurrentPage();
        if (page != null) {
            page.showMethodInvocationTab();
        }
    }

    public void showAggregatedExecutionStatisticTab(EObject object) {
        this.setPageTab(object, 2);
        this.addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2)this.getCurrentPage();
        if (page != null) {
            page.showAggregatedExecutionStatistic();
        }
    }

    public void showExecutionSummaryTab(EObject object) {
        this.setPageTab(object, 0);
        this.addViewPage(object, true);
        ExecutionStatisticPage2 page = (ExecutionStatisticPage2)this.getCurrentPage();
        if (page != null) {
            page.showExecutionSummaryTab();
        }
    }

    protected void setPageTab(EObject object, int index) {
        EObject _mofObject = this.getObjectToView(object);
        if (_mofObject == null) {
            return;
        }
        TraceViewerPage page = this.getPage(_mofObject);
        if (page != null && page instanceof ExecutionStatisticPage2) {
            ((ExecutionStatisticPage2)page).setActiveTabIndex(index);
        }
    }

    public void enableSupportedActions(ExecutionStatisticTabItem tabItem) {
        IAction[] all = this.getAllActions();
        IAction[] supported = tabItem != null ? tabItem.getSupportedActions() : new IAction[]{};
        MultiLevelStatisticView statisticView = tabItem != null ? tabItem.getStatisticView() : null;
        boolean enableColumnsActions = statisticView != null;
        boolean enableTimeMenu = tabItem != null ? tabItem.isTimeMenuEnabled() : false;
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        boolean wasSeparator = false;
        int i = 0;
        while (i < this._toolbarItems.length) {
            if (this._toolbarItems[i] instanceof Separator) {
                if (!wasSeparator) {
                    tbm.add(this._toolbarItems[i]);
                    wasSeparator = true;
                }
            } else {
                wasSeparator = false;
                if (this.isOneOfActions(this._toolbarItems[i], supported) || !this.isOneOfActions(this._toolbarItems[i], all)) {
                    tbm.add(this._toolbarItems[i]);
                }
            }
            ++i;
        }
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        IContributionItem[] menuItems = menuMgr.getItems();
        menuMgr.removeAll();
        if (enableColumnsActions) {
            menuMgr.add((IAction)this._chooseColumns);
            menuMgr.add((IAction)this._sortByColumn);
        }
        int i2 = 0;
        while (i2 < menuItems.length) {
            if (menuItems[i2] instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)menuItems[i2]).getAction();
                if (action != this._sortByColumn && action != this._chooseColumns) {
                    menuMgr.add(menuItems[i2]);
                }
            } else if (menuItems[i2] != this._timeMenu) {
                menuMgr.add(menuItems[i2]);
            }
            ++i2;
        }
        if (enableTimeMenu) {
            menuMgr.add((IContributionItem)this._timeMenu);
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    private boolean isOneOfActions(IContributionItem item, IAction[] actions) {
        if (!(item instanceof ActionContributionItem)) {
            return false;
        }
        IAction lookFor = ((ActionContributionItem)item).getAction();
        int i = 0;
        while (i < actions.length) {
            if (actions[i] == lookFor) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IAction[] getAllActions() {
        return new IAction[]{this.getReportAction(), this.getFiltersAction(), this._percentMode, this._deltaColumns, this._classLevel, this._packageLevel, this._instanceLevel, this._methodLevel, this._next, this._previous, this._update, this._caller, this._callee, this._openSource, this._zoomInAction, this._zoomOutAction, this._stdSelectAction, this._openColorDialog};
    }

    private void createPercentModeAction() {
        if (this._percentMode != null) {
            return;
        }
        String strShowPercent = TraceUIMessages._13;
        this._percentMode = new Action(strShowPercent){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.runShowPercentAction();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
    }

    public void showPage(IPage page) {
        super.showPage(page);
        if (page instanceof ExecutionStatisticPage2) {
            final ExecutionStatisticPage2 executionStatisticPage = (ExecutionStatisticPage2)page;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("ShowInvocationFlow", Boolean.toString(PerftraceUtil.hasFullMethodInvocationInfo((EObject)executionStatisticPage.getMOFObject())));
                    System.setProperty("ShowInvocationDetails", Boolean.toString(PerftraceUtil.hasMethodInvocationInfo((EObject)executionStatisticPage.getMOFObject())));
                    return null;
                }
            });
        }
    }

    public Action getReportAction() {
        return this._printColumns;
    }

    public String getDefaultPageMessage() {
        return TraceMessages._22;
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        final String rid = memento.getString(RUNTIME_ID);
        if (rid == null) {
            return;
        }
        this.loadingTrace();
        site.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                PDProjectExplorer.getFromActivePerspective();
                TRCAgentProxy obj = PDContentProvider.getAgent((String)rid);
                if (obj != null) {
                    ExecutionStatisticViewer2.this.showExecutionSummaryTab((EObject)obj);
                } else {
                    ExecutionStatisticViewer2.this.loadingTraceDone();
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        String rid = null;
        if (this._mofObject != null && this._mofObject instanceof TRCAgentProxy) {
            rid = ((TRCAgentProxy)this._mofObject).getRuntimeId();
        }
        if (rid != null) {
            memento.putString(RUNTIME_ID, rid);
            super.saveState(memento);
        }
    }

    public boolean isActiveViewer() {
        return this == activeViewer;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof ExecutionStatisticViewer2) {
            activeViewer = (ExecutionStatisticViewer2)part;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part instanceof ExecutionStatisticViewer2) {
            activeViewer = (ExecutionStatisticViewer2)part;
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (activeViewer == part) {
            activeViewer = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getViewSite().getPage().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.getViewSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public static ExecutionStatisticViewer2 getActiveViewer() {
        return activeViewer;
    }
}

