/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTabItem;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.ExecutionSummaryView;
import org.eclipse.hyades.trace.views.internal.MemoryStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class ExecutionSummaryTab
extends ExecutionStatisticTabItem {
    private static final String TITLE = TraceUIPlugin.getString("59");
    protected ExecutionSummaryView _view;

    protected ExecutionSummaryTab(ExecutionStatisticPage2 page) {
        super(page);
    }

    public void createControl(Composite parent) {
        this._view = new ExecutionSummaryView(parent, this);
        this._view.initialize();
        this.setViewContextMenu(this._view.getExecutionStatisticView());
        this.setViewContextMenu(this._view.getMemoryStatisticView());
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this._view != null) {
            this._view.menuAboutToShow(menu);
        }
    }

    public Control getControl() {
        return this._view != null ? this._view.getControl() : null;
    }

    public ExecutionSummaryView getView() {
        return this._view;
    }

    public MultiLevelStatisticView getStatisticView() {
        if (this._view == null) {
            return null;
        }
        ExecutionStatisticView execution = this._view.getExecutionStatisticView();
        MemoryStatisticView memory = this._view.getMemoryStatisticView();
        if (execution != null) {
            return memory == null || !this.hasFocus(memory) ? execution : memory;
        }
        return memory;
    }

    private boolean hasFocus(MultiLevelStatisticView view) {
        Tree tree = view.getTree();
        if (tree != null) {
            try {
                return tree.isFocusControl();
            }
            catch (SWTException sWTException) {
                return false;
            }
        }
        return false;
    }

    public String getViewTitle() {
        return TITLE;
    }

    public void refresh() {
        if (this._view != null) {
            this._view.refresh();
        }
    }

    public void selectionChanged() {
    }

    public void setFocus() {
        if (this._view != null) {
            this._view.getControl().setFocus();
        }
    }

    public void update(boolean newPage) {
        if (this._view != null) {
            this._view.update();
        }
    }

    public void dispose() {
        super.dispose();
        if (this._view != null) {
            this._view.dispose();
            this._view = null;
        }
    }

    public void update() {
        if (this.updateView(this._view.getExecutionStatisticView())) {
            return;
        }
        this.updateView(this._view.getMemoryStatisticView());
    }

    public Object[] getViewerControls() {
        Object[] objectArray;
        ExecutionStatisticView executionView = this._view.getExecutionStatisticView();
        MemoryStatisticView memoryView = this._view.getMemoryStatisticView();
        if (memoryView == null) {
            Object[] objectArray2;
            if (executionView == null) {
                objectArray2 = new Object[]{};
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = executionView.getTree();
            }
            return objectArray2;
        }
        if (executionView == null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = executionView.getTree();
        } else {
            Object[] objectArray5 = new Object[2];
            objectArray5[0] = executionView.getTree();
            objectArray = objectArray5;
            objectArray5[1] = memoryView.getTree();
        }
        return objectArray;
    }

    public boolean isFilteringEnabled() {
        return false;
    }

    private void setViewContextMenu(StatisticView view) {
        if (view == null) {
            return;
        }
        this._page.setContextMenu((Control)view.getTree(), (ISelectionProvider)view.getTreeViewer());
    }

    private boolean updateView(StatisticView view) {
        if (view == null || !view.getTree().isFocusControl()) {
            return false;
        }
        view.update();
        return true;
    }

    public void setCheckedLevels(int newLevel) {
        if (this._view != null) {
            this._view.setCheckedLevels(newLevel);
        }
    }

    public void runShowPercentAction() {
        if (this._view != null) {
            this._view.runShowPercentAction();
        }
    }

    public void runDeltaColumnsAction() {
        if (this._view != null) {
            this._view.runDeltaColumnsAction();
        }
    }

    public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = this._page.getViewer();
        return new IAction[]{viewer.getReportAction(), viewer._packageLevel, viewer._classLevel, viewer._methodLevel, viewer._openSource, viewer._percentMode, viewer._deltaColumns};
    }

    protected void handleHidden() {
        MultiLevelStatisticView v = this._view.getExecutionStatisticView();
        if (v != null) {
            v.setHidden();
        }
        if ((v = this._view.getMemoryStatisticView()) != null) {
            v.setHidden();
        }
    }

    protected void handleVisible() {
        MultiLevelStatisticView v = this._view.getExecutionStatisticView();
        if (v != null) {
            v.setVisible();
        }
        if ((v = this._view.getMemoryStatisticView()) != null) {
            v.setVisible();
        }
    }
}

