/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import com.ibm.icu.util.ULocale;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilterEventsUI {
    private static EAttribute[] comboAttributes = new EAttribute[]{TracePackageImpl.init().getTRCPackage_BaseTime(), TracePackageImpl.init().getTRCPackage_CumulativeTime(), TracePackageImpl.init().getTRCPackage_Calls(), TracePackageImpl.init().getTRCPackage_TotalSize(), TracePackageImpl.init().getTRCPackage_CollectedSize(), TracePackageImpl.init().getTRCPackage_TotalInstances(), TracePackageImpl.init().getTRCPackage_CollectedInstances()};
    private Button filterByTimeOrEventsControl;
    private Combo orderCombo;
    private Text lengthText;
    private Combo typeOfDurationCombo;
    private FiltersStandardTabUI _standardTabUI;
    private IContextLabelFormatProvider _topBaseTime;
    private IContextLabelFormatProvider _topCumulTime;
    private IContextLabelFormatProvider _topCalls;
    private IContextLabelFormatProvider _topTotalSize;
    private IContextLabelFormatProvider _topCollectedSize;
    private IContextLabelFormatProvider _topTotalInst;
    private IContextLabelFormatProvider _topCollectedInst;

    public FilterEventsUI(FiltersStandardTabUI standardTabUI) {
        this._standardTabUI = standardTabUI;
        String context = ContextUpdaterHelper.getCurrentFocusContextLanguage();
        this._topBaseTime = this.getContextLabelFormatProvider(context, "ft.top.base.time");
        this._topCumulTime = this.getContextLabelFormatProvider(context, "ft.top.cumul.time");
        this._topCalls = this.getContextLabelFormatProvider(context, "ft.top.calls");
        this._topTotalSize = this.getContextLabelFormatProvider(context, "ft.top.total.size");
        this._topCollectedSize = this.getContextLabelFormatProvider(context, "ft.top.collect.size");
        this._topTotalInst = this.getContextLabelFormatProvider(context, "ft.top.total.inst");
        this._topCollectedInst = this.getContextLabelFormatProvider(context, "ft.top.collect.inst");
    }

    private IContextLabelFormatProvider getContextLabelFormatProvider(String context, String attributeId) {
        return ContextManager.getContextLabelFormatProvider((String)context, (String)attributeId, (int)3);
    }

    public Control createControl(Composite parent) {
        boolean rotateLayout;
        Composite timeEventsContainer = this.createCompositeWithNumberColumns(parent, 1);
        this.filterByTimeOrEventsControl = new Button(timeEventsContainer, 32);
        this.filterByTimeOrEventsControl.setLayoutData((Object)new GridData());
        this.filterByTimeOrEventsControl.setText(TraceUIMessages._184);
        this.filterByTimeOrEventsControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterEventsUI.this.filterByTimeEventsUpdate();
            }
        });
        Composite comboBoxContainers = this.createCompositeWithNumberColumns(timeEventsContainer, 5);
        Label showLabel = new Label(comboBoxContainers, 1);
        showLabel.setText(TraceUIMessages._185);
        ULocale ulocale = ULocale.getDefault();
        boolean bl = rotateLayout = ulocale.getLanguage().equals("fr") || ulocale.getLanguage().equals("es") || ulocale.getLanguage().equals("ru");
        if (rotateLayout) {
            this.lengthText = new Text(comboBoxContainers, 2048);
            this.lengthText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.lengthText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent key) {
                    if (!FilterEventsUI.this.isInt(FilterEventsUI.this.lengthText.getText().trim())) {
                        FilterEventsUI.this._standardTabUI.setError(TraceUIMessages._196);
                    } else {
                        FilterEventsUI.this._standardTabUI.noError();
                    }
                }
            });
            this.orderCombo = new Combo(comboBoxContainers, 2056);
            this.orderCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.orderCombo.add(TraceUIMessages._187);
            this.orderCombo.add(TraceUIMessages._186);
            this.orderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        } else {
            this.orderCombo = new Combo(comboBoxContainers, 2056);
            this.orderCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.orderCombo.add(TraceUIMessages._187);
            this.orderCombo.add(TraceUIMessages._186);
            this.orderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
            this.lengthText = new Text(comboBoxContainers, 2048);
            this.lengthText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this.lengthText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent key) {
                    if (!FilterEventsUI.this.isInt(FilterEventsUI.this.lengthText.getText().trim())) {
                        FilterEventsUI.this._standardTabUI.setError(TraceUIMessages._196);
                    } else {
                        FilterEventsUI.this._standardTabUI.noError();
                    }
                }
            });
        }
        Label byLabel = new Label(comboBoxContainers, 1);
        byLabel.setText(TraceUIMessages._188);
        this.typeOfDurationCombo = new Combo(comboBoxContainers, 2056);
        this.typeOfDurationCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.typeOfDurationCombo.add(this._topBaseTime.getDisplayStringFromElement((Object)"ft.top.base.time", null, 3));
        this.typeOfDurationCombo.add(this._topCumulTime.getDisplayStringFromElement((Object)"ft.top.cumul.time", null, 3));
        this.typeOfDurationCombo.add(this._topCalls.getDisplayStringFromElement((Object)"ft.top.calls", null, 3));
        this.typeOfDurationCombo.add(this._topTotalSize.getDisplayStringFromElement((Object)"ft.top.total.size", null, 3));
        this.typeOfDurationCombo.add(this._topCollectedSize.getDisplayStringFromElement((Object)"ft.top.collect.size", null, 3));
        this.typeOfDurationCombo.add(this._topTotalInst.getDisplayStringFromElement((Object)"ft.top.total.inst", null, 3));
        this.typeOfDurationCombo.add(this._topCollectedInst.getDisplayStringFromElement((Object)"ft.top.collect.inst", null, 3));
        this.typeOfDurationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.orderCombo.select(0);
        this.typeOfDurationCombo.select(0);
        return timeEventsContainer;
    }

    private Composite createCompositeWithNumberColumns(Composite parent, int numColumns) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        container.setLayout((Layout)layout);
        return container;
    }

    public void filterByTimeEventsUpdate() {
        boolean filterByTimeOrEvents = this.filterByTimeOrEventsControl.getSelection();
        this.orderCombo.setEnabled(filterByTimeOrEvents);
        this.lengthText.setEnabled(filterByTimeOrEvents);
        this.typeOfDurationCombo.setEnabled(filterByTimeOrEvents);
    }

    private int getInt(String str) {
        return Integer.parseInt(str);
    }

    private boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void initializeValues() {
        this.filterByTimeOrEventsControl.setSelection(false);
    }

    public void initializeFrom(SimpleSearchQuery filter) {
        if (filter.getOrderByExpresions().size() > 0) {
            this.filterByTimeOrEventsControl.setSelection(true);
            OrderByElement orderByElement = (OrderByElement)filter.getOrderByExpresions().get(0);
            if (OrderByOperators.ASC_LITERAL.equals((Object)orderByElement.getOperator())) {
                this.orderCombo.select(1);
            } else {
                this.orderCombo.select(0);
            }
            this.lengthText.setText(new Integer(filter.getMaxElements()).toString());
            EStructuralFeature feature = ((SimpleOperand)orderByElement.getOperand()).getFeature();
            int i = 0;
            while (i < comboAttributes.length) {
                if (comboAttributes[i].equals(feature)) {
                    this.typeOfDurationCombo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.filterByTimeOrEventsControl.setSelection(false);
            this.orderCombo.select(0);
            this.lengthText.setText("10");
            this.typeOfDurationCombo.select(0);
        }
        this.filterByTimeEventsUpdate();
    }

    public void performApply(SimpleSearchQuery filter) {
        if (this.filterByTimeOrEventsControl.getSelection()) {
            EAttribute feature = comboAttributes[this.typeOfDurationCombo.getSelectionIndex()];
            OrderByOperators operator = this.orderCombo.getSelectionIndex() == 1 ? OrderByOperators.ASC_LITERAL : OrderByOperators.DESC_LITERAL;
            int maxElements = this.getInt(this.lengthText.getText().trim());
            FilterEventsUI.addOrderByExpressionAndSetMaxElements(filter, (EStructuralFeature)feature, operator, maxElements);
        }
    }

    public static void addOrderByExpressionAndSetMaxElements(SimpleSearchQuery query, EStructuralFeature feature, OrderByOperators operator, int maxElements) {
        OrderByElement orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
        SimpleOperand operand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        operand.setFeature(feature);
        orderByElement.setOperand((Operand)operand);
        orderByElement.setOperator(operator);
        query.getOrderByExpresions().add((Object)orderByElement);
        query.setMaxElements(maxElements);
    }
}

