/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.adapter.internal.ActiveFilter;
import org.eclipse.hyades.trace.views.adapter.internal.FilterEventsUI;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.hyades.ui.util.ICommonUIHelper;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FiltersStandardTabTraceViewsUI
extends FiltersStandardTabUI {
    public static EAttribute ATTRIBUTE_PACKAGE_NAME = TracePackageImpl.init().getTRCPackage_Name();
    public static EAttribute ATTRIBUTE_CLASS_NAME = TracePackageImpl.init().getTRCClass_Name();
    public static EAttribute ATTRIBUTE_METHOD_NAME = TracePackageImpl.init().getTRCMethod_Name();
    public static EAttribute ATTRIBUTE_BASE_TIME = TracePackageImpl.init().getTRCMethod_BaseTime();
    public static RelationalOperators OPERATOR_LIKE = RelationalOperators.get((int)6);
    public static RelationalOperators OPERATOR_GREATER_THAN = RelationalOperators.get((int)1);
    private boolean _showMethodLevel;
    private Text _filterText;
    private Button _packageLevel;
    private Button _classLevel;
    private Button _methodLevel;
    private Button _caseControl;
    private Button _gettersFilter;
    private Button _baseTimeFilter;
    private FilterEventsUI _eventsUI;
    private IContextLabelFormatProvider _packageLabelProvider;
    private IContextLabelFormatProvider _classLabelProvider;
    private IContextLabelFormatProvider _methodLabelProvider;

    public FiltersStandardTabTraceViewsUI(boolean showMethodLevel) {
        this._showMethodLevel = showMethodLevel;
    }

    private void updateLabelProvider() {
        String context = ContextUpdaterHelper.getCurrentFocusContextLanguage();
        this._packageLabelProvider = this.getContextLabelFormatProvider(context, "package.name");
        this._classLabelProvider = this.getContextLabelFormatProvider(context, "class.name");
        this._methodLabelProvider = this.getContextLabelFormatProvider(context, "method.name");
    }

    private IContextLabelFormatProvider getContextLabelFormatProvider(String context, String attributeId) {
        return ContextManager.getContextLabelFormatProvider((String)context, (String)attributeId, (int)3);
    }

    public Control createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        Group nameFilters = new Group(content, 0);
        nameFilters.setText(TraceUIMessages._270);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        nameFilters.setLayout((Layout)layout);
        GridData data = GridUtil.createHorizontalFill();
        nameFilters.setLayoutData((Object)data);
        Composite filterContainer = new Composite((Composite)nameFilters, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        filterContainer.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        filterContainer.setLayoutData((Object)data);
        Label filter = new Label(filterContainer, 0);
        filter.setText(TraceUIMessages._182);
        Composite filterTextContainer = new Composite(filterContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        filterTextContainer.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        filterTextContainer.setLayoutData((Object)data);
        this._filterText = new Text(filterTextContainer, 2048);
        this._filterText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent key) {
            }
        });
        this._caseControl = new Button(filterTextContainer, 32);
        this._caseControl.setLayoutData((Object)new GridData());
        this._caseControl.setText(TraceUIMessages._183);
        Composite levelContainer = new Composite(filterContainer, 0);
        layout = new GridLayout();
        levelContainer.setLayout((Layout)layout);
        levelContainer.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label filterByLabel = new Label(levelContainer, 0);
        filterByLabel.setText(TraceUIMessages._178);
        Composite buttonLevelContainer = new Composite(levelContainer, 0);
        layout = new GridLayout();
        buttonLevelContainer.setLayout((Layout)layout);
        buttonLevelContainer.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.updateLabelProvider();
        this._packageLevel = new Button(buttonLevelContainer, 16);
        this._packageLevel.setText(this._packageLabelProvider.getDisplayStringFromElement((Object)TraceMessages.ST_FPKN, null, 3));
        this._packageLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._classLevel = new Button(buttonLevelContainer, 16);
        this._classLevel.setText(this._classLabelProvider.getDisplayStringFromElement((Object)TraceMessages.ST_FPCN, null, 3));
        this._classLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this._methodLevel = null;
        if (this._showMethodLevel) {
            this._methodLevel = new Button(buttonLevelContainer, 16);
            this._methodLevel.setText(this._methodLabelProvider.getDisplayStringFromElement((Object)TraceMessages.ST_FPMN, null, 3));
            this._methodLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        this._eventsUI = new FilterEventsUI(this);
        this._eventsUI.createControl((Composite)nameFilters);
        Composite gettersFilterContainer = new Composite((Composite)nameFilters, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        gettersFilterContainer.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        gettersFilterContainer.setLayoutData((Object)data);
        this._gettersFilter = new Button(gettersFilterContainer, 32);
        this._gettersFilter.setText(TraceUIMessages._233);
        this._gettersFilter.setSelection(false);
        Group valueFilters = new Group(content, 0);
        valueFilters.setText(TraceUIMessages._234);
        layout = new GridLayout();
        layout.numColumns = 2;
        valueFilters.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        valueFilters.setLayoutData((Object)data);
        Composite valueFilterContainer = new Composite((Composite)valueFilters, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        valueFilterContainer.setLayout((Layout)layout);
        data = GridUtil.createHorizontalFill();
        valueFilterContainer.setLayoutData((Object)data);
        this._baseTimeFilter = new Button(valueFilterContainer, 32);
        this._baseTimeFilter.setText(TraceUIMessages._235);
        this._baseTimeFilter.setSelection(false);
        Composite thresholdContainer = new Composite((Composite)valueFilters, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        thresholdContainer.setLayout((Layout)layout);
        data = new GridData(768);
        thresholdContainer.setLayoutData((Object)data);
        return content;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    public void initializeFrom(SimpleSearchQuery filter) {
        this._filterText.setText("");
        this._caseControl.setSelection(true);
        this._eventsUI.initializeValues();
        boolean levelSet = false;
        if (filter.getWhereExpression() != null && filter.getWhereExpression() instanceof LogicalExpression) {
            LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
            EList filterElements = logicalExpression.getArguments();
            int i = 0;
            while (i < filterElements.size()) {
                BinaryExpression be;
                EStructuralFeature feature;
                if (filterElements.get(i) instanceof BinaryExpression && (feature = ((SimpleOperand)(be = (BinaryExpression)filterElements.get(i)).getLeftOperand()).getFeature()) != null) {
                    boolean validFeature = false;
                    String filterText = "";
                    if (feature.equals(ATTRIBUTE_PACKAGE_NAME)) {
                        filterText = this._packageLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._packageLevel.setSelection(true);
                        validFeature = true;
                    } else if (feature.equals(ATTRIBUTE_CLASS_NAME)) {
                        filterText = this._classLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._classLevel.setSelection(true);
                        validFeature = true;
                    } else if (feature.equals(ATTRIBUTE_METHOD_NAME)) {
                        filterText = this._methodLabelProvider.convertModelValueToDisplayString(String.valueOf(((SimpleOperand)be.getRightOperands().get(0)).getRawValue()));
                        this._methodLevel.setSelection(true);
                        validFeature = true;
                    }
                    if (validFeature) {
                        this._filterText.setText(filterText);
                        this._caseControl.setSelection(!be.isCaseInsensitive());
                        levelSet = true;
                    }
                }
                ++i;
            }
        }
        this._gettersFilter.setSelection(ActiveFilter.isFilterEnabled(TraceUIPlugin.GETSET_FILTER, filter));
        this._baseTimeFilter.setSelection(ActiveFilter.isFilterEnabled(TraceUIPlugin.THRESHOLD_FILTER, filter));
        if (!levelSet) {
            this._packageLevel.setSelection(true);
        }
        this._eventsUI.initializeFrom(filter);
    }

    public SimpleSearchQuery performApply() {
        SimpleSearchQuery resultFilter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        EList arguments = logicalExpression.getArguments();
        this._eventsUI.performApply(resultFilter);
        if (this._filterText.getText().trim().length() > 0) {
            if (this._packageLevel.getSelection()) {
                arguments.add((Object)ICommonUIHelper.INSTANCE.createBinaryExpression((EStructuralFeature)ATTRIBUTE_PACKAGE_NAME, OPERATOR_LIKE, this._packageLabelProvider.convertDisplayStringToModelValue(this._filterText.getText().trim()), !this._caseControl.getSelection()));
            } else if (this._classLevel.getSelection()) {
                arguments.add((Object)ICommonUIHelper.INSTANCE.createBinaryExpression((EStructuralFeature)ATTRIBUTE_CLASS_NAME, OPERATOR_LIKE, this._classLabelProvider.convertDisplayStringToModelValue(this._filterText.getText().trim()), !this._caseControl.getSelection()));
            } else if (this._methodLevel != null && this._methodLevel.getSelection()) {
                arguments.add((Object)ICommonUIHelper.INSTANCE.createBinaryExpression((EStructuralFeature)ATTRIBUTE_METHOD_NAME, OPERATOR_LIKE, this._methodLabelProvider.convertDisplayStringToModelValue(this._filterText.getText().trim()), !this._caseControl.getSelection()));
            }
        }
        if (this._gettersFilter.getSelection()) {
            arguments.add((Object)TraceUIPlugin.GETSET_FILTER.createActiveExpression());
        } else {
            arguments.add((Object)TraceUIPlugin.GETSET_FILTER.createDisabledExpression());
        }
        if (this._baseTimeFilter.getSelection()) {
            arguments.add((Object)TraceUIPlugin.THRESHOLD_FILTER.createActiveExpression());
        } else {
            arguments.add((Object)TraceUIPlugin.THRESHOLD_FILTER.createDisabledExpression());
        }
        resultFilter.setWhereExpression((WhereExpression)logicalExpression);
        return resultFilter;
    }
}

