/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticPage;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticViewer;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class MemoryStatisticViewer
extends MultiLevelStatisticViewer {
    protected Action _percentMode;
    protected Action _deltaColumns;
    protected Action _instanceLevel;
    protected static final String _title = TraceUIPlugin.getString("3");

    public MemoryStatisticViewer() {
        this.setDefaultFilterName(CommonUIMessages._111);
    }

    public TraceViewerPage createPage(EObject mofObject) {
        if (this._fi != null) {
            this._fi.restore();
        }
        return new MemoryStatisticPage(mofObject, (TraceViewer)this);
    }

    public String getViewTitle() {
        return _title;
    }

    protected void getLevelActions(Vector actions) {
        super.getLevelActions(actions);
        this._instanceLevel = new Action("show.instance.level"){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MemoryStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MemoryStatisticViewer.this.revertChecked(MemoryStatisticViewer.this._instanceLevel);
                    return;
                }
                MemoryStatisticViewer.this.setCheckedLevels(page, 3);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._instanceLevel.setEnabled(true);
        actions.addElement(new Separator());
        actions.addElement(this._instanceLevel);
    }

    public void getActions(Vector actions) {
        String strShowPercent = TraceUIMessages._13;
        this._percentMode = new Action(strShowPercent){

            public void run() {
                MemoryStatisticPage page = (MemoryStatisticPage)MemoryStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MemoryStatisticViewer.this.revertChecked(MemoryStatisticViewer.this._percentMode);
                    return;
                }
                page.getView().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
        String strShowDelta = TraceUIMessages._84;
        this._deltaColumns = new Action(strShowDelta){

            public void run() {
                MemoryStatisticPage page = (MemoryStatisticPage)MemoryStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MemoryStatisticViewer.this.revertChecked(MemoryStatisticViewer.this._deltaColumns);
                    return;
                }
                page.getView().getDeltaColumnsAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._deltaColumns.setText(strShowDelta);
        TracePluginImages.setImageDescriptors((IAction)this._deltaColumns, "lcl16", "delta_show.gif");
        this._deltaColumns.setDescription(strShowDelta);
        this._deltaColumns.setToolTipText(strShowDelta);
        this._deltaColumns.setEnabled(true);
        int actionSize = actions.size();
        super.getActions(actions);
        if (actionSize + 1 < actions.size()) {
            actions.insertElementAt(this._percentMode, actionSize + 2);
            actions.insertElementAt(this._deltaColumns, actionSize + 3);
        } else {
            actions.addElement(new Separator());
            actions.addElement(this._percentMode);
            actions.addElement(this._deltaColumns);
        }
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action deltaColumns() {
        return this._deltaColumns;
    }

    public Action getInstanceLevel() {
        return this._instanceLevel;
    }

    protected void setActionsNull() {
        super.setActionsNull();
        this._instanceLevel = null;
    }

    public void updateContext() {
        super.updateContext();
        this.setActionProperties(this._instanceLevel, this._context, "show.instance.level");
    }

    public String getDefaultPageMessage() {
        return TraceMessages._23;
    }
}

