/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticTabItem;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.internal.MethodDetails;
import org.eclipse.hyades.trace.views.internal.MethodDetailsStatistic;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class MethodDetailsTab
extends ExecutionStatisticTabItem {
    protected static final String _title = TraceUIPlugin.getString("7");
    protected MethodDetails _view;
    protected String _description;

    public MethodDetailsTab(ExecutionStatisticPage2 page) {
        super(page);
    }

    public void createControl(Composite parent) {
        this._view = new MethodDetails(parent, this);
        this._view.initialize();
        this._page.setContextMenu((Control)this._view.getMethodStatistic().getTree(), (ISelectionProvider)this._view.getMethodStatistic().getTreeViewer());
        this._page.setContextMenu((Control)this._view.getChildrenStatistic().getTree(), (ISelectionProvider)this._view.getChildrenStatistic().getTreeViewer());
        this._page.setContextMenu((Control)this._view.getParentStatistic().getTree(), (ISelectionProvider)this._view.getParentStatistic().getTreeViewer());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), String.valueOf(TraceUIPlugin.getPluginId()) + ".mthi0000");
    }

    public boolean isEmpty() {
        return !PerftraceUtil.hasMethodInvocationInfo((EObject)this._page.getMOFObject());
    }

    public Control getControl() {
        return this._view != null ? this._view.getControl() : null;
    }

    public void refresh() {
        if (this._view != null) {
            this._view.updateButtons();
            this._view.refresh();
        }
    }

    public void setFocus() {
        if (this._view != null) {
            this._view.getControl().setFocus();
        }
    }

    public void selectionChanged() {
        if (this._view != null) {
            this._view.selectionChanged();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this._view != null) {
            this._view.menuAboutToShow(menu);
        }
    }

    public void dispose() {
        if (this._view != null) {
            this._view.dispose();
        }
        this._view = null;
        this._page = null;
    }

    public void update(boolean newPage) {
        if (newPage && this._view != null) {
            this._view.update(true);
        }
    }

    public MethodDetails getView() {
        return this._view;
    }

    public MultiLevelStatisticView getStatisticView() {
        if (this._view == null) {
            return null;
        }
        if (this.hasFocus(this._view.getChildrenStatistic())) {
            return this._view.getChildrenStatistic();
        }
        if (this.hasFocus(this._view.getParentStatistic())) {
            return this._view.getParentStatistic();
        }
        return this._view.getMethodStatistic();
    }

    private boolean hasFocus(MultiLevelStatisticView view) {
        Tree tree = view.getTree();
        if (tree != null) {
            try {
                return tree.isFocusControl();
            }
            catch (SWTException sWTException) {
                return false;
            }
        }
        return false;
    }

    public String getViewTitle() {
        return _title;
    }

    public Action percentMode() {
        return ((ExecutionStatisticViewer2)this._page.getTraceViewer()).percentMode();
    }

    public void updateTitle() {
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this.getMOFObject());
        this.setViewTitle(selModel.getFirstElement());
    }

    protected void setViewTitle(Object selection) {
        StringBuffer methodName = new StringBuffer(TraceUIPlugin.getString("7"));
        if (selection != null) {
            TRCMethod method = null;
            if (selection instanceof TRCMethod) {
                method = (TRCMethod)selection;
            } else if (selection instanceof TRCMethodInvocation) {
                method = ((TRCMethodInvocation)selection).getMethod();
            }
            if (method != null) {
                String className = "";
                String packName = "";
                if (method.getDefiningClass() != null) {
                    className = method.getDefiningClass().getName();
                    if (method.getDefiningClass().getPackage() != null) {
                        packName = method.getDefiningClass().getPackage().getName();
                    }
                }
                if (packName.length() > 0) {
                    methodName.append(": ").append(packName).append(".").append(className).append(".").append(method.getName()).append(method.getSignature());
                } else {
                    methodName.append(": ").append(className).append(".").append(method.getName()).append(method.getSignature());
                }
            }
        } else {
            methodName.append(": ").append(TraceUIMessages._171);
        }
        this.setContentDescription(methodName.toString());
    }

    private void setContentDescription(String string) {
        this._description = string;
    }

    public String getContentDescription() {
        return this._description;
    }

    public TRCMethod getCurrentSelection() {
        return this._view.getCurrentSelection();
    }

    public void updateStatusContext(IContextLanguage language) {
        if (this._view != null) {
            this._view.updateStatusContext(language);
        }
    }

    public void runShowPercentAction() {
        if (this._view != null) {
            this._view.getMethodStatistic().getShowPercentAction().run();
            this._view.getParentStatistic().getShowPercentAction().run();
            this._view.getChildrenStatistic().getShowPercentAction().run();
        }
    }

    public IAction[] getSupportedActions() {
        ExecutionStatisticViewer2 viewer = this._page.getViewer();
        return new IAction[]{viewer.getReportAction(), viewer._openSource, viewer._percentMode};
    }

    public Object[] getViewerControls() {
        return new Object[]{this._view.getMethodStatistic().getTree(), this._view.getChildrenStatistic().getTree(), this._view.getParentStatistic().getTree()};
    }

    public void tabItemSelected() {
        this._view.refresh();
    }

    protected void handleHidden() {
        MethodDetailsStatistic v = this._view.getMethodStatistic();
        if (v != null) {
            v.setHidden();
        }
        if ((v = this._view.getParentStatistic()) != null) {
            v.setHidden();
        }
        if ((v = this._view.getChildrenStatistic()) != null) {
            v.setHidden();
        }
    }

    protected void handleVisible() {
        MethodDetailsStatistic v = this._view.getMethodStatistic();
        if (v != null) {
            v.setVisible();
        }
        if ((v = this._view.getParentStatistic()) != null) {
            v.setVisible();
        }
        if ((v = this._view.getChildrenStatistic()) != null) {
            v.setVisible();
        }
    }
}

