/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.IPage;

public abstract class MultiLevelStatisticViewer
extends FilterTraceViewer
implements IContextViewer {
    protected Action _packageLevel;
    protected Action _classLevel;
    protected Action _openSource;
    protected Action _chooseColumns;
    protected Action _sortByColumn;
    protected ContextSelectionMenuListener _contextSelectionMenuListener;
    protected String _context;
    protected boolean _contextChanged = false;

    public abstract String getViewTitle();

    public abstract TraceViewerPage createPage(EObject var1);

    public void setCheckedLevels(MultiLevelStatisticPage page, int newLevel) {
        if (page.getView().getLevel() == newLevel) {
            page.getView().updateButtons();
        } else {
            page.getView().setLevel(newLevel);
            page.getView().updateButtons();
            page.getView().redrawTable();
        }
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof MultiLevelStatisticPage)) continue;
            ((MultiLevelStatisticPage)page).dispose();
        }
        this.setActionsNull();
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.fContextMenu = null;
        super.dispose();
    }

    protected void setActionsNull() {
        this._classLevel = null;
        this._packageLevel = null;
        this._openSource = null;
    }

    public void setFocus() {
        MultiLevelStatisticPage page = (MultiLevelStatisticPage)this.getCurrentPage();
        if (page != null) {
            page.setFocus();
        }
        ContextUpdaterHelper.setCurrentFocusContextLanguage(this.getSelectedContext());
    }

    protected void getLevelActions(Vector actions) {
        this._packageLevel = new Action("show.package.level"){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MultiLevelStatisticViewer.this.revertChecked(MultiLevelStatisticViewer.this._packageLevel);
                    return;
                }
                MultiLevelStatisticViewer.this.setCheckedLevels(page, 1);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._packageLevel.setEnabled(true);
        this._packageLevel.setChecked(true);
        this._classLevel = new Action("show.class.level"){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    MultiLevelStatisticViewer.this.revertChecked(MultiLevelStatisticViewer.this._classLevel);
                    return;
                }
                MultiLevelStatisticViewer.this.setCheckedLevels(page, 2);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._classLevel.setEnabled(true);
        actions.addElement(new Separator());
        actions.addElement(this._packageLevel);
        actions.addElement(this._classLevel);
    }

    protected void getActions(Vector actions) {
        String openSourceStr = TraceUIMessages._74;
        this._openSource = new Action(openSourceStr){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        this._openSource.setEnabled(false);
        String strChooseColumns = TraceUIMessages._56;
        this._chooseColumns = new Action(strChooseColumns){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                MultiLevelStatisticView view = page.getView();
                view.getChooseColumnsAction(view.getColumnDataList(), view.getColumnsPreferencesKey()).run();
            }
        };
        this._chooseColumns.setText(strChooseColumns);
        TracePluginImages.setImageDescriptors((IAction)this._chooseColumns, "lcl16", "choosecolumn_co.gif");
        this._chooseColumns.setDescription(strChooseColumns);
        this._chooseColumns.setToolTipText(strChooseColumns);
        this._chooseColumns.setEnabled(true);
        String strSortByColumn = TraceUIMessages._58;
        this._sortByColumn = new Action(strSortByColumn){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)MultiLevelStatisticViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                MultiLevelStatisticView view = page.getView();
                view.getSortByColumnAction().run();
            }
        };
        this._sortByColumn.setText(strSortByColumn);
        TracePluginImages.setImageDescriptors((IAction)this._sortByColumn, "lcl16", "alphab_sort_co.gif");
        this._sortByColumn.setDescription(strSortByColumn);
        this._sortByColumn.setToolTipText(strSortByColumn);
        this._sortByColumn.setEnabled(true);
        IMenuManager menum = this.getViewSite().getActionBars().getMenuManager();
        menum.add((IAction)this._chooseColumns);
        menum.add((IAction)this._sortByColumn);
        MenuManager submenu = new MenuManager(TraceUIMessages._222);
        submenu.addMenuListener((IMenuListener)this.getContextSelectionMenuListener());
        submenu.add((IAction)new Action(){});
        menum.add((IContributionItem)submenu);
        actions.addElement(this._openSource);
        actions.addElement(new Separator());
    }

    public void showPage(IPage page) {
        super.showPage(page);
        this.getContextSelectionMenuListener().setViewer(this);
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        Vector<Separator> actions = new Vector<Separator>();
        this.getLevelActions(actions);
        this.updateContext();
        actions.addElement(new Separator());
        this.getActions(actions);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        int i = 0;
        while (i < actions.size()) {
            if (actions.elementAt(i) instanceof IContributionItem) {
                tbm.add((IContributionItem)actions.elementAt(i));
            } else if (actions.elementAt(i) instanceof IAction) {
                tbm.add((IAction)actions.elementAt(i));
            }
            ++i;
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action getClassLevel() {
        return this._classLevel;
    }

    public Action getPackageLevel() {
        return this._packageLevel;
    }

    public Action openSource() {
        return this._openSource;
    }

    protected void revertChecked(Action action) {
        action.setChecked(!action.isChecked());
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"ProfilingAgentScope"};
        return scope;
    }

    public void filterUpdated() {
        TraceViewerPage page = (TraceViewerPage)this.getCurrentPage();
        if (page != null) {
            if (this.fPartVisible) {
                page.refreshPage();
            } else {
                this.fForceRefresh = true;
            }
        }
    }

    protected void setActionProperties(Action action, String context, String attributeId) {
        String strLevel = null;
        Image icon = null;
        IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider((String)context, (String)attributeId, (int)2);
        if (clfp != null) {
            strLevel = clfp.getDisplayStringFromElement((Object)attributeId, null, 2);
            icon = clfp.getDisplayImageByElement((Object)attributeId, null, 2);
        } else {
            strLevel = attributeId;
        }
        action.setText(strLevel);
        action.setImageDescriptor(ImageDescriptor.createFromImage(icon));
        action.setDescription(strLevel);
        action.setToolTipText(strLevel);
    }

    public ContextSelectionMenuListener getContextSelectionMenuListener() {
        if (this._contextSelectionMenuListener == null) {
            this._contextSelectionMenuListener = new ContextSelectionMenuListener();
        }
        return this._contextSelectionMenuListener;
    }

    public void updateContext() {
        this.setActionProperties(this._packageLevel, this._context, "show.package.level");
        this.setActionProperties(this._classLevel, this._context, "show.class.level");
        ContextUpdaterHelper.setCurrentFocusContextLanguage(this.getSelectedContext());
        this._contextChanged = false;
    }

    public Object[] getViewerControls() {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof MultiLevelStatisticPage) {
            return new Object[]{((MultiLevelStatisticPage)this.getCurrentPage()).getView().getTree()};
        }
        return null;
    }

    public Viewer[] getExportViewer() {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof MultiLevelStatisticPage) {
            return new Viewer[]{((MultiLevelStatisticPage)this.getCurrentPage()).getView().getTreeViewer()};
        }
        return null;
    }

    public String getSelectedContext() {
        return this._context;
    }

    public boolean contextChanged() {
        return this._contextChanged;
    }

    public void setSelectedContext(String context) {
        this.setSelectedContext(context, true);
    }

    public void setSelectedContext(String context, boolean refresh) {
        this._contextChanged = context == null ? this._context != null : !context.equals(this._context);
        this._context = context;
        if (this._contextChanged && refresh && this.getCurrentPage() != null) {
            ((TraceViewerPage)this.getCurrentPage()).refreshPage();
        }
    }
}

