/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.IPage;

public class PatternViewer
extends TraceViewer
implements IContextViewer {
    protected Action _reset;
    protected Action _showRawTime;
    private Action _zoomInAction;
    private Action _zoomOutAction;
    private Action _stdSelectAction;
    protected Action _showCompensatedTime;
    protected Action _percentMode;
    private boolean _stdSelect = true;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;
    protected ContextSelectionMenuListener _contextSelectionMenuListener;
    protected String _context;
    protected boolean _contextChanged;

    public TraceViewerPage createPage(EObject mofObject) {
        return new PatternPage(mofObject, this);
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof PatternPage)) continue;
            ((PatternPage)page).dispose();
        }
        this._showCompensatedTime = null;
        this._showRawTime = null;
        this._stdSelectAction = null;
        this._zoomInAction = null;
        this._zoomOutAction = null;
        this._percentMode = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        String compTime = TraceUIMessages._112;
        this._showCompensatedTime = new Action(compTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(compTime);
        this._showCompensatedTime.setDescription(compTime);
        this._showCompensatedTime.setToolTipText(compTime);
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(ref == 0);
        String rawTime = TraceUIMessages._111;
        this._showRawTime = new Action(rawTime){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(rawTime);
        this._showRawTime.setDescription(rawTime);
        this._showRawTime.setToolTipText(rawTime);
        ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(ref == 1);
        String strHome = TraceUIMessages._73;
        this._reset = new Action(strHome){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().update();
            }
        };
        this._reset.setText(strHome);
        TracePluginImages.setImageDescriptors((IAction)this._reset, "tool16", "home_nav.gif");
        this._reset.setDescription(strHome);
        this._reset.setToolTipText(strHome);
        String strStdSelect = TraceUIMessages._117;
        this._stdSelectAction = new Action(strStdSelect){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                PatternViewer.this._stdSelect = true;
                PatternViewer.this._zoomIn = !PatternViewer.this._stdSelect;
                PatternViewer.this._zoomOut = !PatternViewer.this._stdSelect;
                PatternViewer.this._stdSelectAction.setChecked(true);
                PatternViewer.this._zoomInAction.setChecked(false);
                PatternViewer.this._zoomOutAction.setChecked(false);
                if (page == null) {
                    return;
                }
                page.getView().zoomIn(PatternViewer.this._zoomIn);
                page.getView().zoomOut(PatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._stdSelectAction.setText(strStdSelect);
        TracePluginImages.setImageDescriptors((IAction)this._stdSelectAction, "lcl16", "select_zoomin.gif");
        this._stdSelectAction.setDescription(strStdSelect);
        this._stdSelectAction.setToolTipText(strStdSelect);
        String strZoomIn = TraceUIMessages._7;
        this._zoomInAction = new Action(strZoomIn){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                PatternViewer.this._zoomIn = this.isChecked();
                if (!PatternViewer.this._zoomIn) {
                    PatternViewer.this._stdSelect = true;
                } else {
                    PatternViewer.this._stdSelect = !PatternViewer.this._zoomIn;
                    PatternViewer.this._zoomOut = !PatternViewer.this._zoomIn;
                }
                if (PatternViewer.this._zoomIn) {
                    PatternViewer.this._stdSelectAction.setChecked(false);
                    PatternViewer.this._zoomOutAction.setChecked(false);
                } else {
                    PatternViewer.this._stdSelectAction.setChecked(true);
                }
                if (page == null) {
                    return;
                }
                page.getView().zoomIn(PatternViewer.this._zoomIn);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomInAction.setText(strZoomIn);
        TracePluginImages.setImageDescriptors((IAction)this._zoomInAction, "lcl16", "zoomin_nav.gif");
        this._zoomInAction.setDescription(strZoomIn);
        this._zoomInAction.setToolTipText(strZoomIn);
        String strZoomOut = TraceUIMessages._8;
        this._zoomOutAction = new Action(strZoomOut){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                PatternViewer.this._zoomOut = this.isChecked();
                if (!PatternViewer.this._zoomOut) {
                    PatternViewer.this._stdSelect = true;
                } else {
                    PatternViewer.this._stdSelect = !PatternViewer.this._zoomOut;
                    PatternViewer.this._zoomIn = !PatternViewer.this._zoomOut;
                }
                if (PatternViewer.this._zoomOut) {
                    PatternViewer.this._stdSelectAction.setChecked(false);
                    PatternViewer.this._zoomInAction.setChecked(false);
                } else {
                    PatternViewer.this._stdSelectAction.setChecked(true);
                }
                if (page == null) {
                    return;
                }
                page.getView().zoomOut(PatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomOutAction.setText(strZoomOut);
        TracePluginImages.setImageDescriptors((IAction)this._zoomOutAction, "lcl16", "zoomout_nav.gif");
        this._zoomOutAction.setDescription(strZoomOut);
        this._zoomOutAction.setToolTipText(strZoomOut);
        Action openColorDialog = new Action(TraceUIMessages._99){

            public void run() {
                GraphColorDialog dialog = new GraphColorDialog(PatternViewer.this.getViewSite().getShell(), TraceUIMessages._97, null);
                dialog.open();
            }
        };
        openColorDialog.setText(TraceUIMessages._99);
        TracePluginImages.setImageDescriptors((IAction)openColorDialog, "tool16", "opengraphcolor_co.gif");
        openColorDialog.setDescription(TraceUIMessages._99);
        openColorDialog.setToolTipText(TraceUIMessages._99);
        String strShowPercent = TraceUIMessages._13;
        this._percentMode = new Action(strShowPercent){

            public void run() {
                PatternPage page = (PatternPage)PatternViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                page.getView().getExecutionStatistic().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager submenu = new MenuManager(TraceUIMessages._113);
        menu.add((IContributionItem)submenu);
        submenu.add((IAction)this._showCompensatedTime);
        submenu.add((IAction)this._showRawTime);
        MenuManager submenu2 = new MenuManager(TraceUIMessages._222);
        submenu2.addMenuListener((IMenuListener)this.getContextSelectionMenuListener());
        submenu2.add((IAction)new Action(){});
        menu.add((IContributionItem)submenu2);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._stdSelectAction);
        tbm.add((IAction)this._zoomInAction);
        tbm.add((IAction)this._zoomOutAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._reset);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)openColorDialog);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._percentMode);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((PatternPage)this.getCurrentPage()).setFocus();
        }
    }

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            int idx = 0;
            while (idx < agents.size()) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent != null && !agent.eIsProxy() && agent.getType().equals("Profiler")) {
                    ++nbOfAgents;
                    a = agent;
                }
                ++idx;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public String getViewTitle() {
        return TraceUIPlugin.getString("4");
    }

    public void initializeActionBar() {
        this._stdSelectAction.setChecked(true);
        this._zoomInAction.setChecked(false);
        this._zoomOutAction.setChecked(false);
    }

    public ContextSelectionMenuListener getContextSelectionMenuListener() {
        if (this._contextSelectionMenuListener == null) {
            this._contextSelectionMenuListener = new ContextSelectionMenuListener();
        }
        return this._contextSelectionMenuListener;
    }

    public void showPage(IPage page) {
        super.showPage(page);
        this.getContextSelectionMenuListener().setViewer(this);
    }

    public void updateContext() {
        ContextUpdaterHelper.setCurrentFocusContextLanguage(this.getSelectedContext());
        this._contextChanged = false;
    }

    public String getSelectedContext() {
        return this._context;
    }

    public boolean contextChanged() {
        return this._contextChanged;
    }

    public void setSelectedContext(String context) {
        this.setSelectedContext(context, true);
    }

    public void setSelectedContext(String context, boolean refresh) {
        this._contextChanged = context == null ? this._context != null : !context.equals(this._context);
        this._context = context;
        if (this._contextChanged && refresh && this.getCurrentPage() != null) {
            ((TraceViewerPage)this.getCurrentPage()).refreshPage();
        }
    }

    public Viewer[] getExportViewer() {
        return null;
    }

    public Object[] getViewerControls() {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof PatternPage) {
            return new Object[]{((PatternPage)this.getCurrentPage()).getView().getCanvas(), ((PatternPage)this.getCurrentPage()).getView().getExecutionStatistic().getTree()};
        }
        return null;
    }

    public String getDefaultPageMessage() {
        return TraceMessages._21;
    }
}

