/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.DynamicFilter;
import org.eclipse.hyades.ui.util.ICommonUIHelper;

public class ThresholdFilter
extends DynamicFilter {
    private static String DEFAULT_NEGLIBLE_BASE_TIME = "0.001";
    private String threshold = DEFAULT_NEGLIBLE_BASE_TIME;

    public ThresholdFilter() {
        super(String.valueOf(UIPlugin.getPluginId()) + "_THRESHOLD_CHECKED_", String.valueOf(UIPlugin.getPluginId()) + "_THRESHOLD_UNCHECKED_");
    }

    public SimpleSearchQuery update(SimpleSearchQuery filter, EObject object) {
        if (filter == null || filter.getWhereExpression() == null) {
            return filter;
        }
        double totalTime = PerftraceUtil.getTotalCumulativeTime((EObject)object);
        this.threshold = Double.toString(0.001 * totalTime);
        SimpleSearchQuery result = this.duplicateQuery(filter, this.createActiveExpression(), this.getEnabledKey());
        return result;
    }

    public WhereExpression createActiveExpression() {
        LogicalExpression result = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        result.setOperator(LogicalOperators.AND_LITERAL);
        result.getArguments().add((Object)ICommonUIHelper.INSTANCE.createBinaryExpression((EStructuralFeature)TracePackageImpl.init().getTRCMethod_BaseTime(), RelationalOperators.get((int)4), this.threshold, true));
        result.setName(this.getEnabledKey());
        return result;
    }

    public WhereExpression createDisabledExpression() {
        LogicalExpression result = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        result.setOperator(LogicalOperators.AND_LITERAL);
        result.getArguments().add((Object)ICommonUIHelper.INSTANCE.createBinaryExpression((EStructuralFeature)TracePackageImpl.init().getTRCPackage_BaseTime(), RelationalOperators.NEQ_LITERAL, "-1", true));
        result.setName(this.getDisabledKey());
        return result;
    }

    private SimpleSearchQuery duplicateQuery(SimpleSearchQuery filter, WhereExpression update, String updatedName) {
        SimpleSearchQuery result = (SimpleSearchQuery)EcoreUtil.copy((EObject)filter);
        if (updatedName.equals(filter.getWhereExpression().getName())) {
            filter.setWhereExpression(update);
        } else {
            this.updateNamedWhereExpression(filter.getWhereExpression(), update, updatedName);
        }
        return result;
    }

    private boolean updateNamedWhereExpression(WhereExpression source, WhereExpression update, String updatedName) {
        if (source instanceof BinaryExpression) {
            return false;
        }
        LogicalExpression le = (LogicalExpression)source;
        EList arguments = le.getArguments();
        int i = 0;
        while (i < arguments.size()) {
            WhereExpression element = (WhereExpression)arguments.get(i);
            if (updatedName.equals(element.getName())) {
                arguments.set(i, (Object)update);
                return true;
            }
            if (this.updateNamedWhereExpression(element, update, updatedName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

