/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.actions.internal.OpenMethodDetailsAction;
import org.eclipse.hyades.trace.views.actions.internal.OpenMethodInvocationAction;
import org.eclipse.hyades.trace.views.adapter.internal.AggregatedExecutionStatisticsTab;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.ContextInfoContainer;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AggregatedAvgTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AggregatedCallsColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AggregatedCumulativeTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AggregatedMaxTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AggregatedMinTimeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PerThreadPercentColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ThreadMethodInvocationNameColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class AggregatedExecutionStatistic
extends MultiLevelStatisticView {
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    protected ContextInfoContainer _contextInfo;
    protected AggregatedExecutionStatisticsTab _tabItem;
    protected ColumnLabelAdapter _threadNameCol;
    protected ColumnLabelAdapter _cumulativeTimeCol;
    protected ColumnLabelAdapter _minTimeCol;
    protected ColumnLabelAdapter _avgTimeCol;
    protected ColumnLabelAdapter _maxTimeCol;
    protected ColumnLabelAdapter _callsCol;
    protected ColumnLabelAdapter _percentCol;
    protected Object lastSelectedObject;

    protected static Listener getBarGraphPainter(final Tree tree, final int columnNumber) {
        return new Listener(){
            private ColumnLabelAdapter columnLabel = new PerThreadPercentColumnLabel();

            public void handleEvent(Event event) {
                TreeColumn column;
                StatisticTableColumnInfo info;
                int pos;
                event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                if ((event.detail & 2) != 0) {
                    GC gc = event.gc;
                    gc.setAdvanced(true);
                    if (gc.getAdvanced()) {
                        int columnCount = tree.getColumnCount();
                        if (event.index == columnCount - 1 || columnCount == 0) {
                            Rectangle area = tree.getClientArea();
                            int width = area.x + area.width - event.x;
                            if (width > 0) {
                                Region region = new Region();
                                gc.getClipping(region);
                                region.add(event.x, event.y, width, event.height);
                                gc.setClipping(region);
                                region.dispose();
                            }
                        }
                        Color foreground = gc.getForeground();
                        Color background = gc.getBackground();
                        gc.setForeground(event.display.getSystemColor(26));
                        gc.fillRectangle(0, event.y, 100000, event.height);
                        gc.setForeground(foreground);
                        gc.setBackground(background);
                        event.detail &= 0xFFFFFFFD;
                    }
                }
                if ((pos = (info = StatisticTableColumnInfo.getStatisticTableColumnInfo(column = tree.getColumn(event.index))).getColumnData().getInitalPos()) == columnNumber) {
                    TreeItem item = (TreeItem)event.item;
                    Double value = this.columnLabel.comparableDoubleValue(item.getData(), null);
                    int barWidth = value != null ? (int)Math.round(value * (double)column.getWidth()) : 0;
                    GC gc = event.gc;
                    Display display = event.display;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    Color sysBack = display.getSystemColor(3);
                    Color sysFore = display.getSystemColor(7);
                    Color fore = new Color((Device)display, (sysBack.getRed() + 3 * sysFore.getRed()) / 4, (sysBack.getGreen() + 3 * sysFore.getGreen()) / 4, (sysBack.getBlue() + 3 * sysFore.getBlue()) / 4);
                    Color back = new Color((Device)display, (3 * sysBack.getRed() + sysFore.getRed()) / 4, (3 * sysBack.getGreen() + sysFore.getGreen()) / 4, (3 * sysBack.getBlue() + sysFore.getBlue()) / 4);
                    gc.setAdvanced(true);
                    if (gc.getAdvanced()) {
                        gc.setAlpha(220);
                    }
                    gc.setBackground(back);
                    gc.setForeground(fore);
                    gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, false);
                    gc.setForeground(foreground);
                    gc.setBackground(background);
                    back.dispose();
                    fore.dispose();
                }
            }
        };
    }

    protected Composite createTree(Composite parent, int options) {
        Tree tree = this._toolkit.createTree(parent, options);
        tree.addListener(40, AggregatedExecutionStatistic.getBarGraphPainter(tree, 1));
        return tree;
    }

    public AggregatedExecutionStatistic(Composite parent, AggregatedExecutionStatisticsTab tabItem) {
        super(true, parent, tabItem.getPage());
        this._tabItem = tabItem;
        this._viewerFilter = new ExecutionStatisticFilter();
        this.createColumnsLabelProviders();
    }

    protected static boolean isAccessMethod(TRCMethodInvocation inv) {
        Pattern p = Pattern.compile("access\\$(\\p{Digit})?");
        return p.matcher(inv.getMethod().getName()).matches();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".exef0008";
    }

    public void createColumnsLabelProviders() {
        this._threadNameCol = new ThreadMethodInvocationNameColumnLabel();
        this._percentCol = new PerThreadPercentColumnLabel();
        this._cumulativeTimeCol = new AggregatedCumulativeTimeColumnLabel();
        this._minTimeCol = new AggregatedMinTimeColumnLabel();
        this._maxTimeCol = new AggregatedMaxTimeColumnLabel();
        this._avgTimeCol = new AggregatedAvgTimeColumnLabel();
        this._callsCol = new AggregatedCallsColumnLabel();
    }

    public String getColumnsPreferencesKey() {
        return "AggrExec1_";
    }

    public String getDefaultColumnsTemplate() {
        String executionColumn = "thread.name:0:" + String.valueOf(7) + ":left:200," + "method.percent.thread" + ":1:" + String.valueOf(1) + ":right:120," + "method.cumul.time" + ":2:" + String.valueOf(1) + ":right:150," + "method.min.time" + ":3:" + String.valueOf(1) + ":right:80," + "method.avg.time" + ":4:" + String.valueOf(1) + ":right:80," + "method.max.time" + ":5:" + String.valueOf(1) + ":right:80," + "method.calls" + ":6:" + String.valueOf(1) + ":right:50";
        return executionColumn;
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new AggregatedExecutionTreeViewer(tree);
    }

    public void expandToSelectedElement(boolean methodInvOnly) {
        Object selection;
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0 && (selection = model.getFirstElement()) != null) {
            if (methodInvOnly && !(selection instanceof TRCMethodInvocation)) {
                return;
            }
            this.select(selection);
            if (selection instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)selection)));
            }
        }
    }

    private void select(Object selection) {
        Tree tree = (Tree)this.getTreeViewer().getControl();
        ArrayList selectedItems = new ArrayList();
        if (selection instanceof TRCMethodInvocation) {
            this.searchMethodInvocation(tree, this.getItemsRoot(tree), (TRCMethodInvocation)selection, selectedItems);
        } else if (selection instanceof TRCMethod) {
            this.searchMethod(tree, this.getItemsRoot(tree), (TRCMethod)selection, selectedItems);
        }
        if (selectedItems.isEmpty()) {
            tree.deselectAll();
            this.lastSelectedObject = null;
            return;
        }
        TreeItem[] treeSelection = new TreeItem[]{(TreeItem)selectedItems.get(0)};
        if (treeSelection[0] != null) {
            this.lastSelectedObject = treeSelection[0].getData();
            tree.setSelection(treeSelection);
        } else {
            this.lastSelectedObject = null;
            tree.deselectAll();
        }
    }

    private void searchMethod(Tree tree, TreeItem item, TRCMethod method, ArrayList selectedItems) {
        Object[] invocations = method.getInvocations().toArray();
        int i = 0;
        while (i < invocations.length) {
            this.searchMethodInvocation(tree, item, (TRCMethodInvocation)invocations[i], selectedItems);
            ++i;
        }
    }

    protected void searchMethodUsages(TreeItem[] items, TRCMethod method, ArrayList selectedItems) {
        AggregatedExecutionTreeViewer treeViewr = (AggregatedExecutionTreeViewer)this.getTreeViewer();
        int j = 0;
        while (j < items.length) {
            TreeItem item = items[j];
            if (item != null && !item.isDisposed()) {
                Object itemData = this.getItemModelData(item);
                if (itemData instanceof TRCThread) {
                    treeViewr.expandItem(item);
                    this.searchMethodUsages(item.getItems(), method, selectedItems);
                    break;
                }
                if (itemData instanceof AggregatedInvocation) {
                    AggregatedInvocation aggrInv = (AggregatedInvocation)itemData;
                    if (aggrInv.getMethod() == method) {
                        selectedItems.add(item);
                    }
                    treeViewr.expandItem(item);
                    this.searchMethodUsages(item.getItems(), method, selectedItems);
                }
            }
            ++j;
        }
    }

    private void searchMethodInvocation(Tree tree, TreeItem item, TRCMethodInvocation inv, ArrayList selectedItems) {
        TreeItem[] threadItems = item != null ? item.getItems() : tree.getItems();
        TreeItem threadItem = this.searchItem(threadItems, inv.getThread());
        if (threadItem != null) {
            TRCMethodInvocation[] callStack = this.getFilteredCallStack(inv);
            AggregatedExecutionTreeViewer treeViewr = (AggregatedExecutionTreeViewer)this.getTreeViewer();
            treeViewr.expandItem(threadItem);
            TreeItem area = threadItem;
            int level = callStack.length - 1;
            while (level >= 0) {
                TreeItem aggrInvItem = this.searchItem(area.getItems(), callStack[level]);
                if (aggrInvItem == null) break;
                treeViewr.expandItem(aggrInvItem);
                area = aggrInvItem;
                --level;
            }
            if (!selectedItems.contains(area)) {
                selectedItems.add(area);
            }
            return;
        }
        if (!selectedItems.contains(item)) {
            selectedItems.add(item);
        }
    }

    private TRCMethodInvocation[] getFilteredCallStack(TRCMethodInvocation invocation) {
        ArrayList<TRCMethodInvocation> callStack = new ArrayList<TRCMethodInvocation>();
        TRCMethodInvocation inv = invocation;
        while (inv != null) {
            if (!AggregatedExecutionStatistic.isAccessMethod(inv)) {
                callStack.add(inv);
            }
            inv = inv.getInvokedBy();
        }
        TRCMethodInvocation[] stack = new TRCMethodInvocation[callStack.size()];
        int i = 0;
        while (i < callStack.size()) {
            stack[i] = (TRCMethodInvocation)callStack.get(i);
            ++i;
        }
        return stack;
    }

    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
        this._tabItem.updateCallStacks();
    }

    protected TreeItem getItemsRoot(Tree tree) {
        return null;
    }

    protected TreeItem searchItem(TreeItem[] items, Object obj) {
        int j = 0;
        while (j < items.length) {
            Object itemData;
            TreeItem item = items[j];
            if (item != null && !item.isDisposed() && (itemData = this.getItemModelData(item)) instanceof AggregatedInvocation) {
                AggregatedInvocation aggrInv = (AggregatedInvocation)itemData;
                if (obj instanceof TRCMethodInvocation && aggrInv.getMethod().equals(((TRCMethodInvocation)obj).getMethod())) {
                    return item;
                }
            }
            ++j;
        }
        return null;
    }

    protected Object getItemModelData(TreeItem item) {
        return item.getData();
    }

    public void menuAboutToShow(IMenuManager menu) {
        Object obj;
        AggregatedExecutionTreeViewer treeViewer = (AggregatedExecutionTreeViewer)this.getTreeViewer();
        ISelection sel = treeViewer.getSelection();
        if (sel != null && (obj = ((IStructuredSelection)sel).getFirstElement()) != null && obj instanceof AggregatedInvocation) {
            menu.add((IContributionItem)this.fSeparator);
            OpenMethodInvocationAction act = new OpenMethodInvocationAction(TraceUIPlugin.getString("29"));
            TracePluginImages.setImageDescriptors((IAction)act, "tool16", "meth_invc_co.gif");
            menu.add((IAction)act);
            OpenMethodDetailsAction act1 = new OpenMethodDetailsAction(TraceUIPlugin.getString("28"));
            TracePluginImages.setImageDescriptors((IAction)act1, "tool16", "methdetails_view.gif");
            menu.add((IAction)act1);
        }
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
        menu.add((IAction)((ExecutionStatisticViewer2)this._page.getTraceViewer()).openSource());
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
    }

    protected void updateDetailsPane() {
        int selCount = this.getTree().getSelectionCount();
        if (selCount != 1) {
            return;
        }
        TreeItem item = this.getTree().getSelection()[0];
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TreeItem) {
            itemData = ((TreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ExecutionStatisticSorter();
    }

    protected void firstTimeUpdate() {
        super.firstTimeUpdate();
        this._viewerSorter.setSortedColumn(-1, this.getTree().getColumn(this.updateTableGetColumnNumber()));
        this.redrawTable();
    }

    protected int updateTableGetColumnNumber() {
        return 1;
    }

    public void dispose() {
        super.dispose();
    }

    public IContentProvider getContentProvider() {
        return new ExecutionStatisticContentProvider();
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new ExecutionStatisticCellLabelProvider(colData);
    }

    public LabelProvider getTableLabelProvider() {
        return new ExecutionStatisticLabelProvider(this);
    }

    public void notifyViewSelectionChanged(Object source, Object selection) {
        if (selection instanceof AggregatedInvocation) {
            List invocations = ((AggregatedInvocation)selection).getAllInvocations();
            for (AggregatedInvocation.Item item : invocations) {
                UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add((Object)item.getInvocation());
            }
        } else {
            UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(selection);
        }
        this.lastSelectedObject = selection;
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource(source);
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        } else {
            Object sel;
            ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
            if (model.size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllThreads((EObject)this._page.getMOFObject()).length <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.aggrexecution";
    }

    public int getDrawMode() {
        return this._drawMode;
    }

    public void setDrawMode(int mode) {
        this._drawMode = mode;
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCumulativeTime = PerftraceUtil.getTotalCumulativeTime((EObject)this._page.getMOFObject());
            if (this._totalCumulativeTime == 0.0) {
                this._totalCumulativeTime = 1.0;
            }
        }
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._cumulativeTimeCol) {
            return ContextUpdaterHelper.updateCumulTime(col, isDeltaColumn, this.isShowPercent(), this.getDrawMode(), this._totalCumulativeTime);
        }
        if (col == this._callsCol) {
            return ContextUpdaterHelper.updateCalls(col, isDeltaColumn, this.isShowPercent(), true, this._totalCalls);
        }
        return super.getColumnDisplayInfo(col, isDeltaColumn);
    }

    protected Composite createControl(Composite parent, ArrayList cols) {
        final Composite vc = super.createControl(parent, cols);
        this._contextInfo = new ContextInfoContainer();
        this._contextInfo.setViewer((IContextViewer)this._page.getTraceViewer());
        this._contextInfo.createControl(vc);
        this._contextInfo.addContextInfoContainerListener(new IContextInfoContainerListener(){

            public void visibilityChanged(boolean isVisible) {
                vc.layout(true, true);
            }
        });
        return vc;
    }

    protected void updateStatusContext(IContextLanguage language) {
        if (this._contextInfo != null) {
            this._contextInfo.updateStatusContext(language);
        }
    }

    public void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        this.resetColumns();
        if (this._page instanceof ExecutionStatisticPage2 && this._contextInfo != null) {
            this._contextInfo.setMOFObject(this._page.getMOFObject());
        }
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
    }

    protected void resetColumns() {
        this._threadNameCol.resetMap();
        this._cumulativeTimeCol.resetMap();
        this._callsCol.resetMap();
        this._avgTimeCol.resetMap();
        this._minTimeCol.resetMap();
        this._maxTimeCol.resetMap();
        this._percentCol.resetMap();
    }

    protected StructuredViewer createTreeViewer(Composite tree) {
        TreeViewer tv = this.getTreeViewer((Tree)tree);
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object node;
                TreeViewer tv;
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty() && (tv = (TreeViewer)AggregatedExecutionStatistic.this.getTreeViewer()).isExpandable(node = ((IStructuredSelection)selection).getFirstElement())) {
                    tv.setExpandedState(node, !tv.getExpandedState(node));
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tv);
        return tv;
    }

    public Object getLastSelectedObject() {
        return this.lastSelectedObject;
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return null;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return null;
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return this._viewerFilter;
    }

    public int getLevel() {
        return 0;
    }

    public boolean isEmptyUpdate() {
        return false;
    }

    public void setLevel(int i) {
    }

    class AggregatedExecutionTreeViewer
    extends MultiLevelStatisticView.MultiLevelStatisticTreeViewer {
        public AggregatedExecutionTreeViewer(Composite parent) {
            super((MultiLevelStatisticView)AggregatedExecutionStatistic.this, parent);
        }

        public AggregatedExecutionTreeViewer(Tree tree) {
            super((MultiLevelStatisticView)AggregatedExecutionStatistic.this, tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class ExecutionStatisticCellLabelProvider
    extends StatisticCellLabelProvider {
        public ExecutionStatisticCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((ExecutionStatisticLabelProvider)AggregatedExecutionStatistic.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((ExecutionStatisticLabelProvider)AggregatedExecutionStatistic.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class ExecutionStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof AggregatedInvocation) {
                AggregatedInvocation parent = ((AggregatedInvocation)element).getParent();
                if (parent != null) {
                    return parent;
                }
                return ((AggregatedInvocation)element).getThread();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PerftraceUtil.getAllThreads((EObject)AggregatedExecutionStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object element) {
            if (element instanceof TRCThread) {
                return AggregatedInvocation.getThreadCalls((TRCThread)element).toArray();
            }
            if (element instanceof AggregatedInvocation) {
                return ((AggregatedInvocation)element).getNestedCalls().toArray();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TRCThread) {
                return ((TRCThread)element).getInitialInvocations().size() > 0;
            }
            if (element instanceof AggregatedInvocation) {
                return ((AggregatedInvocation)element).getNestedCalls().size() > 0;
            }
            return false;
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(AggregatedExecutionStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCThread)) {
                return true;
            }
            String compareText = "";
            compareText = ((TRCThread)element).getName();
            if (compareText.equals("")) {
                compareText = TraceUIMessages._87;
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class ExecutionStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ExecutionStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (pos == 0) {
                return AggregatedExecutionStatistic.this.getElementColumnImage(obj, AggregatedExecutionStatistic.this._threadNameCol, false);
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            switch (pos) {
                case 0: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._threadNameCol, false);
                }
                case 1: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._percentCol, false);
                }
                case 2: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._cumulativeTimeCol, false);
                }
                case 3: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._minTimeCol, false);
                }
                case 4: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._avgTimeCol, false);
                }
                case 5: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._maxTimeCol, false);
                }
                case 6: {
                    return AggregatedExecutionStatistic.this.getElementColumnText(obj, AggregatedExecutionStatistic.this._callsCol, false);
                }
            }
            return "";
        }
    }

    public class ExecutionStatisticSorter
    extends StatisticView.StatisticSorter {
        public ExecutionStatisticSorter() {
            super(AggregatedExecutionStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCThread && e2 instanceof TRCThread) {
                if (this._pos == 0) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._threadNameCol, false);
                }
                if (this._pos == 1) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._cumulativeTimeCol, false);
                }
                if (this._pos == 2) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._cumulativeTimeCol, false);
                }
            }
            if (e1 instanceof AggregatedInvocation && e2 instanceof AggregatedInvocation) {
                if (this._pos == 0) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._threadNameCol, false);
                }
                if (this._pos == 1) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._percentCol, false);
                }
                if (this._pos == 2) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._cumulativeTimeCol, false);
                }
                if (this._pos == 3) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._minTimeCol, false);
                }
                if (this._pos == 4) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._avgTimeCol, false);
                }
                if (this._pos == 5) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._maxTimeCol, false);
                }
                if (this._pos == 6) {
                    return this._sortSequence * AggregatedExecutionStatistic.this.compareElements(e1, e2, AggregatedExecutionStatistic.this._callsCol, false);
                }
            }
            return 0;
        }
    }
}

