/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.CoverageStatisticPage;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticViewer;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticMethodView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CallsColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ClassNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodsHitColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodsMissedColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodsPercentHitColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PackageNameColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.CoverageFolder;
import org.eclipse.hyades.trace.views.util.internal.CoverageUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CoverageStatisticView
extends MultiLevelStatisticMethodView {
    public static final String CALLS_NOT_COMPUTED = "COVERAGE_STATISTICS.CALLS_NOT_COMPUTED";
    private static final int[] _numberOfColumns = new int[]{7, 8, 9};
    private static int _level = 1;
    private boolean _isCallsMeaningfull;
    protected ColumnLabelAdapter _packageNameCol;
    protected ColumnLabelAdapter _classNameCol;
    protected ColumnLabelAdapter _methodNameCol;
    protected ColumnLabelAdapter _callsCol;
    protected ColumnLabelAdapter _methodsMissedCol;
    protected ColumnLabelAdapter _methodsHitCol;
    protected ColumnLabelAdapter _methodsPercentHitCol;

    public CoverageStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this.createColumnsLabelProviders();
        this._isCallsMeaningfull = true;
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".ccsv0000";
    }

    public void createColumnsLabelProviders() {
        this._packageNameCol = new PackageNameColumnLabel();
        this._classNameCol = new ClassNameColumnLabel();
        this._methodNameCol = new MethodNameColumnLabel();
        this._callsCol = new CallsColumnLabel();
        this._methodsMissedCol = new MethodsMissedColumnLabel();
        this._methodsHitCol = new MethodsHitColumnLabel();
        this._methodsPercentHitCol = new MethodsPercentHitColumnLabel();
    }

    public boolean isEmptyUpdate() {
        return !CoverageUtil.isCoverageSupport(this._page.getMOFObject());
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return String.valueOf(TraceUIMessages._131) + ":0:" + String.valueOf(7) + ":221," + "class.name" + ":1:0" + ":100," + "package.name" + ":2:0" + ":100," + "package.calls" + ":3:" + String.valueOf(1) + ":right:120," + "cov.methods.missed" + ":4:" + String.valueOf(1) + ":right:120," + "cov.methods.hit" + ":5:" + String.valueOf(1) + ":right:120," + "cov.perc.methods.hit" + ":6:" + String.valueOf(1) + ":right:120";
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return String.valueOf(TraceUIMessages._131) + ":0:" + String.valueOf(7) + ":200," + "class.name" + ":1:0" + ":100," + "package.name" + ":2:" + String.valueOf(1) + ":150," + "class.calls" + ":3:" + String.valueOf(1) + ":right:60," + "cov.methods.missed" + ":4:" + String.valueOf(1) + ":right:100," + "cov.methods.hit" + ":5:" + String.valueOf(1) + ":right:100," + "cov.perc.methods.hit" + ":6:" + String.valueOf(1) + ":right:100";
    }

    protected String getDefaultColumnsTemplateMethodLevel() {
        return String.valueOf(TraceUIMessages._131) + ":0:" + String.valueOf(7) + ":200," + "class.name" + ":1:" + String.valueOf(1) + ":100," + "package.name" + ":2:" + String.valueOf(1) + ":100," + "method.calls" + ":3:" + String.valueOf(1) + ":right:45," + "cov.methods.missed" + ":4:" + String.valueOf(1) + ":right:90," + "cov.methods.hit" + ":5:" + String.valueOf(1) + ":right:90," + "cov.perc.methods.hit" + ":6:" + String.valueOf(1) + ":right:90";
    }

    public String getDefaultColumnsTemplate() {
        String columns = super.getDefaultColumnsTemplate();
        if (columns == null) {
            columns = "";
        }
        return String.valueOf(columns) + this.getColumnsTemplateExtensions(_numberOfColumns[_level - 1], "org.eclipse.hyades.trace.views.adapter.internal.CoverageStatisticViewer", true);
    }

    public String getColumnsPreferencesKey() {
        this.setLevel(this.getLevel());
        if (this.getLevel() == 1) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "CovStatsPack60";
        }
        if (this.getLevel() == 2) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "CovStatsClass60";
        }
        if (this.getLevel() == 3) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "CovStatsMethod60";
        }
        return "";
    }

    private boolean isCallsMeaningful() {
        CoverageAnalysis covAnalysis = ((CoverageStatisticPage)this._page).getCovAnalysis();
        CoverageFolder root = covAnalysis.getRoot();
        if (root == null) {
            return true;
        }
        ArrayList traceObjects = root.getTraceObjects();
        for (Object o : traceObjects) {
            TRCMonitor monitor;
            TRCNode node;
            TRCAgentProxy agentProxy;
            if (!(o instanceof TRCAgentProxy ? !this.isCallsMeaningful(agentProxy = (TRCAgentProxy)o) : (o instanceof TRCNode ? !this.isCallsMeaningful(node = (TRCNode)o) : o instanceof TRCMonitor && !this.isCallsMeaningful(monitor = (TRCMonitor)o)))) continue;
            return false;
        }
        return true;
    }

    private boolean isCallsMeaningful(TRCMonitor monitor) {
        EList nodes = monitor.getNodes();
        for (TRCNode node : nodes) {
            if (this.isCallsMeaningful(node)) continue;
            return false;
        }
        return true;
    }

    private boolean isCallsMeaningful(TRCNode node) {
        EList processProxies = node.getProcessProxies();
        for (TRCProcessProxy processProxy : processProxies) {
            EList agentProxies = processProxy.getAgentProxies();
            for (TRCAgentProxy agentProxy : agentProxies) {
                if (this.isCallsMeaningful(agentProxy)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCallsMeaningful(TRCAgentProxy agentProxy) {
        EList configs = agentProxy.getConfigurations();
        for (TRCConfiguration config : configs) {
            EList options = config.getOptions();
            for (TRCOption option : options) {
                if (!CALLS_NOT_COMPUTED.equals(option.getKey()) || !option.getValue().equalsIgnoreCase("true")) continue;
                return false;
            }
        }
        return true;
    }

    public IContentProvider getContentProvider() {
        return new CoverageStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new CoverageStatisticLabelProvider((StatisticView)this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new CoverageStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new CoverageStatisticFilter();
    }

    protected String getViewTypeStr() {
        return "viewoption.coverage";
    }

    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            EObject obj = ((Coverage)sel).getTraceObj();
            this.notifyViewSelectionChanged(this, obj);
        }
    }

    protected void expandFirstElement() {
        Tree tree = ((TreeViewer)this.getTreeViewer()).getTree();
        TreeItem[] items = tree.getItems();
        if (items.length != 0) {
            ((MultiLevelStatisticView.MultiLevelStatisticTreeViewer)this.getTreeViewer()).expandItem(items[0]);
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        super.menuAboutToShow(menu);
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)((MultiLevelStatisticViewer)this.getTraceViewerPage().getTraceViewer()).openSource());
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    protected Object getItemModelData(TreeItem item) {
        if (item.getData() != null) {
            return ((Coverage)item.getData()).getTraceObj();
        }
        return null;
    }

    protected TreeItem getItemsRoot(Tree tree) {
        if (tree.getItemCount() > 0) {
            return tree.getItems()[0];
        }
        return null;
    }

    protected void showPercentUpdate() {
        super.showPercentUpdate();
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._packageNameCol) {
            return ContextUpdaterHelper.updatePackageName(col, this._page.getMOFObject());
        }
        if (col == this._callsCol) {
            return ContextUpdaterHelper.updateCalls(col, false, false, this._isCallsMeaningfull, this._totalCalls);
        }
        return super.getColumnDisplayInfo(col, false);
    }

    public void update() {
        this._packageNameCol.resetMap();
        this._classNameCol.resetMap();
        this._methodNameCol.resetMap();
        this._callsCol.resetMap();
        this._methodsMissedCol.resetMap();
        this._methodsHitCol.resetMap();
        this._methodsPercentHitCol.resetMap();
        super.update();
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new CoverageStatisticCellLabelProvider(colData);
    }

    public class CoverageStatisticCellLabelProvider
    extends StatisticCellLabelProvider {
        public CoverageStatisticCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((CoverageStatisticLabelProvider)CoverageStatisticView.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((CoverageStatisticLabelProvider)CoverageStatisticView.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class CoverageStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        public CoverageStatisticContentProvider() {
            super(CoverageStatisticView.this);
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            CoverageStatisticView.this._isCallsMeaningfull = CoverageStatisticView.this.isCallsMeaningful();
        }

        public Object[] getChildren(Object element) {
            ArrayList childs = ((Coverage)element).getChilds();
            if (childs == null) {
                return null;
            }
            return childs.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Coverage> tmpList = new ArrayList<Coverage>();
            tmpList.clear();
            CoverageAnalysis covAnalysis = ((CoverageStatisticPage)CoverageStatisticView.this._page).getCovAnalysis();
            if (covAnalysis.getRoot() != null) {
                switch (CoverageStatisticView.this.getLevel()) {
                    case 1: {
                        tmpList.add(covAnalysis.getRoot());
                        return tmpList.toArray();
                    }
                    case 2: {
                        tmpList.add(covAnalysis.getClassLevel());
                        return tmpList.toArray();
                    }
                    case 3: {
                        tmpList.add(covAnalysis.getMethodLevel());
                        return tmpList.toArray();
                    }
                }
                return tmpList.toArray();
            }
            return tmpList.toArray();
        }
    }

    public class CoverageStatisticFilter
    extends StatisticView.StatisticFilter {
        public CoverageStatisticFilter() {
            super(CoverageStatisticView.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            Coverage cov = (Coverage)element;
            boolean flag = true;
            String compareText = "";
            switch (CoverageStatisticView.this.getLevel()) {
                case 1: {
                    if (!(cov.getTraceObj() instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)cov.getTraceObj()).getName().length() == 0) {
                        compareText = TraceUIMessages._87;
                        break;
                    }
                    compareText = ((TRCPackage)cov.getTraceObj()).getName();
                    break;
                }
                case 2: {
                    if (!(cov.getTraceObj() instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)cov.getTraceObj()).getName();
                    break;
                }
                case 3: {
                    if (!(cov.getTraceObj() instanceof TRCMethod)) {
                        return true;
                    }
                    compareText = ((TRCMethod)cov.getTraceObj()).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class CoverageStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public CoverageStatisticLabelProvider(StatisticView viewer) {
            super(CoverageStatisticView.this, viewer);
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            Coverage cov = (Coverage)obj;
            switch (pos) {
                case 0: {
                    if (cov.getTraceObj() instanceof TRCPackage) {
                        return CoverageStatisticView.this.getElementColumnImage(cov, CoverageStatisticView.this._packageNameCol, false);
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return CoverageStatisticView.this.getElementColumnImage(cov, CoverageStatisticView.this._classNameCol, false);
                    }
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return CoverageStatisticView.this.getElementColumnImage(cov, CoverageStatisticView.this._methodNameCol, false);
                    }
                }
                case 1: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return CoverageStatisticView.this.getElementColumnImage(cov, CoverageStatisticView.this._classNameCol, false);
                    }
                    return null;
                }
                case 2: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return CoverageStatisticView.this.getElementColumnImage(cov, CoverageStatisticView.this._packageNameCol, false);
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return CoverageStatisticView.this.getElementColumnImage(cov, CoverageStatisticView.this._packageNameCol, false);
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            Coverage cov = (Coverage)obj;
            switch (pos) {
                case 0: {
                    if (cov.getTraceObj() instanceof TRCPackage) {
                        return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._packageNameCol, false);
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._classNameCol, false);
                    }
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._methodNameCol, false);
                    }
                    return TraceUIMessages._128;
                }
                case 1: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._classNameCol, false);
                    }
                    return "";
                }
                case 2: {
                    if (cov.getTraceObj() instanceof TRCMethod) {
                        return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._packageNameCol, false);
                    }
                    if (cov.getTraceObj() instanceof TRCClass) {
                        return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._packageNameCol, false);
                    }
                    return "";
                }
                case 3: {
                    return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._callsCol, false);
                }
                case 4: {
                    return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._methodsMissedCol, false);
                }
                case 5: {
                    return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._methodsHitCol, false);
                }
                case 6: {
                    return CoverageStatisticView.this.getElementColumnText(cov, CoverageStatisticView.this._methodsPercentHitCol, false);
                }
            }
            if (CoverageStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)CoverageStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }
    }

    public class CoverageStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public CoverageStatisticSorter() {
            super(CoverageStatisticView.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Coverage cov1 = (Coverage)e1;
            Coverage cov2 = (Coverage)e2;
            switch (this._pos) {
                case 0: {
                    if (cov1.getTraceObj() instanceof TRCPackage) {
                        return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._packageNameCol, false);
                    }
                    if (cov1.getTraceObj() instanceof TRCClass) {
                        return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._classNameCol, false);
                    }
                    if (cov1.getTraceObj() instanceof TRCMethod) {
                        return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._methodNameCol, false);
                    }
                    return 0;
                }
                case 1: {
                    if (cov1.getTraceObj() instanceof TRCMethod && cov2.getTraceObj() instanceof TRCMethod) {
                        return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._classNameCol, false);
                    }
                    return 0;
                }
                case 2: {
                    if (cov1.getTraceObj() instanceof TRCMethod && cov2.getTraceObj() instanceof TRCMethod) {
                        return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._packageNameCol, false);
                    }
                    if (cov1.getTraceObj() instanceof TRCClass && cov2.getTraceObj() instanceof TRCClass) {
                        return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._packageNameCol, false);
                    }
                    return 0;
                }
                case 3: {
                    return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._callsCol, false);
                }
                case 4: {
                    return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._methodsMissedCol, false);
                }
                case 5: {
                    return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._methodsHitCol, false);
                }
                case 6: {
                    return this._sortSequence * CoverageStatisticView.this.compareElements(e1, e2, CoverageStatisticView.this._methodsPercentHitCol, false);
                }
            }
            if (CoverageStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)CoverageStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
            }
            return 0;
        }
    }
}

