/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.ExecutionStatistic;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.Pattern;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;

public class ExecutionDetails {
    protected PatternPage _page;
    protected Sash hSash;
    protected Composite _viewContainer;
    protected Pattern _executionGraph;
    protected ExecutionStatistic _executionStatistic;
    protected Separator fSeparator = new Separator();
    static final int SASH_WIDTH = 3;
    protected String tmpString;

    public ExecutionDetails(Composite parent, PatternPage page) {
        this._page = page;
        this._viewContainer = new Composite(parent, 0);
        this._executionGraph = new Pattern(this._viewContainer, this._page, true);
        this._executionStatistic = new ExecutionStatistic(this._viewContainer, this._page);
        TreeViewer tv = (TreeViewer)this._executionStatistic.getTreeViewer();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tv);
        UIPlugin.getDefault().addViewSelectionChangedListener(new IViewSelectionChangedListener(){

            public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
                ExecutionDetails.this.selectionChanged();
            }
        });
        this.hSash = new Sash(this._viewContainer, 256);
        this.hSash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 1) {
                    ExecutionDetails.this.hSash.setBounds(event.x, event.y, event.width, event.height);
                    ExecutionDetails.this.layout();
                }
            }
        });
        this._viewContainer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ExecutionDetails.this.shellResized();
            }
        });
    }

    void layout() {
        Rectangle tabCompositeBounds = this._viewContainer.getClientArea();
        Rectangle hSashBounds = this.hSash.getBounds();
        Control comp = this._executionGraph.getControl();
        comp.setBounds(0, 0, tabCompositeBounds.width, hSashBounds.y);
        this._executionStatistic.getControl().setBounds(0, hSashBounds.y + hSashBounds.height, tabCompositeBounds.width, tabCompositeBounds.height - (hSashBounds.y + hSashBounds.height));
    }

    void shellResized() {
        Rectangle tabFolderPageBounds = this._viewContainer.getClientArea();
        Control control = this._executionGraph.getControl();
        Rectangle list1Bounds = new Rectangle(0, 0, tabFolderPageBounds.width, 3 * (tabFolderPageBounds.height - 3) / 4);
        control.setBounds(list1Bounds);
        this._executionStatistic.getControl().setBounds(0, list1Bounds.height + 3, tabFolderPageBounds.width, tabFolderPageBounds.height - (list1Bounds.height + 3));
        this.hSash.setBounds(0, list1Bounds.height, tabFolderPageBounds.width, 3);
    }

    public Control getControl() {
        return this._viewContainer;
    }

    public void refresh() {
        this._executionGraph.refresh();
        this._executionStatistic.refresh();
    }

    public void selectionChanged() {
        this._executionStatistic.selectionChanged();
        this._executionGraph.selectionChanged();
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (this._executionGraph.getCanvas() != null && this._executionGraph.getCanvas().getControl() != null && this._executionGraph.getCanvas().getControl().isFocusControl()) {
            this._executionGraph.menuAboutToShow(menu);
        } else {
            this.addExecutionStatisticMenu(menu);
        }
    }

    protected void addExecutionStatisticMenu(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._executionStatistic.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._executionStatistic.getChooseColumnsAction(this._executionStatistic.getColumnDataList(), this._executionStatistic.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
        this._page.percentMode().setChecked(this._executionStatistic.isShowPercent());
    }

    public void updateModelSelection() {
        ISelection selection = this._executionStatistic.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this._executionStatistic.notifyViewSelectionChanged(this, sel);
        }
    }

    public void dispose() {
        this._executionStatistic.dispose();
        this._executionGraph.dispose();
    }

    protected void postUpdateEvents() {
    }

    public boolean isEmpty() {
        return this._executionGraph.isEmpty();
    }

    protected String getViewTypeStr() {
        return "viewoption.methodinvocation";
    }

    public void update() {
        this._executionGraph.updateUI();
    }

    public void update(boolean redraw) {
        this._executionGraph.updateUI();
        if (redraw) {
            this._executionStatistic.updateUI(this._executionStatistic.getColumnDataList());
        }
    }

    public void initialize() {
        this._executionGraph.initialize();
    }

    public JCanvas getCanvas() {
        return this._executionGraph.getCanvas();
    }

    public void updateUI() {
        this._executionGraph.updateUI();
    }

    public void zoomOut(boolean zoom) {
        this._executionGraph.zoomOut(zoom);
    }

    public void zoomIn(boolean zoom) {
        this._executionGraph.zoomIn(zoom);
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement());
    }

    public ExecutionStatistic getExecutionStatistic() {
        return this._executionStatistic;
    }

    public Pattern getExecutionGraph() {
        return this._executionGraph;
    }
}

