/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.internal.SummaryGraph;
import org.eclipse.hyades.trace.views.internal.SummaryGraphSource;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderConfigurationException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ExecutionSummaryGraphsView {
    private final Composite _parent;
    private final SashForm _graphsContainer;
    private final SummaryGraph _heapGraph;
    private final SummaryGraph _threadsGraph;
    private final ExecutionStatisticPage2 _page;
    private SummaryGraphSource threadsSource;
    private SummaryGraphSource heapActiveSource;
    private SummaryGraphSource heapTotalSource;

    public ExecutionSummaryGraphsView(ExecutionStatisticPage2 page, Composite parent) throws ZoomSliderConfigurationException {
        this._page = page;
        this._parent = parent;
        this._graphsContainer = new SashForm(this._parent, 256);
        this._graphsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this._heapGraph = new SummaryGraph((Composite)this._graphsContainer, TraceUIMessages._240);
        this.heapActiveSource = new SummaryGraphSource(TraceUIMessages._241, Display.getDefault().getSystemColor(9));
        this.heapTotalSource = new SummaryGraphSource(TraceUIMessages._242, Display.getDefault().getSystemColor(3));
        this._heapGraph.addGraphSource(this.heapActiveSource);
        this._heapGraph.addGraphSource(this.heapTotalSource);
        this._threadsGraph = new SummaryGraph((Composite)this._graphsContainer, TraceUIMessages._246);
        this.threadsSource = new SummaryGraphSource(TraceUIMessages._247, Display.getDefault().getSystemColor(3));
        this._threadsGraph.addGraphSource(this.threadsSource);
    }

    public void update() {
        EObject mof = this._page.getMOFObject();
        double time = PerftraceUtil.getMaximumTime((EObject)mof);
        Object[] threads = PerftraceUtil.getAllThreads((EObject)mof);
        this.threadsSource.addData(new SummaryGraphSource.GraphDataItem(time, threads.length));
        long activeSize = PerftraceUtil.getActiveSize((EObject)mof);
        this.heapActiveSource.addData(new SummaryGraphSource.GraphDataItem(time, activeSize));
        long totalSize = PerftraceUtil.getTotalSize((EObject)mof);
        this.heapTotalSource.addData(new SummaryGraphSource.GraphDataItem(time, totalSize));
        this._heapGraph.update();
        this._threadsGraph.update();
    }

    public void dispose() {
        this._heapGraph.dispose();
        this._threadsGraph.dispose();
    }
}

