/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionSummaryTab;
import org.eclipse.hyades.trace.views.adapter.internal.FilterEventsUI;
import org.eclipse.hyades.trace.views.internal.ExecutionStatisticView;
import org.eclipse.hyades.trace.views.internal.MemoryStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ExecutionSummaryView {
    protected HyadesFormToolkit _toolkit;
    protected Form _form;
    protected ExecutionSummaryTab _tabItem;
    protected ExecutionStatisticView topMethodCalls;
    protected MemoryStatisticView topInstances;

    public ExecutionSummaryView(Composite parent, ExecutionSummaryTab tabItem) {
        this._tabItem = tabItem;
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this._form = this._toolkit.createForm(parent);
        this._form.setText(TraceUIPlugin.getString("59"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        this._form.setLayoutData((Object)new GridData(4, 4, true, true));
        this._form.getBody().setLayout((Layout)gridLayout);
        this._form.getBody().setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm _sashForm = new SashForm(this._form.getBody(), 512);
        _sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        Section titledConvert = this.getWrappedTitle((Composite)_sashForm, TraceUIMessages._237);
        this.topMethodCalls = new ExecutionStatisticView((Composite)titledConvert, (TraceViewerPage)tabItem.getPage()){
            private final SimpleSearchQuery topMethodsFilter;
            {
                this.topMethodsFilter = ExecutionSummaryView.this.createTopMethodsFilter();
            }

            protected SimpleSearchQuery getCurrentFilter() {
                return this.topMethodsFilter;
            }

            protected void firstTimeUpdate() {
                super.firstTimeUpdate();
                this.redrawTable();
            }
        };
        this.topMethodCalls.updateButtons();
        titledConvert.setClient(this.topMethodCalls.getControl());
        if (PerftraceUtil.hasHeapInfo((EObject)this._tabItem.getMOFObject())) {
            titledConvert = this.getWrappedTitle((Composite)_sashForm, TraceUIMessages._238);
            this.topInstances = new MemoryStatisticView((Composite)titledConvert, (TraceViewerPage)tabItem.getPage()){
                private int level;
                private final SimpleSearchQuery topInstancesFilter;
                {
                    this.level = 2;
                    this.topInstancesFilter = ExecutionSummaryView.this.createTopInstancesFilter();
                }

                protected SimpleSearchQuery getCurrentFilter() {
                    return this.topInstancesFilter;
                }

                protected void firstTimeUpdate() {
                    super.firstTimeUpdate();
                    this.redrawTable();
                    TreeColumn column = ExecutionSummaryView.this.getColumn(ExecutionSummaryView.this.topInstances.getTree(), 6);
                    if (column != null) {
                        this.getViewerSorter().setSortedColumn(-1, column);
                    }
                }

                public void setLevel(int level) {
                    this.level = level;
                }

                public int getLevel() {
                    return this.level;
                }
            };
            this.topInstances.setLevel(this.topMethodCalls.getLevel());
            titledConvert.setClient(this.topInstances.getControl());
        }
    }

    public void dispose() {
        this.disposeView(this.topMethodCalls);
        this.disposeView(this.topInstances);
        this._toolkit.dispose();
        this._form.dispose();
    }

    private void disposeView(StatisticView view) {
        if (view == null) {
            return;
        }
        view.dispose();
    }

    public void initialize() {
    }

    public ExecutionStatisticView getExecutionStatisticView() {
        return this.topMethodCalls;
    }

    public MemoryStatisticView getMemoryStatisticView() {
        return this.topInstances;
    }

    public Control getControl() {
        return this._form;
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.menuAboutToShow(menu, this.topMethodCalls);
        this.menuAboutToShow(menu, this.topInstances);
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._tabItem.getMOFObject()).getFirstElement());
    }

    public void refresh() {
        this.refreshView(this.topMethodCalls);
        this.refreshView(this.topInstances);
    }

    public void update() {
        this.updateView(this.topMethodCalls);
        this.updateView(this.topInstances);
    }

    private void updateView(StatisticView view) {
        if (view == null) {
            return;
        }
        view.update();
    }

    private void refreshView(StatisticView view) {
        if (view == null) {
            return;
        }
        view.refresh();
    }

    private SimpleSearchQuery createTopMethodsFilter() {
        SimpleSearchQuery result = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        FilterEventsUI.addOrderByExpressionAndSetMaxElements(result, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_BaseTime(), OrderByOperators.DESC_LITERAL, 10);
        this.setWhereExpressionAnd(result);
        return result;
    }

    private SimpleSearchQuery createTopInstancesFilter() {
        SimpleSearchQuery result = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        FilterEventsUI.addOrderByExpressionAndSetMaxElements(result, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_TotalSize(), OrderByOperators.DESC_LITERAL, 10);
        this.setWhereExpressionAnd(result);
        return result;
    }

    private void setWhereExpressionAnd(SimpleSearchQuery query) {
        LogicalExpression expr = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        expr.setOperator(LogicalOperators.AND_LITERAL);
        query.setWhereExpression((WhereExpression)expr);
    }

    private TreeColumn getColumn(Tree tree, int logicalIndex) {
        int i = 0;
        while (i < tree.getColumnCount()) {
            TreeColumn column = tree.getColumn(i);
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(column);
            if (info.getColumnData().getInitalPos() == logicalIndex) {
                return column;
            }
            ++i;
        }
        return null;
    }

    private void menuAboutToShow(IMenuManager menu, StatisticView view) {
        if (view == null) {
            return;
        }
        if (view.getTree().isFocusControl()) {
            view.menuAboutToShow(menu);
        }
    }

    private Section getWrappedTitle(Composite parent, String title) {
        Section result = this._toolkit.createSection(parent, 256);
        result.setText(title);
        result.marginWidth = 3;
        result.marginHeight = 3;
        GridLayout layout = new GridLayout();
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        TableWrapData data = new TableWrapData();
        data.grabVertical = true;
        data.grabHorizontal = true;
        data.heightHint = 200;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)data);
        return result;
    }

    public void setCheckedLevels(int newLevel) {
        if (newLevel == 4) {
            newLevel = 3;
        }
        if (this.topMethodCalls != null && this.topMethodCalls.getLevel() != newLevel) {
            this.topMethodCalls.setLevel(newLevel);
            this.topMethodCalls.updateButtons();
            this.topMethodCalls.redrawTable();
        }
        if (newLevel == 3) {
            newLevel = 2;
        }
        if (this.topInstances != null && this.topInstances.getLevel() != newLevel) {
            this.topInstances.setLevel(newLevel);
            this.topInstances.redrawTable();
        }
        if (this.topMethodCalls != null) {
            this.topMethodCalls.updateButtons();
        } else if (this.topInstances != null) {
            this.topInstances.updateButtons();
        }
    }

    public void runDeltaColumnsAction() {
        if (this.topMethodCalls != null) {
            this.topMethodCalls.getDeltaColumnsAction().run();
        }
        if (this.topInstances != null) {
            this.topInstances.getDeltaColumnsAction().run();
        }
    }

    public void runShowPercentAction() {
        if (this.topMethodCalls != null) {
            this.topMethodCalls.getShowPercentAction().run();
        }
        if (this.topInstances != null) {
            this.topInstances.getShowPercentAction().run();
        }
    }
}

