/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.trace.views.internal.StdDrawStrategy;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.util.internal.BufferedCanvas;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;

public class JCanvas
implements SelectionListener,
KeyListener,
TraverseListener {
    protected final float MAG_STEP = 2.0f;
    protected static final int ARROW_FACTOR = 4;
    protected static final int MIN_FONT_SIZE = 5;
    protected static final int MAX_FONT_SIZE = 72;
    protected static final float GROWTH_FACTOR = 1.25f;
    protected StdDrawStrategy _objDS;
    protected float _left;
    protected float _top;
    protected float _prefWidth;
    protected float _prefHeight;
    protected float _xscale = 1.0f;
    protected float _yscale = 1.0f;
    protected float _xscaleMax = 64.0f;
    protected float _yscaleMax = 64.0f;
    protected Point _origin = new Point(0, 0);
    protected Rectangle _prevSize = new Rectangle(0, 0, 0, 0);
    private Cursor _zoomInCursor;
    private Cursor _zoomOutCursor;
    private Cursor _defaultCursor;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;
    protected boolean _controlDown = false;
    protected BufferedCanvas fCanvas;
    protected int fCanvasStyle;
    public static final int fScrollBarWidth = 12;
    protected int fHSel = 0;
    protected int fVSel = 0;
    protected int fHeight;

    public JCanvas(Composite parent, int style) {
        this(parent, style, 0);
    }

    public JCanvas(Composite parent, int style, int height) {
        this.fCanvasStyle = style;
        this.fHeight = height;
        ImageDescriptor zoomInSource = TracePluginImages.DESC_IMG_ZOOMIN_SOURCE;
        ImageDescriptor zoomOutSource = TracePluginImages.DESC_IMG_ZOOMOUT_SOURCE;
        ImageDescriptor zoomMask = TracePluginImages.DESC_IMG_ZOOMMASK;
        this._zoomInCursor = new Cursor((Device)Display.getCurrent(), zoomInSource.getImageData(), zoomMask.getImageData(), 0, 0);
        this._zoomOutCursor = new Cursor((Device)Display.getCurrent(), zoomOutSource.getImageData(), zoomMask.getImageData(), 0, 0);
        this.createControl(parent);
        this._defaultCursor = new Cursor((Device)Display.getCurrent(), 0);
    }

    public boolean alignVertical(JCanvas source) {
        if (this._top != source._top || this._origin.y != source._origin.y || this._prefHeight != source._prefHeight || this._yscale != source._yscale) {
            this._top = source._top;
            this._origin.y = source._origin.y;
            this._prefHeight = source._prefHeight;
            this.yscale(source.yscale());
            return true;
        }
        return false;
    }

    public float bottom() {
        return this._top + this.height();
    }

    public Canvas canvas() {
        return this.fCanvas;
    }

    protected final Control createControl(Composite parent) {
        this.fCanvas = new BufferedCanvas(parent, this.fCanvasStyle){

            public void doPaint(GC gc) {
                JCanvas.this.paint(gc);
            }
        };
        this.fCanvas.setBackground(SpectrumColorMap.getBackgroundColor());
        ScrollBar horizontalBar = this.fCanvas.getHorizontalBar();
        ScrollBar verticalBar = this.fCanvas.getVerticalBar();
        if (horizontalBar != null) {
            horizontalBar.addSelectionListener((SelectionListener)this);
        }
        if (verticalBar != null) {
            verticalBar.addSelectionListener((SelectionListener)this);
        }
        this.fCanvas.addKeyListener(this);
        this.fCanvas.addTraverseListener(this);
        return this.fCanvas;
    }

    public int denormX(float x) {
        return Math.round((x - this._left) * this._xscale - (float)this._origin.x);
    }

    public int denormY(float y) {
        return Math.round((y - this._top) * this._yscale - (float)this._origin.y);
    }

    protected void denormZoom(float zx, float zy, float cx, float cy) {
        float lzx = Math.min(this._xscaleMax / this.xscale(), zx);
        float lzy = Math.min(this._yscaleMax / this.yscale(), zy);
        if (lzx != 1.0f || lzy != 1.0f) {
            this.xscale(this.xscale() * lzx);
            this.yscale(this.yscale() * lzy);
            this.zoomJCanvasScroller(lzx, lzy, cx, cy);
        }
        this.updateScrollbars();
    }

    public void drawArrow(GC g, float nx1, float ny1, float nx2, float ny2, Color col) {
        int y2;
        int yd;
        int x1 = this.denormX(nx1);
        int y1 = this.denormY(ny1);
        int x2 = this.denormX(nx2);
        int xd = x2 - x1;
        int len = (int)Math.sqrt(xd * xd + (yd = (y2 = this.denormY(ny2)) - y1) * yd);
        if (len > 1) {
            xd = Math.round((float)(xd * 4) * this._xscale / (float)len);
            yd = Math.round((float)(yd * 4) * this._yscale / (float)len);
        }
        if (xd != 0 || yd != 0) {
            g.setForeground(col);
            g.setBackground(col);
            g.drawLine(x2, y2, x2 - xd - yd / 2, y2 + xd / 2 - yd);
            g.drawLine(x2, y2, x2 - xd + yd / 2, y2 - xd / 2 - yd);
        }
        g.setForeground(col);
        g.setBackground(col);
        g.drawLine(x1, y1, x2, y2);
    }

    public void drawDiamond(GC g, float nx, float ny, float nw, float nh, Color col, boolean fill) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        float xs = this._xscale;
        float ys = this._yscale;
        int w = Math.round(xs * nw);
        int h = Math.round(ys * nh);
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        int[] points = new int[]{x + w / 2, y, x + w, y + h / 2, x + w / 2, y + h, x, y + h / 2};
        g.setForeground(col);
        g.setBackground(col);
        if (fill) {
            g.fillPolygon(points);
        } else {
            g.drawPolygon(points);
        }
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(y + h)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(x + w)));
    }

    public void drawLine(GC g, float nx1, float ny1, float nx2, float ny2, Color col) {
        g.setForeground(col);
        g.setBackground(col);
        int x1 = this.denormX(nx1);
        int y1 = this.denormY(ny1);
        int x2 = this.denormX(nx2);
        int y2 = this.denormY(ny2);
        g.drawLine(x1, y1, x2, y2);
    }

    public void drawLoop(GC g, float nx, float ny, float nw, float nh, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        g.setForeground(col);
        g.setBackground(col);
        g.drawOval(x - w / 2, y - h, w, h);
    }

    public void drawRect(GC g, float nx, float ny, float nw, float nh, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        if (w < 1 || h < 1) {
            w = 1;
            h = 1;
            return;
        }
        g.setForeground(col);
        g.setBackground(col);
        g.drawRectangle(x, y, w, h);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(y + h)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(x + w)));
    }

    public void drawRectXor(float nx, float ny, float nw, float nh) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        GC g = new GC((Drawable)this.fCanvas);
        g.setXORMode(true);
        g.setForeground(display.getSystemColor(1));
        g.setBackground(display.getSystemColor(2));
        if (w >= 1 && h >= 1) {
            g.drawRectangle(x, y, w, h);
        }
        g.dispose();
    }

    public void drawRectXor(GC g, float nx, float ny, float nw, float nh) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        g.setXORMode(true);
        g.setForeground(display.getSystemColor(1));
        g.setBackground(display.getSystemColor(2));
        if (w >= 1 && h >= 1) {
            g.drawRectangle(x, y, w, h);
        }
    }

    public void drawSquare(GC g, float nx, float ny, float nw, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        if (w < 1) {
            return;
        }
        g.setForeground(col);
        g.setBackground(col);
        g.drawRectangle(x, y, w, w);
    }

    public void drawString(GC gc, String s, float nx, float ny, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        gc.setForeground(col);
        gc.drawString(s, x, y - 10, true);
    }

    public void drawString(GC gc, String s, float nx, float ny, Color col, Color bgColor) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        gc.setForeground(col);
        gc.setBackground(bgColor);
        gc.drawString(s, x, y - 10);
    }

    protected boolean extendedTo(float x, float y) {
        boolean outside = false;
        float dx = 0.0f;
        float dy = 0.0f;
        if (x < this.left()) {
            dx = (this.left() - x) * 1.25f;
            this._prefWidth += dx;
            this.left(x);
            outside = true;
        } else if (x > this.left() + this.width()) {
            this._prefWidth = (x - this.left()) * 1.25f;
            outside = true;
        }
        if (y < this.top()) {
            dy = (this.top() - y) * 1.25f;
            this._prefHeight += dy;
            this.top(y);
            outside = true;
        } else if (y > this.top() + this.height()) {
            this._prefHeight = (y - this.top()) * 1.25f;
            outside = true;
        }
        if (outside) {
            int cdx = Math.round(dx * this._xscale);
            int cdy = Math.round(dy * this._yscale);
            this._origin.x += cdx;
            this._origin.y += cdy;
        }
        return outside;
    }

    protected float fdenormX(float x) {
        return (x - this._left) * this._xscale - (float)this._origin.x;
    }

    protected float fdenormY(float y) {
        return (y - this._top) * this._yscale - (float)this._origin.y;
    }

    public void fill3DDiamond(GC g, float nx, float ny, float nw, float nh, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        float xs = this._xscale;
        float ys = this._yscale;
        int w = Math.round(xs * nw);
        int h = Math.round(ys * nh);
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        int[] points = new int[]{x + w / 2, y, x + w, y + h / 2, x + w / 2, y + h, x, y + h / 2};
        g.setForeground(col);
        g.setBackground(col);
        g.fillPolygon(points);
        Color darker = new Color(null, 0, col.getGreen(), col.getBlue());
        g.setForeground(darker);
        g.setBackground(darker);
        g.drawLine(x + w / 2, y, x + w, y + h / 2);
        g.drawLine(x + w, y + h / 2, x + w / 2, y + h);
        g.drawLine(x + w + 1, y + h / 2, x + w / 2, y + h + 1);
        Color brighter = new Color(null, col.getRed(), col.getGreen(), 0);
        g.setForeground(brighter);
        g.setBackground(brighter);
        g.drawLine(x + w / 2, y + h, x, y + h / 2);
        g.drawLine(x, y + h / 2, x + w / 2, y);
        g.drawLine(x - 1, y + h / 2, x + w / 2, y - 1);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(y + h)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(x + w)));
    }

    public void fill3DRect(GC g, float nx, float ny, float nw, float nh, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        g.setForeground(col);
        g.setBackground(col);
        g.fillRoundRectangle(x, y, w, h, 1, 1);
        g.fillRoundRectangle(x + 1, y + 1, w - 2, h - 2, 1, 1);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(y + h)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(x + w)));
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this._objDS != null) {
            this._objDS.fillContextMenu(menu);
        }
    }

    public void fillOval(GC g, float nx, float ny, float nw, float nh, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        g.setForeground(col);
        g.setBackground(col);
        g.fillOval(x, y, w, h);
    }

    public void fillRect(GC g, float nx, float ny, float nw, float nh, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        int h = Math.round(this._yscale * nh);
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        g.setForeground(col);
        g.setBackground(col);
        g.fillRectangle(x, y, w, h);
        this._objDS.setHeight(Math.max(this._objDS.getHeight(), (float)(y + h)));
        this._objDS.setWidth(Math.max(this._objDS.getWidth(), (float)(x + w)));
    }

    public void fillSquare(GC g, float nx, float ny, float nw, Color col) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this._xscale * nw);
        if (w < 1) {
            w = 1;
        }
        g.setBackground(col);
        g.fillRectangle(x, y, w, w);
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public Point getOrigin() {
        return this._origin;
    }

    protected Point getPreferredSize() {
        int width = Math.round(this._prefWidth * this.xscale());
        int height = Math.round(this._prefHeight * this.yscale());
        return new Point(width, height);
    }

    public int getScrollX() {
        return this.fHSel;
    }

    public Rectangle getSize() {
        Rectangle rect = this.fCanvas.getClientArea();
        return rect;
    }

    protected Rectangle getVisible() {
        Rectangle rect = this.fCanvas.getClientArea();
        rect.height -= this.fHeight;
        return rect;
    }

    public float height() {
        return this._prefHeight;
    }

    public void home() {
        if (this.xscale() == 1.0f && this.yscale() == 1.0f) {
            this.scrollTo(0, 0);
        } else {
            this.xscale(1.0f);
            this.yscale(1.0f);
            this._origin.x = 0;
            this._origin.y = 0;
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 262144) {
            this._controlDown = true;
        } else if (e.keyCode == 0x1000005) {
            this.pageUp();
        } else if (e.keyCode == 0x1000006) {
            this.pageDown();
        } else if (e.keyCode == 0x1000001) {
            this.page(0.0f, -0.1f);
        } else if (e.keyCode == 0x1000002) {
            this.page(0.0f, 0.1f);
        } else if (e.keyCode == 0x1000003) {
            if (this._controlDown) {
                this.page(-0.9f, 0.0f);
            } else {
                this.page(-0.1f, 0.0f);
            }
        } else if (e.keyCode == 0x1000004) {
            if (this._controlDown) {
                this.page(0.9f, 0.0f);
            } else {
                this.page(0.1f, 0.0f);
            }
        } else if (e.keyCode == 0x1000007) {
            this.zoomToFill(1.0f, 1000.0f);
            this.redraw();
        } else if (e.keyCode == 0x1000009 || e.character == '=' || e.character == '+') {
            this.zoomIn();
            this.redraw();
        } else if (e.character == '_' || e.character == '-') {
            this.zoomOut();
            this.redraw();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 262144) {
            this._controlDown = false;
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public float left() {
        return this._left;
    }

    public void left(float x) {
        this._left = x;
    }

    public float normX(int x) {
        return (float)(x + this._origin.x) / this._xscale + this._left;
    }

    public float normY(int y) {
        return (float)(y + this._origin.y) / this._yscale + this._top;
    }

    protected void page(float fx, float fy) {
        this.page(fx, fy, true);
    }

    protected void page(float fx, float fy, boolean updateScrollbars) {
        if (fx != 0.0f) {
            int visibleWidth = this.getVisible().width;
            int totalWidth = this.getPreferredSize().x;
            int hiddenLeft = this._origin.x;
            int hiddenRight = totalWidth - visibleWidth - hiddenLeft;
            if (fx > 0.0f && hiddenRight <= 0) {
                this._origin.x = this.getPreferredSize().x - this.getVisible().width;
                if (updateScrollbars) {
                    this.updateScrollbars();
                }
                return;
            }
            if (fx < 0.0f && hiddenLeft <= 0) {
                this._origin.x = 0;
                if (updateScrollbars) {
                    this.updateScrollbars();
                }
                return;
            }
        }
        if (fy != 0.0f) {
            int visibleHeight = this.getVisible().height;
            int totalHeight = this.getPreferredSize().y;
            int hiddenTop = this._origin.y;
            int hiddenBottom = totalHeight - visibleHeight - hiddenTop;
            if (fy < 0.0f && hiddenTop <= 0) {
                this._origin.y = 0;
                if (updateScrollbars) {
                    this.updateScrollbars();
                }
                return;
            }
            if (fy > 0.0f && hiddenBottom <= 0) {
                return;
            }
        }
        Rectangle visible = this.getVisible();
        this.scrollBy(Math.round((float)visible.width * fx), Math.round((float)visible.height * fy), updateScrollbars);
    }

    public void pageDown() {
        this.page(0.0f, 0.8f);
    }

    public void pageUp() {
        this.page(0.0f, -0.8f);
    }

    protected void paint(GC gc) {
        if (this._objDS == null) {
            return;
        }
        FontData data = SpectrumColorMap.getFontData();
        Font font = new Font((Device)Display.getDefault(), data);
        gc.setFont(font);
        this._objDS.setDirty();
        if (this._objDS.isDirtyAndReset()) {
            this._objDS.bgRedraw(gc);
            if (this.sizeChanged()) {
                this.updateScrollbars();
            }
            this._prevSize = this.getVisible();
        }
        font.dispose();
    }

    public void redraw() {
        Display display = Display.getCurrent();
        if (display == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    JCanvas.this.fCanvas.redraw();
                }
            });
        } else {
            this.fCanvas.redraw();
        }
    }

    public float right() {
        return this._left + this.width();
    }

    public void scrollBy(int dx, int dy) {
        this.scrollBy(dx, dx, true);
    }

    public void scrollBy(int dx, int dy, boolean updateScrollbars) {
        this.scrollTo(this._origin.x + dx, this._origin.y + dy, updateScrollbars);
    }

    public void scrollTo(int x, int y) {
        this.scrollTo(x, y, true);
    }

    public void scrollTo(int x, int y, boolean updateScrollbars) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        Point p = new Point(x, y);
        if (p.x != this._origin.x || p.y != this._origin.y) {
            this._origin = p;
            this.redraw();
            if (updateScrollbars) {
                this.updateScrollbars(p.x, p.y);
            }
        }
    }

    public void setArea(float width, float height) {
        this._prefWidth = width;
        this._prefHeight = height;
    }

    public void setDrawStrategy(StdDrawStrategy strategy) {
        this._objDS = strategy;
        if (this.fCanvas == null || this._objDS == null) {
            return;
        }
        this.fCanvas.addMouseListener(this._objDS);
        this.fCanvas.addMouseMoveListener(this._objDS);
    }

    public void setMenuListener(IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)this.fCanvas);
        this.fCanvas.setMenu(menu);
    }

    public void setOrigin(Point p) {
        this._origin = p;
    }

    public void setZoomLimits(float zx, float zy) {
        this._xscaleMax = zx;
        this._yscaleMax = zy;
    }

    protected boolean sizeChanged() {
        Rectangle size = this.getVisible();
        return size.width != this._prevSize.width || size.height != this._prevSize.height;
    }

    public float top() {
        return this._top;
    }

    public void top(float y) {
        this._top = y;
    }

    public void updateScrollbars() {
        int steps;
        if (this._objDS == null) {
            return;
        }
        ScrollBar hb = this.fCanvas.getHorizontalBar();
        ScrollBar vb = this.fCanvas.getVerticalBar();
        if (hb != null) {
            int visibleWidth = this.getVisible().width;
            int totalWidth = this.getPreferredSize().x;
            int hiddenLeft = this._origin.x;
            hb.setMinimum(0);
            hb.setMaximum(totalWidth - visibleWidth);
            if (totalWidth <= visibleWidth) {
                hb.setVisible(false);
            } else {
                hb.setVisible(true);
                int fHPageIncrement = Math.round((float)visibleWidth * 0.1f);
                if (fHPageIncrement == 0) {
                    return;
                }
                steps = hb.getMaximum() / fHPageIncrement + 2;
                hb.setMaximum(steps * fHPageIncrement);
                hb.setThumb(hb.getMaximum() / steps);
                hb.setSelection(hiddenLeft);
                hb.setPageIncrement(fHPageIncrement);
                hb.setIncrement(fHPageIncrement);
                this.fHSel = hb.getSelection();
            }
        }
        if (vb != null) {
            int visibleHeight = this.getVisible().height;
            int totalHeight = this.getPreferredSize().y;
            int hiddenTop = this._origin.y;
            vb.setMinimum(0);
            vb.setMaximum(totalHeight - visibleHeight);
            if (totalHeight <= visibleHeight) {
                vb.setVisible(false);
            } else {
                vb.setVisible(true);
                int fVPageIncrement = Math.round((float)visibleHeight * 0.1f);
                if (fVPageIncrement == 0) {
                    return;
                }
                steps = vb.getMaximum() / fVPageIncrement + 2;
                vb.setMaximum(steps * fVPageIncrement);
                vb.setThumb(vb.getMaximum() / steps);
                vb.setSelection(hiddenTop);
                vb.setPageIncrement(fVPageIncrement);
                vb.setIncrement(fVPageIncrement);
                this.fVSel = vb.getSelection();
            }
        }
    }

    protected void updateScrollbars(int dx, int dy) {
        if (this._objDS == null) {
            return;
        }
        ScrollBar hb = this.fCanvas.getHorizontalBar();
        ScrollBar vb = this.fCanvas.getVerticalBar();
        if (hb != null) {
            hb.setSelection(dx);
            this.fHSel = hb.getSelection();
        }
        if (vb != null) {
            vb.setSelection(dy);
            this.fVSel = vb.getSelection();
        }
    }

    public boolean visible(float nx, float ny, float nw, float nh) {
        int x = this.denormX(nx);
        int y = this.denormY(ny);
        int w = Math.round(this.xscale() * nw);
        int h = Math.round(this.yscale() * nh);
        Rectangle visible = this.getVisible();
        return x <= visible.width && x + w >= 0 && y <= visible.height && y + h >= 0;
    }

    public float visibleBottom() {
        return this.normY(this.getVisible().height);
    }

    public float visibleHeight() {
        return (float)this.getVisible().height / this.yscale();
    }

    public float visibleLeft() {
        return this.normX(0);
    }

    public float visibleRight() {
        return this.normX(this.getVisible().width);
    }

    public float visibleTop() {
        return this.normY(0);
    }

    public float visibleWidth() {
        return (float)this.getVisible().width / this.xscale();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fCanvas.getHorizontalBar()) {
            ScrollBar hb = (ScrollBar)e.widget;
            int sel = hb.getSelection();
            if (sel != 0 && sel >= this.fHSel && this.fHSel >= 0) {
                int diff = sel - this.fHSel;
                if (diff > 0 && hb.getPageIncrement() > 0) {
                    float pageIncr = (float)diff * 0.1f / (float)hb.getPageIncrement();
                    this.page(pageIncr, 0.0f, false);
                }
            } else {
                int diff = this.fHSel - sel;
                if (diff > 0 && hb.getPageIncrement() > 0) {
                    float pageIncr = (float)diff * 0.1f / (float)hb.getPageIncrement();
                    this.page(-pageIncr, 0.0f, false);
                }
            }
            this.fHSel = sel;
        } else if (e.widget == this.fCanvas.getVerticalBar()) {
            ScrollBar vb = (ScrollBar)e.widget;
            int sel = vb.getSelection();
            if (sel != 0 && sel >= this.fVSel && this.fVSel >= 0) {
                int diff = sel - this.fVSel;
                if (diff > 0 && vb.getPageIncrement() > 0) {
                    float pageIncr = (float)diff * 0.1f / (float)vb.getPageIncrement();
                    this.page(0.0f, pageIncr, false);
                }
            } else {
                int diff = this.fVSel - sel;
                if (diff > 0 && vb.getPageIncrement() > 0) {
                    float pageIncr = (float)diff * 0.1f / (float)vb.getPageIncrement();
                    this.page(0.0f, -pageIncr, false);
                }
            }
            this.fVSel = sel;
        }
    }

    public float width() {
        return this._prefWidth;
    }

    public float xscale() {
        return this._xscale;
    }

    protected void xscale(float s) {
        this._xscale = Math.min(s, this._xscaleMax);
    }

    public float yscale() {
        return this._yscale;
    }

    protected void yscale(float s) {
        this._yscale = Math.min(s, this._yscaleMax);
    }

    public void zoom(float cx, float cy) {
        if (this._zoomIn) {
            this.denormZoom(1.5f, 1.5f, cx, cy);
        }
        if (this._zoomOut) {
            this.denormZoom(0.5f, 0.5f, cx, cy);
        }
        this.redraw();
    }

    public void zoom(float zx, float zy, float cx, float cy) {
        this.denormZoom(zx, zy, this.fdenormX(cx), this.fdenormY(cy));
    }

    public void zoomIn() {
        if (this._zoomIn) {
            this.fCanvas.setCursor(this._zoomInCursor);
        } else {
            this.fCanvas.setCursor(this._defaultCursor);
        }
    }

    protected void zoomJCanvasScroller(float zx, float zy, float cx, float cy) {
        this._origin.x = Math.round(((float)this._origin.x + cx) * zx - cx);
        this._origin.y = Math.round(((float)this._origin.y + cy) * zy - cy);
    }

    public void zoomOut() {
        if (this._zoomOut) {
            this.fCanvas.setCursor(this._zoomOutCursor);
        } else {
            this.fCanvas.setCursor(this._defaultCursor);
        }
    }

    public void setDefautCursor() {
        this.fCanvas.setCursor(this._defaultCursor);
    }

    public void zoomRect(float x, float y, float w, float h) {
        Rectangle visible = this.getVisible();
        float dw = w * this.xscale();
        float dh = h * this.yscale();
        float factorx = (float)visible.width / dw;
        float factory = (float)visible.height / dh;
        float cx = this.fdenormX(x + w / 2.0f);
        float cy = this.fdenormY(y + h / 2.0f);
        float dx = cx - (float)visible.width / 2.0f;
        float dy = cy - (float)visible.height / 2.0f;
        this.denormZoom(factorx, factory, cx += dx / factorx, cy += dy / factory);
    }

    public void zoomToFill(float xScaleMax, float yScaleMax) {
        float objDS_width;
        if (this._objDS == null || this.fCanvas == null) {
            return;
        }
        float pixwidth = this.getVisible().width;
        float pixheight = this.getVisible().height;
        if (pixwidth <= 0.0f) {
            pixwidth = 500.0f;
        }
        if (pixheight <= 0.0f) {
            pixheight = 250.0f;
        }
        objDS_width = (objDS_width = this._objDS.width()) == 0.0f ? 1.0f : objDS_width;
        float objDS_height = this._objDS.height();
        float f = objDS_height = objDS_height == 0.0f ? 1.0f : objDS_height;
        if (objDS_width > 1.0f && pixwidth / objDS_width < xScaleMax) {
            this.xscale(pixwidth / objDS_width);
        } else {
            this.xscale(xScaleMax);
        }
        if (objDS_height > 1.0f && pixheight / objDS_height < yScaleMax) {
            this.yscale(pixheight / objDS_height);
        } else {
            this.yscale(yScaleMax);
        }
        this._origin.x = 0;
        this._origin.y = 0;
        this.updateScrollbars();
    }

    public void zoomToFit() {
        this.zoomToFill(1.0f, 1.0f);
    }

    public void dispose() {
        if (this._zoomInCursor != null && !this._zoomInCursor.isDisposed()) {
            this._zoomInCursor.dispose();
        }
        if (this._zoomOutCursor != null && !this._zoomOutCursor.isDisposed()) {
            this._zoomOutCursor.dispose();
        }
        if (this._defaultCursor != null && !this._defaultCursor.isDisposed()) {
            this._defaultCursor.dispose();
        }
        this._objDS = null;
        this._prevSize = null;
        this._origin = null;
        this.fCanvas = null;
        this._zoomInCursor = null;
        this._zoomOutCursor = null;
        this._defaultCursor = null;
    }

    public void isZoomIn(boolean zoom) {
        this._zoomIn = zoom;
        if (zoom) {
            this._zoomOut = false;
        }
    }

    public void isZoomOut(boolean zoom) {
        this._zoomOut = zoom;
        if (zoom) {
            this._zoomIn = false;
        }
    }

    public boolean isZoom() {
        return this._zoomIn || this._zoomOut;
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }
}

