/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.DynamicFilter;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticPage;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ActiveSizeColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ClassNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.CollectedInstancesColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.LiveInstancesColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.NewItemColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PackageNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.TotalInstancesColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.TotalSizeColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MemoryStatisticView
extends MultiLevelStatisticView {
    private static final int[] _numberOfColumns = new int[]{20, 20, 20};
    private static int _level = 1;
    public static final int INSTANCE_LEVEL = 3;
    private TRCPackageImpl.TRCPackageSnapshot packageSnapshot = new TRCPackageImpl.TRCPackageSnapshot();
    private TRCClassImpl.TRCClassSnapshot classSnapshot = new TRCClassImpl.TRCClassSnapshot();
    protected ColumnLabelAdapter _packageNameCol;
    protected ColumnLabelAdapter _classNameCol;
    protected ColumnLabelAdapter _instanceNameCol;
    protected ColumnLabelAdapter _newItemCol;
    protected ColumnLabelAdapter _totalInstancesCol;
    protected ColumnLabelAdapter _liveInstancesCol;
    protected ColumnLabelAdapter _collectedInstancesCol;
    protected ColumnLabelAdapter _totalSizeCol;
    protected ColumnLabelAdapter _activeSizeCol;

    public MemoryStatisticView(Composite parent, TraceViewerPage page) {
        super(true, parent, page);
        this.createColumnsLabelProviders();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".stvw0001";
    }

    public void createColumnsLabelProviders() {
        this._packageNameCol = new PackageNameColumnLabel();
        this._classNameCol = new ClassNameColumnLabel();
        this._instanceNameCol = new InstanceNameColumnLabel();
        this._newItemCol = new NewItemColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._newItemCol, this.packageSnapshot, this.classSnapshot, null);
        this._totalInstancesCol = new TotalInstancesColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._totalInstancesCol, this.packageSnapshot, this.classSnapshot, null);
        this._liveInstancesCol = new LiveInstancesColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._liveInstancesCol, this.packageSnapshot, this.classSnapshot, null);
        this._collectedInstancesCol = new CollectedInstancesColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._collectedInstancesCol, this.packageSnapshot, this.classSnapshot, null);
        this._totalSizeCol = new TotalSizeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._totalSizeCol, this.packageSnapshot, this.classSnapshot, null);
        this._activeSizeCol = new ActiveSizeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._activeSizeCol, this.packageSnapshot, this.classSnapshot, null);
    }

    protected int getClassPosForLevel(int pos) {
        if (this.getLevel() == 1) {
            switch (pos) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
            }
        } else if (this.getLevel() == 3) {
            switch (pos) {
                case 3: {
                    return 5;
                }
                case 4: {
                    return 6;
                }
                case 5: {
                    return 7;
                }
                case 6: {
                    return -1;
                }
                case 7: {
                    return -1;
                }
            }
        }
        return pos;
    }

    public String getDefaultColumnsTemplate() {
        String columns = super.getDefaultColumnsTemplate();
        if (columns == null) {
            columns = this.getLevel() == 3 ? this.getDefaultColumnsTemplateInstanceLevel() : "";
        }
        columns = String.valueOf(columns) + this.getColumnsTemplateExtensions(_numberOfColumns[_level - 1], "org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticViewer", false);
        return columns;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return "package.name:0:" + String.valueOf(7) + ":left:200," + ":1:" + String.valueOf(47) + ":20," + "package.total.inst" + ":2:" + String.valueOf(17) + ":right:100," + "package.live.inst" + ":3:" + String.valueOf(17) + ":right:100," + "package.collect.inst" + ":4:" + String.valueOf(17) + ":right:100," + "package.total.size" + ":5:" + String.valueOf(17) + ":right:100," + "package.active.size" + ":6:" + String.valueOf(17) + ":right:100";
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return "class.name:0:" + String.valueOf(7) + ":200," + ":1:" + String.valueOf(47) + ":20," + "package.name" + ":2:" + String.valueOf(1) + ":left:100," + "class.total.inst" + ":3:" + String.valueOf(17) + ":right:100," + "class.live.inst" + ":4:" + String.valueOf(17) + ":right:100," + "class.collect.inst" + ":5:" + String.valueOf(17) + ":right:100," + "class.total.size" + ":6:" + String.valueOf(17) + ":right:100," + "class.active.size" + ":7:" + String.valueOf(17) + ":right:100";
    }

    protected String getDefaultColumnsTemplateInstanceLevel() {
        return "class.name:0:" + String.valueOf(7) + ":left:200," + ":1:" + String.valueOf(47) + ":20," + "package.name" + ":2:" + String.valueOf(1) + ":left:100," + "object.collected" + ":3:" + String.valueOf(1) + ":right:100," + "object.size" + ":4:" + String.valueOf(1) + ":right:100," + "object.active.size" + ":5:" + String.valueOf(1) + ":right:100";
    }

    public boolean isEmptyUpdate() {
        return PerftraceUtil.getTotalSize((EObject)this._page.getMOFObject()) <= 0L;
    }

    public IContentProvider getContentProvider() {
        return new MemoryStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MemoryStatisticLabelProvider((StatisticView)this);
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new MemoryStatisticCellLabelProvider(colData);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new MemoryStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new MemoryStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        this.setLevel(this.getLevel());
        if (this.getLevel() == 1) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "MemStatsPack60";
        }
        if (this.getLevel() == 2) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "MemStatsClass60";
        }
        if (this.getLevel() == 2) {
            return String.valueOf(PREFERENCE_KEY_PREFIX) + "MemStatsInstance60";
        }
        return "";
    }

    protected String getViewTypeStr() {
        return "viewoption.memory";
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
        super.doUpdateButtons(isPostponedOperation, processedOperations);
        TraceViewerPage page = this.getTraceViewerPage();
        if (!(page instanceof MemoryStatisticPage)) {
            return;
        }
        MemoryStatisticPage memoryPage = (MemoryStatisticPage)page;
        memoryPage.percentMode().setChecked(this.isShowPercent());
        if (this.getLevel() == 3) {
            memoryPage.deltaColumns().setChecked(false);
        } else {
            memoryPage.deltaColumns().setChecked(this.showingDeltaColumns());
        }
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalInst = PerftraceUtil.getTotalInstances((EObject)this._page.getMOFObject());
            if (this._totalInst == 0) {
                this._totalInst = 1;
            }
            this._activeInst = PerftraceUtil.getActiveInstances((EObject)this._page.getMOFObject());
            if (this._activeInst == 0) {
                this._activeInst = 1;
            }
            this._totalSize = PerftraceUtil.getTotalSize((EObject)this._page.getMOFObject());
            if (this._totalSize == 0L) {
                this._totalSize = 1L;
            }
            this._activeSize = PerftraceUtil.getActiveSize((EObject)this._page.getMOFObject());
            if (this._activeSize == 0L) {
                this._activeSize = 1L;
            }
            this._collectedInst = PerftraceUtil.getTotalCollectedInstances((EObject)this._page.getMOFObject());
            if (this._collectedInst == 0) {
                this._collectedInst = 1;
            }
        }
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._packageNameCol) {
            return ContextUpdaterHelper.updatePackageName(col, this._page.getMOFObject());
        }
        if (col == this._totalInstancesCol) {
            return ContextUpdaterHelper.updateTotalInstances(col, isDeltaColumn, this.isShowPercent(), this._totalInst);
        }
        if (col == this._liveInstancesCol) {
            return ContextUpdaterHelper.updateLiveInstances(col, isDeltaColumn, this.isShowPercent(), this._activeInst);
        }
        if (col == this._collectedInstancesCol) {
            return ContextUpdaterHelper.updateCollectedInst(col, isDeltaColumn, this.isShowPercent(), this._collectedInst);
        }
        if (col == this._totalSizeCol) {
            return ContextUpdaterHelper.updateTotalSize(col, isDeltaColumn, this.isShowPercent(), this._totalSize);
        }
        if (col == this._activeSizeCol) {
            return ContextUpdaterHelper.updateActiveSize(col, isDeltaColumn, this.isShowPercent(), this._activeSize);
        }
        return super.getColumnDisplayInfo(col, isDeltaColumn);
    }

    protected void searchInLevel(Tree tree, TreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        super.searchInLevel(tree, item, pack, cls, meth, trcObj);
        switch (this.getLevel()) {
            case 3: {
                if (cls == null) break;
                this.searchInClassLevel(tree, item, cls, null, trcObj);
            }
        }
    }

    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        this._packageNameCol.resetMap();
        this._classNameCol.resetMap();
        this._instanceNameCol.resetMap();
        this._totalInstancesCol.resetMap();
        this._liveInstancesCol.resetMap();
        this._collectedInstancesCol.resetMap();
        this._totalSizeCol.resetMap();
        this._activeSizeCol.resetMap();
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
    }

    public class MemoryStatisticCellLabelProvider
    extends StatisticCellLabelProvider {
        public MemoryStatisticCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((MemoryStatisticLabelProvider)MemoryStatisticView.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((MemoryStatisticLabelProvider)MemoryStatisticView.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class MemoryStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        public MemoryStatisticContentProvider() {
            super(MemoryStatisticView.this);
        }

        public Object[] getChildren(Object element) {
            MemoryStatisticView.this.tmpList.clear();
            if (element instanceof TRCPackage) {
                return FilteringUtil.getFilteredClasses(MemoryStatisticView.this.getCurrentFilter(), (EObject)((TRCPackage)element)).toArray();
            }
            if (element instanceof TRCClass && MemoryStatisticView.this.getLevel() == 3) {
                Object[] elements = FilteringUtil.getFilteredFullTraceObjects(MemoryStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                if (elements.length > 0) {
                    return elements;
                }
                return FilteringUtil.getFilteredHeapObjects(MemoryStatisticView.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
            }
            return MemoryStatisticView.this.tmpList.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            SimpleSearchQuery currentFilter = MemoryStatisticView.this.getCurrentFilter();
            currentFilter = this.updateDynamicFilters(currentFilter, MemoryStatisticView.this._page.getMOFObject());
            if (MemoryStatisticView.this.getLevel() == 1) {
                return FilteringUtil.getFilteredPackages(currentFilter, FilteringUtil.getProcessList(MemoryStatisticView.this._page.getMOFObject())).toArray();
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return FilteringUtil.getFilteredClasses(currentFilter, FilteringUtil.getProcessList(MemoryStatisticView.this._page.getMOFObject())).toArray();
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return FilteringUtil.getFilteredClasses(currentFilter, FilteringUtil.getProcessList(MemoryStatisticView.this._page.getMOFObject())).toArray();
            }
            return new ArrayList().toArray();
        }

        private SimpleSearchQuery updateDynamicFilters(SimpleSearchQuery filter, EObject object) {
            if (!DynamicFilter.containsDynamicFilters(filter)) {
                return filter;
            }
            return DynamicFilter.updateDynamicFilters(filter, object);
        }
    }

    public class MemoryStatisticFilter
    extends StatisticView.StatisticFilter {
        public MemoryStatisticFilter() {
            super(MemoryStatisticView.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            String compareText = "";
            switch (MemoryStatisticView.this.getLevel()) {
                case 1: {
                    if (!(element instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)element).getName().length() == 0) {
                        compareText = TraceUIMessages._87;
                        break;
                    }
                    compareText = ((TRCPackage)element).getName();
                    break;
                }
                case 2: {
                    if (!(element instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)element).getName();
                    break;
                }
                case 3: {
                    if (!(element instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)element).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class MemoryStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public MemoryStatisticLabelProvider(StatisticView viewer) {
            super(MemoryStatisticView.this, viewer);
        }

        protected String getColumnTextPackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCPackage) {
                switch (pos) {
                    case 0: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._totalInstancesCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._liveInstancesCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._collectedInstancesCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._totalSizeCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._activeSizeCol, info.isDeltaColumn());
                    }
                }
                if (MemoryStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)MemoryStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                    return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
                }
            } else {
                return this.getColumnTextClassLevel(obj, col);
            }
            return "";
        }

        protected String getColumnTextClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = MemoryStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._classNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._totalInstancesCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._liveInstancesCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._collectedInstancesCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._totalSizeCol, info.isDeltaColumn());
                    }
                    case 7: {
                        return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._activeSizeCol, info.isDeltaColumn());
                    }
                }
                if (MemoryStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)MemoryStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                    return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
                }
            }
            if (obj instanceof TRCObjectValue && pos == 0) {
                return ((TRCObjectValue)obj).getStringValue();
            }
            return "";
        }

        protected String getColumnTextInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                return this.getColumnTextClassLevel(obj, col);
            }
            switch (pos) {
                case 0: {
                    return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._instanceNameCol, info.isDeltaColumn());
                }
                case 1: {
                    return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._newItemCol, info.isDeltaColumn());
                }
                case 2: {
                    return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._packageNameCol, info.isDeltaColumn());
                }
                case 3: {
                    return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._collectedInstancesCol, info.isDeltaColumn());
                }
                case 4: {
                    return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._totalSizeCol, info.isDeltaColumn());
                }
                case 5: {
                    return MemoryStatisticView.this.getElementColumnText(obj, MemoryStatisticView.this._activeSizeCol, info.isDeltaColumn());
                }
            }
            if (MemoryStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)MemoryStatisticView.this._listOfColumExtension.get(pos - _numberOfColumns[_level - 1]);
                return elt.getClassOfColumnExtension().getColumnText(obj, elt.getInitialColumnPos());
            }
            return "";
        }

        public String getColumnText(Object obj, int col) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                return this.getColumnTextPackageLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return this.getColumnTextClassLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return this.getColumnTextInstanceLevel(obj, col);
            }
            return "";
        }

        protected Image getColumnImagePackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCPackage) {
                switch (pos) {
                    case 0: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._totalInstancesCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._liveInstancesCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._collectedInstancesCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._totalSizeCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._activeSizeCol, info.isDeltaColumn());
                    }
                }
            } else {
                return this.getColumnImageClassLevel(obj, col);
            }
            return null;
        }

        protected Image getColumnImageClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = MemoryStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._classNameCol, info.isDeltaColumn());
                    }
                    case 1: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._newItemCol, info.isDeltaColumn());
                    }
                    case 2: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._packageNameCol, info.isDeltaColumn());
                    }
                    case 3: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._totalInstancesCol, info.isDeltaColumn());
                    }
                    case 4: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._liveInstancesCol, info.isDeltaColumn());
                    }
                    case 5: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._collectedInstancesCol, info.isDeltaColumn());
                    }
                    case 6: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._totalSizeCol, info.isDeltaColumn());
                    }
                    case 7: {
                        return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._activeSizeCol, info.isDeltaColumn());
                    }
                }
            } else {
                return null;
            }
            return null;
        }

        protected Image getColumnImageInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            if (obj instanceof TRCClass) {
                return this.getColumnImageClassLevel(obj, col);
            }
            switch (pos) {
                case 0: {
                    return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._instanceNameCol, info.isDeltaColumn());
                }
                case 1: {
                    return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._newItemCol, info.isDeltaColumn());
                }
                case 2: {
                    return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._packageNameCol, info.isDeltaColumn());
                }
                case 3: {
                    return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._collectedInstancesCol, info.isDeltaColumn());
                }
                case 4: {
                    return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._totalSizeCol, info.isDeltaColumn());
                }
                case 5: {
                    return MemoryStatisticView.this.getElementColumnImage(obj, MemoryStatisticView.this._activeSizeCol, info.isDeltaColumn());
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int col) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                return this.getColumnImagePackageLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return this.getColumnImageClassLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return this.getColumnImageInstanceLevel(obj, col);
            }
            return null;
        }
    }

    public class MemoryStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public MemoryStatisticSorter() {
            super(MemoryStatisticView.this);
        }

        protected int comparePackageLevel(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCPackage && e2 instanceof TRCPackage) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                    }
                    case 1: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._newItemCol, this._info.isDeltaColumn());
                    }
                    case 2: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._totalInstancesCol, this._info.isDeltaColumn());
                    }
                    case 3: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._liveInstancesCol, this._info.isDeltaColumn());
                    }
                    case 4: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._collectedInstancesCol, this._info.isDeltaColumn());
                    }
                    case 5: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._totalSizeCol, this._info.isDeltaColumn());
                    }
                    case 6: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._activeSizeCol, this._info.isDeltaColumn());
                    }
                }
                if (MemoryStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)MemoryStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            } else {
                return this.compareClassLevel(viewer, e1, e2);
            }
            return 0;
        }

        protected int compareClassLevel(Viewer viewer, Object e1, Object e2) {
            int pos = MemoryStatisticView.this.getClassPosForLevel(this._pos);
            if (e1 instanceof TRCClass && e2 instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._classNameCol, this._info.isDeltaColumn());
                    }
                    case 1: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._newItemCol, this._info.isDeltaColumn());
                    }
                    case 2: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                    }
                    case 3: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._totalInstancesCol, this._info.isDeltaColumn());
                    }
                    case 4: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._liveInstancesCol, this._info.isDeltaColumn());
                    }
                    case 5: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._collectedInstancesCol, this._info.isDeltaColumn());
                    }
                    case 6: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._totalSizeCol, this._info.isDeltaColumn());
                    }
                    case 7: {
                        return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._activeSizeCol, this._info.isDeltaColumn());
                    }
                }
                if (MemoryStatisticView.this._listOfColumExtension.size() != 0) {
                    ColumnExtensionValue elt = (ColumnExtensionValue)MemoryStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                    return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
                }
            }
            return 0;
        }

        protected int compareInstanceLevel(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCClass) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._instanceNameCol, this._info.isDeltaColumn());
                }
                case 1: {
                    return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._newItemCol, this._info.isDeltaColumn());
                }
                case 2: {
                    return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._packageNameCol, this._info.isDeltaColumn());
                }
                case 3: {
                    return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._collectedInstancesCol, this._info.isDeltaColumn());
                }
                case 4: {
                    return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._totalSizeCol, this._info.isDeltaColumn());
                }
                case 5: {
                    return this._sortSequence * MemoryStatisticView.this.compareElements(e1, e2, MemoryStatisticView.this._activeSizeCol, this._info.isDeltaColumn());
                }
            }
            if (MemoryStatisticView.this._listOfColumExtension.size() != 0) {
                ColumnExtensionValue elt = (ColumnExtensionValue)MemoryStatisticView.this._listOfColumExtension.get(this._pos - _numberOfColumns[_level - 1]);
                return this._sortSequence * elt.getClassOfColumnExtension().compare(elt.getInitialColumnPos(), e1, e2);
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                return this.comparePackageLevel(viewer, e1, e2);
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return this.compareInstanceLevel(viewer, e1, e2);
            }
            return 0;
        }
    }
}

