/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MethodDetailsTab;
import org.eclipse.hyades.trace.views.internal.ContextInfoContainer;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.MethodDetailsStatistic;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MethodDetails {
    protected ContextInfoContainer _contextInfo;
    protected MethodDetailsTab _tabItem;
    protected MethodDetailsStatistic _parentStatistic;
    protected MethodDetailsStatistic _childrenStatistic;
    protected MethodDetailsStatistic _methodStatistic;
    protected Label _parentLabel;
    protected Label _childrenLabel;
    protected Separator fSeparator;
    protected String tmpString;
    protected Composite viewContainer;
    protected ManagedForm mform;
    protected ScrolledForm _form;
    protected TRCMethod _currentSelection = null;
    protected HyadesFormToolkit _toolkit;
    protected Label _info;
    private TableWrapData _visibleLayoutData;
    private TableWrapData _nonVisibleLayoutData;
    boolean _updateCurrentSelection = false;

    public MethodDetails(Composite parent, MethodDetailsTab tabItem) {
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this.fSeparator = new Separator();
        this._tabItem = tabItem;
        this._form = this._toolkit.createScrolledForm(parent);
        this.mform = new ManagedForm((FormToolkit)this._toolkit, this._form);
        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                MethodDetails.this.createFormContent((IManagedForm)MethodDetails.this.mform);
            }
        });
    }

    public Control getControl() {
        return this._form;
    }

    public void refresh() {
        this.update(true);
    }

    public void selectionChanged() {
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (this._parentStatistic.getTree().isFocusControl()) {
            this._parentStatistic.menuAboutToShow(menu);
        } else if (this._childrenStatistic.getTree().isFocusControl()) {
            this._childrenStatistic.menuAboutToShow(menu);
        } else if (this._methodStatistic.getTree().isFocusControl()) {
            this._methodStatistic.menuAboutToShow(menu);
        }
    }

    public void updateButtons() {
        this._tabItem.percentMode().setChecked(this._methodStatistic.isShowPercent());
    }

    public void updateModelSelection() {
        ISelection selection = null;
        if (this._parentStatistic.getTree().isFocusControl()) {
            selection = this._parentStatistic.getTreeViewer().getSelection();
        } else if (this._childrenStatistic.getTree().isFocusControl()) {
            selection = this._childrenStatistic.getTreeViewer().getSelection();
        } else if (this._methodStatistic.getTree().isFocusControl()) {
            selection = this._methodStatistic.getTreeViewer().getSelection();
        }
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this._methodStatistic.notifyViewSelectionChanged(this, sel);
        }
    }

    public void dispose() {
        this._currentSelection = null;
        this._parentStatistic.dispose();
        this._childrenStatistic.dispose();
        this._methodStatistic.dispose();
        this.mform.dispose();
    }

    protected void postUpdateEvents() {
    }

    public boolean isEmpty() {
        return false;
    }

    protected String getViewTypeStr() {
        return "viewoption.methodinvocation";
    }

    public void updateCurrentSelection() {
        this._updateCurrentSelection = true;
    }

    public void update(boolean redraw) {
        IContextViewer contextViewer = this._tabItem.getContextViewer();
        if (contextViewer == null) {
            return;
        }
        contextViewer.getContextSelectionMenuListener().setMOFObject(this._tabItem.getMOFObject());
        if (this._contextInfo != null) {
            this._contextInfo.setMOFObject(this._tabItem.getMOFObject());
        }
        if (redraw) {
            ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._tabItem.getMOFObject());
            Object selection = selModel.getFirstElement();
            if (this._updateCurrentSelection) {
                this._updateCurrentSelection = false;
                this._currentSelection = null;
                if (selection instanceof TRCMethod) {
                    this._currentSelection = (TRCMethod)selection;
                } else if (selection instanceof TRCMethodInvocation) {
                    this._currentSelection = ((TRCMethodInvocation)selection).getMethod();
                }
            }
            this._childrenStatistic.updateUI(this._childrenStatistic.getColumnDataList());
            this._parentStatistic.updateUI(this._parentStatistic.getColumnDataList());
            this._methodStatistic.updateUI(this._methodStatistic.getColumnDataList());
            if (contextViewer.contextChanged()) {
                contextViewer.updateContext();
            }
            this._tabItem.updateTitle();
            if (this._currentSelection == null) {
                this._info.setText(TraceUIMessages._171);
                return;
            }
            if (this._currentSelection.getInvocations().size() == 0) {
                this._info.setText(TraceUIMessages._177);
            } else {
                this._info.setText("");
            }
        }
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._tabItem.getMOFObject()).getFirstElement());
    }

    public MethodDetailsStatistic getChildrenStatistic() {
        return this._childrenStatistic;
    }

    public MethodDetailsStatistic getParentStatistic() {
        return this._parentStatistic;
    }

    public void initialize() {
        this._tabItem.updateTitle();
    }

    public MethodDetailsStatistic getMethodStatistic() {
        return this._methodStatistic;
    }

    public TRCMethod getCurrentSelection() {
        return this._currentSelection;
    }

    public void runShowPercentAction() {
        this.getMethodStatistic().getShowPercentAction().run();
        this.getParentStatistic().getShowPercentAction().run();
        this.getChildrenStatistic().getShowPercentAction().run();
    }

    private void fillBody(IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 5;
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 5;
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        body.setLayout((Layout)layout);
        this._info = this._toolkit.createLabel(body, "", 64);
        this._info.setForeground(Display.getCurrent().getSystemColor(3));
        this.createContextSection(managedForm, body);
        this.createMehodSection(managedForm, body);
        this.createParentSection(managedForm, body);
        this.createChildrenSection(managedForm, body);
    }

    public void updateStatusContext(IContextLanguage language) {
        if (this._contextInfo != null) {
            this._contextInfo.updateStatusContext(language);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this._form = managedForm.getForm();
        this._form.setText(TraceUIPlugin.getString("7"));
        this.fillBody(managedForm);
        this._form.redraw();
        managedForm.refresh();
    }

    private void createParentSection(IManagedForm managedForm, Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TraceUIMessages._174);
        section.marginWidth = 3;
        section.marginHeight = 3;
        this._parentStatistic = new MethodDetailsStatistic((Composite)section, this._tabItem, false);
        this._parentStatistic.setMethodDetailsType(0);
        this._parentStatistic.setContainer(this);
        this._parentStatistic.createContent((Composite)section);
        section.setClient(this._parentStatistic.getControl());
        GridLayout layout = new GridLayout();
        TableWrapData data = new TableWrapData();
        data.grabVertical = true;
        data.grabHorizontal = true;
        data.heightHint = 200;
        section.setLayout((Layout)layout);
        section.setLayoutData((Object)data);
    }

    private void createChildrenSection(IManagedForm managedForm, Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TraceUIMessages._175);
        this._childrenStatistic = new MethodDetailsStatistic((Composite)section, this._tabItem, false);
        this._childrenStatistic.setMethodDetailsType(2);
        this._childrenStatistic.setContainer(this);
        this._childrenStatistic.createContent((Composite)section);
        section.setClient(this._childrenStatistic.getControl());
        GridLayout layout = new GridLayout();
        TableWrapData data = new TableWrapData();
        data.grabVertical = true;
        data.grabHorizontal = true;
        data.heightHint = 250;
        section.setLayout((Layout)layout);
        section.setLayoutData((Object)data);
    }

    private void createMehodSection(IManagedForm managedForm, Composite parent) {
        Section section = this._toolkit.createSection(parent, 256);
        section.setText(TraceUIMessages._176);
        this._methodStatistic = new MethodDetailsStatistic((Composite)section, this._tabItem, false);
        this._methodStatistic.setMethodDetailsType(1);
        this._methodStatistic.setContainer(this);
        this._methodStatistic.createContent((Composite)section);
        section.setClient(this._methodStatistic.getControl());
    }

    private void createContextSection(IManagedForm managedForm, Composite parent) {
        IContextViewer contextViewer = this._tabItem.getContextViewer();
        if (contextViewer != null) {
            final Section section = this._toolkit.createSection(parent, 256);
            section.setText(TraceUIMessages._222);
            this._contextInfo = new ContextInfoContainer();
            this._contextInfo.setViewer(contextViewer);
            section.setClient((Control)this._contextInfo.createControl((Composite)section));
            this._contextInfo.addContextInfoContainerListener(new IContextInfoContainerListener(){

                public void visibilityChanged(boolean isVisible) {
                    section.setLayoutData((Object)(isVisible ? MethodDetails.this.getContextSectionVisibleLayoutData() : MethodDetails.this.getContextSectionNonVisibleLayoutData()));
                    section.setVisible(isVisible);
                    section.getParent().layout(true, true);
                }
            });
        }
    }

    private TableWrapData getContextSectionVisibleLayoutData() {
        if (this._visibleLayoutData == null) {
            this._visibleLayoutData = new TableWrapData();
        }
        return this._visibleLayoutData;
    }

    private TableWrapData getContextSectionNonVisibleLayoutData() {
        if (this._nonVisibleLayoutData == null) {
            this._nonVisibleLayoutData = new TableWrapData();
            this._nonVisibleLayoutData.heightHint = 0;
        }
        return this._nonVisibleLayoutData;
    }
}

