/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternTab;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.MethodInvocationStatistic;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;

public class MethodInvocationDetails {
    protected SinglePatternTab _tabItem;
    protected HyadesFormToolkit _toolkit;
    protected Form _form;
    protected SinglePattern _invocationGraph;
    protected MethodInvocationStatistic _invocationStatistic;
    protected Separator fSeparator;

    public MethodInvocationDetails(Composite parent, SinglePatternTab tabItem) {
        this._toolkit = new HyadesFormToolkit(parent.getDisplay());
        this._form = this._toolkit.createForm(parent);
        this._form.setText(TraceUIPlugin.getString("5"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        this._form.setLayoutData((Object)new GridData(4, 4, true, true));
        this._form.getBody().setLayout((Layout)gridLayout);
        this._form.getBody().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fSeparator = new Separator();
        this._tabItem = tabItem;
        SashForm _sashForm = new SashForm(this._form.getBody(), 512);
        _sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = this._toolkit.createComposite((Composite)_sashForm);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._invocationGraph = new SinglePattern(composite, this._tabItem, true);
        this._invocationStatistic = new MethodInvocationStatistic((Composite)_sashForm, this._tabItem);
    }

    public Control getControl() {
        return this._form;
    }

    public void refresh() {
        this.update();
    }

    public void selectionChanged() {
        this._invocationStatistic.selectionChanged();
        this._invocationGraph.selectionChanged();
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (this._invocationGraph.getCanvas() != null && this._invocationGraph.getCanvas().getControl() != null && this._invocationGraph.getCanvas().getControl().isFocusControl()) {
            this._invocationGraph.menuAboutToShow(menu);
        } else {
            this.addInvocationStatisticMenu(menu);
        }
    }

    protected void addInvocationStatisticMenu(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._invocationStatistic.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._invocationStatistic.getChooseColumnsAction(this._invocationStatistic.getColumnDataList(), this._invocationStatistic.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
    }

    public void updateModelSelection() {
        ISelection selection = this._invocationStatistic.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this._invocationStatistic.notifyViewSelectionChanged(this, sel);
        }
    }

    public void dispose() {
        this._invocationGraph.dispose();
        this._invocationStatistic.dispose();
        this._form.dispose();
        this._toolkit.dispose();
    }

    protected void postUpdateEvents() {
    }

    public boolean isEmpty() {
        int size = 0;
        ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(this._tabItem.getMOFObject());
        if (selModel.size() > 0) {
            Object obj = selModel.getFirstElement();
            if (obj instanceof TRCMethod) {
                size = ((TRCMethod)obj).getInvocations().toArray().length;
            }
            if (obj instanceof TRCMethodInvocation) {
                size = ((TRCMethodInvocation)obj).getMethod().getInvocations().toArray().length;
            }
        }
        return size <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.methodinvocation";
    }

    public void update() {
        this._invocationGraph.update(true);
        this._invocationStatistic.refresh();
    }

    public void update(boolean redraw) {
        this._invocationGraph.update(redraw);
        if (redraw) {
            this._invocationStatistic.updateUI(this._invocationStatistic.getColumnDataList());
        }
    }

    public void initialize() {
        this._invocationGraph.initialize();
    }

    public JCanvas getCanvas() {
        return this._invocationGraph.getCanvas();
    }

    public void updateUI() {
        this._invocationGraph.updateUI();
    }

    public void zoomOut(boolean zoom) {
        this._invocationGraph.zoomOut(zoom);
    }

    public void zoomIn(boolean zoom) {
        this._invocationGraph.zoomIn(zoom);
    }

    public void previous() {
        this._invocationGraph.previous();
    }

    public void next() {
        this._invocationGraph.next();
    }

    public void showCaller() {
        this._invocationGraph.showCaller();
    }

    public void showCallee() {
        this._invocationGraph.showCallee();
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._tabItem.getMOFObject()).getFirstElement());
    }

    public MethodInvocationStatistic getInvocationStatistic() {
        return this._invocationStatistic;
    }

    public SinglePattern getInvocationGraph() {
        return this._invocationGraph;
    }
}

