/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticViewer;
import org.eclipse.hyades.trace.views.internal.ContextInfoContainer;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnExtensionValue;
import org.eclipse.hyades.trace.views.util.internal.IColumnExtension;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiLevelStatisticView
extends StatisticView {
    protected ContextInfoContainer _contextInfo;
    public static final int PACKAGE_LEVEL = 1;
    public static final int CLASS_LEVEL = 2;
    public static final int DEFAULT_LEVEL = 1;
    public static String PREFERENCE_KEY_PREFIX = "org.eclipse.hyades.trace.views.multilevel.";
    private boolean _isEmpty;

    public MultiLevelStatisticView(Composite parent, TraceViewerPage page, boolean initializeContent) {
        this(false, parent, page, initializeContent);
    }

    public MultiLevelStatisticView(Composite parent, TraceViewerPage page) {
        this(false, parent, page, true);
    }

    public MultiLevelStatisticView(boolean lazyMode, Composite parent, TraceViewerPage page, boolean initializeContent) {
        super(lazyMode, parent, page, initializeContent);
        this._viewerFilter = this.getFilterInstance();
    }

    public MultiLevelStatisticView(boolean lazyMode, Composite parent, TraceViewerPage page) {
        this(lazyMode, parent, page, true);
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }

    public abstract boolean isEmptyUpdate();

    @Override
    public abstract String getColumnsPreferencesKey();

    protected abstract String getDefaultColumnsTemplatePackageLevel();

    protected abstract String getDefaultColumnsTemplateClassLevel();

    protected abstract StatisticView.StatisticFilter getFilterInstance();

    @Override
    public abstract IContentProvider getContentProvider();

    @Override
    public abstract LabelProvider getTableLabelProvider();

    @Override
    protected abstract StatisticView.StatisticSorter getViewerSorterInstance();

    public abstract int getLevel();

    public abstract void setLevel(int var1);

    @Override
    protected abstract String getViewTypeStr();

    @Override
    protected Composite createTree(Composite parent, int options) {
        return this._toolkit.createTree(parent, options);
    }

    @Override
    protected TreeViewer getTreeViewer(Tree tree) {
        return new MultiLevelStatisticTreeViewer(tree);
    }

    @Override
    protected void openSourceForSelection(ISelection selection) {
        MultiLevelStatisticViewer viewer;
        TraceViewer traceViewer;
        TraceViewerPage page;
        if (selection != null && (page = this.getTraceViewerPage()) != null && (traceViewer = page.getTraceViewer()) instanceof MultiLevelStatisticViewer && (viewer = (MultiLevelStatisticViewer)page.getTraceViewer()) != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    viewer.openSource().run();
                }
            });
        }
    }

    @Override
    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected boolean canOpenSourceOnThisObject() {
        ITraceSelection _model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (_model.size() == 0 || _model.getFirstElement() == null) {
            return false;
        }
        Object firstElement = _model.getFirstElement();
        if (firstElement instanceof TRCClass && ((TRCClass)firstElement).getSourceInfo() != null && ((TRCClass)firstElement).getSourceInfo().getLocation().length() > 0) {
            return true;
        }
        return firstElement instanceof TRCMethod;
    }

    public String getColumnsTemplateExtensions(int strColumnNumbers, String matchView, boolean nullViewValue) {
        IConfigurationElement[] members;
        String columnName = "";
        String pos = "";
        String style = "";
        String width = "";
        String align = "";
        String viewId = "";
        int colNumber = strColumnNumbers;
        boolean extendColumn = false;
        this._templateOfColumExtension = "";
        this._listOfColumExtension.clear();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.hyades.trace.views", "columnExtension");
        if (extPoint != null && (members = extPoint.getConfigurationElements()).length != 0) {
            int i = 0;
            while (i < members.length) {
                columnName = members[i].getAttribute("name");
                pos = members[i].getAttribute("pos");
                style = members[i].getAttribute("style");
                width = members[i].getAttribute("width");
                align = members[i].getAttribute("align");
                IConfigurationElement[] applyToView = members[i].getChildren("applyTo");
                extendColumn = false;
                if (applyToView != null) {
                    int k = 0;
                    while (k < applyToView.length) {
                        viewId = applyToView[k].getAttribute("viewId");
                        if (viewId.equalsIgnoreCase(matchView)) {
                            extendColumn = true;
                            break;
                        }
                        ++k;
                    }
                }
                if (extendColumn || nullViewValue && (applyToView == null || applyToView.length == 0)) {
                    this._templateOfColumExtension = String.valueOf(this._templateOfColumExtension) + "," + columnName + ":" + colNumber + ":" + style + ":" + align + ":" + width;
                    ++colNumber;
                    try {
                        ColumnExtensionValue columnVal = new ColumnExtensionValue();
                        columnVal.setClassOfColumnExtension((IColumnExtension)members[i].createExecutableExtension("class"));
                        columnVal.setInitialColumnPos(new Integer(pos));
                        this._listOfColumExtension.add(columnVal);
                    }
                    catch (CoreException e) {
                        System.err.println((Object)e);
                    }
                }
                ++i;
            }
        }
        return this._templateOfColumExtension;
    }

    @Override
    public String getDefaultColumnsTemplate() {
        String columns = null;
        if (this.getLevel() == 0 || this.getLevel() == 1) {
            columns = this.getDefaultColumnsTemplatePackageLevel();
        } else if (this.getLevel() == 2) {
            columns = this.getDefaultColumnsTemplateClassLevel();
        }
        return columns;
    }

    @Override
    protected void doHandleSelectionEvent(boolean isPostponedOperation, int processedOperations) {
        Object sel;
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0 && (sel = model.getFirstElement()) != null) {
            this.select(sel);
            if (sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    private void select(Object obj) {
        TRCClass cls = null;
        TRCPackage pack = null;
        TRCMethod meth = null;
        TRCObject trcObj = null;
        Tree tree = (Tree)this.getTreeViewer().getControl();
        TreeItem[] items = tree.getItems();
        if (items.length != 0) {
            if (obj instanceof TRCPackage) {
                pack = (TRCPackage)obj;
            } else if (obj instanceof TRCClass) {
                cls = (TRCClass)obj;
                pack = cls.getPackage();
            } else if (obj instanceof TRCMethod) {
                meth = (TRCMethod)obj;
                cls = meth.getDefiningClass();
                if (cls != null) {
                    pack = cls.getPackage();
                }
            } else if (obj instanceof TRCObject) {
                cls = ((TRCObject)obj).getIsA();
                pack = cls.getPackage();
                trcObj = (TRCObject)obj;
            } else if (obj instanceof TRCMethodInvocation && (cls = PerftraceUtil.getClass((TRCMethodInvocation)((TRCMethodInvocation)obj))) != null) {
                pack = cls.getPackage();
            }
            this.searchInLevel(tree, this.getItemsRoot(tree), pack, cls, meth, trcObj);
        }
    }

    protected TreeItem getItemsRoot(Tree tree) {
        return null;
    }

    protected void searchInPackageLevel(Tree tree, TreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        TreeItem pacItem = null;
        TreeItem[] pacItems = null;
        pacItems = item != null ? item.getItems() : tree.getItems();
        pacItem = this.searchItem(pacItems, pack);
        if (pacItem != null) {
            if (cls == null) {
                tree.setSelection(new TreeItem[]{pacItem});
                return;
            }
            ((MultiLevelStatisticTreeViewer)this.getTreeViewer()).expandItem(pacItem);
            this.searchInClassLevel(tree, pacItem, cls, meth, trcObj);
            return;
        }
        if (item != null) {
            tree.setSelection(new TreeItem[]{item});
            return;
        }
        tree.deselectAll();
    }

    protected void searchInClassLevel(Tree tree, TreeItem item, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        TreeItem[] classItems = null;
        TreeItem classItemBis = null;
        classItems = item != null ? item.getItems() : tree.getItems();
        classItemBis = this.searchItem(classItems, cls);
        if (classItemBis != null) {
            if (meth == null && trcObj == null) {
                tree.setSelection(new TreeItem[]{classItemBis});
                return;
            }
            ((MultiLevelStatisticTreeViewer)this.getTreeViewer()).expandItem(classItemBis);
            if (trcObj != null) {
                this.searchInObjectLevel(tree, classItemBis, trcObj);
                return;
            }
            if (meth != null) {
                this.searchInMethodLevel(tree, classItemBis, meth);
                return;
            }
        } else if (item != null) {
            tree.setSelection(new TreeItem[]{item});
            return;
        }
        tree.deselectAll();
    }

    protected void searchInMethodLevel(Tree tree, TreeItem item, TRCMethod meth) {
        TreeItem[] methodItems = null;
        methodItems = item != null ? item.getItems() : tree.getItems();
        TreeItem methodItem = this.searchItem(methodItems, meth);
        if (methodItem != null) {
            tree.setSelection(new TreeItem[]{methodItem});
            return;
        }
        if (item != null) {
            tree.setSelection(new TreeItem[]{item});
            return;
        }
        tree.deselectAll();
    }

    protected void searchInObjectLevel(Tree tree, TreeItem item, TRCObject obj) {
        TreeItem[] objItems = null;
        objItems = item != null ? item.getItems() : tree.getItems();
        TreeItem objItem = this.searchItem(objItems, obj);
        if (objItem != null) {
            tree.setSelection(new TreeItem[]{objItem});
            return;
        }
        if (item != null) {
            tree.setSelection(new TreeItem[]{item});
            return;
        }
        tree.deselectAll();
    }

    protected void searchInLevel(Tree tree, TreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        switch (this.getLevel()) {
            case 1: {
                this.searchInPackageLevel(tree, item, pack, cls, meth, null);
                break;
            }
            case 2: {
                if (cls == null) break;
                this.searchInClassLevel(tree, item, cls, meth, null);
            }
        }
    }

    protected Object getItemModelData(TreeItem item) {
        return item.getData();
    }

    protected TreeItem searchItem(TreeItem[] items, Object obj) {
        TreeItem item = null;
        int j = 0;
        while (j < items.length) {
            item = items[j];
            if (item != null && !item.isDisposed() && item.getData() != null && obj == this.getItemModelData(item)) {
                return item;
            }
            ++j;
        }
        return null;
    }

    @Override
    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            if (sel instanceof MethodCallDetails) {
                this.notifyViewSelectionChanged(this, ((MethodCallDetails)sel).getMethod());
            } else {
                this.notifyViewSelectionChanged(this, sel);
            }
        }
    }

    @Override
    protected void doHandleViewSelectionChangedEvent(ViewSelectionChangedEvent event, boolean isPostponedOperation, int processedOperations) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        } else {
            Object sel;
            ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
            if (model.size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    @Override
    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        this.resetChooseColumnsAction();
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
        menu.add((IAction)this.getSortByColumnAction());
    }

    public void redrawTable() {
        this.getTree().setRedraw(false);
        ArrayList<ColumnData> list = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        TreeColumn[] treeColumns = this.getTree().getColumns();
        LinkedList<Integer> widthInfor = new LinkedList<Integer>();
        LinkedList<String> columnNames = new LinkedList<String>();
        int i = 0;
        while (i < treeColumns.length) {
            widthInfor.add(new Integer(treeColumns[i].getWidth()));
            columnNames.add(treeColumns[i].getText());
            ++i;
        }
        this.resetColumns(list);
        i = 0;
        while (i < this.getTree().getColumns().length) {
            int j = 0;
            while (j < columnNames.size()) {
                if (((String)columnNames.get(j)).equals(this.getTree().getColumn(i).getText())) {
                    this.getTree().getColumn(i).setWidth(((Integer)widthInfor.get(j)).intValue());
                    StatisticTableColumnInfo treeColumnInfo = this.getColumnInfo(this.getTree().getColumn(i));
                    int index = this.getColumnIndexByColumnKey(list, treeColumnInfo.getColumnData().key());
                    if (index == -1) break;
                    list.get(index).width((Integer)widthInfor.get(j));
                    break;
                }
                ++j;
            }
            ++i;
        }
        this._currentColumns = list;
        this.getTree().setRedraw(true);
        this.refresh();
    }

    private int getColumnIndexByColumnKey(ArrayList<ColumnData> columnData, String key) {
        if (columnData == null) {
            return -1;
        }
        int i = 0;
        while (i < columnData.size()) {
            if (columnData.get(i).key().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected void resetColumns(ArrayList list) {
        super.resetColumns(list);
        this.expandFirstElement();
    }

    protected void resetChooseColumnsAction() {
        this._chooseColumnAction = null;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void doUpdateButtons(boolean isPostponedOperation, int processedOperations) {
        ((MultiLevelStatisticPage)this.getTraceViewerPage()).updateButtons(this.getLevel());
        ((MultiLevelStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
    }

    @Override
    protected void doUpdate(boolean refresh, boolean isPostponedOperation, int processedOperations) {
        if (this._page instanceof MultiLevelStatisticPage && this._contextInfo != null) {
            this._contextInfo.setMOFObject(this._page.getMOFObject());
        }
        super.doUpdate(refresh, isPostponedOperation, processedOperations);
        if (this._page instanceof MultiLevelStatisticPage) {
            ((MultiLevelStatisticPage)this._page).updateFilterAppliedDescription();
            this._isEmpty = this.isEmptyUpdate();
        }
        Tree tree = this.getTree();
        this.setLinesVisible(tree);
        this._viewerSorter = this.getViewerSorterInstance();
        if (_previousColumnText != null) {
            int i = 0;
            while (i < tree.getColumnCount()) {
                if (tree.getColumn(i).getText().equals(_previousColumnText)) {
                    this._viewerSorter.setSortedColumn(_previousSequence, tree.getColumn(i));
                    return;
                }
                ++i;
            }
        }
    }

    protected SimpleSearchQuery getCurrentFilter() {
        if (this._page instanceof MultiLevelStatisticPage) {
            return ((MultiLevelStatisticPage)this._page).getCurrentFilter();
        }
        return null;
    }

    @Override
    protected Composite createControl(Composite parent, ArrayList cols) {
        final Composite vc = super.createControl(parent, cols);
        if (this._page.getTraceViewer() instanceof MultiLevelStatisticViewer) {
            this._contextInfo = new ContextInfoContainer();
            this._contextInfo.setViewer((IContextViewer)this._page.getTraceViewer());
            this._contextInfo.createControl(vc);
            this._contextInfo.addContextInfoContainerListener(new IContextInfoContainerListener(){

                public void visibilityChanged(boolean isVisible) {
                    vc.layout(true, true);
                }
            });
        }
        return vc;
    }

    protected void updateStatusContext(IContextLanguage language) {
        if (this._contextInfo != null) {
            this._contextInfo.updateStatusContext(language);
        }
    }

    @Override
    protected void handleHidden() {
        super.handleHidden();
    }

    @Override
    protected void handleVisible() {
        super.handleVisible();
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
    }

    @Override
    public SelectionListener getSelectionListener() {
        return new MultiLevelStatisticViewSelectionListener();
    }

    public abstract class MultiLevelStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public abstract Object[] getElements(Object var1);

        public Object[] getChildren(Object element) {
            return new ArrayList().toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }
    }

    public abstract class MultiLevelStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MultiLevelStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public abstract String getColumnText(Object var1, int var2);
    }

    public abstract class MultiLevelStatisticSorter
    extends StatisticView.StatisticSorter {
        public MultiLevelStatisticSorter() {
            super(MultiLevelStatisticView.this);
        }

        public abstract int compare(Viewer var1, Object var2, Object var3);
    }

    class MultiLevelStatisticTreeViewer
    extends TreeViewer {
        public MultiLevelStatisticTreeViewer(Composite parent) {
            super(parent);
        }

        public MultiLevelStatisticTreeViewer(Tree tree) {
            super(tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }

        public ISelection getSelection() {
            Object obj;
            ISelection sel = super.getSelection();
            if (sel != null && !sel.isEmpty() && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof MethodCallDetails) {
                TRCMethod m = ((MethodCallDetails)obj).getMethod();
                if (m == null) {
                    return null;
                }
                return new StructuredSelection((Object)m);
            }
            return sel;
        }
    }

    class MultiLevelStatisticViewSelectionListener
    extends StatisticView.StatViewSelectionListener {
        public MultiLevelStatisticViewSelectionListener() {
            super(MultiLevelStatisticView.this);
        }

        public void widgetSelected(SelectionEvent arg0) {
            super.widgetSelected(arg0);
            if (arg0.widget instanceof TableColumn) {
                MultiLevelStatisticView.this.expandFirstElement();
                MultiLevelStatisticView.this.handleSelectionEvent();
            }
        }
    }
}

