/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.ContextInfoContainer;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.internal.IContextInfoContainerListener;
import org.eclipse.hyades.trace.views.internal.StatisticCellLabelProvider;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ClassNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.InstanceNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.NumberReferencesColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PackageNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ReferenceDetailColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ReferenceSizeColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.IFTRCClass;
import org.eclipse.hyades.trace.views.util.internal.IFTRCObject;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ReferenceTable
extends StatisticView
implements IRefChangedListener {
    private static boolean USE_NEW_FILTERING_FOR_GET_REF = false;
    private static boolean USE_NEW_FILTERING_FOR_GET_CHILDREN = false;
    protected ContextInfoContainer _contextInfo;
    protected int _drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
    private TRCClassImpl.TRCClassSnapshot classSnapshot = new TRCClassImpl.TRCClassSnapshot();
    protected ColumnLabelAdapter _classNameCol;
    protected ColumnLabelAdapter _packageNameCol;
    protected ColumnLabelAdapter _refSizeCol;
    protected ColumnLabelAdapter _instanceNameCol;
    protected ColumnLabelAdapter _numRefsCol;
    protected ColumnLabelAdapter _numRefsInstCol;

    protected Composite createTree(Composite parent, int options) {
        return this._toolkit.createTree(parent, options);
    }

    public ReferenceTable(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new ClassStatisticFilter();
        TraceUIPlugin.getDefault().addRefChangedEventListener(this);
        this.createColumnsLabelProviders();
    }

    protected String getContextHelpId() {
        return String.valueOf(TraceUIPlugin.getPluginId()) + ".rfst0000";
    }

    public void createColumnsLabelProviders() {
        this._classNameCol = new ClassNameColumnLabel();
        this._packageNameCol = new PackageNameColumnLabel();
        this._refSizeCol = new ReferenceSizeColumnLabel();
        ContextUpdaterHelper.addSnapshots(this._refSizeCol, null, this.classSnapshot, null);
        this._instanceNameCol = new InstanceNameColumnLabel();
        this._numRefsCol = new NumberReferencesColumnLabel();
        this._numRefsInstCol = new ReferenceDetailColumnLabel();
    }

    public String getColumnsPreferencesKey() {
        return "Ref63";
    }

    public String getDefaultColumnsTemplate() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        String name = TraceUIMessages._109;
        if (this.showReferTo()) {
            name = TraceUIMessages._108;
        }
        String executionColumn = String.valueOf(name) + ":0:" + String.valueOf(7) + ":left:200," + "package.name" + ":1:" + String.valueOf(1) + ":left:150," + "ref.size" + ":2:" + String.valueOf(1) + ":right:100," + "ref.number.by" + ":3:" + String.valueOf(1) + ":left:170," + "ref.details.by" + ":4:" + String.valueOf(1) + ":left:350";
        return executionColumn;
    }

    protected IContentProvider getContentProvider() {
        return new ObjReferenceContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ObjReferenceLabelProvider(this);
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected TreeViewer getTreeViewer(Tree tree) {
        return new ReferenceTreeViewer(tree);
    }

    protected void handleSelectionEvent() {
        ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(true);
            Object sel = model.getFirstElement();
            if (!(sel instanceof TRCPackage)) {
                ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(true);
            }
            this.select(sel);
            if (sel instanceof TRCObject) {
                sel = ((TRCObject)sel).getIsA();
            } else if (sel instanceof TRCClass) {
                this.select((TRCClass)sel);
            }
            if (sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
        menu.add((IAction)this.getSortByColumnAction());
    }

    private void select(Object sel) {
        TRCClass cls = null;
        TRCObject obj = null;
        if (sel instanceof TRCClass) {
            cls = (TRCClass)sel;
        } else if (sel instanceof TRCObject) {
            obj = (TRCObject)sel;
            cls = obj.getIsA();
        }
        if (cls == null) {
            return;
        }
        Tree tree = (Tree)this.getTreeViewer().getControl();
        TreeItem[] items = tree.getItems();
        TRCClass clsItem = null;
        int idx = 0;
        while (idx < items.length) {
            TreeItem item = items[idx];
            if (item.getData() instanceof TRCClass) {
                clsItem = (TRCClass)item.getData();
            }
            if (item.getData() instanceof TRCObject) {
                clsItem = ((TRCObject)item.getData()).getIsA();
            }
            if (clsItem != null && clsItem.getId() == cls.getId()) {
                ((ReferenceTreeViewer)this.getTreeViewer()).expandItem(item);
                if (obj == null) {
                    tree.setSelection(new TreeItem[]{item});
                    this.setNewSelection();
                    return;
                }
                TreeItem[] childItems = item.getItems();
                int i = 0;
                while (i < childItems.length) {
                    TreeItem childItem = childItems[i];
                    if (childItem.getData().equals(obj)) {
                        tree.setSelection(new TreeItem[]{childItem});
                        this.setNewSelection();
                        return;
                    }
                    ++i;
                }
            }
            ++idx;
        }
    }

    public void updateButtons() {
        ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
    }

    private boolean canOpenSourceOnThisObject() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() == 0 || model.getFirstElement() == null) {
            return false;
        }
        Object sel = model.getFirstElement();
        return sel instanceof TRCClass;
    }

    protected void updateDetailsPane() {
        int selCount = this.getTree().getSelectionCount();
        if (selCount != 1) {
            return;
        }
        TreeItem item = this.getTree().getSelection()[0];
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TreeItem) {
            itemData = ((TreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object itemData = ((IStructuredSelection)selection).getFirstElement();
            if (itemData instanceof TRCObjectReference) {
                itemData = this.showReferTo() ? ((TRCObjectReference)itemData).getOwner() : ((TRCObjectReference)itemData).getTarget();
            }
            this.notifyViewSelectionChanged(this, itemData);
        }
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ObjReferenceSorter();
    }

    protected void setLinesVisible(Tree tree) {
        tree.setLinesVisible(false);
    }

    public void update() {
        this.resetColumns();
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (this._page instanceof ReferenceTablePage && this._contextInfo != null) {
            this._contextInfo.setMOFObject(this._page.getMOFObject());
        }
        super.update();
        ((ReferenceTablePage)this._page).updateFilterAppliedDescription();
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeRefChangedEventListener(this);
        super.dispose();
    }

    public void handleRefChangedEvent() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        Tree tree = this.getTree();
        TreeColumn firstColumn = tree.getColumn(0);
        String text = firstColumn.getText();
        String name = TraceUIMessages._109;
        if (this.showReferTo()) {
            name = TraceUIMessages._108;
        }
        if (text.startsWith(">") || text.startsWith("<")) {
            firstColumn.setText(String.valueOf(text.substring(0, 1)) + name);
        } else {
            firstColumn.setText(name);
        }
        Action referands = ((ReferenceTablePage)this.getTraceViewerPage()).referands();
        Action referee = ((ReferenceTablePage)this.getTraceViewerPage()).referee();
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (referands != null) {
            referands.setChecked(ref == 0);
        }
        if (referee != null) {
            referee.setChecked(ref == 1);
        }
        this.update();
    }

    private boolean showReferTo() {
        return this._drawmode == 0;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        } else {
            Object sel;
            ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
            if (model.size() > 0 && (sel = model.getFirstElement()) != null && sel instanceof EObject) {
                this.updateStatusContext(ContextManager.getContextLanguage((String)ContextUpdaterHelper.getContext((EObject)sel)));
            }
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses((EObject)this._page.getMOFObject()).length <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.reference";
    }

    protected SimpleSearchQuery getCurrentFilter() {
        return ((ReferenceTablePage)this._page).getCurrentFilter();
    }

    protected ColumnDisplayInfo getColumnDisplayInfo(ColumnLabelAdapter col, boolean isDeltaColumn) {
        if (col == this._packageNameCol) {
            return ContextUpdaterHelper.updatePackageName(col, this._page.getMOFObject());
        }
        return ContextUpdaterHelper.updateRefCol(col, this.showReferTo());
    }

    protected Composite createControl(Composite parent, ArrayList cols) {
        final Composite vc = super.createControl(parent, cols);
        this._contextInfo = new ContextInfoContainer();
        this._contextInfo.setViewer((IContextViewer)this._page.getTraceViewer());
        this._contextInfo.createControl(vc);
        this._contextInfo.addContextInfoContainerListener(new IContextInfoContainerListener(){

            public void visibilityChanged(boolean isVisible) {
                vc.layout(true, true);
            }
        });
        return vc;
    }

    protected void updateStatusContext(IContextLanguage language) {
        if (this._contextInfo != null) {
            this._contextInfo.updateStatusContext(language);
        }
    }

    protected void resetColumns() {
        this._classNameCol.resetMap();
        this._packageNameCol.resetMap();
        this._refSizeCol.resetMap();
        this._instanceNameCol.resetMap();
        this._numRefsCol.resetMap();
        this._numRefsInstCol.resetMap();
    }

    public CellLabelProvider getCellLabelProvider(ColumnData colData) {
        return new ObjReferenceCellLabelProvider(colData);
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ReferenceTable.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCClass)) {
                return true;
            }
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTRCClassData
    implements IFTRCClass {
        private TRCClass cls = null;

        public MyTRCClassData(TRCClass o) {
            this.cls = o;
        }

        public TRCClass getTRCClass() {
            return this.cls;
        }

        public long getId() {
            return this.cls.getId();
        }

        public void setId(long value) {
            this.cls.setId(value);
        }

        public String getName() {
            return this.cls.getName();
        }

        public void setName(String value) {
            this.cls.setName(value);
        }

        public int getSize() {
            return this.cls.getSize();
        }

        public void setSize(int value) {
            this.cls.setSize(value);
        }

        public double getLoadTime() {
            return this.cls.getLoadTime();
        }

        public void setLoadTime(double value) {
            this.cls.setLoadTime(value);
        }

        public double getUnloadTime() {
            return this.cls.getUnloadTime();
        }

        public void setUnloadTime(double value) {
            this.cls.setUnloadTime(value);
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }

        public void setInterface(boolean value) {
            this.cls.setInterface(value);
        }

        public int getLineNo() {
            return this.cls.getLineNo();
        }

        public void setLineCount(int value) {
            this.cls.setLineCount(value);
        }

        public int getLineCount() {
            return this.cls.getLineCount();
        }

        public void setLineNo(int value) {
            this.cls.setLineNo(value);
        }

        public double getBaseTime() {
            return this.cls.getBaseTime();
        }

        public void setBaseTime(double value) {
            this.cls.setBaseTime(value);
        }

        public double getCumulativeTime() {
            return this.cls.getCumulativeTime();
        }

        public void setCumulativeTime(double value) {
            this.cls.setCumulativeTime(value);
        }

        public int getCalls() {
            return this.cls.getCalls();
        }

        public void setCalls(int value) {
            this.cls.setCalls(value);
        }

        public int getInheritedCalls() {
            return this.cls.getInheritedCalls();
        }

        public void setInheritedCalls(int value) {
            this.cls.setInheritedCalls(value);
        }

        public double getInheritedBaseTime() {
            return this.cls.getInheritedBaseTime();
        }

        public void setInheritedBaseTime(double value) {
            this.cls.setInheritedBaseTime(value);
        }

        public double getInheritedCumulativeTime() {
            return this.cls.getInheritedCumulativeTime();
        }

        public void setInheritedCumulativeTime(double value) {
            this.cls.setInheritedCumulativeTime(value);
        }

        public int getTotalSize() {
            return this.cls.getTotalSize();
        }

        public void setTotalSize(int value) {
            this.cls.setTotalSize(value);
        }

        public int getTotalInstances() {
            return this.cls.getTotalInstances();
        }

        public void setTotalInstances(int value) {
            this.cls.setTotalInstances(value);
        }

        public int getCollectedSize() {
            return this.cls.getCollectedSize();
        }

        public void setCollectedSize(int value) {
            this.cls.setCollectedSize(value);
        }

        public int getCollectedInstances() {
            return this.cls.getCollectedInstances();
        }

        public void setCollectedInstances(int value) {
            this.cls.setCollectedInstances(value);
        }

        public double getTotalCpuTime() {
            return this.cls.getTotalCpuTime();
        }

        public void setTotalCpuTime(double value) {
            this.cls.setTotalCpuTime(value);
        }

        public EList getObjects() {
            return this.cls.getObjects();
        }

        public TRCThread getLoadedBy() {
            return this.cls.getLoadedBy();
        }

        public void setLoadedBy(TRCThread value) {
            this.cls.setLoadedBy(value);
        }

        public EList getMethods() {
            return this.cls.getMethods();
        }

        public EList getClassObjects() {
            return this.cls.getClassObjects();
        }

        public TRCPackage getPackage() {
            return this.cls.getPackage();
        }

        public void setPackage(TRCPackage value) {
            this.cls.setPackage(value);
        }

        public TRCClassLoader getClassLoader() {
            return this.cls.getClassLoader();
        }

        public void setClassLoader(TRCClassLoader value) {
            this.cls.setClassLoader(value);
        }

        public TRCSourceInfo getSourceInfo() {
            return this.cls.getSourceInfo();
        }

        public void setSourceInfo(TRCSourceInfo value) {
            this.cls.setSourceInfo(value);
        }

        public TRCClass getEnclosedBy() {
            return this.cls.getEnclosedBy();
        }

        public void setEnclosedBy(TRCClass value) {
            this.cls.setEnclosedBy(value);
        }

        public EList getExtends() {
            return this.getExtends();
        }

        public EList getImplements() {
            return this.getImplements();
        }

        public EList getLocks() {
            return this.getLocks();
        }

        public EClass eClass() {
            return this.cls.eClass();
        }

        public Resource eResource() {
            return this.cls.eResource();
        }

        public EObject eContainer() {
            return this.cls.eContainer();
        }

        public EStructuralFeature eContainingFeature() {
            return this.cls.eContainingFeature();
        }

        public EReference eContainmentFeature() {
            return this.cls.eContainmentFeature();
        }

        public EList eContents() {
            return this.cls.eContents();
        }

        public TreeIterator eAllContents() {
            return this.cls.eAllContents();
        }

        public boolean eIsProxy() {
            return this.cls.eIsProxy();
        }

        public EList eCrossReferences() {
            return this.cls.eCrossReferences();
        }

        public Object eGet(EStructuralFeature feature) {
            return this.cls.eGet(feature);
        }

        public Object eGet(EStructuralFeature feature, boolean resolve) {
            return this.cls.eGet(feature, resolve);
        }

        public void eSet(EStructuralFeature feature, Object newValue) {
            this.cls.eSet(feature, newValue);
        }

        public boolean eIsSet(EStructuralFeature feature) {
            return this.cls.eIsSet(feature);
        }

        public void eUnset(EStructuralFeature feature) {
            this.cls.eUnset(feature);
        }

        public EList eAdapters() {
            return this.cls.eAdapters();
        }

        public boolean eDeliver() {
            return this.cls.eDeliver();
        }

        public void eSetDeliver(boolean deliver) {
            this.cls.eSetDeliver(deliver);
        }

        public void eNotify(Notification notification) {
            this.cls.eNotify(notification);
        }

        public void takeSnapshot() {
            this.cls.takeSnapshot();
        }

        public ISnapshot retrieveSnapshot() {
            return this.cls.retrieveSnapshot();
        }

        public void removeSnapshot() {
            this.cls.removeSnapshot();
        }

        public int computeDelta(IDelta delta) {
            return this.cls.computeDelta(delta);
        }

        public int computeDelta(IDelta delta, int featureID) {
            return this.cls.computeDelta(delta, featureID);
        }

        public boolean testAttribute(Object target, String name, String value) {
            return true;
        }

        public TRCPrimitiveType getArrayType() {
            return this.cls instanceof TRCArrayClass ? ((TRCArrayClass)this.cls).getArrayType() : null;
        }

        public void setArrayType(TRCPrimitiveType value) {
            if (this.cls instanceof TRCArrayClass) {
                ((TRCArrayClass)this.cls).setArrayType(value);
            }
        }

        public TRCClass getElementType() {
            return this.cls instanceof TRCArrayClass ? ((TRCArrayClass)this.cls).getElementType() : null;
        }

        public void setElementType(TRCClass value) {
            if (this.cls instanceof TRCArrayClass) {
                ((TRCArrayClass)this.cls).setElementType(value);
            }
        }

        public EList getAnnotations() {
            return this.cls.getAnnotations();
        }

        public Object eInvoke(EOperation arg0, EList<?> arg1) throws InvocationTargetException {
            return this.cls instanceof TRCArrayClass ? ((TRCArrayClass)this.cls).eInvoke(arg0, arg1) : null;
        }

        public int getCumulativeSize() {
            return this.cls.getCumulativeSize();
        }

        public void setCumulativeSize(int value) {
            this.cls.setCumulativeSize(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTRCObjectData
    implements IFTRCObject {
        private TRCObject obj;

        public MyTRCObjectData(TRCObject o) {
            this.obj = o;
        }

        public TRCObject getTRCObject() {
            return this.obj;
        }

        public long getId() {
            return this.obj.getId();
        }

        public void setId(long value) {
            this.obj.setId(value);
        }

        public int getSize() {
            return this.obj.getSize();
        }

        public void setSize(int value) {
            this.obj.setSize(value);
        }

        public TRCClass getIsA() {
            return this.obj.getIsA();
        }

        public void setIsA(TRCClass value) {
            this.obj.setIsA(value);
        }

        public TRCProcess getProcess() {
            return this.obj.getProcess();
        }

        public void setProcess(TRCProcess value) {
            this.obj.setProcess(value);
        }

        public EClass eClass() {
            return this.obj.eClass();
        }

        public Resource eResource() {
            return this.obj.eResource();
        }

        public EObject eContainer() {
            return this.obj.eContainer();
        }

        public EStructuralFeature eContainingFeature() {
            return this.obj.eContainingFeature();
        }

        public EReference eContainmentFeature() {
            return this.obj.eContainmentFeature();
        }

        public EList eContents() {
            return this.obj.eContents();
        }

        public TreeIterator eAllContents() {
            return this.obj.eAllContents();
        }

        public boolean eIsProxy() {
            return this.obj.eIsProxy();
        }

        public EList eCrossReferences() {
            return this.obj.eCrossReferences();
        }

        public Object eGet(EStructuralFeature feature) {
            return this.obj.eGet(feature);
        }

        public Object eGet(EStructuralFeature feature, boolean resolve) {
            return this.obj.eGet(feature, resolve);
        }

        public void eSet(EStructuralFeature feature, Object newValue) {
            this.obj.eSet(feature, newValue);
        }

        public boolean eIsSet(EStructuralFeature feature) {
            return this.obj.eIsSet(feature);
        }

        public void eUnset(EStructuralFeature feature) {
            this.obj.eUnset(feature);
        }

        public EList eAdapters() {
            return this.obj.eAdapters();
        }

        public boolean eDeliver() {
            return this.obj.eDeliver();
        }

        public void eSetDeliver(boolean deliver) {
            this.obj.eSetDeliver(deliver);
        }

        public void eNotify(Notification notification) {
            this.obj.eNotify(notification);
        }

        public boolean testAttribute(Object target, String name, String value) {
            return false;
        }

        public EList getRefOwner() {
            return this.obj instanceof TRCHeapObject ? ((TRCHeapObject)this.obj).getRefOwner() : null;
        }

        public EList getRefTarget() {
            return this.obj instanceof TRCHeapObject ? ((TRCHeapObject)this.obj).getRefTarget() : null;
        }

        public EList getInvocations() {
            return this.obj instanceof TRCTraceObject ? ((TRCTraceObject)this.obj).getInvocations() : null;
        }

        public TRCThread getThread() {
            return this.obj instanceof TRCTraceObject ? ((TRCTraceObject)this.obj).getThread() : null;
        }

        public void setThread(TRCThread value) {
            if (this.obj instanceof TRCTraceObject) {
                ((TRCTraceObject)this.obj).setThread(value);
            }
        }

        public Object eInvoke(EOperation arg0, EList<?> arg1) throws InvocationTargetException {
            return this.obj instanceof TRCTraceObject ? ((TRCTraceObject)this.obj).eInvoke(arg0, arg1) : null;
        }

        public int getCumulativeSize() {
            return this.obj.getCumulativeSize();
        }

        public void setCumulativeSize(int value) {
            this.obj.setCumulativeSize(value);
        }
    }

    public class ObjReferenceCellLabelProvider
    extends StatisticCellLabelProvider {
        public ObjReferenceCellLabelProvider(ColumnData colData) {
            super(colData);
        }

        public void update(ViewerCell cell) {
            this.visualIndex = cell.getVisualIndex();
            cell.setText(((ObjReferenceLabelProvider)ReferenceTable.this.getTableLabelProvider()).getColumnText(cell.getElement(), this.visualIndex));
            cell.setImage(((ObjReferenceLabelProvider)ReferenceTable.this.getTableLabelProvider()).getColumnImage(cell.getElement(), this.visualIndex));
        }
    }

    public class ObjReferenceContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCClass) {
                return null;
            }
            if (element instanceof TRCHeapObject) {
                return ((TRCHeapObject)element).getIsA();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List classes = FilteringUtil.getFilteredClasses(ReferenceTable.this.getCurrentFilter(), FilteringUtil.getProcessList(ReferenceTable.this._page.getMOFObject()));
            Object[] elements = new Object[classes.size()];
            int i = 0;
            while (i < classes.size()) {
                elements[i] = new MyTRCClassData((TRCClass)classes.get(i));
                ++i;
            }
            return elements;
        }

        private EList getRef(TRCHeapObject obj) {
            if (USE_NEW_FILTERING_FOR_GET_REF) {
                BasicEList eList = new BasicEList();
                if (ReferenceTable.this.showReferTo()) {
                    eList.addAll(FilteringUtil.getFilteredObjectReferences(ReferenceTable.this.getCurrentFilter(), (EObject)obj, false));
                } else {
                    eList.addAll(FilteringUtil.getFilteredObjectReferences(ReferenceTable.this.getCurrentFilter(), (EObject)obj, true));
                }
                return eList;
            }
            if (ReferenceTable.this.showReferTo()) {
                return obj.getRefTarget();
            }
            return obj.getRefOwner();
        }

        private TRCHeapObject getHeapObject(TRCObjectReference obj) {
            if (ReferenceTable.this.showReferTo()) {
                return obj.getOwner();
            }
            return obj.getTarget();
        }

        public Object[] getChildren(Object element) {
            ReferenceTable.this.tmpList.clear();
            if (element instanceof TRCClass) {
                if (USE_NEW_FILTERING_FOR_GET_CHILDREN) {
                    TRCHeapObject obj = null;
                    Object[] classObjects = element instanceof MyTRCClassData ? FilteringUtil.getFilteredHeapObjects(ReferenceTable.this.getCurrentFilter(), (EObject)((MyTRCClassData)element).getTRCClass(), true).toArray() : FilteringUtil.getFilteredHeapObjects(ReferenceTable.this.getCurrentFilter(), (EObject)((TRCClass)element), true).toArray();
                    int idx = 0;
                    while (idx < classObjects.length) {
                        TRCObject tmpObject = (TRCObject)classObjects[idx];
                        if (tmpObject instanceof TRCHeapObject) {
                            obj = (TRCHeapObject)tmpObject;
                            break;
                        }
                        ++idx;
                    }
                    if (obj != null && this.getRef(obj).size() > 0) {
                        ReferenceTable.this.tmpList.add(obj);
                    }
                    Object[] objects = element instanceof MyTRCClassData ? FilteringUtil.getFilteredHeapObjects(ReferenceTable.this.getCurrentFilter(), (EObject)((MyTRCClassData)element).getTRCClass()).toArray() : FilteringUtil.getFilteredHeapObjects(ReferenceTable.this.getCurrentFilter(), (EObject)((TRCClass)element)).toArray();
                    int idx2 = 0;
                    while (idx2 < objects.length) {
                        TRCObject tmpObject = (TRCObject)objects[idx2];
                        if (tmpObject instanceof TRCHeapObject && this.getRef((TRCHeapObject)tmpObject).size() > 0) {
                            ReferenceTable.this.tmpList.add(tmpObject);
                        }
                        ++idx2;
                    }
                } else {
                    TRCHeapObject obj = null;
                    Object[] classObjects = ((TRCClass)element).getClassObjects().toArray();
                    int idx = 0;
                    while (idx < classObjects.length) {
                        TRCObject tmpObject = (TRCObject)classObjects[idx];
                        if (tmpObject instanceof TRCHeapObject) {
                            obj = (TRCHeapObject)tmpObject;
                            break;
                        }
                        ++idx;
                    }
                    if (obj != null && this.getRef(obj).size() > 0) {
                        ReferenceTable.this.tmpList.add(obj);
                    }
                    Object[] objects = ((TRCClass)element).getObjects().toArray();
                    int idx3 = 0;
                    while (idx3 < objects.length) {
                        TRCObject tmpObject = (TRCObject)objects[idx3];
                        if (tmpObject instanceof TRCHeapObject && this.getRef((TRCHeapObject)tmpObject).size() > 0) {
                            ReferenceTable.this.tmpList.add(tmpObject);
                        }
                        ++idx3;
                    }
                }
            } else if (element instanceof TRCHeapObject) {
                ReferenceTable.this.tmpList.addAll(this.getRef((TRCHeapObject)element));
            } else {
                ReferenceTable.this.tmpList.addAll(this.getRef(this.getHeapObject((TRCObjectReference)element)));
            }
            return ReferenceTable.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    public class ObjReferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ObjReferenceLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTree().getColumn(col)).getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._classNameCol, false);
                    }
                    case 1: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._packageNameCol, false);
                    }
                    case 2: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._refSizeCol, false);
                    }
                    case 3: {
                        return "";
                    }
                }
            } else if (obj instanceof TRCHeapObject) {
                switch (pos) {
                    case 0: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._instanceNameCol, false);
                    }
                    case 1: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._packageNameCol, false);
                    }
                    case 2: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._refSizeCol, false);
                    }
                    case 3: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._numRefsCol, false);
                    }
                    case 4: {
                        return "";
                    }
                }
            } else {
                switch (pos) {
                    case 0: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._instanceNameCol, false);
                    }
                    case 1: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._packageNameCol, false);
                    }
                    case 2: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._refSizeCol, false);
                    }
                    case 3: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._numRefsCol, false);
                    }
                    case 4: {
                        return ReferenceTable.this.getElementColumnText(obj, ReferenceTable.this._numRefsInstCol, false);
                    }
                }
            }
            return "";
        }
    }

    public class ObjReferenceSorter
    extends StatisticView.StatisticSorter {
        public ObjReferenceSorter() {
            super(ReferenceTable.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCClass) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._classNameCol, false);
                    }
                    case 1: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._packageNameCol, false);
                    }
                    case 2: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._refSizeCol, false);
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else if (e1 instanceof TRCHeapObject) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._instanceNameCol, false);
                    }
                    case 1: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._packageNameCol, false);
                    }
                    case 2: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._refSizeCol, false);
                    }
                    case 3: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._numRefsCol, false);
                    }
                    case 4: {
                        return 0;
                    }
                }
            } else {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._instanceNameCol, false);
                    }
                    case 1: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._packageNameCol, false);
                    }
                    case 2: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._refSizeCol, false);
                    }
                    case 3: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._numRefsCol, false);
                    }
                    case 4: {
                        return this._sortSequence * ReferenceTable.this.compareElements(e1, e2, ReferenceTable.this._numRefsInstCol, false);
                    }
                }
            }
            return 0;
        }
    }

    class ReferenceTreeViewer
    extends TreeViewer {
        public ReferenceTreeViewer(Composite parent) {
            super(parent);
        }

        public ReferenceTreeViewer(Tree tree) {
            super(tree);
        }

        public void expandItem(TreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }
}

