/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.trace.views.internal.SummaryGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.GraphSource;
import org.eclipse.hyades.ui.widgets.grapher.graphs.LineGraph;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderConfigurationException;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderEvent;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SummaryGraph
implements ZoomSliderListener {
    private Composite namesContainer;
    private Composite graphComposite;
    private final List sourceList = new ArrayList();
    private GraphCanvas canvas;
    private TimeZoomSlider xSlider;
    private ZoomSlider ySlider;

    public SummaryGraph(Composite parent, String title) throws ZoomSliderConfigurationException {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        container.setLayout((Layout)gridLayout);
        gridLayout.verticalSpacing = 0;
        Button titleLabel = new Button(container, 16392);
        titleLabel.setText(title);
        titleLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createGraphComposite(container);
        this.namesContainer = new Composite(container, 0);
        this.namesContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout namesLayout = new GridLayout(0, true);
        this.namesContainer.setLayout((Layout)namesLayout);
        namesLayout.verticalSpacing = 0;
        namesLayout.marginHeight = 0;
    }

    private void createGraphComposite(Composite parent) throws ZoomSliderConfigurationException {
        this.graphComposite = new Composite(parent, 0);
        this.graphComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.graphComposite.setLayout((Layout)gridLayout);
        this.ySlider = new ZoomSlider(this.graphComposite);
        this.ySlider.setLayoutData((Object)new GridData(4, 4, false, true));
        this.ySlider.addZoomSliderListener((ZoomSliderListener)this);
        this.ySlider.configure(0.0, 200.0, 50.0, 150.0, 2.0);
        this.ySlider.setEnabled(false);
        this.canvas = new GraphCanvas(this.graphComposite, 0);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite emptyFill = new Composite(this.graphComposite, 0);
        emptyFill.setLayoutData((Object)new GridData(4, 4, false, false));
        this.xSlider = new TimeZoomSlider(this.graphComposite);
        this.xSlider.setLayoutData((Object)new GridData(4, 4, true, false));
        this.xSlider.setDirection(-1);
        this.xSlider.setOrientation(1);
        this.xSlider.addZoomSliderListener((ZoomSliderListener)this);
        this.xSlider.configure(-10000.0, 10000.0, -200.0, 200.0, 2.0);
        this.xSlider.setEnabled(false);
    }

    public void addGraphSource(SummaryGraphSource graphSource) {
        LineGraph lineGraph = new LineGraph(0, (GraphSource)graphSource, this.xSlider, this.ySlider, graphSource.getColor());
        this.canvas.addGraph((Graph)lineGraph);
        this.addName(graphSource);
        this.sourceList.add(graphSource);
    }

    private void addName(final SummaryGraphSource graphSource) {
        ++((GridLayout)this.namesContainer.getLayout()).numColumns;
        Composite container = new Composite(this.namesContainer, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        final Canvas tick = new Canvas(container, 0);
        tick.setLayoutData((Object)new GridData(20, 20));
        tick.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(graphSource.getColor());
                e.gc.fillRectangle(tick.getBounds());
                e.gc.setForeground(e.display.getSystemColor(2));
                e.gc.drawRectangle(tick.getBounds());
            }
        });
        Label title = new Label(container, 0);
        title.setText(graphSource.getName());
        title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void zoomSliderChanged(ZoomSliderEvent event) {
        this.canvas.redraw();
    }

    public void update() {
        this.canvas.redraw();
        if (this.sourceList.isEmpty()) {
            return;
        }
        double maxX = 0.0;
        double minX = Double.MAX_VALUE;
        double maxY = 0.0;
        double minY = Double.MAX_VALUE;
        int i = 0;
        while (i < this.sourceList.size()) {
            SummaryGraphSource source = (SummaryGraphSource)this.sourceList.get(i);
            if (source.getMax() > maxX) {
                maxX = source.getMax();
            }
            if (source.getMin() < minX) {
                minX = source.getMin();
            }
            if (source.getValueMax() > maxY) {
                maxY = source.getValueMax();
            }
            if (source.getValueMin() < minY) {
                minY = source.getValueMin();
            }
            ++i;
        }
        try {
            this.xSlider.configure(0.8 * minX, 1.2 * maxX, minX, maxX, 2.0);
            this.ySlider.configure(0.8 * minY, 1.2 * maxY, minY, maxY, 2.0);
        }
        catch (ZoomSliderConfigurationException zoomSliderConfigurationException) {}
    }

    public void dispose() {
        ArrayList graphs = this.canvas.getGraphs();
        int i = 0;
        while (i < graphs.size()) {
            ((LineGraph)graphs.get(i)).dispose();
            ++i;
        }
    }
}

