/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class TracePluginImages {
    private static URL fgIconBaseURL = null;
    public static final String T_LCL = "lcl16";
    public static final String T_TOOL = "tool16";
    public static final String T_VIEW = "view16";
    public static final String T_OBJ = "obj16";
    public static final String T_WIZBAN = "wizban";
    public static Hashtable _images;
    public static Hashtable _imageDescriptors;
    public static final String IMG_SOURCE = "opensource_co.gif";
    public static final String IMG_CLASS_ST = "class_stat_co.gif";
    public static final String IMG_HEAP = "heap_co.gif";
    public static final String IMG_METH_ST = "meth_stat_co.gif";
    public static final String IMG_REF = "obj_ref_co.gif";
    public static final String IMG_METH = "methods_co.gif";
    public static final String IMG_OBJ = "objects_co.gif";
    public static final String IMG_CLASS_OBJ = "classobject_obj.gif";
    public static final String IMG_NEXT = "next_nav.gif";
    public static final String IMG_PREV = "prev_nav.gif";
    public static final String IMG_ZOOMIN = "zoomin_nav.gif";
    public static final String IMG_ZOOMOUT = "zoomout_nav.gif";
    public static final String IMG_RESTORE_ORG = "select_zoomin.gif";
    public static final String IMG_OPEN_GRAPH_TABLE = "show_table.gif";
    public static final String IMG_HOME = "home_nav.gif";
    public static final String IMG_CALLER = "showcaller_co.gif";
    public static final String IMG_CALLEE = "caller_co.gif";
    public static final String IMG_METHEXEC = "meth_exec_co.gif";
    public static final String IMG_METHINVO = "meth_invc_co.gif";
    public static final String IMG_METHINVODETAILS = "methdetails_view.gif";
    public static final String IMG_PERCENT = "percentage_show.gif";
    public static final String IMG_DELTACOLUMNS = "delta_show.gif";
    public static final String IMG_DELTAUP = "increasedvalue_obj.gif";
    public static final String IMG_DELTADOWN = "decreasedvalue_obj.gif";
    public static final String IMG_DELTANEW = "newentry_obj.gif";
    public static final String IMG_BLANK = "blank_obj.gif";
    public static final String IMG_COLORS = "opengraphcolor_co.gif";
    public static final String IMG_PRINTCOLUMNS = "htmlexport_co.gif";
    public static final String IMG_CHOOSECOLUMNS = "choosecolumn_co.gif";
    public static final String IMG_SORTCOLUMNS = "alphab_sort_co.gif";
    public static final String IMG_PACKAGE = "package_obj.gif";
    public static final String IMG_CLASS = "class.gif";
    public static final String IMG_PACKAGE_COL = "package_obj_col.gif";
    public static final String IMG_CLASS_COL = "class_col.gif";
    public static final String IMG_METHOD = "methods_co.gif";
    public static final String IMG_THREAD = "thread_obj.gif";
    public static final ImageDescriptor DESC_IMG_ZOOMMASK;
    public static final ImageDescriptor DESC_IMG_ZOOMIN_SOURCE;
    public static final ImageDescriptor DESC_IMG_ZOOMOUT_SOURCE;
    public static final ImageDescriptor DESC_IMG_DELTAUP;
    public static final ImageDescriptor DESC_IMG_DELTADOWN;
    public static final ImageDescriptor DESC_IMG_DELTANEW;
    public static final ImageDescriptor DESC_IMG_BLANK;
    public static final ImageDescriptor DESC_IMG_CLASS;
    public static final ImageDescriptor DESC_IMG_PACKAGE;
    public static final ImageDescriptor DESC_IMG_CLASS_COL;
    public static final ImageDescriptor DESC_IMG_PACKAGE_COL;
    public static final ImageDescriptor DESC_IMG_METHOD;
    public static final ImageDescriptor DESC_IMG_THREAD;
    public static final ImageDescriptor DESC_IMG_OBJ;
    public static final ImageDescriptor DESC_IMG_CLASS_OBJ;

    static {
        try {
            fgIconBaseURL = new URL(TraceUIPlugin.getDefault().getBundle().getEntry("/"), "icons/full/");
        }
        catch (MalformedURLException e) {
            TraceUIPlugin.getDefault().log(e);
        }
        DESC_IMG_ZOOMMASK = TracePluginImages.createManaged(T_OBJ, "zoom_mask.bmp");
        DESC_IMG_ZOOMIN_SOURCE = TracePluginImages.createManaged(T_OBJ, "zoomin_source.bmp");
        DESC_IMG_ZOOMOUT_SOURCE = TracePluginImages.createManaged(T_OBJ, "zoomout_source.bmp");
        DESC_IMG_DELTAUP = TracePluginImages.createManaged(T_OBJ, IMG_DELTAUP);
        DESC_IMG_DELTADOWN = TracePluginImages.createManaged(T_OBJ, IMG_DELTADOWN);
        DESC_IMG_DELTANEW = TracePluginImages.createManaged(T_OBJ, IMG_DELTANEW);
        DESC_IMG_BLANK = TracePluginImages.createManaged(T_OBJ, IMG_BLANK);
        DESC_IMG_CLASS = TracePluginImages.createManaged(T_OBJ, IMG_CLASS);
        DESC_IMG_PACKAGE = TracePluginImages.createManaged(T_OBJ, IMG_PACKAGE);
        DESC_IMG_CLASS_COL = TracePluginImages.createManaged(T_OBJ, IMG_CLASS_COL);
        DESC_IMG_PACKAGE_COL = TracePluginImages.createManaged(T_OBJ, IMG_PACKAGE_COL);
        DESC_IMG_METHOD = TracePluginImages.createManaged(T_OBJ, "methods_co.gif");
        DESC_IMG_THREAD = TracePluginImages.createManaged(T_OBJ, IMG_THREAD);
        DESC_IMG_OBJ = TracePluginImages.createManaged(T_OBJ, IMG_OBJ);
        DESC_IMG_CLASS_OBJ = TracePluginImages.createManaged(T_OBJ, IMG_CLASS_OBJ);
    }

    public static Image getImage(String name) {
        return (Image)_images.get(name);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return (ImageDescriptor)_imageDescriptors.get(name);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)TracePluginImages.makeIconFileURL(prefix, name));
            if (_images == null || _imageDescriptors == null) {
                _images = new Hashtable();
                _imageDescriptors = new Hashtable();
            }
            _imageDescriptors.put(name, result);
            _images.put(name, result.createImage());
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)TracePluginImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            id = ImageDescriptor.createFromURL((URL)TracePluginImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        action.setImageDescriptor(TracePluginImages.create("e" + type, relPath));
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        StringBuffer buffer;
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        if (prefix != null) {
            buffer = new StringBuffer(prefix);
            buffer.append('/');
            buffer.append(name);
        } else {
            buffer = new StringBuffer(name);
        }
        return new URL(fgIconBaseURL, buffer.toString());
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)TracePluginImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void shutdown() {
        if (_images == null) {
            return;
        }
        for (Object next : _images.values()) {
            if (!(next instanceof Image) || ((Image)next).isDisposed()) continue;
            ((Image)next).dispose();
        }
        _images.clear();
        _images = null;
        _imageDescriptors.clear();
        _imageDescriptors = null;
    }
}

