/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ActiveFilter;
import org.eclipse.hyades.trace.views.adapter.internal.FilterEventsUI;
import org.eclipse.hyades.trace.views.adapter.internal.GetSetFilter;
import org.eclipse.hyades.trace.views.adapter.internal.ThresholdFilter;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.util.internal.IColorChangedListener;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.hyades.trace.views.util.internal.UpdateModel;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TraceUIPlugin
extends AbstractUIPlugin {
    private static TraceUIPlugin _plugin;
    public static final ActiveFilter THRESHOLD_FILTER;
    public static final ActiveFilter GETSET_FILTER;
    public static final String PLUGIN_ID = "org.eclipse.hyades.trace.views";
    private static final String FILTER_TYPE = "org.eclipse.hyades.trace.views.ProfilingFilterType";
    private static final boolean ADD_GET_SET_FILTER = true;
    private static final boolean DO_NOT_ADD_GET_SET_FILTER = false;
    private ResourceBundle fResourceBundle;
    private ListenerList fColorChangedEventListeners = new ListenerList();
    private ListenerList fRefChangedEventListeners = new ListenerList();
    private ListenerList fTimeChangedEventListeners = new ListenerList();

    static {
        THRESHOLD_FILTER = new ThresholdFilter();
        GETSET_FILTER = new GetSetFilter();
    }

    public TraceUIPlugin() {
        if (_plugin == null) {
            _plugin = this;
        }
    }

    public static TraceUIPlugin getDefault() {
        return _plugin;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return TracePluginImages.getImageDescriptor(name);
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        TracePluginImages.setImageDescriptors(action, type, relPath);
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public ResourceBundle getResourceBundle() {
        if (this.fResourceBundle == null) {
            try {
                this.fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
                this.fResourceBundle = null;
            }
        }
        return this.fResourceBundle;
    }

    public static String getString(String key) {
        ResourceBundle bundle = TraceUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getResourceString(String key) {
        return TraceUIPlugin.getString(key);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"background_rgb", (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"selection_rgb", (RGB)new RGB(255, 255, 149));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"unknown_rgb", (RGB)new RGB(128, 128, 128));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"classes_rgb", (RGB)new RGB(71, 141, 141));
        store.setDefault("bg_option", "system_default");
        store.setDefault("class_option", "class_default_color");
        store.setDefault("obj_ref_display", 0);
        store.setDefault("time_display", 0);
        store.setDefault("percent", 0);
        store.setDefault("page_size", 131072);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.savePluginPreferences();
        SpectrumColorMap.shutdown();
        TracePluginImages.shutdown();
        TraceSDUtil.shutdown();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.addDefaultFilters();
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)new UpdateModel());
        SpectrumColorMap.startup();
    }

    public void addColorChangedEventListener(IColorChangedListener listener) {
        this.fColorChangedEventListeners.add((Object)listener);
    }

    public void addRefChangedEventListener(IRefChangedListener listener) {
        this.fRefChangedEventListeners.add((Object)listener);
    }

    public void addTimeChangedEventListener(ITimeChangedListener listener) {
        this.fTimeChangedEventListeners.add((Object)listener);
    }

    public void removeColorChangedEventListener(IColorChangedListener listener) {
        this.fColorChangedEventListeners.remove((Object)listener);
    }

    public void removeRefChangedEventListener(IRefChangedListener listener) {
        this.fRefChangedEventListeners.remove((Object)listener);
    }

    public void removeTimeChangedEventListener(ITimeChangedListener listener) {
        this.fTimeChangedEventListeners.remove((Object)listener);
    }

    public void notifyColorChangedEventListener() {
        Object[] listeners = this.fColorChangedEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IColorChangedListener)listeners[idx]).handleColorChangedEvent();
            ++idx;
        }
    }

    public void notifyRefChangedEventListener() {
        Object[] listeners = this.fRefChangedEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IRefChangedListener)listeners[idx]).handleRefChangedEvent();
            ++idx;
        }
    }

    public void notifyTimeChangedEventListener() {
        Object[] listeners = this.fTimeChangedEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((ITimeChangedListener)listeners[idx]).handleTimeChangedEvent();
            ++idx;
        }
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getId() {
        return TraceUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    private void addDefaultFilters() {
        String traceViewsPluginDefaultFiltersKey = PLUGIN_ID;
        if (!FilterResourceHandler.isDefaultFiltersAddedForKey((String)traceViewsPluginDefaultFiltersKey)) {
            ArrayList<FilterQueries> filtersToAdd = new ArrayList<FilterQueries>();
            FilterQueries fq = FilterResourceHandler.createFilterQueries((String)FILTER_TYPE, (String)CommonUIMessages._111, null, null);
            filtersToAdd.add(fq);
            fq = TraceUIPlugin.createFilterQuery(TraceUIMessages._216, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_BaseTime(), OrderByOperators.DESC_LITERAL, false);
            filtersToAdd.add(fq);
            fq = TraceUIPlugin.createFilterQuery(TraceUIMessages._217, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_CumulativeTime(), OrderByOperators.DESC_LITERAL, false);
            filtersToAdd.add(fq);
            fq = TraceUIPlugin.createFilterQuery(TraceUIMessages._219, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_Calls(), OrderByOperators.DESC_LITERAL, false);
            filtersToAdd.add(fq);
            fq = TraceUIPlugin.createFilterQuery(TraceUIMessages._218, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_TotalSize(), OrderByOperators.DESC_LITERAL, false);
            filtersToAdd.add(fq);
            fq = TraceUIPlugin.createFilterQuery(TraceUIMessages._220, (EStructuralFeature)TracePackage.eINSTANCE.getTRCPackage_TotalInstances(), OrderByOperators.DESC_LITERAL, false);
            filtersToAdd.add(fq);
            fq = TraceUIPlugin.createFilterQuery(TraceUIMessages._236, null, null, false);
            filtersToAdd.add(fq);
            FilterResourceHandler.addFiltersOnInstanceLoad(filtersToAdd);
            FilterResourceHandler.defaultFiltersAddedForKey((String)traceViewsPluginDefaultFiltersKey, (boolean)true);
        }
    }

    private static FilterQueries createFilterQuery(String name, EStructuralFeature feature, OrderByOperators operator, boolean addGetSetFilter) {
        FilterQueries filterQuery = FilterResourceHandler.createFilterQueries((String)FILTER_TYPE, (String)name, null, null);
        SimpleSearchQuery query = filterQuery.standard();
        if (feature != null && operator != null) {
            FilterEventsUI.addOrderByExpressionAndSetMaxElements(query, feature, operator, 10);
        }
        TraceUIPlugin.addGetterThresholdFilters(query, addGetSetFilter);
        return filterQuery;
    }

    private static void addGetterThresholdFilters(SimpleSearchQuery filter, boolean addGetSetFilter) {
        WhereExpression expr = filter.getWhereExpression();
        if (expr == null) {
            expr = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            ((LogicalExpression)expr).setOperator(LogicalOperators.AND_LITERAL);
        }
        if (expr instanceof LogicalExpression) {
            EList arguments = ((LogicalExpression)expr).getArguments();
            if (addGetSetFilter) {
                arguments.add((Object)THRESHOLD_FILTER.createActiveExpression());
                arguments.add((Object)GETSET_FILTER.createActiveExpression());
            } else {
                arguments.add((Object)THRESHOLD_FILTER.createDisabledExpression());
                arguments.add((Object)GETSET_FILTER.createDisabledExpression());
            }
        }
        filter.setWhereExpression(expr);
    }
}

