/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.fragment;

import org.eclipse.hyades.trace.views.internal.fragment.ILazyFragmentTreeContentWithIndexProvider;
import org.eclipse.hyades.trace.views.internal.fragment.IProviderContext;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;

public class ContentProviderNewLazyAdaptor
implements ILazyFragmentTreeContentWithIndexProvider {
    private ITreeContentProvider provider;
    private ElementInfo inputElementInfo;
    private TreeViewer viewer;
    private ECWrapper comparerWrapper;
    private ViewerComparator comparator;

    public ContentProviderNewLazyAdaptor(ITreeContentProvider cp, IElementComparer comparer, ViewerComparator c) {
        this.provider = cp;
        this.comparerWrapper = new ECWrapper(comparer);
        this.comparator = c;
    }

    public static Object getObject(Object element) {
        return element instanceof ElementInfo ? ((ElementInfo)element).element : element;
    }

    public Object toViewerElement(Object element) {
        if (element instanceof ElementInfo) {
            ElementInfo info = (ElementInfo)element;
            if (info.getContainer() == this) {
                return info;
            }
            element = info.element;
        } else if (element.equals(this.inputElementInfo.element)) {
            return element;
        }
        return new ElementInfo(null, element);
    }

    public Object getParent(Object element) {
        ElementInfo info = this.getElementInfo(element);
        return info != null ? info.getParent() : null;
    }

    public void updateChildCount(Object element, int currentChildCount, IProviderContext context) {
        ElementInfo info = this.getElementInfo(element);
        if (info == null) {
            return;
        }
        int count = info.getChildrenLength();
        if (!info.isChildCountInited) {
            info.isChildCountInited = true;
        }
        context.setChildCount(element, count);
    }

    public void updateElement(Object parent, int index, IProviderContext context) {
        ElementInfo info = this.getElementInfo(parent);
        if (info == null) {
            return;
        }
        Object[] children = info.getSortedChildren();
        Object c = children[index];
        if (c instanceof ElementInfo) {
            c = ((ElementInfo)c).element;
        }
        ElementInfo child = info.equals(this.inputElementInfo) ? new ElementInfo(null, c) : new ElementInfo(info, c);
        children[index] = child;
        context.replace(parent, index, child);
        context.setHasChildren(child, child.hasChildren());
    }

    private ElementInfo getElementInfo(Object element) {
        if (element == null || element.equals(this.inputElementInfo.element)) {
            return this.inputElementInfo;
        }
        return element instanceof ElementInfo ? (ElementInfo)element : null;
    }

    public void dispose() {
        this.inputElementInfo = null;
        this.provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.inputElementInfo == null) {
            this.inputElementInfo = new ElementInfo(null, newInput);
            this.inputElementInfo.isChildCountInited = true;
        } else {
            this.inputElementInfo.elementChanged(newInput);
        }
        this.viewer = (TreeViewer)viewer;
        this.provider.inputChanged(viewer, oldInput, newInput);
    }

    public ITableLabelProvider wrapLableProvider(ITableLabelProvider provider) {
        return new TableLPWrapper(provider);
    }

    public IElementComparer getComparerWrapper() {
        return this.comparerWrapper.comparer != null ? this.comparerWrapper : null;
    }

    public void setViewerComparator(ViewerComparator c) {
        if (this.inputElementInfo != null) {
            this.inputElementInfo.reset();
        }
        this.comparator = c;
    }

    public int indexOf(Object parent, Object element) {
        ElementInfo elInfo = this.getElementInfo(parent);
        return elInfo != null ? elInfo.indexOf(element) : -1;
    }

    public ITreeContentProvider getWrappedContentProvider() {
        return this.provider;
    }

    private static class ECWrapper
    implements IElementComparer {
        private IElementComparer comparer;

        public ECWrapper(IElementComparer comparer) {
            this.comparer = comparer;
        }

        public boolean equals(Object a, Object b) {
            if (this.comparer == null) {
                return a.equals(b);
            }
            return this.comparer.equals(ContentProviderNewLazyAdaptor.getObject(a), ContentProviderNewLazyAdaptor.getObject(b));
        }

        public int hashCode(Object element) {
            if (this.comparer == null) {
                return element.hashCode();
            }
            return this.comparer.hashCode(ContentProviderNewLazyAdaptor.getObject(element));
        }
    }

    private class ElementInfo {
        ElementInfo parent;
        Object element;
        Object[] children;
        boolean isSorted;
        boolean isChildCountInited;
        Boolean hasChildren;

        ElementInfo(ElementInfo parent, Object element) {
            if (element instanceof ElementInfo) {
                int i = 0;
                ++i;
            }
            this.parent = parent;
            this.element = element;
        }

        public void elementChanged(Object element) {
            this.element = element;
            this.reset();
        }

        public void reset() {
            this.children = null;
            this.isSorted = false;
            this.hasChildren = null;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementInfo other = (ElementInfo)obj;
            return this.element.equals(other.element);
        }

        public ContentProviderNewLazyAdaptor getContainer() {
            return ContentProviderNewLazyAdaptor.this;
        }

        public Object getParent() {
            if (this.parent == null) {
                if (this.equals(ContentProviderNewLazyAdaptor.this.inputElementInfo)) {
                    return null;
                }
                Object parentEl = ContentProviderNewLazyAdaptor.this.provider.getParent(this.element);
                if (parentEl == null) {
                    if (ContentProviderNewLazyAdaptor.this.inputElementInfo.indexOf(this.element) >= 0) {
                        this.parent = ContentProviderNewLazyAdaptor.this.inputElementInfo;
                        return ((ContentProviderNewLazyAdaptor)ContentProviderNewLazyAdaptor.this).inputElementInfo.element;
                    }
                    return null;
                }
                this.parent = (parentEl = ContentProviderNewLazyAdaptor.this.toViewerElement(parentEl)) instanceof ElementInfo ? (ElementInfo)parentEl : ContentProviderNewLazyAdaptor.this.inputElementInfo;
            }
            if (this.parent.equals(ContentProviderNewLazyAdaptor.this.inputElementInfo)) {
                return this.parent.element;
            }
            return this.parent;
        }

        public Object[] getSortedChildren() {
            this.getRawChildren();
            if (!this.isSorted) {
                if (this.children.length != 0 && ContentProviderNewLazyAdaptor.this.comparator != null) {
                    ContentProviderNewLazyAdaptor.this.comparator.sort((Viewer)ContentProviderNewLazyAdaptor.this.viewer, this.children);
                }
                if (this.children.getClass() != Object[].class) {
                    Object[] tmp = new Object[this.children.length];
                    System.arraycopy(this.children, 0, tmp, 0, tmp.length);
                    this.children = tmp;
                }
                this.isSorted = true;
            }
            return this.children;
        }

        public int indexOf(Object element) {
            Object[] children = this.getSortedChildren();
            if (element instanceof ElementInfo) {
                element = ((ElementInfo)element).element;
            }
            int i = 0;
            while (i < children.length) {
                Object c = children[i];
                if (c instanceof ElementInfo) {
                    c = ((ElementInfo)c).element;
                }
                if (element.equals(c)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private Object[] getRawChildren() {
            if (this.children == null) {
                if (this.equals(ContentProviderNewLazyAdaptor.this.inputElementInfo)) {
                    this.children = ContentProviderNewLazyAdaptor.this.provider.getElements(this.element);
                } else {
                    Object[] objectArray = this.children = ContentProviderNewLazyAdaptor.this.provider.hasChildren(this.element) ? ContentProviderNewLazyAdaptor.this.provider.getChildren(this.element) : new Object[]{};
                }
                if (this.children == null) {
                    this.children = new Object[0];
                }
            }
            return this.children;
        }

        public boolean hasChildren() {
            if (this.hasChildren == null) {
                this.hasChildren = this.equals(ContentProviderNewLazyAdaptor.this.inputElementInfo) ? Boolean.TRUE : Boolean.valueOf(ContentProviderNewLazyAdaptor.this.provider.hasChildren(this.element));
            }
            return this.hasChildren;
        }

        public int getChildrenLength() {
            int length = this.getRawChildren().length;
            return length;
        }
    }

    private static class TableLPWrapper
    extends LabelProvider
    implements ITableLabelProvider {
        private ITableLabelProvider lp;

        TableLPWrapper(ITableLabelProvider provider) {
            this.lp = provider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.lp.addListener(listener);
        }

        public void dispose() {
            this.lp.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Object o = ContentProviderNewLazyAdaptor.getObject(element);
            return this.lp.getColumnImage(o, columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            Object o = ContentProviderNewLazyAdaptor.getObject(element);
            return this.lp.getColumnText(o, columnIndex);
        }

        public boolean isLabelProperty(Object element, String property) {
            Object o = ContentProviderNewLazyAdaptor.getObject(element);
            return this.lp.isLabelProperty(o, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.lp.removeListener(listener);
        }
    }
}

