/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.fragment;

import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.trace.views.internal.fragment.Expansion;

public class ExpansionRange {
    private Expansion base;
    private int startOffset;
    private int size;
    private Expansion startExpansion;
    private Expansion endExpansion;
    private Expansion lastIncludedExpansion;
    public static final int NONE = 0;
    public static final int CONTAINMENT = 1;
    public static final int REFERENCE = 2;

    private ExpansionRange(Expansion base, int offset, int size) {
        this.base = base;
        this.startOffset = offset;
        this.size = size;
    }

    private static void assertRange(Expansion base, int offset, int size) {
        Assert.isTrue((size >= 0 ? 1 : 0) != 0);
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)base.isExpanded());
        Assert.isTrue((base.getAllChildSize(false) >= offset ? 1 : 0) != 0);
        Assert.isTrue((base.getAllChildSize(false) - offset >= size ? 1 : 0) != 0);
    }

    public static ExpansionRange createExpansionRange(Expansion base, int offset, int size) {
        ExpansionRange.assertRange(base, offset, size);
        return new ExpansionRange(base, offset, size);
    }

    public int getSize(boolean includeReferencedParents) {
        return includeReferencedParents ? this.size + this.getNumParentRefs() : this.size;
    }

    public int getDepth(Expansion exp) {
        int i = 0;
        while (exp != null) {
            if (exp.equals(this.base)) {
                return i;
            }
            exp = exp.getParent();
            ++i;
        }
        return -1;
    }

    public void clearCache() {
        this.startExpansion = null;
        this.endExpansion = null;
        this.lastIncludedExpansion = null;
    }

    public Expansion getStartExpansion() {
        if (this.startExpansion == null) {
            if (this.size == 0) {
                return null;
            }
            this.startExpansion = this.base.getChildExpansionByOffset(this.startOffset, false);
        }
        return this.startExpansion;
    }

    private Expansion getEndExpansion() {
        if (this.endExpansion == null) {
            if (this.startOffset + this.size == this.base.getAllChildSize(false)) {
                return null;
            }
            this.endExpansion = this.base.getChildExpansionByOffset(this.startOffset + this.size, false);
        }
        return this.endExpansion;
    }

    public Expansion getLastIncludedExpansion() {
        if (this.lastIncludedExpansion == null && this.size != 0) {
            this.lastIncludedExpansion = this.base.getChildExpansionByOffset(this.startOffset + this.size - 1, false);
        }
        return this.lastIncludedExpansion;
    }

    public int getMaxMove(boolean forward) {
        return forward ? this.getMaxForwardMove() : this.getMaxBackwardMove();
    }

    public int getMaxForwardMove() {
        int move = this.base.getAllChildSize(false) - this.startOffset - this.size;
        Assert.isTrue((move >= 0 ? 1 : 0) != 0);
        return move;
    }

    public int getMaxBackwardMove() {
        return this.startOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int limitByMaxMove(int num) {
        return num > 0 ? Math.min(num, this.getMaxForwardMove()) : Math.min(num, this.getStartOffset());
    }

    public ExpansionRange moveToStart(int newStart, boolean preservingSize) {
        this.assertValid();
        Assert.isTrue((newStart >= 0 ? 1 : 0) != 0);
        int newSize = this.size;
        int childSize = this.base.getAllChildSize(false);
        if (newStart + newSize > childSize) {
            if (preservingSize) {
                newStart = childSize - newSize;
            } else {
                newSize = childSize - newStart;
            }
        }
        return ExpansionRange.createExpansionRange(this.base, newStart, newSize);
    }

    public ExpansionRange getInterection(ExpansionRange other) {
        ExpansionRange result;
        if (this.startOffset == other.startOffset) {
            result = other.size > this.size ? this : other;
        } else {
            int endOffset = this.startOffset + this.size;
            int otherEndOffset = other.startOffset + other.size;
            result = this.startOffset > other.startOffset ? (endOffset <= otherEndOffset ? this : (this.startOffset <= otherEndOffset ? ExpansionRange.createExpansionRange(this.base, this.startOffset, otherEndOffset - this.startOffset) : null)) : (otherEndOffset <= endOffset ? other : (other.startOffset <= endOffset ? ExpansionRange.createExpansionRange(this.base, other.startOffset, endOffset - other.startOffset) : null));
        }
        return result;
    }

    public int getRelation(Expansion exp) {
        if (exp.equals(this.base)) {
            return 2;
        }
        if (this.size == 0) {
            return 0;
        }
        if (!exp.isChildOf(this.base)) {
            return 0;
        }
        int ri = this.internalGetRawIndex(exp);
        if (ri >= this.startOffset && ri < this.startOffset + this.size) {
            return 1;
        }
        if (exp.isParentOf(this.getLastIncludedExpansion()) || exp.isParentOf(this.getStartExpansion())) {
            return 2;
        }
        return 0;
    }

    private int internalGetRawIndex(Expansion exp) {
        return exp.getRootIndex() - this.base.getRootIndex() - 1;
    }

    public Expansion getBase() {
        return this.base;
    }

    public int getNumParentRefs() {
        Expansion exp = this.getStartExpansion();
        if (exp == null) {
            return this.size;
        }
        int depth = this.getDepth(exp);
        Assert.isTrue((depth > 0 ? 1 : 0) != 0);
        return depth - 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getStartIndex(Expansion exp) {
        switch (this.getRelation(exp)) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                Expansion expDirectChild = this.getStartExpansion();
                if (expDirectChild == null) {
                    return -1;
                }
                while (!expDirectChild.getParent().equals(exp)) {
                    expDirectChild = expDirectChild.getParent();
                }
                return expDirectChild.getIndex();
            }
        }
        Assert.isTrue((boolean)false);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getEndIndex(Expansion exp) {
        switch (this.getRelation(exp)) {
            case 0: {
                return -1;
            }
            case 1: {
                Expansion exp2 = this.getLastIncludedExpansion();
                if (exp2 == null) {
                    return -1;
                }
                if (exp2.equals(exp)) {
                    return 0;
                }
                Expansion p = exp2.getParent();
                while (true) {
                    if (p == null) {
                        return exp.getDirectChildSize(false);
                    }
                    if (p.equals(exp)) {
                        return exp2.getIndex() + 1;
                    }
                    exp2 = p;
                    p = p.getParent();
                }
            }
            case 2: {
                Expansion expDirectChild = this.getLastIncludedExpansion();
                if (expDirectChild == null) {
                    return -1;
                }
                if (!expDirectChild.isChildOf(exp)) {
                    return exp.getDirectChildSize(false);
                }
                while (!expDirectChild.getParent().equals(exp)) {
                    expDirectChild = expDirectChild.getParent();
                }
                return expDirectChild.getIndex() + 1;
            }
        }
        Assert.isTrue((boolean)false);
        return 0;
    }

    public int getIndex(Expansion exp) {
        int offset = this.getStartIndex(exp.getParent());
        if (offset == -1) {
            return -1;
        }
        return exp.getIndex() - offset;
    }

    public int getDirectChildCount(Expansion exp) {
        int offset = this.getStartIndex(exp);
        if (offset == -1) {
            return -1;
        }
        int endIndex = this.getEndIndex(exp);
        Assert.isTrue((endIndex != -1 && offset <= endIndex ? 1 : 0) != 0);
        int result = endIndex - offset;
        Assert.isTrue((result <= this.size ? 1 : 0) != 0);
        return result;
    }

    public Expansion[] getDirectChildren(Expansion exp, boolean expanded) {
        int offset = this.getStartIndex(exp);
        if (offset == -1) {
            return new Expansion[0];
        }
        int endIndex = this.getEndIndex(exp);
        Assert.isTrue((endIndex != -1 && offset <= endIndex ? 1 : 0) != 0);
        return exp.getDirectChildren(offset, endIndex, true);
    }

    public boolean hasDirectChildren(Expansion exp, boolean expanded) {
        int offset = this.getStartIndex(exp);
        if (offset == -1) {
            return false;
        }
        int endIndex = this.getEndIndex(exp);
        Assert.isTrue((endIndex != -1 && offset <= endIndex ? 1 : 0) != 0);
        return exp.hasDirectChildren(offset, endIndex, true);
    }

    public ExpansionRange adjustOnExpand(Expansion exp) {
        int newSize;
        int newStart;
        Assert.isTrue((boolean)exp.isChildOf(this.base));
        int expIndex = this.internalGetRawIndex(exp);
        if (expIndex < this.startOffset) {
            newStart = this.startOffset + exp.getAllChildSize(false);
            newSize = this.size;
        } else if (expIndex < this.startOffset + this.size - 1) {
            newStart = this.startOffset;
            newSize = this.size + exp.getAllChildSize(false);
        } else {
            newStart = this.startOffset;
            newSize = this.size;
        }
        return ExpansionRange.createExpansionRange(this.base, newStart, newSize);
    }

    public ExpansionRange adjustOnCollapse(Expansion exp) {
        int newSize;
        int newStart;
        Assert.isTrue((boolean)exp.isChildOf(this.base));
        int expIndex = this.internalGetRawIndex(exp);
        int childSize = exp.getAllChildSize(false);
        int nextExpIndex = expIndex + childSize + 1;
        if (expIndex < this.startOffset) {
            if (nextExpIndex <= this.startOffset) {
                newStart = this.startOffset - exp.getAllChildSize(false);
                newSize = this.size;
            } else {
                newStart = expIndex + 1;
                newSize = nextExpIndex <= this.startOffset + this.size ? this.startOffset + this.size - nextExpIndex : 0;
            }
        } else if (expIndex < this.startOffset + this.size - 1) {
            newStart = this.startOffset;
            newSize = nextExpIndex <= this.startOffset + this.size ? this.size - exp.getAllChildSize(false) : expIndex - this.startOffset + 1;
        } else {
            newStart = this.startOffset;
            newSize = this.size;
        }
        return ExpansionRange.createExpansionRange(this.base, newStart, newSize);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpansionRange other = (ExpansionRange)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    public void assertValid() {
        ExpansionRange.assertRange(this.base, this.startOffset, this.size);
    }

    public ExpansionRange expand(Expansion exp, Object data, int childCount) {
        if (exp.isExpanded()) {
            return this;
        }
        if (exp.isVirtual()) {
            Assert.isTrue((childCount >= 0 ? 1 : 0) != 0);
            exp.materialize(data, childCount, true);
        } else {
            Assert.isTrue((childCount == -1 || exp.getDirectChildSize(false) == childCount ? 1 : 0) != 0);
            Assert.isTrue((data == null || exp.getData().equals(data) ? 1 : 0) != 0);
            exp.expand();
        }
        return this.adjustOnExpand(exp);
    }

    public ExpansionRange collapse(Expansion exp, boolean preserveChildInfo) {
        if (!exp.isExpanded()) {
            return this;
        }
        ExpansionRange newRange = this.adjustOnCollapse(exp);
        exp.collapse(preserveChildInfo);
        return newRange;
    }
}

