/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.swt.graphics.Image;

public class AggregatedCumulativeTimeColumnLabel
extends AbstractNumberColumnLabel {
    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof AggregatedInvocation) {
            return new Double(((AggregatedInvocation)element).getSumTime());
        }
        if (element instanceof AggregatedInvocation.Item) {
            return new Double(((AggregatedInvocation.Item)element).getSumTime());
        }
        if (element instanceof TRCThread) {
            return new Double(this.getThreadTime((TRCThread)element));
        }
        return null;
    }

    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        Number value = this.getValue(element, info);
        return value != null ? TString.formatTimeValue((double)value.doubleValue()) : "";
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        return null;
    }

    private double getThreadTime(TRCThread thread) {
        double startTime = thread.getStartTime();
        double stopTime = thread.getStopTime();
        if (stopTime < startTime) {
            stopTime = thread.getProcess().getLastEventTime();
        }
        return Math.max(stopTime - startTime, 0.0);
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        if (element instanceof AggregatedInvocation) {
            return "method.cumul.time";
        }
        if (element instanceof TRCThread) {
            return "method.cumul.time";
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        return null;
    }
}

