/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.MethodCallDetails;

public class CallsColumnLabel
extends AbstractNumberColumnLabel {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (info.isCallsMeaningfull) {
            return super.getDisplayString(element, info);
        }
        return "";
    }

    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        if (element instanceof TRCPackage) {
            return new Integer(((TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getCalls());
        }
        if (element instanceof TRCClass) {
            return new Integer(((TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getCalls());
        }
        if (element instanceof TRCMethod) {
            return new Integer(((TRCMethodImpl.TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getCalls());
        }
        if (element instanceof MethodCallDetails) {
            return new Integer(((MethodCallDetails)element).getCalls());
        }
        if (element instanceof TRCFullTraceObject) {
            return new Integer(((TRCFullTraceObject)element).getCalls());
        }
        if (element instanceof Coverage) {
            return new Integer(((Coverage)element).getCalls());
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            ((TRCPackage)element).computeDelta((IDelta)delta, 5);
            return new Integer(delta.getCalls());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            ((TRCClass)element).computeDelta((IDelta)delta, 12);
            return new Integer(delta.getCalls());
        }
        if (element instanceof TRCMethod) {
            TRCMethodImpl.TRCMethodSnapshot delta = this.methodSnapshot();
            ((TRCMethod)element).computeDelta((IDelta)delta, 11);
            return new Integer(delta.getCalls());
        }
        if (element instanceof MethodCallDetails) {
            MethodCallDetails methodDetails = (MethodCallDetails)element;
            return this.getDelta(methodDetails.getMethod(), info);
        }
        return null;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        if (element instanceof Coverage) {
            return "cov.calls";
        }
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.calls";
        }
        if (eObj instanceof TRCClass) {
            return "class.calls";
        }
        if (eObj instanceof TRCMethod) {
            return "method.calls";
        }
        if (eObj instanceof TRCFullTraceObject) {
            return "object.calls";
        }
        return null;
    }
}

