/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;

public class CumulativeTimeColumnLabel
extends AbstractNumberColumnLabel {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return "";
        }
        if (element instanceof TRCFullTraceObject && info.isDeltaColumn) {
            return "";
        }
        if (element instanceof TRCFullMethodInvocation && info.isDeltaColumn) {
            return "";
        }
        return super.getDisplayString(element, info);
    }

    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            return new Double(((TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getCumulativeTime());
        }
        if (element instanceof TRCClass) {
            return new Double(((TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getCumulativeTime());
        }
        if (element instanceof TRCMethod) {
            return new Double(((TRCMethodImpl.TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getCumulativeTime());
        }
        if (element instanceof TRCFullTraceObject) {
            return new Double(((TRCFullTraceObject)element).getCumulativeTime());
        }
        if (element instanceof TRCFullMethodInvocation) {
            TRCFullMethodInvocation inv = (TRCFullMethodInvocation)element;
            double start = inv.getEntryTime();
            double end = inv.getExitTime();
            double overhead = inv.getOverhead();
            if (end == 0.0) {
                end = inv.getProcess().getLastEventTime();
            }
            if (info.drawMode == 0) {
                return new Double(end - start - overhead);
            }
            return new Double(end - start);
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            ((TRCPackage)element).computeDelta((IDelta)delta, 4);
            return new Double(delta.getCumulativeTime());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            ((TRCClass)element).computeDelta((IDelta)delta, 11);
            return new Double(delta.getCumulativeTime());
        }
        if (element instanceof TRCMethod) {
            TRCMethodImpl.TRCMethodSnapshot delta = this.methodSnapshot();
            ((TRCMethod)element).computeDelta((IDelta)delta, 10);
            return new Double(delta.getCumulativeTime());
        }
        return null;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.base.time";
        }
        if (eObj instanceof TRCClass) {
            return "class.base.time";
        }
        if (eObj instanceof TRCMethod) {
            return "method.base.time";
        }
        if (eObj instanceof TRCObject) {
            return "object.base.time";
        }
        if (eObj instanceof TRCFullMethodInvocation) {
            if (info.drawMode == 0) {
                return "method.cumul.time";
            }
            return "method.raw.cumul.time";
        }
        return null;
    }
}

