/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class InstanceNameColumnLabel
extends ColumnLabelAdapter {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return "";
        }
        TRCObject obj = this.getTRCObject(element, info);
        if (obj != null) {
            EObject eObj = ContextUpdaterHelper.getEObject(obj);
            IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"object.name", (int)1);
            return formatter.getDisplayStringFromElement((Object)String.valueOf(obj.getId()), (Object)obj, 1);
        }
        return "";
    }

    protected TRCObject getTRCObject(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCObjectReference) {
            TRCObjectReference ref = (TRCObjectReference)element;
            TRCHeapObject object = null;
            object = info.showReferTo ? ref.getOwner() : ref.getTarget();
            return object;
        }
        if (element instanceof TRCMethodInvocation) {
            return ((TRCMethodInvocation)element).getOwningObject();
        }
        if (element instanceof TRCObject) {
            return (TRCObject)element;
        }
        return null;
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        TRCObject obj = this.getTRCObject(element, info);
        if (obj != null) {
            EObject eObj = ContextUpdaterHelper.getEObject(obj);
            IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"object.name", (int)1);
            return this.createImage(formatter.getDisplayImageByElement((Object)String.valueOf(obj.getId()), element, 1));
        }
        return null;
    }

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        return null;
    }
}

