/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;

public class LiveInstancesColumnLabel
extends AbstractNumberColumnLabel {
    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot();
            return new Integer(ps.getTotalInstances() - ps.getCollectedInstances());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot();
            return new Integer(cs.getTotalInstances() - cs.getCollectedInstances());
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            ((TRCPackage)element).computeDelta((IDelta)delta, 10);
            ((TRCPackage)element).computeDelta((IDelta)delta, 12);
            return new Integer(delta.getTotalInstances() - delta.getCollectedInstances());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            ((TRCClass)element).computeDelta((IDelta)delta, 17);
            ((TRCClass)element).computeDelta((IDelta)delta, 19);
            return new Integer(delta.getTotalInstances() - delta.getCollectedInstances());
        }
        return null;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.live.inst";
        }
        if (eObj instanceof TRCClass) {
            return "class.live.inst";
        }
        return null;
    }
}

